/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.auditor.impl;

import java.util.List;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.auditor.AuditAdmin;
import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.glite.pseudo.server.auditor.AuditPersonEntry;
import org.glite.pseudo.server.auditor.impl.AbstractHibernateAuditor;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateAuditAdmin
extends AbstractHibernateAuditor
implements AuditAdmin {
    private static final Logger log = LoggerFactory.getLogger(HibernateAuditAdmin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditEventEntry getEvent(String eventId) {
        log.debug("Retrieving event details for the eventId={}", (Object)eventId);
        Session session = this.getCurrentSession();
        Transaction tx = null;
        AuditEventEntry result = null;
        try {
            tx = session.beginTransaction();
            result = this.queryEvent(eventId, session);
            tx.commit();
        }
        catch (Exception e) {
            log.error("Exception caught while querying the database", (Throwable)e);
            tx.rollback();
        }
        finally {
            HibernateAuditAdmin.closeSession(session);
        }
        return result;
    }

    public AuditEventEntry[] getEvents(String personId) {
        return this.getEvents(personId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditEventEntry[] getEvents(String personId, String sortedBy) {
        log.debug("Retrieving all the events for the personId={}", (Object)personId);
        Session session = this.getCurrentSession();
        Transaction tx = null;
        AuditEventEntry[] result = null;
        try {
            tx = session.beginTransaction();
            AuditPersonEntry person = this.queryPerson(personId, session);
            result = person.getAuditEvents();
            if (sortedBy == null) {
                // empty if block
            }
            tx.commit();
        }
        catch (Exception e) {
            log.error("Exception caught while querying the database", (Throwable)e);
            tx.rollback();
        }
        finally {
            HibernateAuditAdmin.closeSession(session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditPersonEntry getPerson(String personId) {
        log.debug("Retrieving user details for the personId={}", (Object)personId);
        Session session = this.getCurrentSession();
        Transaction tx = null;
        AuditPersonEntry result = null;
        try {
            tx = session.beginTransaction();
            result = this.queryPerson(personId, session);
            tx.commit();
        }
        catch (Exception e) {
            log.error("Exception caught while querying the database", (Throwable)e);
            tx.rollback();
        }
        finally {
            HibernateAuditAdmin.closeSession(session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditPersonEntry[] getPersons() {
        log.debug("Retrieving all the users from the database");
        Session session = this.getCurrentSession();
        Transaction tx = null;
        List list = null;
        try {
            tx = session.beginTransaction();
            Query query = session.createQuery("from " + this.personImpl);
            list = query.list();
            tx.commit();
        }
        catch (Exception e) {
            log.error("Exception caught while querying the database", (Throwable)e);
            tx.rollback();
        }
        finally {
            HibernateAuditAdmin.closeSession(session);
        }
        AuditPersonEntry[] result = new AuditPersonEntry[list.toArray().length];
        list.toArray(result);
        return result;
    }

    public AuditEventEntry[] getPseudoEvents(String pseudoDN) {
        return this.getPseudoEvents(pseudoDN, null);
    }

    public AuditEventEntry[] getPseudoEvents(String pseudoDN, String sortedBy) {
        return this.getEventsByMessage(pseudoDN, sortedBy);
    }

    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        log.debug("Initializing HibernateAuditAdmin..");
        super.init(configuration);
        log.info("HibernateAuditAdmin successfully initialized.");
    }

    private AuditPersonEntry queryPerson(String personId, Session session) {
        Query query = session.createQuery("from " + this.personImpl + " as person where person.id like :personId");
        query.setString("personId", personId);
        return (AuditPersonEntry)query.uniqueResult();
    }

    private AuditEventEntry queryEvent(String eventId, Session session) {
        Query query = session.createQuery("from " + this.eventImpl + " as event where event.id like :eventId");
        query.setString("eventId", eventId);
        return (AuditEventEntry)query.uniqueResult();
    }

    private AuditEventEntry[] getEventsByMessage(String message, String sortedBy) {
        log.debug("Retrieving all the events for message={}", (Object)message);
        Session session = this.getCurrentSession();
        Transaction tx = null;
        List list = null;
        try {
            tx = session.beginTransaction();
            Query query = null;
            if (sortedBy == null) {
                query = session.createQuery("from " + this.eventImpl + " as event where event.eventMessage like :message");
                query.setString("message", message);
            } else {
                query = session.createQuery("from " + this.eventImpl + " as event where event.eventMessage like :message " + " order by event." + sortedBy);
            }
            query.setString("message", message);
            list = query.list();
        }
        catch (Exception e) {
            log.error("Exception caught while querying the database", (Throwable)e);
            tx.rollback();
        }
        AuditEventEntry[] result = new AuditEventEntry[list.toArray().length];
        list.toArray(result);
        return result;
    }
}

