/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.auditor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.glite.pseudo.common.util.Util;
import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateAuditor
implements PseudoServerComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractHibernateAuditor.class);
    protected static final String HIBERNATE_CFG_IDENTIFIER = "HibernateConfiguration";
    protected static final String HIBERNATE_MAPPINGS_IDENTIFIER = "HibernateMappings";
    protected static final String HIBERNATE_PERSON_IMPLEMENTATION = "PersonImplementation";
    protected static final String HIBERNATE_EVENT_IMPLEMENTATION = "EventImplementation";
    protected String personImpl;
    protected String eventImpl;
    protected SessionFactory sessionFactory = null;

    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        Profile.Section cfgSection = configuration.getAuditorConfiguration();
        String hbrConfig = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)HIBERNATE_CFG_IDENTIFIER)));
        log.debug("Hibernate configuration file = {}", (Object)hbrConfig);
        if (hbrConfig == null) {
            throw new PseudoServerException("Hibernate configuration file cannot be empty!");
        }
        String hbrMappings = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)HIBERNATE_MAPPINGS_IDENTIFIER)));
        log.debug("Hibernate mappings configuration file = {}", (Object)hbrMappings);
        if (hbrMappings == null) {
            throw new PseudoServerException("Hibernate mappings configuration file cannot be empty!");
        }
        this.personImpl = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)HIBERNATE_PERSON_IMPLEMENTATION)));
        log.debug("Person implementation class = {}", (Object)this.personImpl);
        if (this.personImpl == null) {
            throw new PseudoServerException("Person implementation class cannot be empty!");
        }
        this.eventImpl = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)HIBERNATE_EVENT_IMPLEMENTATION)));
        log.debug("Event implementation class = {}", (Object)this.eventImpl);
        if (this.eventImpl == null) {
            throw new PseudoServerException("Event implementation class cannot be empty!");
        }
        try {
            FileInputStream fileInput = new FileInputStream(hbrMappings);
            File cfgFile = new File(hbrConfig);
            Configuration cfg = new Configuration().configure(cfgFile);
            cfg = cfg.addInputStream((InputStream)fileInput);
            this.sessionFactory = cfg.buildSessionFactory();
        }
        catch (Throwable ex) {
            log.error("Initial SessionFactory creation failed." + ex);
            throw new PseudoServerException(ex);
        }
        log.info("HibernateAuditor successfully initialized.");
    }

    public void shutdown() {
        this.sessionFactory.close();
    }

    protected Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected static void closeSession(Session session) {
        if (session.isOpen()) {
            session.close();
        }
    }
}

