/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.aaclient.impl;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.SimpleProvider;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.aaclient.AAClient;
import org.glite.pseudo.server.aaclient.AAClientException;
import org.glite.pseudo.server.aaclient.impl.SSLConfigSender;
import org.glite.pseudo.server.caclient.impl.AbstractSSLClient;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.glite.security.voms.service.certificates.VOMSCertificates;
import org.glite.security.voms.service.certificates.VOMSCertificatesServiceLocator;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSClient
extends AbstractSSLClient
implements AAClient {
    private static final Logger log = LoggerFactory.getLogger(VOMSClient.class);
    public static final String CA_CERTIFICATE_DIRECTORY = "/etc/grid-security/certificates";
    private VOMSCertificates vomsCertService;

    public void registerCertificate(X509Certificate original, X509Certificate alias) throws AAClientException {
        String originalDN = OpensslNameUtils.convertFromRfc2253((String)original.getSubjectX500Principal().getName(), (boolean)false);
        String caDN = OpensslNameUtils.convertFromRfc2253((String)original.getIssuerX500Principal().getName(), (boolean)false);
        String aliasDN = ((Object)alias.getSubjectDN()).toString();
        log.info("Registering " + aliasDN + " as an alias to " + originalDN);
        try {
            log.debug("Generating VOMS X509Certificate");
            org.glite.security.voms.service.certificates.X509Certificate newCert = new org.glite.security.voms.service.certificates.X509Certificate(alias.getEncoded(), alias.getSerialNumber().longValue(), X500NameUtils.getPortableRFC2253Form((String)((Object)alias.getIssuerDN()).toString()), alias.getNotAfter().toString(), X500NameUtils.getPortableRFC2253Form((String)aliasDN.toString()));
            this.vomsCertService.addCertificate(originalDN, caDN, newCert);
        }
        catch (Exception e) {
            throw new AAClientException("Could not add new certificate to the VOMS certificate service!", e);
        }
    }

    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        PEMCredential credential;
        log.debug("Initializing VOMSClient");
        Profile.Section cfgSection = configuration.getAAClientConfiguration();
        super.init(cfgSection);
        if (this.keyFile == null) {
            throw new PseudoServerException("Private key for client authentication is not configured!");
        }
        log.debug("Using {} as a private key for client authentication.", (Object)this.keyFile);
        if (this.certFile == null) {
            throw new PseudoServerException("Client authentication certificate is not configured!");
        }
        log.debug("Using {} as a certificate for client authentication.", (Object)this.certFile);
        try {
            if (this.keyPasswd == null) {
                log.debug("Password for the private key is not configured, the private key should be plaintext.");
                credential = new PEMCredential(this.keyFile, this.certFile, null);
            } else {
                log.debug("Using a password for decrypting the private key.");
                credential = new PEMCredential(this.keyFile, this.certFile, this.keyPasswd.toCharArray());
            }
        }
        catch (KeyStoreException e) {
            throw new PseudoServerException("Could not initialize the private key!", e);
        }
        catch (CertificateException e) {
            throw new PseudoServerException("Could not initialize the X.509 certificate!", e);
        }
        catch (IOException e) {
            throw new PseudoServerException("Could not read the private key and/or certificate file!", e);
        }
        OpensslCertChainValidator validator = new OpensslCertChainValidator(CA_CERTIFICATE_DIRECTORY);
        try {
            SimpleProvider provider = SSLConfigSender.getTransportProvider((X509Credential)credential, (X509CertChainValidator)validator);
            VOMSCertificatesServiceLocator locator = new VOMSCertificatesServiceLocator((EngineConfiguration)provider);
            locator.setVOMSCertificatesEndpointAddress(this.endpoint);
            this.vomsCertService = locator.getVOMSCertificates();
        }
        catch (Exception e) {
            throw new PseudoServerException("Error during VOMS certificate service client initialization!", e);
        }
        log.info("VOMS certificate service client successfully initialized.");
    }

    public void shutdown() {
        super.shutdown();
    }
}

