/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.ChainedTilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.UnresolvingLocaleDefinitionsFactory;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.definition.dao.ResolvingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.definition.pattern.BasicPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternDefinitionResolverAware;
import org.apache.tiles.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.factory.NotAvailableFeatureException;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.locale.impl.DefaultLocaleResolver;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.renderer.TypeDetectingAttributeRenderer;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.apache.tiles.renderer.impl.ChainedDelegateAttributeRenderer;
import org.apache.tiles.renderer.impl.DefinitionAttributeRenderer;
import org.apache.tiles.renderer.impl.StringAttributeRenderer;
import org.apache.tiles.renderer.impl.TemplateAttributeRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTilesContainerFactory
extends AbstractTilesContainerFactory {
    protected static final String STRING_RENDERER_NAME = "string";
    protected static final String TEMPLATE_RENDERER_NAME = "template";
    protected static final String DEFINITION_RENDERER_NAME = "definition";
    private final Logger log = LoggerFactory.getLogger(BasicTilesContainerFactory.class);

    @Override
    public TilesContainer createContainer(TilesApplicationContext applicationContext) {
        BasicTilesContainer container = this.instantiateContainer(applicationContext);
        TilesRequestContextFactory requestContextFactory = this.createRequestContextFactory(applicationContext);
        container.setRequestContextFactory(requestContextFactory);
        container.setApplicationContext(applicationContext);
        LocaleResolver resolver = this.createLocaleResolver(applicationContext, requestContextFactory);
        container.setDefinitionsFactory(this.createDefinitionsFactory(applicationContext, requestContextFactory, resolver));
        AttributeEvaluatorFactory attributeEvaluatorFactory = this.createAttributeEvaluatorFactory(applicationContext, requestContextFactory, resolver);
        container.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        container.setPreparerFactory(this.createPreparerFactory(applicationContext, requestContextFactory));
        container.setRendererFactory(this.createRendererFactory(applicationContext, requestContextFactory, container, attributeEvaluatorFactory));
        return container;
    }

    protected BasicTilesContainer instantiateContainer(TilesApplicationContext context) {
        return new BasicTilesContainer();
    }

    protected TilesRequestContextFactory createRequestContextFactory(TilesApplicationContext context) {
        ChainedTilesRequestContextFactory contextFactory = new ChainedTilesRequestContextFactory();
        this.registerChainedRequestContextFactories(contextFactory);
        return contextFactory;
    }

    protected void registerChainedRequestContextFactories(ChainedTilesRequestContextFactory contextFactory) {
        List<TilesRequestContextFactory> factories = this.getTilesRequestContextFactoriesToBeChained(contextFactory);
        contextFactory.setFactories(factories);
    }

    protected List<TilesRequestContextFactory> getTilesRequestContextFactoriesToBeChained(ChainedTilesRequestContextFactory parent) {
        ArrayList<TilesRequestContextFactory> factories = new ArrayList<TilesRequestContextFactory>();
        this.registerRequestContextFactory("org.apache.tiles.servlet.context.ServletTilesRequestContextFactory", factories, parent);
        this.registerRequestContextFactory("org.apache.tiles.portlet.context.PortletTilesRequestContextFactory", factories, parent);
        this.registerRequestContextFactory("org.apache.tiles.jsp.context.JspTilesRequestContextFactory", factories, parent);
        return factories;
    }

    protected void registerRequestContextFactory(String className, List<TilesRequestContextFactory> factories, TilesRequestContextFactory parent) {
        TilesRequestContextFactory retValue = null;
        try {
            Class clazz = ClassUtil.getClass((String)className, TilesRequestContextFactory.class);
            retValue = (TilesRequestContextFactory)clazz.newInstance();
            if (parent != null && retValue instanceof TilesRequestContextFactoryAware) {
                ((TilesRequestContextFactoryAware)((Object)retValue)).setRequestContextFactory(parent);
            }
        }
        catch (ClassNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot find class '" + className + "', ignoring problem", (Throwable)e);
            }
        }
        catch (NotAvailableFeatureException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Not available feature exception during instantiation of class '" + className + "', ignoring problem", (Throwable)((Object)e));
            }
        }
        catch (InstantiationException e) {
            throw new TilesContainerFactoryException("Cannot instantiate '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new TilesContainerFactoryException("Cannot access default constructor '" + className + "'", e);
        }
        if (retValue != null) {
            factories.add(retValue);
        }
    }

    protected DefinitionsFactory createDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        UnresolvingLocaleDefinitionsFactory factory = this.instantiateDefinitionsFactory(applicationContext, contextFactory, resolver);
        factory.setApplicationContext(applicationContext);
        factory.setLocaleResolver(resolver);
        factory.setDefinitionDAO(this.createLocaleDefinitionDao(applicationContext, contextFactory, resolver));
        if (factory instanceof Refreshable) {
            ((Refreshable)((Object)factory)).refresh();
        }
        return factory;
    }

    protected UnresolvingLocaleDefinitionsFactory instantiateDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        return new UnresolvingLocaleDefinitionsFactory();
    }

    protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        ResolvingLocaleUrlDefinitionDAO dao = new ResolvingLocaleUrlDefinitionDAO();
        return dao;
    }

    protected DefinitionDAO<Locale> createLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        BaseLocaleUrlDefinitionDAO definitionDao = this.instantiateLocaleDefinitionDao(applicationContext, contextFactory, resolver);
        definitionDao.setReader(this.createDefinitionsReader(applicationContext, contextFactory));
        definitionDao.setSourceURLs(this.getSourceURLs(applicationContext, contextFactory));
        definitionDao.setApplicationContext(applicationContext);
        if (definitionDao instanceof PatternDefinitionResolverAware) {
            ((PatternDefinitionResolverAware)((Object)definitionDao)).setPatternDefinitionResolver(this.createPatternDefinitionResolver(Locale.class));
        }
        return definitionDao;
    }

    protected LocaleResolver createLocaleResolver(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new DefaultLocaleResolver();
    }

    protected DefinitionsReader createDefinitionsReader(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new DigesterDefinitionsReader();
    }

    protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        ArrayList<URL> retValue = new ArrayList<URL>(1);
        try {
            retValue.add(applicationContext.getResource("/WEB-INF/tiles.xml"));
        }
        catch (IOException e) {
            throw new TilesContainerFactoryException("Cannot get URL: /WEB-INF/tiles.xml", e);
        }
        return retValue;
    }

    protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        return new BasicAttributeEvaluatorFactory(new DirectAttributeEvaluator());
    }

    protected PreparerFactory createPreparerFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new BasicPreparerFactory();
    }

    protected RendererFactory createRendererFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        BasicRendererFactory retValue = new BasicRendererFactory();
        retValue.setApplicationContext(applicationContext);
        retValue.setRequestContextFactory(contextFactory);
        retValue.setContainer(container);
        retValue.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        this.registerAttributeRenderers(retValue, applicationContext, contextFactory, container, attributeEvaluatorFactory);
        retValue.setDefaultRenderer(this.createDefaultAttributeRenderer(retValue, applicationContext, contextFactory, container, attributeEvaluatorFactory));
        return retValue;
    }

    protected AttributeRenderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateAttributeRenderer retValue = new ChainedDelegateAttributeRenderer();
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(DEFINITION_RENDERER_NAME));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(TEMPLATE_RENDERER_NAME));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(STRING_RENDERER_NAME));
        retValue.setApplicationContext(applicationContext);
        retValue.setRequestContextFactory(contextFactory);
        retValue.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return retValue;
    }

    protected <T> PatternDefinitionResolver<T> createPatternDefinitionResolver(Class<T> customizationKeyClass) {
        WildcardDefinitionPatternMatcherFactory definitionPatternMatcherFactory = new WildcardDefinitionPatternMatcherFactory();
        return new BasicPatternDefinitionResolver(definitionPatternMatcherFactory, definitionPatternMatcherFactory);
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        rendererFactory.registerRenderer(STRING_RENDERER_NAME, this.createStringAttributeRenderer(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory));
        rendererFactory.registerRenderer(TEMPLATE_RENDERER_NAME, this.createTemplateAttributeRenderer(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory));
        rendererFactory.registerRenderer(DEFINITION_RENDERER_NAME, this.createDefinitionAttributeRenderer(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory));
    }

    protected AttributeRenderer createStringAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        StringAttributeRenderer stringRenderer = new StringAttributeRenderer();
        stringRenderer.setApplicationContext(applicationContext);
        stringRenderer.setRequestContextFactory(contextFactory);
        stringRenderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return stringRenderer;
    }

    protected AttributeRenderer createTemplateAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        TemplateAttributeRenderer templateRenderer = new TemplateAttributeRenderer();
        templateRenderer.setApplicationContext(applicationContext);
        templateRenderer.setRequestContextFactory(contextFactory);
        templateRenderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return templateRenderer;
    }

    protected AttributeRenderer createDefinitionAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        DefinitionAttributeRenderer definitionRenderer = new DefinitionAttributeRenderer();
        definitionRenderer.setApplicationContext(applicationContext);
        definitionRenderer.setContainer(container);
        definitionRenderer.setRequestContextFactory(contextFactory);
        definitionRenderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return definitionRenderer;
    }
}

