/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact.cli;

import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSProxyInit;
import org.glite.voms.contact.VOMSRequestOptions;

public class VomsProxyInitClient {
    private static final Logger log = Logger.getLogger(VomsProxyInitClient.class);
    protected VOMSProxyInit proxyInit;
    protected CommandLineParser parser = new GnuParser();
    protected HelpFormatter helpFormatter = new HelpFormatter();
    protected Options options;
    String[] fqans;
    String targets;
    String ordering;
    int lifetime;
    String proxyOutput;
    String keyPassword;
    String proxyType;
    String delegationType;
    String policyType;
    int bits = 1024;

    protected void setupUserCredentials(String userCert, String userKey) {
        System.setProperty("X509_USER_CERT", userCert);
        System.setProperty("X509_USER_KEY", userKey);
    }

    protected void setupVomsesPath(String vomsesPath) {
        System.setProperty("VOMSES_LOCATION", vomsesPath);
    }

    protected void setupVomsdir(String vomsdir) {
        System.setProperty("VOMSDIR", vomsdir);
    }

    protected void setupCaDir(String caDir) {
        System.setProperty("CADIR", caDir);
    }

    protected void setupCLParser() {
        this.options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Displays helps and exits.");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"vomsdir");
        OptionBuilder.withDescription((String)"Specifies non-standard vomsdir directory.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"vomsdir"));
        OptionBuilder.withLongOpt((String)"cadir");
        OptionBuilder.withDescription((String)"Specifies non-standard ca certificate directory.");
        OptionBuilder.hasArg((boolean)true);
        this.options.addOption(OptionBuilder.create((String)"cadir"));
        OptionBuilder.withLongOpt((String)"vomsesPath");
        OptionBuilder.withDescription((String)"Specifies non-standard locations where the voms-proxy-init looks for vomses files. The path is a colon (:) separated list of paths.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"vomsesPath"));
        OptionBuilder.withLongOpt((String)"usercert");
        OptionBuilder.withDescription((String)"Specifies non-standard user certificate.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"usercert"));
        OptionBuilder.withLongOpt((String)"userkey");
        OptionBuilder.withDescription((String)"Specifies non-standard user private key.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"userkey"));
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.withDescription((String)"Specifies a password that is used to decrypt the user's private key.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"password"));
        OptionBuilder.withLongOpt((String)"lifetime");
        OptionBuilder.withDescription((String)"Specifies the lifetime for the generated proxy.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"lifetime"));
        OptionBuilder.withLongOpt((String)"out");
        OptionBuilder.withDescription((String)"Specifies a non-standard location for the generated proxy. The standard location is /tmp/X509_up_<username>.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"out"));
        OptionBuilder.withLongOpt((String)"order");
        OptionBuilder.withDescription((String)"Specifies the ordering of received attributes. The options is a comma (,) separated list of FQANs.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"order"));
        OptionBuilder.withLongOpt((String)"voms");
        OptionBuilder.withDescription((String)"Specifies a request FQAN in the form: <voName>:<FQAN>.");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"voms"));
        OptionBuilder.withLongOpt((String)"targets");
        OptionBuilder.withDescription((String)"Targets the AC against a specific comma separated list of hostnames.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"targets"));
        OptionBuilder.withLongOpt((String)"proxyType");
        OptionBuilder.withDescription((String)"Specifies the type of proxy that will be generated. Possible values are: GT2_PROXY, GT3_PROXY, GT4_PROXY. The default value is GT2_PROXY.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"proxyType"));
        OptionBuilder.withLongOpt((String)"policyType");
        OptionBuilder.withDescription((String)"Specifies the policy type of the proxy.  Only significant with proxyType >= GT3_PROXY.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"policyType"));
        OptionBuilder.withLongOpt((String)"delegationType");
        OptionBuilder.withDescription((String)"Specifies the type of delegation requested for the generated proxy. Possible values are: NONE, LIMITED, FULL. The default value is FULL.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"delegationType"));
        OptionBuilder.withLongOpt((String)"bits");
        OptionBuilder.withDescription((String)"Specifies the key size of the created proxy. Possible values are 512, 1024, 2048.  The default alue is 1024");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"bits"));
    }

    protected void printHelpMessageAndExit(int exitStatus) {
        this.helpFormatter.printHelp("VomsProxyInit", this.options);
        System.exit(exitStatus);
    }

    protected void getArguments(String[] args) {
        try {
            CommandLine line = this.parser.parse(this.options, args);
            if (line.hasOption("h")) {
                this.printHelpMessageAndExit(0);
            }
            if (line.hasOption("vomsdir")) {
                this.setupVomsdir(line.getOptionValue("vomsdir"));
            }
            if (line.hasOption("cadir")) {
                this.setupCaDir(line.getOptionValue("cadir"));
            }
            if (line.hasOption("vomsesPath")) {
                this.setupVomsesPath(line.getOptionValue("vomsesPath"));
            }
            if (line.hasOption("usercert") && line.hasOption("userkey")) {
                this.setupUserCredentials(line.getOptionValue("usercert"), line.getOptionValue("userkey"));
            }
            if (line.hasOption("out")) {
                this.proxyOutput = line.getOptionValue("out");
            }
            if (line.hasOption("order")) {
                this.ordering = line.getOptionValue("order");
            }
            if (line.hasOption("targets")) {
                this.targets = line.getOptionValue("targets");
            }
            if (line.hasOption("lifetime")) {
                this.lifetime = Integer.parseInt(line.getOptionValue("lifetime"));
            }
            if (line.hasOption("voms")) {
                this.fqans = line.getOptionValues("voms");
            }
            if (line.hasOption("password")) {
                this.keyPassword = line.getOptionValue("password");
            }
            if (line.hasOption("proxyType")) {
                this.proxyType = line.getOptionValue("proxyType");
            }
            if (line.hasOption("policyType")) {
                this.policyType = line.getOptionValue("policyType");
            }
            if (line.hasOption("delegationType")) {
                this.delegationType = line.getOptionValue("delegationType");
            }
            if (line.hasOption("bits")) {
                this.bits = Integer.parseInt(line.getOptionValue("bits"));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.helpFormatter.printHelp("VomsProxyInit", this.options);
            System.exit(-1);
        }
    }

    protected void buildProxy() {
        int type;
        if (this.keyPassword != null) {
            this.proxyInit = VOMSProxyInit.instance(this.keyPassword);
        } else {
            log.warn((Object)"No password given to decrypt the openssl private key...");
            this.proxyInit = VOMSProxyInit.instance();
        }
        if (this.proxyOutput != null) {
            this.proxyInit.setProxyOutputFile(this.proxyOutput);
        }
        if (this.proxyType != null) {
            type = 2;
            if (this.proxyType.equals("GT2_PROXY")) {
                type = 2;
            } else if (this.proxyType.equals("GT3_PROXY")) {
                type = 3;
            } else if (this.proxyType.equals("GT4_PROXY")) {
                type = 4;
            } else {
                log.warn((Object)"Unsupported proxy type specified! The default value will be used.");
            }
            this.proxyInit.setProxyType(type);
        }
        if (this.bits != 512 && this.bits != 1024 && this.bits != 2048) {
            log.warn((Object)"Unsupported bit size specified! The default value will be used.");
            this.bits = 1024;
        }
        this.proxyInit.setProxyKeySize(this.bits);
        if (this.policyType != null) {
            this.proxyInit.setPolicyType(this.policyType);
        }
        if (this.delegationType != null) {
            type = 0;
            if (this.delegationType.equals("NONE")) {
                type = 8;
            } else if (this.delegationType.equals("LIMITED")) {
                type = 1;
            } else if (this.delegationType.equals("FULL")) {
                type = 0;
            } else {
                log.warn((Object)"Unsupported delegation type specified! The default value will be used.");
            }
            this.proxyInit.setDelegationType(type);
        }
        log.debug((Object)("fqans:" + ToStringBuilder.reflectionToString((Object)this.fqans)));
        if (this.fqans == null) {
            this.proxyInit.getVomsProxy();
        } else {
            HashMap<String, VOMSRequestOptions> options = new HashMap<String, VOMSRequestOptions>();
            for (int i = 0; i < this.fqans.length; ++i) {
                VOMSRequestOptions o;
                String[] opts = this.fqans[i].split(":");
                if (opts.length != 2) {
                    throw new VOMSException("Voms FQANs must be specified according to the <voName>:<fqan> syntax (e.g., cms:/cms/Role=lcgadmin).");
                }
                String voName = opts[0];
                if (options.containsKey(voName)) {
                    o = (VOMSRequestOptions)options.get(voName);
                } else {
                    o = new VOMSRequestOptions();
                    o.setVoName(voName);
                    options.put(voName, o);
                }
                o.addFQAN(opts[1]);
                if (this.ordering == null) continue;
                o.setOrdering(this.ordering);
            }
            this.proxyInit.getVomsProxy(options.values());
        }
    }

    public VomsProxyInitClient(String[] args) {
        this.setupCLParser();
        this.getArguments(args);
        this.buildProxy();
    }

    public static void main(String[] args) {
        new VomsProxyInitClient(args);
    }
}

