/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.glite.voms.contact.VOMSServerInfo;

public class VOMSServerMap {
    protected Map map = new TreeMap();

    public void add(VOMSServerInfo info) {
        String key = info.getAlias();
        if (this.map.containsKey(key)) {
            Set servers = (Set)this.map.get(key);
            servers.add(info);
            return;
        }
        HashSet<VOMSServerInfo> l = new HashSet<VOMSServerInfo>();
        l.add(info);
        this.map.put(key, l);
    }

    public Set get(String nick) {
        return (Set)this.map.get(nick);
    }

    public int serverCount(String nick) {
        if (this.map.containsKey(nick)) {
            return ((Set)this.map.get(nick)).size();
        }
        return 0;
    }

    public void merge(VOMSServerMap other) {
        for (Map.Entry e : other.map.entrySet()) {
            if (this.map.containsKey(e.getKey())) {
                this.get((String)e.getKey()).addAll((Set)e.getValue());
                continue;
            }
            this.map.put(e.getKey(), e.getValue());
        }
    }

    public String toString() {
        if (this.map == null || this.map.isEmpty()) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        Iterator i = this.map.entrySet().iterator();
        buf.append("VOMSServerMap:[\n");
        while (i.hasNext()) {
            Map.Entry e = i.next();
            buf.append(e.getKey() + ":\n");
            buf.append("\tnum_servers: " + ((Set)e.getValue()).size() + "\n");
            buf.append("\tserver_details: \n\t\t" + StringUtils.join(((Set)e.getValue()).iterator(), (String)"\n\t\t") + "\n");
        }
        buf.append("]\n");
        return buf.toString();
    }
}

