/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSDecoder;
import org.glite.voms.contact.VOMSErrorMessage;
import org.glite.voms.contact.VOMSWarningMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VOMSResponse {
    private static int ERROR_OFFSET = 1000;
    private static final Logger log = Logger.getLogger(VOMSResponse.class);
    protected Document xmlResponse;

    public boolean hasErrors() {
        if (this.xmlResponse.getElementsByTagName("error").getLength() != 0) {
            return true;
        }
        return this.xmlResponse.getElementsByTagName("item").getLength() != 0 && this.xmlResponse.getElementsByTagName("ac").getLength() == 0;
    }

    public boolean hasWarnings() {
        if (this.xmlResponse.getElementsByTagName("warning").getLength() != 0) {
            return true;
        }
        return this.xmlResponse.getElementsByTagName("item").getLength() != 0 && this.xmlResponse.getElementsByTagName("ac").getLength() != 0;
    }

    public byte[] getAC() {
        Element acElement = (Element)this.xmlResponse.getElementsByTagName("ac").item(0);
        return VOMSDecoder.decode(acElement.getFirstChild().getNodeValue());
    }

    public byte[] getData() {
        Element acElement = (Element)this.xmlResponse.getElementsByTagName("bitstr").item(0);
        if (acElement != null) {
            return VOMSDecoder.decode(acElement.getFirstChild().getNodeValue());
        }
        return null;
    }

    public int getVersion() {
        Element versionElement = (Element)this.xmlResponse.getElementsByTagName("version").item(0);
        if (versionElement == null) {
            return 0;
        }
        return Integer.parseInt(versionElement.getFirstChild().getNodeValue());
    }

    public String getACAsString() {
        Element acElement = (Element)this.xmlResponse.getElementsByTagName("ac").item(0);
        return acElement.getFirstChild().getNodeValue();
    }

    public VOMSErrorMessage[] errorMessages() {
        VOMSErrorMessage[] result = this.errorMessagesREST();
        if (result != null) {
            return result;
        }
        NodeList nodes = this.xmlResponse.getElementsByTagName("item");
        if (nodes.getLength() == 0) {
            return null;
        }
        result = new VOMSErrorMessage[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element numberElement = (Element)itemElement.getElementsByTagName("number").item(0);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            int number = Integer.parseInt(numberElement.getFirstChild().getNodeValue());
            if (number < ERROR_OFFSET) continue;
            result[i] = new VOMSErrorMessage(number, messageElement.getFirstChild().getNodeValue());
        }
        return result;
    }

    private VOMSErrorMessage[] errorMessagesREST() {
        NodeList nodes = this.xmlResponse.getElementsByTagName("error");
        if (nodes.getLength() == 0) {
            return null;
        }
        VOMSErrorMessage[] result = new VOMSErrorMessage[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element codeElement = (Element)itemElement.getElementsByTagName("code").item(0);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            String strcode = codeElement.getFirstChild().getNodeValue();
            int code = strcode.equals("NoSuchUser") ? 1001 : (strcode.equals("BadRequest") ? 1005 : (strcode.equals("SuspendedUser") ? 1004 : 1006));
            result[i] = new VOMSErrorMessage(code, messageElement.getFirstChild().getNodeValue());
        }
        return result;
    }

    public VOMSWarningMessage[] warningMessages() {
        VOMSWarningMessage[] result = this.warningMessagesREST();
        if (result != null) {
            return result;
        }
        NodeList nodes = this.xmlResponse.getElementsByTagName("item");
        if (nodes.getLength() == 0) {
            return null;
        }
        result = new VOMSWarningMessage[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element numberElement = (Element)itemElement.getElementsByTagName("number").item(0);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            int number = Integer.parseInt(numberElement.getFirstChild().getNodeValue());
            if (number >= ERROR_OFFSET) continue;
            result[i] = new VOMSWarningMessage(number, messageElement.getFirstChild().getNodeValue());
        }
        return result;
    }

    private VOMSWarningMessage[] warningMessagesREST() {
        NodeList nodes = this.xmlResponse.getElementsByTagName("warning");
        if (nodes.getLength() == 0) {
            return null;
        }
        VOMSWarningMessage[] result = new VOMSWarningMessage[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            String message = itemElement.getFirstChild().getNodeValue();
            int number = message.contains("validity") ? 2 : (message.contains("selected") ? 1 : (message.contains("contains attributes") ? 3 : 4));
            log.debug((Object)("Message = " + message + " number = " + number));
            if (number >= ERROR_OFFSET) continue;
            result[i] = new VOMSWarningMessage(number, message);
        }
        return result;
    }

    public VOMSResponse(Document res) {
        this.xmlResponse = res;
    }
}

