/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.contact.ExtensionData;
import org.glite.voms.contact.MyProxyCertInfo;
import org.glite.voms.contact.ProxyPolicy;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSException;

public class VOMSProxyBuilder {
    private static final Logger log = Logger.getLogger(VOMSProxyBuilder.class);
    public static final int GT2_PROXY = 2;
    public static final int GT3_PROXY = 3;
    public static final int GT4_PROXY = 4;
    public static final int DEFAULT_PROXY_TYPE = 2;
    public static final int DEFAULT_DELEGATION_TYPE = 0;
    public static final int DEFAULT_PROXY_LIFETIME = 86400;
    private static final String PROXY_CERT_INFO_V3_OID = "1.3.6.1.4.1.3536.1.222";
    private static final String PROXY_CERT_INFO_V4_OID = "1.3.6.1.5.5.7.1.14";

    public static AttributeCertificate buildAC(byte[] acBytes) {
        ByteArrayInputStream bai = new ByteArrayInputStream(acBytes);
        try {
            return AttributeCertificate.getInstance(bai);
        }
        catch (IOException e) {
            log.error((Object)("Error parsing attribute certificate:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    public static UserCredentials buildProxy(UserCredentials cred, List ACs, int lifetime, int gtVersion, int delegType, String policyType) {
        return VOMSProxyBuilder.buildProxy(cred, ACs, lifetime, gtVersion, delegType, policyType, 1024);
    }

    public static UserCredentials buildProxy(UserCredentials cred, List ACs, int lifetime, int gtVersion, int delegType, String policyType, int bits) {
        if (ACs.isEmpty()) {
            throw new VOMSException("Please specify a non-empty list of attribute certificate to build a voms-proxy.");
        }
        Iterator i = ACs.iterator();
        ASN1EncodableVector acVector = new ASN1EncodableVector();
        while (i.hasNext()) {
            acVector.add((DEREncodable)((AttributeCertificate)i.next()));
        }
        HashMap<String, ExtensionData> extensions = new HashMap<String, ExtensionData>();
        if (!ACs.isEmpty()) {
            DERSequence seqac = new DERSequence((DEREncodableVector)acVector);
            DERSequence seqacwrap = new DERSequence((DEREncodable)seqac);
            extensions.put("1.3.6.1.4.1.8005.100.100.5", ExtensionData.creator("1.3.6.1.4.1.8005.100.100.5", (DERObject)seqacwrap));
        }
        KeyUsage keyUsage = new KeyUsage(176);
        extensions.put("2.5.29.15", ExtensionData.creator("2.5.29.15", true, keyUsage.getDERObject()));
        return VOMSProxyBuilder.myCreateCredential(cred.getUserChain(), cred.getUserKey(), bits, lifetime, delegType, gtVersion, extensions, policyType);
    }

    public static UserCredentials buildProxy(UserCredentials cred, int lifetime, int proxy_type) {
        return VOMSProxyBuilder.buildProxy(cred, lifetime, proxy_type, 1024);
    }

    public static UserCredentials buildProxy(UserCredentials cred, int lifetime, int proxy_type, int bits) {
        return VOMSProxyBuilder.myCreateCredential(cred.getUserChain(), cred.getUserKey(), bits, lifetime, proxy_type, 2, new HashMap(), "");
    }

    private static UserCredentials myCreateCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, int gtVersion, HashMap extensions, String policyType) {
        KeyPairGenerator keys = null;
        try {
            keys = KeyPairGenerator.getInstance("RSA", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Error activating bouncycastle: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e.getMessage(), e.getCause());
        }
        catch (NoSuchProviderException e) {
            log.error((Object)("Error activating bouncycastle: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e.getMessage(), e.getCause());
        }
        keys.initialize(bits);
        KeyPair pair = keys.genKeyPair();
        X509Certificate proxy = VOMSProxyBuilder.myCreateProxyCertificate(certs[0], privateKey, pair.getPublic(), lifetime, delegationMode, gtVersion, extensions, policyType);
        X509Certificate[] newCerts = new X509Certificate[certs.length + 1];
        newCerts[0] = proxy;
        System.arraycopy(certs, 0, newCerts, 1, certs.length);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < newCerts.length; ++i) {
                log.debug((Object)("CERT[" + i + "] IS: " + newCerts[i].getSubjectDN()));
            }
        }
        return UserCredentials.instance(pair.getPrivate(), newCerts);
    }

    /*
     * Unable to fully structure code
     */
    private static X509Certificate myCreateProxyCertificate(X509Certificate cert, PrivateKey issuerKey, PublicKey publicKey, int lifetime, int delegationMode, int gtVersion, HashMap extensions, String policyType) {
        certGen = new X509V3CertificateGenerator();
        cnValue = null;
        policy = null;
        serialNum = null;
        if (issuerKey == null) {
            VOMSProxyBuilder.log.error((Object)"Passed issuer key is null");
            throw new VOMSException("Passed issuerKey is null!");
        }
        block2 : switch (gtVersion) {
            case 2: {
                serialNum = cert.getSerialNumber();
                switch (delegationMode) {
                    case 1: {
                        cnValue = "limited proxy";
                        break block2;
                    }
                    case 0: {
                        cnValue = "proxy";
                        break block2;
                    }
                }
                break;
            }
            case 3: 
            case 4: {
                rand = new Random();
                number = Math.abs(rand.nextInt(0x7FFFFFFF));
                cnValue = String.valueOf(number);
                serialNum = new BigInteger(String.valueOf(number));
                data = (ExtensionData)extensions.get("1.3.6.1.4.1.3536.1.222");
                if (data != null) break;
                if (policyType != null) ** GOTO lbl41
                switch (delegationMode) {
                    case 1: 
                    case 2: 
                    case 3: {
                        policy = new ProxyPolicy(ProxyPolicy.LIMITED);
                        ** GOTO lbl46
                    }
                    case 0: 
                    case 4: 
                    case 5: {
                        policy = new ProxyPolicy(ProxyPolicy.IMPERSONATION);
                        ** GOTO lbl46
                    }
                    case 6: {
                        throw new IllegalArgumentException("Restricted proxy requires ProxyCertInfo");
                    }
                    case 7: {
                        policy = new ProxyPolicy(ProxyPolicy.INDEPENDENT);
                        ** GOTO lbl46
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid proxyType");
                    }
                }
lbl41:
                // 1 sources

                try {
                    policy = new ProxyPolicy(new DERObjectIdentifier(policyType));
                }
                catch (IllegalArgumentException e) {
                    throw new VOMSException("OID required as policyType");
                }
lbl46:
                // 4 sources

                if (gtVersion == 3) {
                    extensions.put("1.3.6.1.4.1.3536.1.222", ExtensionData.creator("1.3.6.1.4.1.3536.1.222", new MyProxyCertInfo(policy, gtVersion).getDERObject()));
                    break;
                }
                extensions.put("1.3.6.1.5.5.7.1.14", ExtensionData.creator("1.3.6.1.5.5.7.1.14", true, new MyProxyCertInfo(policy, gtVersion).getDERObject()));
            }
        }
        if (cnValue == null) {
            throw new IllegalArgumentException("Type of delegation unspecified");
        }
        exts = extensions.values().toArray(new ExtensionData[0]);
        for (i = 0; i < exts.length; ++i) {
            certGen.addExtension(exts[i].getOID(), exts[i].getCritical(), (DEREncodable)exts[i].getObj());
        }
        issuerDN = (X509Name)cert.getSubjectDN();
        vec = new ASN1EncodableVector();
        vec.add((DEREncodable)X509Name.CN);
        vec.add((DEREncodable)new DERPrintableString(cnValue));
        DNComponents = ((ASN1Sequence)issuerDN.getDERObject()).getObjects();
        subject = new ASN1EncodableVector();
        while (DNComponents.hasMoreElements()) {
            subject.add((DEREncodable)((DERObject)DNComponents.nextElement()));
        }
        subject.add((DEREncodable)new DERSet((DEREncodable)new DERSequence((DEREncodableVector)vec)));
        subjectDN = new X509Name((ASN1Sequence)new DERSequence((DEREncodableVector)subject));
        certGen.setSubjectDN(subjectDN);
        certGen.setIssuerDN(issuerDN);
        certGen.setSerialNumber(serialNum);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(cert.getSigAlgName());
        date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        certGen.setNotBefore(date.getTime());
        if (lifetime <= 0) {
            certGen.setNotAfter(cert.getNotAfter());
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            certGen.setNotAfter(date.getTime());
        }
        try {
            return certGen.generateX509Certificate(issuerKey);
        }
        catch (SignatureException e) {
            VOMSProxyBuilder.log.error((Object)("Error creating proxy: " + e.getMessage()));
            if (VOMSProxyBuilder.log.isDebugEnabled()) {
                VOMSProxyBuilder.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
        catch (InvalidKeyException e) {
            VOMSProxyBuilder.log.error((Object)("Error creating proxy: " + e.getMessage()));
            if (VOMSProxyBuilder.log.isDebugEnabled()) {
                VOMSProxyBuilder.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    public static void saveProxy(UserCredentials cred, OutputStream os) {
        try {
            cred.save(os);
        }
        catch (IOException e) {
            log.error((Object)("Error saving generated proxy: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error saving generated proxy: " + e.getMessage(), e);
        }
    }

    public static void saveProxy(UserCredentials cred, String filename) throws FileNotFoundException {
        VOMSProxyBuilder.saveProxy(cred, new FileOutputStream(filename));
    }
}

