/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSServerInfo;
import org.glite.voms.contact.VOMSServerMap;

public class VOMSESFileParser {
    private static final Logger log;
    private static final String splitSyntax = "\\x22[^\\x22]\\x22";
    private static final List<File> vomsesPaths;

    private VOMSESFileParser() {
    }

    private String fixQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String[] splitLine(String line) {
        String[] tokens = line.split(splitSyntax);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.fixQuotes(tokens[i]);
        }
        return tokens;
    }

    private VOMSServerMap parseDir(File vomsesDir) throws IOException {
        File[] allFiles = vomsesDir.listFiles();
        VOMSServerMap result = new VOMSServerMap();
        log.debug((Object)("Parsing vomses dir:" + vomsesDir));
        for (int i = 0; i < allFiles.length; ++i) {
            result.merge(this.parse(allFiles[i]));
        }
        return result;
    }

    VOMSServerMap parse(String fileName) throws IOException {
        return this.parse(new File(fileName));
    }

    private VOMSServerMap parse(File vomsesFile) throws IOException {
        String line;
        BufferedReader reader = null;
        VOMSServerMap result = new VOMSServerMap();
        if (vomsesFile.isDirectory()) {
            return this.parseDir(vomsesFile);
        }
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(vomsesFile)));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error opening vomses file '" + vomsesFile.getAbsolutePath() + "': " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        log.debug((Object)("Parsing vomses file: " + vomsesFile.getAbsolutePath()));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.matches("\\s*$")) continue;
            String[] tokens = this.splitLine(line.trim());
            if (tokens.length < 5 || tokens.length > 6) {
                throw new VOMSException("Syntax error on vomses file!");
            }
            result.add(VOMSServerInfo.fromStringArray(tokens));
        }
        return result;
    }

    public VOMSServerMap buildServerMap() throws IOException {
        Iterator<File> i = vomsesPaths.iterator();
        if (log.isDebugEnabled()) {
            String locations = StringUtils.join(vomsesPaths.iterator(), (String)",");
            log.debug((Object)("Known vomses files: " + locations));
        }
        VOMSServerMap result = new VOMSServerMap();
        while (i.hasNext()) {
            result.merge(this.parse(i.next()));
        }
        return result;
    }

    public static VOMSESFileParser instance() {
        return new VOMSESFileParser();
    }

    static {
        File vomsVomses;
        File gliteVomses;
        File globusVomses;
        File gliteLocFile;
        log = Logger.getLogger(VOMSESFileParser.class);
        String gliteLoc = System.getProperty("GLITE_LOCATION", null);
        String vomsesLoc = System.getProperty("VOMSES_LOCATION", null);
        ArrayList<File> list = new ArrayList<File>();
        File defaultLocFile = new File(File.separator + "etc" + File.separator + "vomses");
        if (defaultLocFile.exists()) {
            list.add(defaultLocFile);
        }
        if (gliteLoc != null && (gliteLocFile = new File(gliteLoc + File.separator + "etc" + File.separator + "vomses")).exists()) {
            list.add(gliteLocFile);
        }
        if (vomsesLoc != null) {
            String[] userLocations = vomsesLoc.split(":");
            for (int i = 0; i < userLocations.length; ++i) {
                File vomsesLocFile = new File(userLocations[i] + File.separator + "vomses");
                if (!vomsesLocFile.exists()) continue;
                list.add(vomsesLocFile);
            }
        }
        if ((globusVomses = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "vomses")).exists()) {
            list.add(globusVomses);
        }
        if ((gliteVomses = new File(System.getProperty("user.home") + File.separator + ".glite" + File.separator + "vomses")).exists()) {
            list.add(gliteVomses);
        }
        if ((vomsVomses = new File(System.getProperty("user.home") + File.separator + ".voms" + File.separator + "vomses")).exists()) {
            list.add(vomsVomses);
        }
        vomsesPaths = list;
    }
}

