/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.FileCertReader;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSException;

public class VOMSKeyManager
implements X509KeyManager {
    private X509KeyManager manager;
    public static final int TYPE_PKCS12 = 1;
    public static final int TYPE_PEM = 2;
    private static final Logger logger = Logger.getLogger(VOMSKeyManager.class);

    public VOMSKeyManager(String certfile, String keyfile, String password) {
        this(certfile, keyfile, password, 2);
    }

    public VOMSKeyManager(UserCredentials creds) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        this.manager = null;
        if (creds.getUserKey() == null) {
            throw new UnrecoverableKeyException("Passed Credential does not hold a private key!");
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, "".toCharArray());
        logger.debug((Object)"ABOUT to set key entry");
        keyStore.setKeyEntry("alias", creds.getUserKey(), "".toCharArray(), creds.getUserChain());
        logger.debug((Object)("STORETYPE: " + keyStore.getType()));
        keyManagerFactory.init(keyStore, "".toCharArray());
        this.manager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
    }

    public VOMSKeyManager(String certfile, String keyfile, String password, int type) {
        block14: {
            this.manager = null;
            FileInputStream stream = null;
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                char[] passwd = password.toCharArray();
                KeyStore keyStore = null;
                if (type == 2) {
                    keyStore = KeyStore.getInstance("JKS");
                    keyStore = this.load(certfile, keyfile, passwd);
                } else if (type == 1) {
                    keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
                    stream = new FileInputStream(certfile);
                    keyStore.load(stream, passwd);
                }
                if (keyStore != null) {
                    keyManagerFactory.init(keyStore, passwd);
                    this.manager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
                    break block14;
                }
                throw new VOMSException("Cannot initialize VOMSKeyManager: ");
            }
            catch (Exception e) {
                throw new VOMSException("Cannot initialize VOMSKeyManager: ", e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    private KeyStore createKeyStore(String cert, String key, char[] passwd) throws CertificateException, IOException {
        FileCertReader reader = new FileCertReader();
        Certificate[] certs = reader.readCerts(cert).toArray(new X509Certificate[0]);
        PrivateKey pkey = null;
        KeyStore store = null;
        try {
            if (key == null) {
                throw new VOMSException("Cannot load the private key.");
            }
            pkey = reader.readPrivateKey(key);
        }
        catch (IOException e) {
            throw new VOMSException("Cannot load the private key.", e);
        }
        try {
            store = KeyStore.getInstance("JKS");
            store.setKeyEntry("alias", pkey, passwd, certs);
        }
        catch (KeyStoreException e) {
            throw new VOMSException("Cannot load the key pair.", e);
        }
        return store;
    }

    private KeyStore load(String certfile, String keyfile, char[] pwd) throws CertificateException, IOException {
        KeyStore store = null;
        store = !certfile.equals(keyfile) ? this.createKeyStore(certfile, keyfile, pwd) : this.createKeyStore(certfile, certfile, pwd);
        return store;
    }

    public String chooseClientAlias(String[] keytype, Principal[] issuers, Socket socket) {
        return this.manager.chooseClientAlias(keytype, issuers, socket);
    }

    public String chooseServerAlias(String keytype, Principal[] issuers, Socket socket) {
        return this.manager.chooseServerAlias(keytype, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.manager.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keytype, Principal[] issuers) {
        return this.manager.getClientAliases(keytype, issuers);
    }

    public String[] getServerAliases(String keytype, Principal[] issuers) {
        return this.manager.getServerAliases(keytype, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.manager.getPrivateKey(alias);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

