/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.SimpleTimeZone;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.X509Principal;
import org.glite.voms.PKIUtils;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.FullAttributes;

public class VOMSAttribute {
    private static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";
    private AttributeCertificate myAC;

    public byte[] getSignature() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getSignature();
    }

    public String getSerial() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getSerialNumber().getValue().toString();
    }

    private static Date convert(String t) throws ParseException {
        SimpleDateFormat dateF;
        if (t.indexOf("GMT") > 0) {
            dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        } else {
            dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        return dateF.parse(t);
    }

    public Date getNotAfter() throws ParseException {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        try {
            return this.myAC.getNotAfter();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate: " + e.getMessage());
        }
    }

    public Date getNotBefore() throws ParseException {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        try {
            return this.myAC.getNotBefore();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate: " + e.getMessage());
        }
    }

    public boolean validAt(Date date) {
        if (date == null) {
            date = new Date();
        }
        try {
            return this.getNotAfter().after(date) && this.getNotBefore().before(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate");
        }
    }

    public String getIssuer() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        X500Principal principal = this.myAC.getIssuer();
        return principal.getName();
    }

    public String getIssuerX509() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        X509Principal principal = this.myAC.getIssuerX509();
        if (principal != null) {
            return PKIUtils.getOpenSSLFormatPrincipal((Principal)principal);
        }
        return null;
    }

    public String getHolder() {
        GeneralName gn;
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        GeneralNames names = this.myAC.getHolder().getIssuer();
        Enumeration e = ((ASN1Sequence)names.getDERObject()).getObjects();
        if (e.hasMoreElements() && (gn = (GeneralName)e.nextElement()).getTagNo() == 4) {
            try {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                new DEROutputStream((OutputStream)b).writeObject((Object)gn.getName());
                X500Principal principal = new X500Principal(b.toByteArray());
                return principal.getName();
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public String getHolderX509() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHolderX509();
    }

    public boolean isValid() {
        return this.validAt(new Date());
    }

    public boolean isHolder(X509Certificate cert) {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHolder().isHolder(cert);
    }

    public boolean isIssuer(X509Certificate cert) {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getIssuer().equals(cert.getSubjectX500Principal());
    }

    public VOMSAttribute(AttributeCertificate ac) {
        if (ac == null) {
            throw new IllegalArgumentException("VOMSAttribute: AttributeCertificate is NULL");
        }
        this.myAC = ac;
    }

    public AttributeCertificate getAC() {
        return this.privateGetAC();
    }

    AttributeCertificate privateGetAC() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC;
    }

    public List getFullyQualifiedAttributes() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getFullyQualifiedAttributes();
    }

    public List getListOfFQAN() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getListOfFQAN();
    }

    public String getHostPort() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHostPort();
    }

    public String getHost() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHost();
    }

    public int getPort() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getPort();
    }

    public String getVO() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getVO();
    }

    public String toString() {
        return "VO      :" + this.getVO() + "\n" + "HostPort:" + this.getHostPort() + "\n" + "FQANs   :" + this.getListOfFQAN();
    }

    public FullAttributes getFullAttributes() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getFullAttributes();
    }

    public ACCerts getCertList() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getCertList();
    }

    public ACTargets getTargets() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getTargets();
    }
}

