/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIStoreCache;

public class PKIStoreFactory {
    private static PKIStore getCAStore(String dir, boolean aggressive, boolean timer) throws CertificateException, CRLException, IOException {
        String storeDir = dir == null ? PKIStore.DEFAULT_CADIR : dir;
        PKIStore s = PKIStoreCache.INSTANCE.getCAStore(storeDir);
        if (s == null) {
            PKIStoreCache.INSTANCE.addCAStore(storeDir, new PKIStore(dir, 2, aggressive, timer));
        }
        return PKIStoreCache.INSTANCE.getCAStore(storeDir);
    }

    private static PKIStore getVOMSStore(String dir, boolean aggressive, boolean timer) throws CertificateException, CRLException, IOException {
        String storeDir = dir == null ? PKIStore.DEFAULT_VOMSDIR : dir;
        PKIStore s = PKIStoreCache.INSTANCE.getVOMSStore(storeDir);
        if (s == null) {
            PKIStoreCache.INSTANCE.addVOMSStore(storeDir, new PKIStore(storeDir, 1, aggressive, timer));
        }
        return PKIStoreCache.INSTANCE.getVOMSStore(storeDir);
    }

    public static synchronized PKIStore getStore(String dir, int type, boolean aggressive, boolean timer) throws IOException, CertificateException, CRLException {
        if (type == 2) {
            return PKIStoreFactory.getCAStore(dir, aggressive, timer);
        }
        if (type == 1) {
            return PKIStoreFactory.getVOMSStore(dir, aggressive, timer);
        }
        throw new IllegalArgumentException("Unsupported store type: " + type);
    }

    public static synchronized PKIStore getStore(String dir, int type, boolean aggressive) throws IOException, CertificateException, CRLException {
        return PKIStoreFactory.getStore(dir, type, aggressive, true);
    }

    public static synchronized PKIStore getStore(String dir, int type) throws IOException, CertificateException, CRLException {
        return PKIStoreFactory.getStore(dir, type, true, true);
    }

    public static synchronized PKIStore getStore(int type) throws IOException, CertificateException, CRLException {
        return PKIStoreFactory.getStore(null, type, true, true);
    }

    public static synchronized PKIStore getStore() {
        return new PKIStore();
    }
}

