/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.DirectoryList;

class FileCertReader {
    static Logger logger = Logger.getLogger((String)FileCertReader.class.getName());
    static final int BUF_LEN = 1000;
    static final byte CARR = 13;
    static final byte NL = 10;
    static final int TYPE_ANCHOR = 100;
    static final int TYPE_CRL = 101;
    static final int TYPE_CERT = 102;
    CertificateFactory certFactory;

    public FileCertReader() throws CertificateException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (Exception e) {
            logger.error((Object)("Error while creating a FileCertReader: " + e.getMessage()));
            throw new CertificateException("Error while creating a FileCertReader: " + e.getMessage(), e);
        }
    }

    public FileCertReader(Provider provider) throws CertificateException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509", provider);
        }
        catch (Exception e) {
            logger.error((Object)("Error while creating a FileCertReader: " + e.getMessage()));
            throw new CertificateException("Error while creating a FileCertReader: " + e.getMessage(), e);
        }
    }

    public FileCertReader(String provider) throws CertificateException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509", provider);
        }
        catch (Exception e) {
            logger.error((Object)("Error while creating a FileCertReader: " + e.getMessage()));
            throw new CertificateException("Error while creating a FileCertReader: " + e.getMessage(), e);
        }
    }

    public Vector readCerts(String files) throws IOException, CertificateException {
        Vector certs = this.readFiles(files, 102);
        Iterator certIter = certs.iterator();
        logger.debug((Object)"read certs: ");
        while (certIter.hasNext()) {
            X509Certificate cert = (X509Certificate)certIter.next();
            logger.debug((Object)("Read cert: " + ((Object)cert.getSubjectDN()).toString()));
        }
        return certs;
    }

    public PrivateKey readPrivateKey(String file) throws IOException {
        File keyfile = new File(file);
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(keyfile));
        FileCertReader.skipToKeyBeginning(fis);
        return (PrivateKey)PrivateKeyInfo.getInstance((Object)new ASN1InputStream((InputStream)fis).readObject()).getPrivateKey();
    }

    public Vector readAnchors(String files) throws IOException, CertificateException {
        Vector anchors = this.readFiles(files, 100);
        Iterator anchorIter = anchors.iterator();
        logger.debug((Object)"read TrustAnchors: ");
        while (anchorIter.hasNext()) {
            TrustAnchor anchor = (TrustAnchor)anchorIter.next();
            logger.debug((Object)("Read TrustAnchor: " + ((Object)anchor.getTrustedCert().getSubjectDN()).toString()));
        }
        return anchors;
    }

    public Vector readCRLs(String files) throws IOException, CertificateException {
        Vector crls = this.readFiles(files, 101);
        Iterator crlIter = crls.iterator();
        logger.debug((Object)"read CRLs: ");
        while (crlIter.hasNext()) {
            X509CRL crl = (X509CRL)crlIter.next();
            logger.debug((Object)("Read CRL: " + ((Object)crl.getIssuerDN()).toString()));
        }
        return crls;
    }

    private Vector readFiles(String files, int type) throws CertificateException {
        Vector storeVector = new Vector();
        try {
            DirectoryList dir = new DirectoryList(files);
            for (File nextFile : dir.getListing()) {
                storeVector.addAll(this.readFile(nextFile, type));
            }
        }
        catch (IOException e) {
            logger.fatal((Object)("Error while reading certificates or CRLs: " + e.getMessage()));
            throw new CertificateException("Error while reading certificates or CRLs: " + e.getMessage(), e);
        }
        return storeVector;
    }

    public Vector readFile(File certFile, int type) throws IOException {
        BufferedInputStream binStream = null;
        Vector<Object> objects = new Vector<Object>();
        try {
            binStream = new BufferedInputStream(new FileInputStream(certFile));
            while (binStream.available() > 0) {
                Object obj = this.objectReader(binStream, type);
                if (obj != null) {
                    objects.add(obj);
                }
                FileCertReader.skipEmptyLines(binStream);
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("Error while reading certificates or crls from file " + certFile.toString() + "error was: " + e.getMessage()));
            throw new IOException("Error while reading certificates or crls from file " + certFile.toString() + "error was: " + e.getMessage());
        }
        finally {
            if (binStream != null) {
                binStream.close();
            }
        }
        return objects;
    }

    public Object objectReader(BufferedInputStream binStream, int type) throws CertificateException, IOException {
        Object object = null;
        int errors = 0;
        binStream.mark(10000);
        do {
            try {
                if (errors == 1) {
                    errors = 2;
                    FileCertReader.skipToCertBeginning(binStream);
                }
                binStream.mark(100000);
                binStream.reset();
                object = this.readObject(binStream, type);
            }
            catch (Exception e) {
                if (errors != 0) {
                    logger.error((Object)("Certificate or CRL reading failed: " + e.getMessage()));
                    throw new CertificateException("Certificate or CRL reading failed: " + e.getMessage(), e);
                }
                errors = 1;
                binStream.reset();
            }
        } while (errors == 1);
        return object;
    }

    public Object readObject(BufferedInputStream binStream, int type) throws CertificateException {
        Object obj;
        if (type == 101) {
            try {
                obj = this.certFactory.generateCRL(binStream);
            }
            catch (CRLException e) {
                logger.error((Object)("CRL loading failed: " + e.getMessage()));
                throw new CertificateException(e.getMessage(), e);
            }
        } else {
            X509Certificate cert = (X509Certificate)this.certFactory.generateCertificate(binStream);
            if (cert == null) {
                return null;
            }
            if (type == 100) {
                obj = new TrustAnchor(cert, null);
            } else if (type == 102) {
                obj = cert;
            } else {
                logger.fatal((Object)("Internal error: Invalid data type " + type + " when trying to read certificate"));
                throw new CertificateParsingException("Internal error: Invalid data type " + type + " when trying to read certificate");
            }
        }
        return obj;
    }

    public static void skipToCertBeginning(BufferedInputStream stream) throws IOException {
        byte[] b = new byte[1000];
        stream.mark(1002);
        while (stream.available() > 0) {
            int num = stream.read(b);
            String buffer = new String(b, 0, num);
            int index = buffer.indexOf("----BEGIN");
            if (index == -1) {
                stream.reset();
                stream.skip(900L);
                stream.mark(1002);
                continue;
            }
            while (buffer.charAt(index - 1) == '-' && index > 0 && --index != 0) {
            }
            stream.reset();
            stream.skip(index);
            stream.mark(10000);
            return;
        }
    }

    public static void skipToKeyBeginning(BufferedInputStream stream) throws IOException {
        byte[] b = new byte[1000];
        stream.mark(1002);
        while (stream.available() > 0) {
            int num = stream.read(b);
            String buffer = new String(b, 0, num);
            int index = buffer.indexOf("----BEGIN PRIVATE");
            if (index == -1) {
                index = buffer.indexOf("----BEGIN ENCRYPTED");
            }
            if (index == -1) {
                stream.reset();
                stream.skip(900L);
                stream.mark(1002);
                continue;
            }
            while (buffer.charAt(index - 1) == '-' && index > 0 && --index != 0) {
            }
            stream.reset();
            stream.skip(index);
            stream.mark(10000);
            return;
        }
    }

    public static void skipEmptyLines(BufferedInputStream stream) throws IOException {
        byte[] b = new byte[1000];
        stream.mark(1002);
        while (stream.available() > 0) {
            int i;
            int num = stream.read(b);
            for (i = 0; i < num && (b[i] == 13 || b[i] == 10); ++i) {
            }
            stream.reset();
            stream.skip(i);
            if (i < num) {
                stream.mark(10000);
                return;
            }
            stream.mark(1000);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

