/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleTypeDescriptor
extends AbstractTypeDescriptor<Locale> {
    public static final LocaleTypeDescriptor INSTANCE = new LocaleTypeDescriptor();

    public LocaleTypeDescriptor() {
        super(Locale.class);
    }

    @Override
    public Comparator<Locale> getComparator() {
        return LocaleComparator.INSTANCE;
    }

    @Override
    public String toString(Locale value) {
        return value.toString();
    }

    @Override
    public Locale fromString(String string) {
        StringTokenizer tokens = new StringTokenizer(string, "_");
        String language = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        String country = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        String variant = "";
        String sep = "";
        while (tokens.hasMoreTokens()) {
            variant = variant + sep + tokens.nextToken();
            sep = "_";
        }
        return new Locale(language, country, variant);
    }

    @Override
    public <X> X unwrap(Locale value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Locale wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocaleComparator
    implements Comparator<Locale> {
        public static final LocaleComparator INSTANCE = new LocaleComparator();

        @Override
        public int compare(Locale o1, Locale o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

