/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.util.LinkedHashSet;
import javax.transaction.Synchronization;
import org.hibernate.engine.transaction.NullSynchronizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationRegistry.class);
    private LinkedHashSet<Synchronization> synchronizations;

    public void registerSynchronization(Synchronization synchronization) {
        boolean added;
        if (synchronization == null) {
            throw new NullSynchronizationException();
        }
        if (this.synchronizations == null) {
            this.synchronizations = new LinkedHashSet();
        }
        if (!(added = this.synchronizations.add(synchronization))) {
            log.info("Synchronization [{}] was already registered", (Object)synchronization);
        }
    }

    public void notifySynchronizationsBeforeTransactionCompletion() {
        if (this.synchronizations != null) {
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    synchronization.beforeCompletion();
                }
                catch (Throwable t) {
                    log.error("exception calling user Synchronization [{}]", (Object)synchronization, (Object)t);
                }
            }
        }
    }

    public void notifySynchronizationsAfterTransactionCompletion(int status) {
        if (this.synchronizations != null) {
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    synchronization.afterCompletion(status);
                }
                catch (Throwable t) {
                    log.error("exception calling user Synchronization [{}]", (Object)synchronization, (Object)t);
                }
            }
        }
    }
}

