/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.CompareUtil;
import org.apache.tiles.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Serializable,
Cloneable {
    private static final String TEMPLATE_RENDERER = "template";
    protected Set<String> roles = null;
    protected Object value = null;
    protected String expression = null;
    protected Expression expressionObject = null;
    private String renderer = null;
    @Deprecated
    private String name = null;

    public Attribute() {
    }

    public Attribute(Object value) {
        this.value = value;
    }

    public Attribute(Attribute attribute) {
        this.name = attribute.name;
        this.roles = attribute.roles;
        this.value = attribute.getValue();
        this.expressionObject = attribute.expressionObject != null ? new Expression(attribute.expressionObject) : null;
        this.renderer = attribute.renderer;
    }

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Attribute(Object value, String role) {
        this.value = value;
        this.setRole(role);
    }

    @Deprecated
    public Attribute(Object value, String role, AttributeType type) {
        this.value = value;
        this.setType(type);
        this.setRole(role);
    }

    public Attribute(Object value, String expression, String role, String rendererName) {
        this(value, new Expression(expression), role, rendererName);
    }

    public Attribute(Object value, Expression expression, String role, String rendererName) {
        this.value = value;
        this.expressionObject = expression;
        this.renderer = rendererName;
        this.setRole(role);
    }

    public Attribute(String name, Object value, String role, AttributeType type) {
        this.name = name;
        this.value = value;
        this.setType(type);
        this.setRole(role);
    }

    public static Attribute createTemplateAttribute(String template) {
        Attribute attribute = new Attribute();
        attribute.setValue(template);
        attribute.setRenderer(TEMPLATE_RENDERER);
        return attribute;
    }

    public static Attribute createTemplateAttribute(String template, String templateExpression, String templateType, String role) {
        Attribute templateAttribute = Attribute.createTemplateAttribute(template);
        templateAttribute.setRole(role);
        if (templateType != null) {
            templateAttribute.setRenderer(templateType);
        }
        templateAttribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(templateExpression));
        return templateAttribute;
    }

    public static Attribute createTemplateAttributeWithExpression(String templateExpression) {
        Attribute attribute = new Attribute();
        attribute.setExpressionObject(new Expression(templateExpression));
        attribute.setRenderer(TEMPLATE_RENDERER);
        return attribute;
    }

    public String getRole() {
        String retValue = null;
        if (this.roles != null && !this.roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> roleIt = this.roles.iterator();
            if (roleIt.hasNext()) {
                builder.append(roleIt.next());
                while (roleIt.hasNext()) {
                    builder.append(",");
                    builder.append(roleIt.next());
                }
                retValue = builder.toString();
            }
        }
        return retValue;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRole(String role) {
        if (role != null && role.trim().length() > 0) {
            String[] rolesStrings = role.split("\\s*,\\s*");
            this.roles = new HashSet<String>();
            for (int i = 0; i < rolesStrings.length; ++i) {
                this.roles.add(rolesStrings[i]);
            }
        } else {
            this.roles = null;
        }
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getExpression() {
        if (this.expressionObject != null) {
            return this.expressionObject.getExpression();
        }
        return null;
    }

    public void setExpression(String expression) {
        this.expressionObject = expression != null ? new Expression(expression) : null;
    }

    public Expression getExpressionObject() {
        return this.expressionObject;
    }

    public void setExpressionObject(Expression expressionObject) {
        this.expressionObject = expressionObject;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public AttributeType getType() {
        return AttributeType.getType(this.renderer);
    }

    public void setType(AttributeType type) {
        this.renderer = type.toString();
    }

    public String getRenderer() {
        return this.renderer;
    }

    public void setRenderer(String rendererName) {
        this.renderer = rendererName;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    public void setBody(String body) {
        if (body != null && body.length() != 0) {
            this.setValue(body);
        }
    }

    public void inherit(Attribute attribute) {
        Expression targetExpressionObject;
        if (this.value == null) {
            this.value = attribute.getValue();
        }
        if ((targetExpressionObject = attribute.getExpressionObject()) != null && (this.expressionObject == null || this.expressionObject.getExpression() == null)) {
            this.expressionObject = new Expression(targetExpressionObject);
        }
        if (this.roles == null || this.roles.isEmpty()) {
            this.roles = attribute.getRoles();
        }
        if (this.renderer == null) {
            this.renderer = attribute.getRenderer();
        }
    }

    public boolean equals(Object obj) {
        Attribute attribute = (Attribute)obj;
        return CompareUtil.nullSafeEquals(this.value, attribute.value) && CompareUtil.nullSafeEquals(this.renderer, attribute.renderer) && CompareUtil.nullSafeEquals(this.roles, attribute.roles) && CompareUtil.nullSafeEquals(this.expressionObject, attribute.expressionObject);
    }

    public int hashCode() {
        return CompareUtil.nullSafeHashCode(this.value) + CompareUtil.nullSafeHashCode(this.renderer) + CompareUtil.nullSafeHashCode(this.roles) + CompareUtil.nullSafeHashCode(this.expressionObject);
    }

    public Attribute clone() {
        return new Attribute(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        STRING("string"),
        DEFINITION("definition"),
        TEMPLATE("template"),
        OBJECT("object");

        private String stringRepresentation;
        private static Map<String, AttributeType> representation2type;

        public static AttributeType getType(String stringRepresentation) {
            return representation2type.get(stringRepresentation);
        }

        private AttributeType(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        static {
            representation2type = new HashMap<String, AttributeType>();
            representation2type.put("string", STRING);
            representation2type.put("definition", DEFINITION);
            representation2type.put(Attribute.TEMPLATE_RENDERER, TEMPLATE);
            representation2type.put("object", OBJECT);
        }
    }
}

