/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.POPOPrivKey;
import com.novosec.pkix.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class ProofOfPossession
implements DEREncodable {
    DEREncodable obj;
    int tag;

    public ProofOfPossession(DEREncodable obj, int tag) {
        this.obj = obj;
        this.tag = tag;
    }

    public DERNull getRaVerified() {
        if (this.tag != 0) {
            return null;
        }
        if (this.obj instanceof DEROctetString) {
            return new DERNull();
        }
        return (DERNull)this.obj;
    }

    public POPOSigningKey getSignature() {
        if (this.tag != 1) {
            return null;
        }
        return (POPOSigningKey)this.obj;
    }

    public POPOPrivKey getKeyEncipherment() {
        if (this.tag != 2) {
            return null;
        }
        return (POPOPrivKey)this.obj;
    }

    public POPOPrivKey getKeyAgreement() {
        if (this.tag != 3) {
            return null;
        }
        return (POPOPrivKey)this.obj;
    }

    public static ProofOfPossession getInstance(DERObject obj) {
        return ProofOfPossession.getInstance((ASN1TaggedObject)obj, true);
    }

    public static ProofOfPossession getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        int tag = tagObj.getTagNo();
        switch (tag) {
            case 0: {
                return new ProofOfPossession((DEREncodable)tagObj.getObject(), 0);
            }
            case 1: {
                return new ProofOfPossession(POPOSigningKey.getInstance(tagObj.getObject()), 1);
            }
            case 2: {
                return new ProofOfPossession(POPOPrivKey.getInstance(tagObj.getObject()), 2);
            }
            case 3: {
                return new ProofOfPossession(POPOPrivKey.getInstance(tagObj.getObject()), 3);
            }
        }
        throw new IllegalArgumentException("unknown tag: " + tag);
    }

    public DERObject getDERObject() {
        return new DERTaggedObject(true, this.tag, this.obj);
    }

    public String toString() {
        return "ProofOfPossession: (" + this.obj + ")";
    }
}

