/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.OptionalValidity;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class CertTemplate
implements DEREncodable {
    public static final boolean bNameIsExplicit = true;
    private DERInteger version = null;
    private DERInteger serialNumber = null;
    private AlgorithmIdentifier signingAlg = null;
    private X509Name issuer = null;
    private OptionalValidity validity = null;
    private X509Name subject = null;
    private SubjectPublicKeyInfo publicKey = null;
    private DERBitString issuerUID = null;
    private DERBitString subjectUID = null;
    private X509Extensions extensions = null;

    public static CertTemplate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertTemplate.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertTemplate getInstance(Object obj) {
        if (obj == null) {
            return new CertTemplate();
        }
        if (obj instanceof CertTemplate) {
            return (CertTemplate)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertTemplate((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertTemplate(ASN1Sequence seq) {
        Enumeration e;
        Enumeration enumeration = e = seq == null ? null : seq.getObjects();
        block12: while (e != null && e.hasMoreElements()) {
            DERTaggedObject obj = (DERTaggedObject)e.nextElement();
            int tagno = obj == null ? -1 : obj.getTagNo();
            switch (tagno) {
                case 0: {
                    this.version = DERInteger.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
                case 1: {
                    this.serialNumber = DERInteger.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
                case 2: {
                    this.signingAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
                case 3: {
                    this.issuer = X509Name.getInstance((ASN1TaggedObject)obj, (boolean)true);
                    continue block12;
                }
                case 4: {
                    this.validity = OptionalValidity.getInstance((ASN1TaggedObject)obj, false);
                    continue block12;
                }
                case 5: {
                    this.subject = X509Name.getInstance((ASN1TaggedObject)obj, (boolean)true);
                    continue block12;
                }
                case 6: {
                    this.publicKey = SubjectPublicKeyInfo.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
                case 7: {
                    this.issuerUID = DERBitString.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
                case 8: {
                    this.subjectUID = DERBitString.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
                case 9: {
                    this.extensions = X509Extensions.getInstance((ASN1TaggedObject)obj, (boolean)false);
                    continue block12;
                }
            }
            throw new IllegalArgumentException("invalid asn1 sequence");
        }
    }

    public CertTemplate() {
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public void setVersion(DERInteger version) {
        this.version = version;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(DERInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public AlgorithmIdentifier getSigningAlg() {
        return this.signingAlg;
    }

    public void setSigningAlg(AlgorithmIdentifier signingAlg) {
        this.signingAlg = signingAlg;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public void setIssuer(X509Name issuer) {
        this.issuer = issuer;
    }

    public OptionalValidity getValidity() {
        return this.validity;
    }

    public void setValidity(OptionalValidity validity) {
        this.validity = validity;
    }

    public X509Name getSubject() {
        return this.subject;
    }

    public void setSubject(X509Name subject) {
        this.subject = subject;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(SubjectPublicKeyInfo publicKey) {
        this.publicKey = publicKey;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public void setIssuerUID(DERBitString issuerUID) {
        this.issuerUID = issuerUID;
    }

    public DERBitString getSubjectUID() {
        return this.subjectUID;
    }

    public void setSubjectUID(DERBitString subjectUID) {
        this.subjectUID = subjectUID;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(X509Extensions extensions) {
        this.extensions = extensions;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.version != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.version));
        }
        if (this.serialNumber != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.serialNumber));
        }
        if (this.signingAlg != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)this.signingAlg));
        }
        if (this.issuer != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 3, (DEREncodable)this.issuer));
        }
        if (this.validity != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 4, (DEREncodable)this.validity));
        }
        if (this.subject != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 5, (DEREncodable)this.subject));
        }
        if (this.publicKey != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 6, (DEREncodable)this.publicKey));
        }
        if (this.issuerUID != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 7, (DEREncodable)this.issuerUID));
        }
        if (this.subjectUID != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 8, (DEREncodable)this.subjectUID));
        }
        if (this.extensions != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 9, (DEREncodable)this.extensions));
        }
        return new DERSequence(v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(" (");
        if (this.getVersion() != null) {
            sb.append("version: " + this.getVersion() + ", ");
        }
        if (this.getSerialNumber() != null) {
            sb.append("serialNumber: " + this.getSerialNumber() + ", ");
        }
        if (this.getSigningAlg() != null) {
            sb.append("signingAlg: " + this.getSigningAlg() + ", ");
        }
        if (this.getIssuer() != null) {
            sb.append("issuer: " + this.getIssuer() + ", ");
        }
        if (this.getValidity() != null) {
            sb.append("validity: " + this.getValidity() + ", ");
        }
        if (this.getSubject() != null) {
            sb.append("subject: " + this.getSubject() + ", ");
        }
        if (this.getPublicKey() != null) {
            sb.append("publicKey: " + this.getPublicKey() + ", ");
        }
        if (this.getIssuerUID() != null) {
            sb.append("issuerUID: " + this.getIssuerUID() + ", ");
        }
        if (this.getSubjectUID() != null) {
            sb.append("subjectUID: " + this.getSubjectUID() + ", ");
        }
        if (this.getExtensions() != null) {
            sb.append("extensions: " + this.getExtensions() + ", ");
        }
        sb.append("hashCode: " + Integer.toHexString(this.hashCode()) + ")");
        return sb.toString();
    }
}

