/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.CertifiedKeyPair;
import com.novosec.pkix.asn1.cmp.PKIStatusInfo;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class CertResponse
implements DEREncodable {
    DERInteger certReqId;
    PKIStatusInfo status;
    CertifiedKeyPair certifiedKeyPair;
    DEROctetString rspInfo;

    public static CertResponse getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertResponse.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertResponse getInstance(Object obj) {
        if (obj instanceof CertResponse) {
            return (CertResponse)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertResponse((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertResponse(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.certReqId = DERInteger.getInstance(e.nextElement());
        this.status = PKIStatusInfo.getInstance(e.nextElement());
        Object obj = null;
        if (e.hasMoreElements()) {
            obj = e.nextElement();
        }
        if (obj instanceof ASN1Sequence) {
            this.certifiedKeyPair = CertifiedKeyPair.getInstance(obj);
            if (e.hasMoreElements()) {
                obj = e.nextElement();
            }
        }
        if (obj instanceof DEROctetString) {
            this.rspInfo = obj;
        }
    }

    public CertResponse(DERInteger certReqId, PKIStatusInfo status) {
        this.certReqId = certReqId;
        this.status = status;
    }

    public DERInteger getCertReqId() {
        return this.certReqId;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public void setCertifiedKeyPair(CertifiedKeyPair certifiedKeyPair) {
        this.certifiedKeyPair = certifiedKeyPair;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.certifiedKeyPair;
    }

    public void setRspInfo(DEROctetString rspInfo) {
        this.rspInfo = rspInfo;
    }

    public DEROctetString getRspInfo() {
        return this.rspInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certReqId);
        v.add((DEREncodable)this.status);
        if (this.certifiedKeyPair != null) {
            v.add((DEREncodable)this.certifiedKeyPair);
        }
        if (this.rspInfo != null) {
            v.add((DEREncodable)this.rspInfo);
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "CertResponse: ( certReqId: " + this.getCertReqId() + ", status: " + this.getStatus() + ", ";
        if (this.getCertifiedKeyPair() != null) {
            s = s + "certifiedKeyPair: " + this.getCertifiedKeyPair() + ", ";
        }
        if (this.getRspInfo() != null) {
            s = s + "rspInfo: " + this.getRspInfo() + ", ";
        }
        s = s + ")";
        return s;
    }
}

