/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.CertResponse;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CertRepMessage
implements DEREncodable {
    Vector caPubs = new Vector();
    Vector responses = new Vector();

    public static CertRepMessage getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertRepMessage.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertRepMessage getInstance(Object obj) {
        if (obj instanceof CertRepMessage) {
            return (CertRepMessage)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertRepMessage((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertRepMessage(ASN1Sequence seq) {
        int i;
        ASN1Sequence s;
        Enumeration e = seq.getObjects();
        Object obj = e.nextElement();
        if (obj instanceof ASN1TaggedObject) {
            s = (ASN1Sequence)((ASN1TaggedObject)obj).getObject();
            for (i = 0; i < s.size(); ++i) {
                this.caPubs.add(X509CertificateStructure.getInstance((Object)s.getObjectAt(i)));
            }
            obj = e.nextElement();
        }
        s = (ASN1Sequence)obj;
        for (i = 0; i < s.size(); ++i) {
            this.responses.add(CertResponse.getInstance(s.getObjectAt(i)));
        }
    }

    public CertRepMessage(CertResponse response) {
        this.responses.addElement(response);
    }

    public void addCaPubs(X509CertificateStructure caPub) {
        this.caPubs.addElement(caPub);
    }

    public X509CertificateStructure getCaPubs(int nr) {
        if (nr < this.caPubs.size()) {
            return (X509CertificateStructure)this.caPubs.elementAt(nr);
        }
        return null;
    }

    public void addResponse(CertResponse response) {
        this.responses.addElement(response);
    }

    public CertResponse getResponse(int nr) {
        if (nr < this.responses.size()) {
            return (CertResponse)this.responses.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        int i;
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.caPubs.size() > 0) {
            ASN1EncodableVector capv = new ASN1EncodableVector();
            for (i = 0; i < this.caPubs.size(); ++i) {
                capv.add((DEREncodable)((X509CertificateStructure)this.caPubs.elementAt(i)));
            }
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)new DERSequence(capv)));
        }
        ASN1EncodableVector resp = new ASN1EncodableVector();
        for (i = 0; i < this.responses.size(); ++i) {
            resp.add((DEREncodable)((CertResponse)this.responses.elementAt(i)));
        }
        v.add((DEREncodable)new DERSequence(resp));
        return new DERSequence(v);
    }

    public String toString() {
        int i;
        String s = "CertRepMessage: ( ";
        if (this.caPubs.size() > 0) {
            s = s + "caPubs: (";
            for (i = 0; i < this.caPubs.size(); ++i) {
                s = s + (X509CertificateStructure)this.caPubs.elementAt(i);
            }
            s = s + "), ";
        }
        s = s + "responses: (";
        for (i = 0; i < this.responses.size(); ++i) {
            s = s + (CertResponse)this.responses.elementAt(i);
        }
        s = s + ")";
        return s;
    }
}

