/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CAKeyUpdAnnContent
implements DEREncodable {
    X509CertificateStructure oldWithNew;
    X509CertificateStructure newWithOld;
    X509CertificateStructure newWithNew;

    public static CAKeyUpdAnnContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CAKeyUpdAnnContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CAKeyUpdAnnContent getInstance(Object obj) {
        if (obj instanceof CAKeyUpdAnnContent) {
            return (CAKeyUpdAnnContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CAKeyUpdAnnContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CAKeyUpdAnnContent(ASN1Sequence seq) {
        this.oldWithNew = X509CertificateStructure.getInstance((Object)seq.getObjectAt(0));
        this.newWithOld = X509CertificateStructure.getInstance((Object)seq.getObjectAt(1));
        this.newWithNew = X509CertificateStructure.getInstance((Object)seq.getObjectAt(2));
    }

    public CAKeyUpdAnnContent(X509CertificateStructure oldWithNew, X509CertificateStructure newWithOld, X509CertificateStructure newWithNew) {
        this.oldWithNew = oldWithNew;
        this.newWithOld = newWithOld;
        this.newWithNew = newWithNew;
    }

    public X509CertificateStructure getOldWithNew() {
        return this.oldWithNew;
    }

    public X509CertificateStructure getNewWithOld() {
        return this.newWithOld;
    }

    public X509CertificateStructure getNewWithNew() {
        return this.newWithNew;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.oldWithNew);
        v.add((DEREncodable)this.newWithOld);
        v.add((DEREncodable)this.newWithNew);
        return new DERSequence(v);
    }

    public String toString() {
        return "CAKeyUpdAnnContent: oldWithNew = " + this.getOldWithNew() + ", " + "newWithOld = " + this.getNewWithOld() + ", " + "newWithNew = " + this.getNewWithNew() + ")";
    }
}

