/*
 * Decompiled with CFR 0.152.
 */
package nordugrid.arc;

import java.math.BigInteger;
import nordugrid.arc.CacheState;
import nordugrid.arc.DTRCacheParameters;
import nordugrid.arc.DTRCallback;
import nordugrid.arc.DTRErrorStatus;
import nordugrid.arc.DTRLogger;
import nordugrid.arc.DTRPointer;
import nordugrid.arc.DTRStatus;
import nordugrid.arc.DataHandle;
import nordugrid.arc.LogLevel;
import nordugrid.arc.Period;
import nordugrid.arc.StagingProcesses;
import nordugrid.arc.Time;
import nordugrid.arc.URL;
import nordugrid.arc.URLVector;
import nordugrid.arc.User;
import nordugrid.arc.UserConfig;
import nordugrid.arc.arcJNI;

public class DTR {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Object objectManagingMyMemory;

    protected DTR(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DTR dTR) {
        return dTR == null ? 0L : dTR.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                arcJNI.delete_DTR(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    protected void setMemoryManager(Object object) {
        this.objectManagingMyMemory = object;
    }

    public static URL getLOCAL_DELIVERY() {
        long l = arcJNI.DTR_LOCAL_DELIVERY_get();
        return l == 0L ? null : new URL(l, false);
    }

    public static void setLOG_LEVEL(LogLevel logLevel) {
        arcJNI.DTR_LOG_LEVEL_set(logLevel.swigValue());
    }

    public static LogLevel getLOG_LEVEL() {
        return LogLevel.swigToEnum(arcJNI.DTR_LOG_LEVEL_get());
    }

    public DTR(String string, String string2, UserConfig userConfig, String string3, int n, DTRLogger dTRLogger) {
        this(arcJNI.new_DTR(string, string2, UserConfig.getCPtr(userConfig), userConfig, string3, n, DTRLogger.getCPtr(dTRLogger), dTRLogger), true);
    }

    public boolean toBool() {
        return arcJNI.DTR_toBool(this.swigCPtr, this);
    }

    public void registerCallback(DTRCallback dTRCallback, StagingProcesses stagingProcesses) {
        arcJNI.DTR_registerCallback(this.swigCPtr, this, DTRCallback.getCPtr(dTRCallback), dTRCallback, stagingProcesses.swigValue());
    }

    public void reset() {
        arcJNI.DTR_reset(this.swigCPtr, this);
    }

    public void set_id(String string) {
        arcJNI.DTR_set_id(this.swigCPtr, this, string);
    }

    public String get_id() {
        return arcJNI.DTR_get_id(this.swigCPtr, this);
    }

    public String get_short_id() {
        return arcJNI.DTR_get_short_id(this.swigCPtr, this);
    }

    public DataHandle get_source() {
        long l = arcJNI.DTR_get_source(this.swigCPtr, this);
        DataHandle dataHandle = null;
        if (l != 0L) {
            dataHandle = new DataHandle(l, false);
            dataHandle.setMemoryManager(this);
        }
        return dataHandle;
    }

    public DataHandle get_destination() {
        long l = arcJNI.DTR_get_destination(this.swigCPtr, this);
        DataHandle dataHandle = null;
        if (l != 0L) {
            dataHandle = new DataHandle(l, false);
            dataHandle.setMemoryManager(this);
        }
        return dataHandle;
    }

    public String get_source_str() {
        return arcJNI.DTR_get_source_str(this.swigCPtr, this);
    }

    public String get_destination_str() {
        return arcJNI.DTR_get_destination_str(this.swigCPtr, this);
    }

    public UserConfig get_usercfg() {
        long l = arcJNI.DTR_get_usercfg(this.swigCPtr, this);
        UserConfig userConfig = null;
        if (l != 0L) {
            userConfig = new UserConfig(l, false);
            userConfig.setMemoryManager(this);
        }
        return userConfig;
    }

    public void set_timeout(long l) {
        arcJNI.DTR_set_timeout(this.swigCPtr, this, l);
    }

    public Time get_timeout() {
        return new Time(arcJNI.DTR_get_timeout(this.swigCPtr, this), true);
    }

    public void set_process_time(Period period) {
        arcJNI.DTR_set_process_time(this.swigCPtr, this, Period.getCPtr(period), period);
    }

    public Time get_process_time() {
        return new Time(arcJNI.DTR_get_process_time(this.swigCPtr, this), true);
    }

    public Time get_creation_time() {
        return new Time(arcJNI.DTR_get_creation_time(this.swigCPtr, this), true);
    }

    public Time get_modification_time() {
        return new Time(arcJNI.DTR_get_modification_time(this.swigCPtr, this), true);
    }

    public String get_parent_job_id() {
        return arcJNI.DTR_get_parent_job_id(this.swigCPtr, this);
    }

    public void set_priority(int n) {
        arcJNI.DTR_set_priority(this.swigCPtr, this, n);
    }

    public int get_priority() {
        return arcJNI.DTR_get_priority(this.swigCPtr, this);
    }

    public void set_rfc_proxy(boolean bl) {
        arcJNI.DTR_set_rfc_proxy(this.swigCPtr, this, bl);
    }

    public boolean is_rfc_proxy() {
        return arcJNI.DTR_is_rfc_proxy(this.swigCPtr, this);
    }

    public void set_transfer_share(String string) {
        arcJNI.DTR_set_transfer_share(this.swigCPtr, this, string);
    }

    public String get_transfer_share() {
        return arcJNI.DTR_get_transfer_share(this.swigCPtr, this);
    }

    public void set_sub_share(String string) {
        arcJNI.DTR_set_sub_share(this.swigCPtr, this, string);
    }

    public String get_sub_share() {
        return arcJNI.DTR_get_sub_share(this.swigCPtr, this);
    }

    public void set_tries_left(long l) {
        arcJNI.DTR_set_tries_left(this.swigCPtr, this, l);
    }

    public long get_tries_left() {
        return arcJNI.DTR_get_tries_left(this.swigCPtr, this);
    }

    public long get_initial_tries() {
        return arcJNI.DTR_get_initial_tries(this.swigCPtr, this);
    }

    public void decrease_tries_left() {
        arcJNI.DTR_decrease_tries_left(this.swigCPtr, this);
    }

    public void set_status(DTRStatus dTRStatus) {
        arcJNI.DTR_set_status(this.swigCPtr, this, DTRStatus.getCPtr(dTRStatus), dTRStatus);
    }

    public DTRStatus get_status() {
        return new DTRStatus(arcJNI.DTR_get_status(this.swigCPtr, this), true);
    }

    public void set_error_status(DTRErrorStatus.DTRErrorStatusType dTRErrorStatusType, DTRErrorStatus.DTRErrorLocation dTRErrorLocation, String string) {
        arcJNI.DTR_set_error_status__SWIG_0(this.swigCPtr, this, dTRErrorStatusType.swigValue(), dTRErrorLocation.swigValue(), string);
    }

    public void set_error_status(DTRErrorStatus.DTRErrorStatusType dTRErrorStatusType, DTRErrorStatus.DTRErrorLocation dTRErrorLocation) {
        arcJNI.DTR_set_error_status__SWIG_1(this.swigCPtr, this, dTRErrorStatusType.swigValue(), dTRErrorLocation.swigValue());
    }

    public void reset_error_status() {
        arcJNI.DTR_reset_error_status(this.swigCPtr, this);
    }

    public DTRErrorStatus get_error_status() {
        return new DTRErrorStatus(arcJNI.DTR_get_error_status(this.swigCPtr, this), true);
    }

    public void set_bytes_transferred(BigInteger bigInteger) {
        arcJNI.DTR_set_bytes_transferred(this.swigCPtr, this, bigInteger);
    }

    public BigInteger get_bytes_transferred() {
        return arcJNI.DTR_get_bytes_transferred(this.swigCPtr, this);
    }

    public void set_cancel_request() {
        arcJNI.DTR_set_cancel_request(this.swigCPtr, this);
    }

    public boolean cancel_requested() {
        return arcJNI.DTR_cancel_requested(this.swigCPtr, this);
    }

    public void set_delivery_endpoint(URL uRL) {
        arcJNI.DTR_set_delivery_endpoint(this.swigCPtr, this, URL.getCPtr(uRL), uRL);
    }

    public URL get_delivery_endpoint() {
        long l = arcJNI.DTR_get_delivery_endpoint(this.swigCPtr, this);
        URL uRL = null;
        if (l != 0L) {
            uRL = new URL(l, false);
            uRL.setMemoryManager(this);
        }
        return uRL;
    }

    public void add_problematic_delivery_service(URL uRL) {
        arcJNI.DTR_add_problematic_delivery_service(this.swigCPtr, this, URL.getCPtr(uRL), uRL);
    }

    public URLVector get_problematic_delivery_services() {
        long l = arcJNI.DTR_get_problematic_delivery_services(this.swigCPtr, this);
        URLVector uRLVector = null;
        if (l != 0L) {
            uRLVector = new URLVector(l, false);
            uRLVector.setMemoryManager(this);
        }
        return uRLVector;
    }

    public void host_cert_for_remote_delivery(boolean bl) {
        arcJNI.DTR_host_cert_for_remote_delivery__SWIG_0(this.swigCPtr, this, bl);
    }

    public boolean host_cert_for_remote_delivery() {
        return arcJNI.DTR_host_cert_for_remote_delivery__SWIG_1(this.swigCPtr, this);
    }

    public void set_cache_file(String string) {
        arcJNI.DTR_set_cache_file(this.swigCPtr, this, string);
    }

    public String get_cache_file() {
        return arcJNI.DTR_get_cache_file(this.swigCPtr, this);
    }

    public void set_cache_parameters(DTRCacheParameters dTRCacheParameters) {
        arcJNI.DTR_set_cache_parameters(this.swigCPtr, this, DTRCacheParameters.getCPtr(dTRCacheParameters), dTRCacheParameters);
    }

    public DTRCacheParameters get_cache_parameters() {
        long l = arcJNI.DTR_get_cache_parameters(this.swigCPtr, this);
        DTRCacheParameters dTRCacheParameters = null;
        if (l != 0L) {
            dTRCacheParameters = new DTRCacheParameters(l, false);
            dTRCacheParameters.setMemoryManager(this);
        }
        return dTRCacheParameters;
    }

    public void set_cache_state(CacheState cacheState) {
        arcJNI.DTR_set_cache_state(this.swigCPtr, this, cacheState.swigValue());
    }

    public CacheState get_cache_state() {
        return CacheState.swigToEnum(arcJNI.DTR_get_cache_state(this.swigCPtr, this));
    }

    public void set_mapped_source(String string) {
        arcJNI.DTR_set_mapped_source__SWIG_0(this.swigCPtr, this, string);
    }

    public void set_mapped_source() {
        arcJNI.DTR_set_mapped_source__SWIG_1(this.swigCPtr, this);
    }

    public String get_mapped_source() {
        return arcJNI.DTR_get_mapped_source(this.swigCPtr, this);
    }

    public StagingProcesses get_owner() {
        return StagingProcesses.swigToEnum(arcJNI.DTR_get_owner(this.swigCPtr, this));
    }

    public User get_local_user() {
        return new User(arcJNI.DTR_get_local_user(this.swigCPtr, this), true);
    }

    public void set_replication(boolean bl) {
        arcJNI.DTR_set_replication(this.swigCPtr, this, bl);
    }

    public boolean is_replication() {
        return arcJNI.DTR_is_replication(this.swigCPtr, this);
    }

    public void set_force_registration(boolean bl) {
        arcJNI.DTR_set_force_registration(this.swigCPtr, this, bl);
    }

    public boolean is_force_registration() {
        return arcJNI.DTR_is_force_registration(this.swigCPtr, this);
    }

    public void set_bulk_start(boolean bl) {
        arcJNI.DTR_set_bulk_start(this.swigCPtr, this, bl);
    }

    public boolean get_bulk_start() {
        return arcJNI.DTR_get_bulk_start(this.swigCPtr, this);
    }

    public void set_bulk_end(boolean bl) {
        arcJNI.DTR_set_bulk_end(this.swigCPtr, this, bl);
    }

    public boolean get_bulk_end() {
        return arcJNI.DTR_get_bulk_end(this.swigCPtr, this);
    }

    public boolean bulk_possible() {
        return arcJNI.DTR_bulk_possible(this.swigCPtr, this);
    }

    public DTRLogger get_logger() {
        long l = arcJNI.DTR_get_logger(this.swigCPtr, this);
        DTRLogger dTRLogger = null;
        if (l != 0L) {
            dTRLogger = new DTRLogger(l, false);
            dTRLogger.setMemoryManager(this);
        }
        return dTRLogger;
    }

    public void connect_logger() {
        arcJNI.DTR_connect_logger(this.swigCPtr, this);
    }

    public void disconnect_logger() {
        arcJNI.DTR_disconnect_logger(this.swigCPtr, this);
    }

    public static void push(DTRPointer dTRPointer, StagingProcesses stagingProcesses) {
        arcJNI.DTR_push(DTRPointer.getCPtr(dTRPointer), dTRPointer, stagingProcesses.swigValue());
    }

    public boolean suspend() {
        return arcJNI.DTR_suspend(this.swigCPtr, this);
    }

    public boolean error() {
        return arcJNI.DTR_error(this.swigCPtr, this);
    }

    public boolean is_destined_for_pre_processor() {
        return arcJNI.DTR_is_destined_for_pre_processor(this.swigCPtr, this);
    }

    public boolean is_destined_for_post_processor() {
        return arcJNI.DTR_is_destined_for_post_processor(this.swigCPtr, this);
    }

    public boolean is_destined_for_delivery() {
        return arcJNI.DTR_is_destined_for_delivery(this.swigCPtr, this);
    }

    public boolean came_from_pre_processor() {
        return arcJNI.DTR_came_from_pre_processor(this.swigCPtr, this);
    }

    public boolean came_from_post_processor() {
        return arcJNI.DTR_came_from_post_processor(this.swigCPtr, this);
    }

    public boolean came_from_delivery() {
        return arcJNI.DTR_came_from_delivery(this.swigCPtr, this);
    }

    public boolean came_from_generator() {
        return arcJNI.DTR_came_from_generator(this.swigCPtr, this);
    }

    public boolean is_in_final_state() {
        return arcJNI.DTR_is_in_final_state(this.swigCPtr, this);
    }
}

