# Generated by rpcgen.py from nfs4.x on Wed Mar  6 22:34:22 2013
import nfs4_const as const
import nfs4_type as types
import xdrlib
from xdrlib import Error as XDRError

class nullclass(object):
    pass

class NFS4Packer(xdrlib.Packer):
    def __init__(self, check_enum=True, check_array=True):
        xdrlib.Packer.__init__(self)
        self.check_enum = check_enum
        self.check_array = check_array

    pack_hyper = xdrlib.Packer.pack_hyper
    pack_string = xdrlib.Packer.pack_string
    pack_int = xdrlib.Packer.pack_int
    pack_float = xdrlib.Packer.pack_float
    pack_uint = xdrlib.Packer.pack_uint
    pack_opaque = xdrlib.Packer.pack_opaque
    pack_double = xdrlib.Packer.pack_double
    pack_unsigned = xdrlib.Packer.pack_uint
    pack_quadruple = xdrlib.Packer.pack_double
    pack_uhyper = xdrlib.Packer.pack_uhyper
    pack_bool = xdrlib.Packer.pack_bool
    pack_int32_t = pack_int

    pack_uint32_t = pack_uint

    pack_int64_t = pack_hyper

    pack_uint64_t = pack_uhyper

    def pack_authsys_parms(self, data):
        if hasattr(self, 'filter_authsys_parms'):
            data = getattr(self, 'filter_authsys_parms')(data)
        if data.stamp is None:
            raise TypeError, 'data.stamp == None'
        self.pack_uint(data.stamp)
        if data.machinename is None:
            raise TypeError, 'data.machinename == None'
        if len(data.machinename) > 255 and self.check_array:
            raise XDRError, 'array length too long for data.machinename'
        self.pack_string(data.machinename)
        if data.uid is None:
            raise TypeError, 'data.uid == None'
        self.pack_uint(data.uid)
        if data.gid is None:
            raise TypeError, 'data.gid == None'
        self.pack_uint(data.gid)
        if data.gids is None:
            raise TypeError, 'data.gids == None'
        if len(data.gids) > 16 and self.check_array:
            raise XDRError, 'array length too long for data.gids'
        self.pack_array(data.gids, self.pack_uint)

    def pack_nfs_ftype4(self, data):
        if hasattr(self, 'filter_nfs_ftype4'):
            data = getattr(self, 'filter_nfs_ftype4')(data)
        if self.check_enum and data not in [const.NF4REG, const.NF4DIR, const.NF4BLK, const.NF4CHR, const.NF4LNK, const.NF4SOCK, const.NF4FIFO, const.NF4ATTRDIR, const.NF4NAMEDATTR]:
            raise XDRError, 'value=%s not in enum nfs_ftype4' % data
        self.pack_int(data)

    def pack_nfsstat4(self, data):
        if hasattr(self, 'filter_nfsstat4'):
            data = getattr(self, 'filter_nfsstat4')(data)
        if self.check_enum and data not in [const.NFS4_OK, const.NFS4ERR_PERM, const.NFS4ERR_NOENT, const.NFS4ERR_IO, const.NFS4ERR_NXIO, const.NFS4ERR_ACCESS, const.NFS4ERR_EXIST, const.NFS4ERR_XDEV, const.NFS4ERR_NOTDIR, const.NFS4ERR_ISDIR, const.NFS4ERR_INVAL, const.NFS4ERR_FBIG, const.NFS4ERR_NOSPC, const.NFS4ERR_ROFS, const.NFS4ERR_MLINK, const.NFS4ERR_NAMETOOLONG, const.NFS4ERR_NOTEMPTY, const.NFS4ERR_DQUOT, const.NFS4ERR_STALE, const.NFS4ERR_BADHANDLE, const.NFS4ERR_BAD_COOKIE, const.NFS4ERR_NOTSUPP, const.NFS4ERR_TOOSMALL, const.NFS4ERR_SERVERFAULT, const.NFS4ERR_BADTYPE, const.NFS4ERR_DELAY, const.NFS4ERR_SAME, const.NFS4ERR_DENIED, const.NFS4ERR_EXPIRED, const.NFS4ERR_LOCKED, const.NFS4ERR_GRACE, const.NFS4ERR_FHEXPIRED, const.NFS4ERR_SHARE_DENIED, const.NFS4ERR_WRONGSEC, const.NFS4ERR_CLID_INUSE, const.NFS4ERR_RESOURCE, const.NFS4ERR_MOVED, const.NFS4ERR_NOFILEHANDLE, const.NFS4ERR_MINOR_VERS_MISMATCH, const.NFS4ERR_STALE_CLIENTID, const.NFS4ERR_STALE_STATEID, const.NFS4ERR_OLD_STATEID, const.NFS4ERR_BAD_STATEID, const.NFS4ERR_BAD_SEQID, const.NFS4ERR_NOT_SAME, const.NFS4ERR_LOCK_RANGE, const.NFS4ERR_SYMLINK, const.NFS4ERR_RESTOREFH, const.NFS4ERR_LEASE_MOVED, const.NFS4ERR_ATTRNOTSUPP, const.NFS4ERR_NO_GRACE, const.NFS4ERR_RECLAIM_BAD, const.NFS4ERR_RECLAIM_CONFLICT, const.NFS4ERR_BADXDR, const.NFS4ERR_LOCKS_HELD, const.NFS4ERR_OPENMODE, const.NFS4ERR_BADOWNER, const.NFS4ERR_BADCHAR, const.NFS4ERR_BADNAME, const.NFS4ERR_BAD_RANGE, const.NFS4ERR_LOCK_NOTSUPP, const.NFS4ERR_OP_ILLEGAL, const.NFS4ERR_DEADLOCK, const.NFS4ERR_FILE_OPEN, const.NFS4ERR_ADMIN_REVOKED, const.NFS4ERR_CB_PATH_DOWN, const.NFS4ERR_BADIOMODE, const.NFS4ERR_BADLAYOUT, const.NFS4ERR_BAD_SESSION_DIGEST, const.NFS4ERR_BADSESSION, const.NFS4ERR_BADSLOT, const.NFS4ERR_COMPLETE_ALREADY, const.NFS4ERR_CONN_NOT_BOUND_TO_SESSION, const.NFS4ERR_DELEG_ALREADY_WANTED, const.NFS4ERR_BACK_CHAN_BUSY, const.NFS4ERR_LAYOUTTRYLATER, const.NFS4ERR_LAYOUTUNAVAILABLE, const.NFS4ERR_NOMATCHING_LAYOUT, const.NFS4ERR_RECALLCONFLICT, const.NFS4ERR_UNKNOWN_LAYOUTTYPE, const.NFS4ERR_SEQ_MISORDERED, const.NFS4ERR_SEQUENCE_POS, const.NFS4ERR_REQ_TOO_BIG, const.NFS4ERR_REP_TOO_BIG, const.NFS4ERR_REP_TOO_BIG_TO_CACHE, const.NFS4ERR_RETRY_UNCACHED_REP, const.NFS4ERR_UNSAFE_COMPOUND, const.NFS4ERR_TOO_MANY_OPS, const.NFS4ERR_OP_NOT_IN_SESSION, const.NFS4ERR_HASH_ALG_UNSUPP, const.NFS4ERR_CONN_BINDING_NOT_ENFORCED, const.NFS4ERR_CLIENTID_BUSY, const.NFS4ERR_PNFS_IO_HOLE, const.NFS4ERR_SEQ_FALSE_RETRY, const.NFS4ERR_BAD_HIGH_SLOT, const.NFS4ERR_DEADSESSION, const.NFS4ERR_ENCR_ALG_UNSUPP, const.NFS4ERR_PNFS_NO_LAYOUT, const.NFS4ERR_NOT_ONLY_OP, const.NFS4ERR_WRONG_CRED, const.NFS4ERR_WRONG_TYPE, const.NFS4ERR_DIRDELEG_UNAVAIL, const.NFS4ERR_REJECT_DELEG, const.NFS4ERR_RETURNCONFLICT]:
            raise XDRError, 'value=%s not in enum nfsstat4' % data
        self.pack_int(data)

    def pack_attrlist4(self, data):
        if hasattr(self, 'filter_attrlist4'):
            data = getattr(self, 'filter_attrlist4')(data)
        self.pack_opaque(data)

    def pack_bitmap4(self, data):
        if hasattr(self, 'filter_bitmap4'):
            data = getattr(self, 'filter_bitmap4')(data)
        self.pack_array(data, self.pack_uint32_t)

    pack_changeid4 = pack_uint64_t

    pack_clientid4 = pack_uint64_t

    pack_count4 = pack_uint32_t

    pack_length4 = pack_uint64_t

    pack_mode4 = pack_uint32_t

    pack_nfs_cookie4 = pack_uint64_t

    def pack_nfs_fh4(self, data):
        if hasattr(self, 'filter_nfs_fh4'):
            data = getattr(self, 'filter_nfs_fh4')(data)
        if len(data) > const.NFS4_FHSIZE and self.check_array:
            raise XDRError, 'array length too long for data'
        self.pack_opaque(data)

    pack_offset4 = pack_uint64_t

    pack_qop4 = pack_uint32_t

    def pack_sec_oid4(self, data):
        if hasattr(self, 'filter_sec_oid4'):
            data = getattr(self, 'filter_sec_oid4')(data)
        self.pack_opaque(data)

    pack_sequenceid4 = pack_uint32_t

    pack_seqid4 = pack_uint32_t

    def pack_sessionid4(self, data):
        if hasattr(self, 'filter_sessionid4'):
            data = getattr(self, 'filter_sessionid4')(data)
        self.pack_fopaque(const.NFS4_SESSIONID_SIZE, data)

    pack_slotid4 = pack_uint32_t

    def pack_utf8string(self, data):
        if hasattr(self, 'filter_utf8string'):
            data = getattr(self, 'filter_utf8string')(data)
        self.pack_opaque(data)

    pack_utf8str_cis = pack_utf8string

    pack_utf8str_cs = pack_utf8string

    pack_utf8str_mixed = pack_utf8string

    pack_component4 = pack_utf8str_cs

    pack_linktext4 = pack_utf8str_cs

    def pack_pathname4(self, data):
        if hasattr(self, 'filter_pathname4'):
            data = getattr(self, 'filter_pathname4')(data)
        self.pack_array(data, self.pack_component4)

    def pack_verifier4(self, data):
        if hasattr(self, 'filter_verifier4'):
            data = getattr(self, 'filter_verifier4')(data)
        self.pack_fopaque(const.NFS4_VERIFIER_SIZE, data)

    def pack_nfstime4(self, data):
        if hasattr(self, 'filter_nfstime4'):
            data = getattr(self, 'filter_nfstime4')(data)
        if data.seconds is None:
            raise TypeError, 'data.seconds == None'
        self.pack_int64_t(data.seconds)
        if data.nseconds is None:
            raise TypeError, 'data.nseconds == None'
        self.pack_uint32_t(data.nseconds)

    def pack_time_how4(self, data):
        if hasattr(self, 'filter_time_how4'):
            data = getattr(self, 'filter_time_how4')(data)
        if self.check_enum and data not in [const.SET_TO_SERVER_TIME4, const.SET_TO_CLIENT_TIME4]:
            raise XDRError, 'value=%s not in enum time_how4' % data
        self.pack_int(data)

    def pack_settime4(self, data):
        if hasattr(self, 'filter_settime4'):
            data = getattr(self, 'filter_settime4')(data)
        if data.set_it is None:
            raise TypeError, 'data.set_it == None'
        self.pack_time_how4(data.set_it)
        if data.set_it == const.SET_TO_CLIENT_TIME4:
            if data.time is None:
                raise TypeError, 'data.time == None'
            self.pack_nfstime4(data.time)
        else:
            pass

    pack_nfs_lease4 = pack_uint32_t

    def pack_fsid4(self, data):
        if hasattr(self, 'filter_fsid4'):
            data = getattr(self, 'filter_fsid4')(data)
        if data.major is None:
            raise TypeError, 'data.major == None'
        self.pack_uint64_t(data.major)
        if data.minor is None:
            raise TypeError, 'data.minor == None'
        self.pack_uint64_t(data.minor)

    def pack_change_policy4(self, data):
        if hasattr(self, 'filter_change_policy4'):
            data = getattr(self, 'filter_change_policy4')(data)
        if data.cp_major is None:
            raise TypeError, 'data.cp_major == None'
        self.pack_uint64_t(data.cp_major)
        if data.cp_minor is None:
            raise TypeError, 'data.cp_minor == None'
        self.pack_uint64_t(data.cp_minor)

    def pack_fs_location4(self, data):
        if hasattr(self, 'filter_fs_location4'):
            data = getattr(self, 'filter_fs_location4')(data)
        if data.server is None:
            raise TypeError, 'data.server == None'
        self.pack_array(data.server, self.pack_utf8str_cis)
        if data.rootpath is None:
            raise TypeError, 'data.rootpath == None'
        self.pack_pathname4(data.rootpath)

    def pack_fs_locations4(self, data):
        if hasattr(self, 'filter_fs_locations4'):
            data = getattr(self, 'filter_fs_locations4')(data)
        if data.fs_root is None:
            raise TypeError, 'data.fs_root == None'
        self.pack_pathname4(data.fs_root)
        if data.locations is None:
            raise TypeError, 'data.locations == None'
        self.pack_array(data.locations, self.pack_fs_location4)

    pack_acetype4 = pack_uint32_t

    pack_aceflag4 = pack_uint32_t

    pack_acemask4 = pack_uint32_t

    def pack_nfsace4(self, data):
        if hasattr(self, 'filter_nfsace4'):
            data = getattr(self, 'filter_nfsace4')(data)
        if data.type is None:
            raise TypeError, 'data.type == None'
        self.pack_acetype4(data.type)
        if data.flag is None:
            raise TypeError, 'data.flag == None'
        self.pack_aceflag4(data.flag)
        if data.access_mask is None:
            raise TypeError, 'data.access_mask == None'
        self.pack_acemask4(data.access_mask)
        if data.who is None:
            raise TypeError, 'data.who == None'
        self.pack_utf8str_mixed(data.who)

    pack_aclflag4 = pack_uint32_t

    def pack_nfsacl41(self, data):
        if hasattr(self, 'filter_nfsacl41'):
            data = getattr(self, 'filter_nfsacl41')(data)
        if data.na41_flag is None:
            raise TypeError, 'data.na41_flag == None'
        self.pack_aclflag4(data.na41_flag)
        if data.na41_aces is None:
            raise TypeError, 'data.na41_aces == None'
        self.pack_array(data.na41_aces, self.pack_nfsace4)

    def pack_mode_masked4(self, data):
        if hasattr(self, 'filter_mode_masked4'):
            data = getattr(self, 'filter_mode_masked4')(data)
        if data.mm_value_to_set is None:
            raise TypeError, 'data.mm_value_to_set == None'
        self.pack_mode4(data.mm_value_to_set)
        if data.mm_mask_bits is None:
            raise TypeError, 'data.mm_mask_bits == None'
        self.pack_mode4(data.mm_mask_bits)

    def pack_specdata4(self, data):
        if hasattr(self, 'filter_specdata4'):
            data = getattr(self, 'filter_specdata4')(data)
        if data.specdata1 is None:
            raise TypeError, 'data.specdata1 == None'
        self.pack_uint32_t(data.specdata1)
        if data.specdata2 is None:
            raise TypeError, 'data.specdata2 == None'
        self.pack_uint32_t(data.specdata2)

    def pack_netaddr4(self, data):
        if hasattr(self, 'filter_netaddr4'):
            data = getattr(self, 'filter_netaddr4')(data)
        if data.na_r_netid is None:
            raise TypeError, 'data.na_r_netid == None'
        self.pack_string(data.na_r_netid)
        if data.na_r_addr is None:
            raise TypeError, 'data.na_r_addr == None'
        self.pack_string(data.na_r_addr)

    def pack_nfs_impl_id4(self, data):
        if hasattr(self, 'filter_nfs_impl_id4'):
            data = getattr(self, 'filter_nfs_impl_id4')(data)
        if data.nii_domain is None:
            raise TypeError, 'data.nii_domain == None'
        self.pack_utf8str_cis(data.nii_domain)
        if data.nii_name is None:
            raise TypeError, 'data.nii_name == None'
        self.pack_utf8str_cs(data.nii_name)
        if data.nii_date is None:
            raise TypeError, 'data.nii_date == None'
        self.pack_nfstime4(data.nii_date)

    def pack_stateid4(self, data):
        if hasattr(self, 'filter_stateid4'):
            data = getattr(self, 'filter_stateid4')(data)
        if data.seqid is None:
            raise TypeError, 'data.seqid == None'
        self.pack_uint32_t(data.seqid)
        if data.other is None:
            raise TypeError, 'data.other == None'
        self.pack_fopaque(12, data.other)

    def pack_layouttype4(self, data):
        if hasattr(self, 'filter_layouttype4'):
            data = getattr(self, 'filter_layouttype4')(data)
        if self.check_enum and data not in [const.LAYOUT4_NFSV4_1_FILES, const.LAYOUT4_OSD2_OBJECTS, const.LAYOUT4_BLOCK_VOLUME]:
            raise XDRError, 'value=%s not in enum layouttype4' % data
        self.pack_int(data)

    def pack_layout_content4(self, data):
        if hasattr(self, 'filter_layout_content4'):
            data = getattr(self, 'filter_layout_content4')(data)
        if data.loc_type is None:
            raise TypeError, 'data.loc_type == None'
        self.pack_layouttype4(data.loc_type)
        if data.loc_body is None:
            raise TypeError, 'data.loc_body == None'
        self.pack_opaque(data.loc_body)

    def pack_layouthint4(self, data):
        if hasattr(self, 'filter_layouthint4'):
            data = getattr(self, 'filter_layouthint4')(data)
        if data.loh_type is None:
            raise TypeError, 'data.loh_type == None'
        self.pack_layouttype4(data.loh_type)
        if data.loh_body is None:
            raise TypeError, 'data.loh_body == None'
        self.pack_opaque(data.loh_body)

    def pack_layoutiomode4(self, data):
        if hasattr(self, 'filter_layoutiomode4'):
            data = getattr(self, 'filter_layoutiomode4')(data)
        if self.check_enum and data not in [const.LAYOUTIOMODE4_READ, const.LAYOUTIOMODE4_RW, const.LAYOUTIOMODE4_ANY]:
            raise XDRError, 'value=%s not in enum layoutiomode4' % data
        self.pack_int(data)

    def pack_layout4(self, data):
        if hasattr(self, 'filter_layout4'):
            data = getattr(self, 'filter_layout4')(data)
        if data.lo_offset is None:
            raise TypeError, 'data.lo_offset == None'
        self.pack_offset4(data.lo_offset)
        if data.lo_length is None:
            raise TypeError, 'data.lo_length == None'
        self.pack_length4(data.lo_length)
        if data.lo_iomode is None:
            raise TypeError, 'data.lo_iomode == None'
        self.pack_layoutiomode4(data.lo_iomode)
        if data.lo_content is None:
            raise TypeError, 'data.lo_content == None'
        self.pack_layout_content4(data.lo_content)

    def pack_deviceid4(self, data):
        if hasattr(self, 'filter_deviceid4'):
            data = getattr(self, 'filter_deviceid4')(data)
        self.pack_fopaque(const.NFS4_DEVICEID4_SIZE, data)

    def pack_device_addr4(self, data):
        if hasattr(self, 'filter_device_addr4'):
            data = getattr(self, 'filter_device_addr4')(data)
        if data.da_layout_type is None:
            raise TypeError, 'data.da_layout_type == None'
        self.pack_layouttype4(data.da_layout_type)
        if data.da_addr_body is None:
            raise TypeError, 'data.da_addr_body == None'
        self.pack_opaque(data.da_addr_body)

    def pack_layoutupdate4(self, data):
        if hasattr(self, 'filter_layoutupdate4'):
            data = getattr(self, 'filter_layoutupdate4')(data)
        if data.lou_type is None:
            raise TypeError, 'data.lou_type == None'
        self.pack_layouttype4(data.lou_type)
        if data.lou_body is None:
            raise TypeError, 'data.lou_body == None'
        self.pack_opaque(data.lou_body)

    def pack_layoutreturn_type4(self, data):
        if hasattr(self, 'filter_layoutreturn_type4'):
            data = getattr(self, 'filter_layoutreturn_type4')(data)
        if self.check_enum and data not in [const.LAYOUTRETURN4_FILE, const.LAYOUTRETURN4_FSID, const.LAYOUTRETURN4_ALL]:
            raise XDRError, 'value=%s not in enum layoutreturn_type4' % data
        self.pack_int(data)

    def pack_layoutreturn_file4(self, data):
        if hasattr(self, 'filter_layoutreturn_file4'):
            data = getattr(self, 'filter_layoutreturn_file4')(data)
        if data.lrf_offset is None:
            raise TypeError, 'data.lrf_offset == None'
        self.pack_offset4(data.lrf_offset)
        if data.lrf_length is None:
            raise TypeError, 'data.lrf_length == None'
        self.pack_length4(data.lrf_length)
        if data.lrf_stateid is None:
            raise TypeError, 'data.lrf_stateid == None'
        self.pack_stateid4(data.lrf_stateid)
        if data.lrf_body is None:
            raise TypeError, 'data.lrf_body == None'
        self.pack_opaque(data.lrf_body)

    def pack_layoutreturn4(self, data):
        if hasattr(self, 'filter_layoutreturn4'):
            data = getattr(self, 'filter_layoutreturn4')(data)
        if data.lr_returntype is None:
            raise TypeError, 'data.lr_returntype == None'
        self.pack_layoutreturn_type4(data.lr_returntype)
        if data.lr_returntype == const.LAYOUTRETURN4_FILE:
            if data.lr_layout is None:
                raise TypeError, 'data.lr_layout == None'
            self.pack_layoutreturn_file4(data.lr_layout)
        else:
            pass

    def pack_fs4_status_type(self, data):
        if hasattr(self, 'filter_fs4_status_type'):
            data = getattr(self, 'filter_fs4_status_type')(data)
        if self.check_enum and data not in [const.STATUS4_FIXED, const.STATUS4_UPDATED, const.STATUS4_VERSIONED, const.STATUS4_WRITABLE, const.STATUS4_REFERRAL]:
            raise XDRError, 'value=%s not in enum fs4_status_type' % data
        self.pack_int(data)

    def pack_fs4_status(self, data):
        if hasattr(self, 'filter_fs4_status'):
            data = getattr(self, 'filter_fs4_status')(data)
        if data.fss_absent is None:
            raise TypeError, 'data.fss_absent == None'
        self.pack_bool(data.fss_absent)
        if data.fss_type is None:
            raise TypeError, 'data.fss_type == None'
        self.pack_fs4_status_type(data.fss_type)
        if data.fss_source is None:
            raise TypeError, 'data.fss_source == None'
        self.pack_utf8str_cs(data.fss_source)
        if data.fss_current is None:
            raise TypeError, 'data.fss_current == None'
        self.pack_utf8str_cs(data.fss_current)
        if data.fss_age is None:
            raise TypeError, 'data.fss_age == None'
        self.pack_int32_t(data.fss_age)
        if data.fss_version is None:
            raise TypeError, 'data.fss_version == None'
        self.pack_nfstime4(data.fss_version)

    pack_threshold4_read_size = pack_length4

    pack_threshold4_write_size = pack_length4

    pack_threshold4_read_iosize = pack_length4

    pack_threshold4_write_iosize = pack_length4

    def pack_threshold_item4(self, data):
        if hasattr(self, 'filter_threshold_item4'):
            data = getattr(self, 'filter_threshold_item4')(data)
        if data.thi_layout_type is None:
            raise TypeError, 'data.thi_layout_type == None'
        self.pack_layouttype4(data.thi_layout_type)
        if data.thi_hintset is None:
            raise TypeError, 'data.thi_hintset == None'
        self.pack_bitmap4(data.thi_hintset)
        if data.thi_hintlist is None:
            raise TypeError, 'data.thi_hintlist == None'
        self.pack_opaque(data.thi_hintlist)

    def pack_mdsthreshold4(self, data):
        if hasattr(self, 'filter_mdsthreshold4'):
            data = getattr(self, 'filter_mdsthreshold4')(data)
        if data.mth_hints is None:
            raise TypeError, 'data.mth_hints == None'
        self.pack_array(data.mth_hints, self.pack_threshold_item4)

    def pack_retention_get4(self, data):
        if hasattr(self, 'filter_retention_get4'):
            data = getattr(self, 'filter_retention_get4')(data)
        if data.rg_duration is None:
            raise TypeError, 'data.rg_duration == None'
        self.pack_uint64_t(data.rg_duration)
        if data.rg_begin_time is None:
            raise TypeError, 'data.rg_begin_time == None'
        if len(data.rg_begin_time) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.rg_begin_time'
        self.pack_array(data.rg_begin_time, self.pack_nfstime4)

    def pack_retention_set4(self, data):
        if hasattr(self, 'filter_retention_set4'):
            data = getattr(self, 'filter_retention_set4')(data)
        if data.rs_enable is None:
            raise TypeError, 'data.rs_enable == None'
        self.pack_bool(data.rs_enable)
        if data.rs_duration is None:
            raise TypeError, 'data.rs_duration == None'
        if len(data.rs_duration) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.rs_duration'
        self.pack_array(data.rs_duration, self.pack_uint64_t)

    pack_fs_charset_cap4 = pack_uint32_t

    pack_fattr4_supported_attrs = pack_bitmap4

    pack_fattr4_suppattr_exclcreat = pack_bitmap4

    pack_fattr4_type = pack_nfs_ftype4

    pack_fattr4_fh_expire_type = pack_uint32_t

    pack_fattr4_change = pack_changeid4

    pack_fattr4_size = pack_uint64_t

    pack_fattr4_link_support = pack_bool

    pack_fattr4_symlink_support = pack_bool

    pack_fattr4_named_attr = pack_bool

    pack_fattr4_fsid = pack_fsid4

    pack_fattr4_unique_handles = pack_bool

    pack_fattr4_lease_time = pack_nfs_lease4

    pack_fattr4_rdattr_error = pack_nfsstat4

    def pack_fattr4_acl(self, data):
        if hasattr(self, 'filter_fattr4_acl'):
            data = getattr(self, 'filter_fattr4_acl')(data)
        self.pack_array(data, self.pack_nfsace4)

    pack_fattr4_aclsupport = pack_uint32_t

    pack_fattr4_archive = pack_bool

    pack_fattr4_cansettime = pack_bool

    pack_fattr4_case_insensitive = pack_bool

    pack_fattr4_case_preserving = pack_bool

    pack_fattr4_chown_restricted = pack_bool

    pack_fattr4_fileid = pack_uint64_t

    pack_fattr4_files_avail = pack_uint64_t

    pack_fattr4_filehandle = pack_nfs_fh4

    pack_fattr4_files_free = pack_uint64_t

    pack_fattr4_files_total = pack_uint64_t

    pack_fattr4_fs_locations = pack_fs_locations4

    pack_fattr4_hidden = pack_bool

    pack_fattr4_homogeneous = pack_bool

    pack_fattr4_maxfilesize = pack_uint64_t

    pack_fattr4_maxlink = pack_uint32_t

    pack_fattr4_maxname = pack_uint32_t

    pack_fattr4_maxread = pack_uint64_t

    pack_fattr4_maxwrite = pack_uint64_t

    pack_fattr4_mimetype = pack_utf8str_cs

    pack_fattr4_mode = pack_mode4

    pack_fattr4_mode_set_masked = pack_mode_masked4

    pack_fattr4_mounted_on_fileid = pack_uint64_t

    pack_fattr4_no_trunc = pack_bool

    pack_fattr4_numlinks = pack_uint32_t

    pack_fattr4_owner = pack_utf8str_mixed

    pack_fattr4_owner_group = pack_utf8str_mixed

    pack_fattr4_quota_avail_hard = pack_uint64_t

    pack_fattr4_quota_avail_soft = pack_uint64_t

    pack_fattr4_quota_used = pack_uint64_t

    pack_fattr4_rawdev = pack_specdata4

    pack_fattr4_space_avail = pack_uint64_t

    pack_fattr4_space_free = pack_uint64_t

    pack_fattr4_space_total = pack_uint64_t

    pack_fattr4_space_used = pack_uint64_t

    pack_fattr4_system = pack_bool

    pack_fattr4_time_access = pack_nfstime4

    pack_fattr4_time_access_set = pack_settime4

    pack_fattr4_time_backup = pack_nfstime4

    pack_fattr4_time_create = pack_nfstime4

    pack_fattr4_time_delta = pack_nfstime4

    pack_fattr4_time_metadata = pack_nfstime4

    pack_fattr4_time_modify = pack_nfstime4

    pack_fattr4_time_modify_set = pack_settime4

    pack_fattr4_dir_notif_delay = pack_nfstime4

    pack_fattr4_dirent_notif_delay = pack_nfstime4

    pack_fattr4_absent = pack_bool

    def pack_fattr4_fs_layout_type(self, data):
        if hasattr(self, 'filter_fattr4_fs_layout_type'):
            data = getattr(self, 'filter_fattr4_fs_layout_type')(data)
        self.pack_array(data, self.pack_layouttype4)

    pack_fattr4_fs_status = pack_fs4_status

    pack_fattr4_fs_charset_cap4 = pack_fs_charset_cap4

    pack_fattr4_layout_alignment = pack_uint32_t

    pack_fattr4_layout_blksize = pack_uint32_t

    pack_fattr4_layout_hint = pack_layouthint4

    def pack_fattr4_layout_type(self, data):
        if hasattr(self, 'filter_fattr4_layout_type'):
            data = getattr(self, 'filter_fattr4_layout_type')(data)
        self.pack_array(data, self.pack_layouttype4)

    pack_fattr4_mdsthreshold = pack_mdsthreshold4

    pack_fattr4_retention_get = pack_retention_get4

    pack_fattr4_retention_set = pack_retention_set4

    pack_fattr4_retentevt_get = pack_retention_get4

    pack_fattr4_retentevt_set = pack_retention_set4

    pack_fattr4_retention_hold = pack_uint64_t

    pack_fattr4_dacl = pack_nfsacl41

    pack_fattr4_sacl = pack_nfsacl41

    def pack_fattr4(self, data):
        if hasattr(self, 'filter_fattr4'):
            data = getattr(self, 'filter_fattr4')(data)
        if data.attrmask is None:
            raise TypeError, 'data.attrmask == None'
        self.pack_bitmap4(data.attrmask)
        if data.attr_vals is None:
            raise TypeError, 'data.attr_vals == None'
        self.pack_attrlist4(data.attr_vals)

    def pack_change_info4(self, data):
        if hasattr(self, 'filter_change_info4'):
            data = getattr(self, 'filter_change_info4')(data)
        if data.atomic is None:
            raise TypeError, 'data.atomic == None'
        self.pack_bool(data.atomic)
        if data.before is None:
            raise TypeError, 'data.before == None'
        self.pack_changeid4(data.before)
        if data.after is None:
            raise TypeError, 'data.after == None'
        self.pack_changeid4(data.after)

    pack_clientaddr4 = pack_netaddr4

    def pack_cb_client4(self, data):
        if hasattr(self, 'filter_cb_client4'):
            data = getattr(self, 'filter_cb_client4')(data)
        if data.cb_program is None:
            raise TypeError, 'data.cb_program == None'
        self.pack_uint32_t(data.cb_program)
        if data.cb_location is None:
            raise TypeError, 'data.cb_location == None'
        self.pack_netaddr4(data.cb_location)

    def pack_nfs_client_id4(self, data):
        if hasattr(self, 'filter_nfs_client_id4'):
            data = getattr(self, 'filter_nfs_client_id4')(data)
        if data.verifier is None:
            raise TypeError, 'data.verifier == None'
        self.pack_verifier4(data.verifier)
        if data.id is None:
            raise TypeError, 'data.id == None'
        if len(data.id) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.id'
        self.pack_opaque(data.id)

    def pack_client_owner4(self, data):
        if hasattr(self, 'filter_client_owner4'):
            data = getattr(self, 'filter_client_owner4')(data)
        if data.co_verifier is None:
            raise TypeError, 'data.co_verifier == None'
        self.pack_verifier4(data.co_verifier)
        if data.co_ownerid is None:
            raise TypeError, 'data.co_ownerid == None'
        if len(data.co_ownerid) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.co_ownerid'
        self.pack_opaque(data.co_ownerid)

    def pack_server_owner4(self, data):
        if hasattr(self, 'filter_server_owner4'):
            data = getattr(self, 'filter_server_owner4')(data)
        if data.so_minor_id is None:
            raise TypeError, 'data.so_minor_id == None'
        self.pack_uint64_t(data.so_minor_id)
        if data.so_major_id is None:
            raise TypeError, 'data.so_major_id == None'
        if len(data.so_major_id) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.so_major_id'
        self.pack_opaque(data.so_major_id)

    def pack_state_owner4(self, data):
        if hasattr(self, 'filter_state_owner4'):
            data = getattr(self, 'filter_state_owner4')(data)
        if data.clientid is None:
            raise TypeError, 'data.clientid == None'
        self.pack_clientid4(data.clientid)
        if data.owner is None:
            raise TypeError, 'data.owner == None'
        if len(data.owner) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.owner'
        self.pack_opaque(data.owner)

    pack_open_owner4 = pack_state_owner4

    pack_lock_owner4 = pack_state_owner4

    def pack_nfs_lock_type4(self, data):
        if hasattr(self, 'filter_nfs_lock_type4'):
            data = getattr(self, 'filter_nfs_lock_type4')(data)
        if self.check_enum and data not in [const.READ_LT, const.WRITE_LT, const.READW_LT, const.WRITEW_LT]:
            raise XDRError, 'value=%s not in enum nfs_lock_type4' % data
        self.pack_int(data)

    def pack_ssv_subkey4(self, data):
        if hasattr(self, 'filter_ssv_subkey4'):
            data = getattr(self, 'filter_ssv_subkey4')(data)
        if self.check_enum and data not in [const.SSV4_SUBKEY_MIC_I2T, const.SSV4_SUBKEY_MIC_T2I, const.SSV4_SUBKEY_SEAL_I2T, const.SSV4_SUBKEY_SEAL_T2I]:
            raise XDRError, 'value=%s not in enum ssv_subkey4' % data
        self.pack_int(data)

    def pack_ssv_mic_plain_tkn4(self, data):
        if hasattr(self, 'filter_ssv_mic_plain_tkn4'):
            data = getattr(self, 'filter_ssv_mic_plain_tkn4')(data)
        if data.smpt_ssv_seq is None:
            raise TypeError, 'data.smpt_ssv_seq == None'
        self.pack_uint32_t(data.smpt_ssv_seq)
        if data.smpt_orig_plain is None:
            raise TypeError, 'data.smpt_orig_plain == None'
        self.pack_opaque(data.smpt_orig_plain)

    def pack_ssv_mic_tkn4(self, data):
        if hasattr(self, 'filter_ssv_mic_tkn4'):
            data = getattr(self, 'filter_ssv_mic_tkn4')(data)
        if data.smt_ssv_seq is None:
            raise TypeError, 'data.smt_ssv_seq == None'
        self.pack_uint32_t(data.smt_ssv_seq)
        if data.smt_hmac is None:
            raise TypeError, 'data.smt_hmac == None'
        self.pack_opaque(data.smt_hmac)

    def pack_ssv_seal_plain_tkn4(self, data):
        if hasattr(self, 'filter_ssv_seal_plain_tkn4'):
            data = getattr(self, 'filter_ssv_seal_plain_tkn4')(data)
        if data.sspt_confounder is None:
            raise TypeError, 'data.sspt_confounder == None'
        self.pack_opaque(data.sspt_confounder)
        if data.sspt_ssv_seq is None:
            raise TypeError, 'data.sspt_ssv_seq == None'
        self.pack_uint32_t(data.sspt_ssv_seq)
        if data.sspt_orig_plain is None:
            raise TypeError, 'data.sspt_orig_plain == None'
        self.pack_opaque(data.sspt_orig_plain)
        if data.sspt_pad is None:
            raise TypeError, 'data.sspt_pad == None'
        self.pack_opaque(data.sspt_pad)

    def pack_ssv_seal_cipher_tkn4(self, data):
        if hasattr(self, 'filter_ssv_seal_cipher_tkn4'):
            data = getattr(self, 'filter_ssv_seal_cipher_tkn4')(data)
        if data.ssct_ssv_seq is None:
            raise TypeError, 'data.ssct_ssv_seq == None'
        self.pack_uint32_t(data.ssct_ssv_seq)
        if data.ssct_iv is None:
            raise TypeError, 'data.ssct_iv == None'
        self.pack_opaque(data.ssct_iv)
        if data.ssct_encr_data is None:
            raise TypeError, 'data.ssct_encr_data == None'
        self.pack_opaque(data.ssct_encr_data)
        if data.ssct_hmac is None:
            raise TypeError, 'data.ssct_hmac == None'
        self.pack_opaque(data.ssct_hmac)

    def pack_fs_locations_server4(self, data):
        if hasattr(self, 'filter_fs_locations_server4'):
            data = getattr(self, 'filter_fs_locations_server4')(data)
        if data.fls_currency is None:
            raise TypeError, 'data.fls_currency == None'
        self.pack_int32_t(data.fls_currency)
        if data.fls_info is None:
            raise TypeError, 'data.fls_info == None'
        self.pack_opaque(data.fls_info)
        if data.fls_server is None:
            raise TypeError, 'data.fls_server == None'
        self.pack_utf8str_cis(data.fls_server)

    def pack_fs_locations_item4(self, data):
        if hasattr(self, 'filter_fs_locations_item4'):
            data = getattr(self, 'filter_fs_locations_item4')(data)
        if data.fli_entries is None:
            raise TypeError, 'data.fli_entries == None'
        self.pack_array(data.fli_entries, self.pack_fs_locations_server4)
        if data.fli_rootpath is None:
            raise TypeError, 'data.fli_rootpath == None'
        self.pack_pathname4(data.fli_rootpath)

    def pack_fs_locations_info4(self, data):
        if hasattr(self, 'filter_fs_locations_info4'):
            data = getattr(self, 'filter_fs_locations_info4')(data)
        if data.fli_flags is None:
            raise TypeError, 'data.fli_flags == None'
        self.pack_uint32_t(data.fli_flags)
        if data.fli_valid_for is None:
            raise TypeError, 'data.fli_valid_for == None'
        self.pack_int32_t(data.fli_valid_for)
        if data.fli_fs_root is None:
            raise TypeError, 'data.fli_fs_root == None'
        self.pack_pathname4(data.fli_fs_root)
        if data.fli_items is None:
            raise TypeError, 'data.fli_items == None'
        self.pack_array(data.fli_items, self.pack_fs_locations_item4)

    pack_fattr4_fs_locations_info = pack_fs_locations_info4

    pack_nfl_util4 = pack_uint32_t

    def pack_filelayout_hint_care4(self, data):
        if hasattr(self, 'filter_filelayout_hint_care4'):
            data = getattr(self, 'filter_filelayout_hint_care4')(data)
        if self.check_enum and data not in [const.NFLH4_CARE_DENSE, const.NFLH4_CARE_COMMIT_THRU_MDS, const.NFLH4_CARE_STRIPE_UNIT_SIZE, const.NFLH4_CARE_STRIPE_COUNT]:
            raise XDRError, 'value=%s not in enum filelayout_hint_care4' % data
        self.pack_int(data)

    def pack_nfsv4_1_file_layouthint4(self, data):
        if hasattr(self, 'filter_nfsv4_1_file_layouthint4'):
            data = getattr(self, 'filter_nfsv4_1_file_layouthint4')(data)
        if data.nflh_care is None:
            raise TypeError, 'data.nflh_care == None'
        self.pack_uint32_t(data.nflh_care)
        if data.nflh_util is None:
            raise TypeError, 'data.nflh_util == None'
        self.pack_nfl_util4(data.nflh_util)
        if data.nflh_stripe_count is None:
            raise TypeError, 'data.nflh_stripe_count == None'
        self.pack_count4(data.nflh_stripe_count)

    def pack_multipath_list4(self, data):
        if hasattr(self, 'filter_multipath_list4'):
            data = getattr(self, 'filter_multipath_list4')(data)
        self.pack_array(data, self.pack_netaddr4)

    def pack_nfsv4_1_file_layout_ds_addr4(self, data):
        if hasattr(self, 'filter_nfsv4_1_file_layout_ds_addr4'):
            data = getattr(self, 'filter_nfsv4_1_file_layout_ds_addr4')(data)
        if data.nflda_stripe_indices is None:
            raise TypeError, 'data.nflda_stripe_indices == None'
        self.pack_array(data.nflda_stripe_indices, self.pack_uint32_t)
        if data.nflda_multipath_ds_list is None:
            raise TypeError, 'data.nflda_multipath_ds_list == None'
        self.pack_array(data.nflda_multipath_ds_list, self.pack_multipath_list4)

    def pack_nfsv4_1_file_layout4(self, data):
        if hasattr(self, 'filter_nfsv4_1_file_layout4'):
            data = getattr(self, 'filter_nfsv4_1_file_layout4')(data)
        if data.nfl_deviceid is None:
            raise TypeError, 'data.nfl_deviceid == None'
        self.pack_deviceid4(data.nfl_deviceid)
        if data.nfl_util is None:
            raise TypeError, 'data.nfl_util == None'
        self.pack_nfl_util4(data.nfl_util)
        if data.nfl_first_stripe_index is None:
            raise TypeError, 'data.nfl_first_stripe_index == None'
        self.pack_uint32_t(data.nfl_first_stripe_index)
        if data.nfl_pattern_offset is None:
            raise TypeError, 'data.nfl_pattern_offset == None'
        self.pack_offset4(data.nfl_pattern_offset)
        if data.nfl_fh_list is None:
            raise TypeError, 'data.nfl_fh_list == None'
        self.pack_array(data.nfl_fh_list, self.pack_nfs_fh4)

    def pack_ACCESS4args(self, data):
        if hasattr(self, 'filter_ACCESS4args'):
            data = getattr(self, 'filter_ACCESS4args')(data)
        if data.access is None:
            raise TypeError, 'data.access == None'
        self.pack_uint32_t(data.access)

    def pack_ACCESS4resok(self, data):
        if hasattr(self, 'filter_ACCESS4resok'):
            data = getattr(self, 'filter_ACCESS4resok')(data)
        if data.supported is None:
            raise TypeError, 'data.supported == None'
        self.pack_uint32_t(data.supported)
        if data.access is None:
            raise TypeError, 'data.access == None'
        self.pack_uint32_t(data.access)

    def pack_ACCESS4res(self, data):
        if hasattr(self, 'filter_ACCESS4res'):
            data = getattr(self, 'filter_ACCESS4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_ACCESS4resok(data.resok4)
        else:
            pass

    def pack_CLOSE4args(self, data):
        if hasattr(self, 'filter_CLOSE4args'):
            data = getattr(self, 'filter_CLOSE4args')(data)
        if data.seqid is None:
            raise TypeError, 'data.seqid == None'
        self.pack_seqid4(data.seqid)
        if data.open_stateid is None:
            raise TypeError, 'data.open_stateid == None'
        self.pack_stateid4(data.open_stateid)

    def pack_CLOSE4res(self, data):
        if hasattr(self, 'filter_CLOSE4res'):
            data = getattr(self, 'filter_CLOSE4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.open_stateid is None:
                raise TypeError, 'data.open_stateid == None'
            self.pack_stateid4(data.open_stateid)
        else:
            pass

    def pack_COMMIT4args(self, data):
        if hasattr(self, 'filter_COMMIT4args'):
            data = getattr(self, 'filter_COMMIT4args')(data)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.count is None:
            raise TypeError, 'data.count == None'
        self.pack_count4(data.count)

    def pack_COMMIT4resok(self, data):
        if hasattr(self, 'filter_COMMIT4resok'):
            data = getattr(self, 'filter_COMMIT4resok')(data)
        if data.writeverf is None:
            raise TypeError, 'data.writeverf == None'
        self.pack_verifier4(data.writeverf)

    def pack_COMMIT4res(self, data):
        if hasattr(self, 'filter_COMMIT4res'):
            data = getattr(self, 'filter_COMMIT4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_COMMIT4resok(data.resok4)
        else:
            pass

    def pack_createtype4(self, data):
        if hasattr(self, 'filter_createtype4'):
            data = getattr(self, 'filter_createtype4')(data)
        if data.type is None:
            raise TypeError, 'data.type == None'
        self.pack_nfs_ftype4(data.type)
        if data.type == const.NF4LNK:
            if data.linkdata is None:
                raise TypeError, 'data.linkdata == None'
            self.pack_linktext4(data.linkdata)
        elif data.type == const.NF4BLK or data.type == const.NF4CHR:
            if data.devdata is None:
                raise TypeError, 'data.devdata == None'
            self.pack_specdata4(data.devdata)
        elif data.type == const.NF4SOCK or data.type == const.NF4FIFO or data.type == const.NF4DIR:
            pass
        else:
            pass

    def pack_CREATE4args(self, data):
        if hasattr(self, 'filter_CREATE4args'):
            data = getattr(self, 'filter_CREATE4args')(data)
        if data.objtype is None:
            raise TypeError, 'data.objtype == None'
        self.pack_createtype4(data.objtype)
        if data.objname is None:
            raise TypeError, 'data.objname == None'
        self.pack_component4(data.objname)
        if data.createattrs is None:
            raise TypeError, 'data.createattrs == None'
        self.pack_fattr4(data.createattrs)

    def pack_CREATE4resok(self, data):
        if hasattr(self, 'filter_CREATE4resok'):
            data = getattr(self, 'filter_CREATE4resok')(data)
        if data.cinfo is None:
            raise TypeError, 'data.cinfo == None'
        self.pack_change_info4(data.cinfo)
        if data.attrset is None:
            raise TypeError, 'data.attrset == None'
        self.pack_bitmap4(data.attrset)

    def pack_CREATE4res(self, data):
        if hasattr(self, 'filter_CREATE4res'):
            data = getattr(self, 'filter_CREATE4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_CREATE4resok(data.resok4)
        else:
            pass

    def pack_DELEGPURGE4args(self, data):
        if hasattr(self, 'filter_DELEGPURGE4args'):
            data = getattr(self, 'filter_DELEGPURGE4args')(data)
        if data.clientid is None:
            raise TypeError, 'data.clientid == None'
        self.pack_clientid4(data.clientid)

    def pack_DELEGPURGE4res(self, data):
        if hasattr(self, 'filter_DELEGPURGE4res'):
            data = getattr(self, 'filter_DELEGPURGE4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_DELEGRETURN4args(self, data):
        if hasattr(self, 'filter_DELEGRETURN4args'):
            data = getattr(self, 'filter_DELEGRETURN4args')(data)
        if data.deleg_stateid is None:
            raise TypeError, 'data.deleg_stateid == None'
        self.pack_stateid4(data.deleg_stateid)

    def pack_DELEGRETURN4res(self, data):
        if hasattr(self, 'filter_DELEGRETURN4res'):
            data = getattr(self, 'filter_DELEGRETURN4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_GETATTR4args(self, data):
        if hasattr(self, 'filter_GETATTR4args'):
            data = getattr(self, 'filter_GETATTR4args')(data)
        if data.attr_request is None:
            raise TypeError, 'data.attr_request == None'
        self.pack_bitmap4(data.attr_request)

    def pack_GETATTR4resok(self, data):
        if hasattr(self, 'filter_GETATTR4resok'):
            data = getattr(self, 'filter_GETATTR4resok')(data)
        if data.obj_attributes is None:
            raise TypeError, 'data.obj_attributes == None'
        self.pack_fattr4(data.obj_attributes)

    def pack_GETATTR4res(self, data):
        if hasattr(self, 'filter_GETATTR4res'):
            data = getattr(self, 'filter_GETATTR4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_GETATTR4resok(data.resok4)
        else:
            pass

    def pack_GETFH4resok(self, data):
        if hasattr(self, 'filter_GETFH4resok'):
            data = getattr(self, 'filter_GETFH4resok')(data)
        if data.object is None:
            raise TypeError, 'data.object == None'
        self.pack_nfs_fh4(data.object)

    def pack_GETFH4res(self, data):
        if hasattr(self, 'filter_GETFH4res'):
            data = getattr(self, 'filter_GETFH4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_GETFH4resok(data.resok4)
        else:
            pass

    def pack_LINK4args(self, data):
        if hasattr(self, 'filter_LINK4args'):
            data = getattr(self, 'filter_LINK4args')(data)
        if data.newname is None:
            raise TypeError, 'data.newname == None'
        self.pack_component4(data.newname)

    def pack_LINK4resok(self, data):
        if hasattr(self, 'filter_LINK4resok'):
            data = getattr(self, 'filter_LINK4resok')(data)
        if data.cinfo is None:
            raise TypeError, 'data.cinfo == None'
        self.pack_change_info4(data.cinfo)

    def pack_LINK4res(self, data):
        if hasattr(self, 'filter_LINK4res'):
            data = getattr(self, 'filter_LINK4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_LINK4resok(data.resok4)
        else:
            pass

    def pack_open_to_lock_owner4(self, data):
        if hasattr(self, 'filter_open_to_lock_owner4'):
            data = getattr(self, 'filter_open_to_lock_owner4')(data)
        if data.open_seqid is None:
            raise TypeError, 'data.open_seqid == None'
        self.pack_seqid4(data.open_seqid)
        if data.open_stateid is None:
            raise TypeError, 'data.open_stateid == None'
        self.pack_stateid4(data.open_stateid)
        if data.lock_seqid is None:
            raise TypeError, 'data.lock_seqid == None'
        self.pack_seqid4(data.lock_seqid)
        if data.lock_owner is None:
            raise TypeError, 'data.lock_owner == None'
        self.pack_lock_owner4(data.lock_owner)

    def pack_exist_lock_owner4(self, data):
        if hasattr(self, 'filter_exist_lock_owner4'):
            data = getattr(self, 'filter_exist_lock_owner4')(data)
        if data.lock_stateid is None:
            raise TypeError, 'data.lock_stateid == None'
        self.pack_stateid4(data.lock_stateid)
        if data.lock_seqid is None:
            raise TypeError, 'data.lock_seqid == None'
        self.pack_seqid4(data.lock_seqid)

    def pack_locker4(self, data):
        if hasattr(self, 'filter_locker4'):
            data = getattr(self, 'filter_locker4')(data)
        if data.new_lock_owner is None:
            raise TypeError, 'data.new_lock_owner == None'
        self.pack_bool(data.new_lock_owner)
        if data.new_lock_owner == const.TRUE:
            if data.open_owner is None:
                raise TypeError, 'data.open_owner == None'
            self.pack_open_to_lock_owner4(data.open_owner)
        elif data.new_lock_owner == const.FALSE:
            if data.lock_owner is None:
                raise TypeError, 'data.lock_owner == None'
            self.pack_exist_lock_owner4(data.lock_owner)
        else:
            raise XDRError, 'bad switch=%s' % data.new_lock_owner

    def pack_LOCK4args(self, data):
        if hasattr(self, 'filter_LOCK4args'):
            data = getattr(self, 'filter_LOCK4args')(data)
        if data.locktype is None:
            raise TypeError, 'data.locktype == None'
        self.pack_nfs_lock_type4(data.locktype)
        if data.reclaim is None:
            raise TypeError, 'data.reclaim == None'
        self.pack_bool(data.reclaim)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.length is None:
            raise TypeError, 'data.length == None'
        self.pack_length4(data.length)
        if data.locker is None:
            raise TypeError, 'data.locker == None'
        self.pack_locker4(data.locker)

    def pack_LOCK4denied(self, data):
        if hasattr(self, 'filter_LOCK4denied'):
            data = getattr(self, 'filter_LOCK4denied')(data)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.length is None:
            raise TypeError, 'data.length == None'
        self.pack_length4(data.length)
        if data.locktype is None:
            raise TypeError, 'data.locktype == None'
        self.pack_nfs_lock_type4(data.locktype)
        if data.owner is None:
            raise TypeError, 'data.owner == None'
        self.pack_lock_owner4(data.owner)

    def pack_LOCK4resok(self, data):
        if hasattr(self, 'filter_LOCK4resok'):
            data = getattr(self, 'filter_LOCK4resok')(data)
        if data.lock_stateid is None:
            raise TypeError, 'data.lock_stateid == None'
        self.pack_stateid4(data.lock_stateid)

    def pack_LOCK4res(self, data):
        if hasattr(self, 'filter_LOCK4res'):
            data = getattr(self, 'filter_LOCK4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_LOCK4resok(data.resok4)
        elif data.status == const.NFS4ERR_DENIED:
            if data.denied is None:
                raise TypeError, 'data.denied == None'
            self.pack_LOCK4denied(data.denied)
        else:
            pass

    def pack_LOCKT4args(self, data):
        if hasattr(self, 'filter_LOCKT4args'):
            data = getattr(self, 'filter_LOCKT4args')(data)
        if data.locktype is None:
            raise TypeError, 'data.locktype == None'
        self.pack_nfs_lock_type4(data.locktype)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.length is None:
            raise TypeError, 'data.length == None'
        self.pack_length4(data.length)
        if data.owner is None:
            raise TypeError, 'data.owner == None'
        self.pack_lock_owner4(data.owner)

    def pack_LOCKT4res(self, data):
        if hasattr(self, 'filter_LOCKT4res'):
            data = getattr(self, 'filter_LOCKT4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4ERR_DENIED:
            if data.denied is None:
                raise TypeError, 'data.denied == None'
            self.pack_LOCK4denied(data.denied)
        elif data.status == const.NFS4_OK:
            pass
        else:
            pass

    def pack_LOCKU4args(self, data):
        if hasattr(self, 'filter_LOCKU4args'):
            data = getattr(self, 'filter_LOCKU4args')(data)
        if data.locktype is None:
            raise TypeError, 'data.locktype == None'
        self.pack_nfs_lock_type4(data.locktype)
        if data.seqid is None:
            raise TypeError, 'data.seqid == None'
        self.pack_seqid4(data.seqid)
        if data.lock_stateid is None:
            raise TypeError, 'data.lock_stateid == None'
        self.pack_stateid4(data.lock_stateid)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.length is None:
            raise TypeError, 'data.length == None'
        self.pack_length4(data.length)

    def pack_LOCKU4res(self, data):
        if hasattr(self, 'filter_LOCKU4res'):
            data = getattr(self, 'filter_LOCKU4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.lock_stateid is None:
                raise TypeError, 'data.lock_stateid == None'
            self.pack_stateid4(data.lock_stateid)
        else:
            pass

    def pack_LOOKUP4args(self, data):
        if hasattr(self, 'filter_LOOKUP4args'):
            data = getattr(self, 'filter_LOOKUP4args')(data)
        if data.objname is None:
            raise TypeError, 'data.objname == None'
        self.pack_component4(data.objname)

    def pack_LOOKUP4res(self, data):
        if hasattr(self, 'filter_LOOKUP4res'):
            data = getattr(self, 'filter_LOOKUP4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_LOOKUPP4res(self, data):
        if hasattr(self, 'filter_LOOKUPP4res'):
            data = getattr(self, 'filter_LOOKUPP4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_NVERIFY4args(self, data):
        if hasattr(self, 'filter_NVERIFY4args'):
            data = getattr(self, 'filter_NVERIFY4args')(data)
        if data.obj_attributes is None:
            raise TypeError, 'data.obj_attributes == None'
        self.pack_fattr4(data.obj_attributes)

    def pack_NVERIFY4res(self, data):
        if hasattr(self, 'filter_NVERIFY4res'):
            data = getattr(self, 'filter_NVERIFY4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_createmode4(self, data):
        if hasattr(self, 'filter_createmode4'):
            data = getattr(self, 'filter_createmode4')(data)
        if self.check_enum and data not in [const.UNCHECKED4, const.GUARDED4, const.EXCLUSIVE4, const.EXCLUSIVE4_1]:
            raise XDRError, 'value=%s not in enum createmode4' % data
        self.pack_int(data)

    def pack_creatverfattr(self, data):
        if hasattr(self, 'filter_creatverfattr'):
            data = getattr(self, 'filter_creatverfattr')(data)
        if data.cva_verf is None:
            raise TypeError, 'data.cva_verf == None'
        self.pack_verifier4(data.cva_verf)
        if data.cva_attrs is None:
            raise TypeError, 'data.cva_attrs == None'
        self.pack_fattr4(data.cva_attrs)

    def pack_createhow4(self, data):
        if hasattr(self, 'filter_createhow4'):
            data = getattr(self, 'filter_createhow4')(data)
        if data.mode is None:
            raise TypeError, 'data.mode == None'
        self.pack_createmode4(data.mode)
        if data.mode == const.UNCHECKED4 or data.mode == const.GUARDED4:
            if data.createattrs is None:
                raise TypeError, 'data.createattrs == None'
            self.pack_fattr4(data.createattrs)
        elif data.mode == const.EXCLUSIVE4:
            if data.createverf is None:
                raise TypeError, 'data.createverf == None'
            self.pack_verifier4(data.createverf)
        elif data.mode == const.EXCLUSIVE4_1:
            if data.ch_createboth is None:
                raise TypeError, 'data.ch_createboth == None'
            self.pack_creatverfattr(data.ch_createboth)
        else:
            raise XDRError, 'bad switch=%s' % data.mode

    def pack_opentype4(self, data):
        if hasattr(self, 'filter_opentype4'):
            data = getattr(self, 'filter_opentype4')(data)
        if self.check_enum and data not in [const.OPEN4_NOCREATE, const.OPEN4_CREATE]:
            raise XDRError, 'value=%s not in enum opentype4' % data
        self.pack_int(data)

    def pack_openflag4(self, data):
        if hasattr(self, 'filter_openflag4'):
            data = getattr(self, 'filter_openflag4')(data)
        if data.opentype is None:
            raise TypeError, 'data.opentype == None'
        self.pack_opentype4(data.opentype)
        if data.opentype == const.OPEN4_CREATE:
            if data.how is None:
                raise TypeError, 'data.how == None'
            self.pack_createhow4(data.how)
        else:
            pass

    def pack_limit_by4(self, data):
        if hasattr(self, 'filter_limit_by4'):
            data = getattr(self, 'filter_limit_by4')(data)
        if self.check_enum and data not in [const.NFS_LIMIT_SIZE, const.NFS_LIMIT_BLOCKS]:
            raise XDRError, 'value=%s not in enum limit_by4' % data
        self.pack_int(data)

    def pack_nfs_modified_limit4(self, data):
        if hasattr(self, 'filter_nfs_modified_limit4'):
            data = getattr(self, 'filter_nfs_modified_limit4')(data)
        if data.num_blocks is None:
            raise TypeError, 'data.num_blocks == None'
        self.pack_uint32_t(data.num_blocks)
        if data.bytes_per_block is None:
            raise TypeError, 'data.bytes_per_block == None'
        self.pack_uint32_t(data.bytes_per_block)

    def pack_nfs_space_limit4(self, data):
        if hasattr(self, 'filter_nfs_space_limit4'):
            data = getattr(self, 'filter_nfs_space_limit4')(data)
        if data.limitby is None:
            raise TypeError, 'data.limitby == None'
        self.pack_limit_by4(data.limitby)
        if data.limitby == const.NFS_LIMIT_SIZE:
            if data.filesize is None:
                raise TypeError, 'data.filesize == None'
            self.pack_uint64_t(data.filesize)
        elif data.limitby == const.NFS_LIMIT_BLOCKS:
            if data.mod_blocks is None:
                raise TypeError, 'data.mod_blocks == None'
            self.pack_nfs_modified_limit4(data.mod_blocks)
        else:
            raise XDRError, 'bad switch=%s' % data.limitby

    def pack_open_delegation_type4(self, data):
        if hasattr(self, 'filter_open_delegation_type4'):
            data = getattr(self, 'filter_open_delegation_type4')(data)
        if self.check_enum and data not in [const.OPEN_DELEGATE_NONE, const.OPEN_DELEGATE_READ, const.OPEN_DELEGATE_WRITE, const.OPEN_DELEGATE_NONE_EXT]:
            raise XDRError, 'value=%s not in enum open_delegation_type4' % data
        self.pack_int(data)

    def pack_open_claim_type4(self, data):
        if hasattr(self, 'filter_open_claim_type4'):
            data = getattr(self, 'filter_open_claim_type4')(data)
        if self.check_enum and data not in [const.CLAIM_NULL, const.CLAIM_PREVIOUS, const.CLAIM_DELEGATE_CUR, const.CLAIM_DELEGATE_PREV, const.CLAIM_FH, const.CLAIM_DELEG_CUR_FH, const.CLAIM_DELEG_PREV_FH]:
            raise XDRError, 'value=%s not in enum open_claim_type4' % data
        self.pack_int(data)

    def pack_open_claim_delegate_cur4(self, data):
        if hasattr(self, 'filter_open_claim_delegate_cur4'):
            data = getattr(self, 'filter_open_claim_delegate_cur4')(data)
        if data.delegate_stateid is None:
            raise TypeError, 'data.delegate_stateid == None'
        self.pack_stateid4(data.delegate_stateid)
        if data.file is None:
            raise TypeError, 'data.file == None'
        self.pack_component4(data.file)

    def pack_open_claim4(self, data):
        if hasattr(self, 'filter_open_claim4'):
            data = getattr(self, 'filter_open_claim4')(data)
        if data.claim is None:
            raise TypeError, 'data.claim == None'
        self.pack_open_claim_type4(data.claim)
        if data.claim == const.CLAIM_NULL:
            if data.file is None:
                raise TypeError, 'data.file == None'
            self.pack_component4(data.file)
        elif data.claim == const.CLAIM_PREVIOUS:
            if data.delegate_type is None:
                raise TypeError, 'data.delegate_type == None'
            self.pack_open_delegation_type4(data.delegate_type)
        elif data.claim == const.CLAIM_DELEGATE_CUR:
            if data.delegate_cur_info is None:
                raise TypeError, 'data.delegate_cur_info == None'
            self.pack_open_claim_delegate_cur4(data.delegate_cur_info)
        elif data.claim == const.CLAIM_DELEGATE_PREV:
            if data.file_delegate_prev is None:
                raise TypeError, 'data.file_delegate_prev == None'
            self.pack_component4(data.file_delegate_prev)
        elif data.claim == const.CLAIM_FH:
            pass
        elif data.claim == const.CLAIM_DELEG_PREV_FH:
            pass
        elif data.claim == const.CLAIM_DELEG_CUR_FH:
            if data.oc_delegate_stateid is None:
                raise TypeError, 'data.oc_delegate_stateid == None'
            self.pack_stateid4(data.oc_delegate_stateid)
        else:
            raise XDRError, 'bad switch=%s' % data.claim

    def pack_OPEN4args(self, data):
        if hasattr(self, 'filter_OPEN4args'):
            data = getattr(self, 'filter_OPEN4args')(data)
        if data.seqid is None:
            raise TypeError, 'data.seqid == None'
        self.pack_seqid4(data.seqid)
        if data.share_access is None:
            raise TypeError, 'data.share_access == None'
        self.pack_uint32_t(data.share_access)
        if data.share_deny is None:
            raise TypeError, 'data.share_deny == None'
        self.pack_uint32_t(data.share_deny)
        if data.owner is None:
            raise TypeError, 'data.owner == None'
        self.pack_open_owner4(data.owner)
        if data.openhow is None:
            raise TypeError, 'data.openhow == None'
        self.pack_openflag4(data.openhow)
        if data.claim is None:
            raise TypeError, 'data.claim == None'
        self.pack_open_claim4(data.claim)

    def pack_open_read_delegation4(self, data):
        if hasattr(self, 'filter_open_read_delegation4'):
            data = getattr(self, 'filter_open_read_delegation4')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.recall is None:
            raise TypeError, 'data.recall == None'
        self.pack_bool(data.recall)
        if data.permissions is None:
            raise TypeError, 'data.permissions == None'
        self.pack_nfsace4(data.permissions)

    def pack_open_write_delegation4(self, data):
        if hasattr(self, 'filter_open_write_delegation4'):
            data = getattr(self, 'filter_open_write_delegation4')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.recall is None:
            raise TypeError, 'data.recall == None'
        self.pack_bool(data.recall)
        if data.space_limit is None:
            raise TypeError, 'data.space_limit == None'
        self.pack_nfs_space_limit4(data.space_limit)
        if data.permissions is None:
            raise TypeError, 'data.permissions == None'
        self.pack_nfsace4(data.permissions)

    def pack_why_no_delegation4(self, data):
        if hasattr(self, 'filter_why_no_delegation4'):
            data = getattr(self, 'filter_why_no_delegation4')(data)
        if self.check_enum and data not in [const.WND4_NOT_WANTED, const.WND4_CONTENTION, const.WND4_RESOURCE, const.WND4_NOT_SUPP_FTYPE, const.WND4_WRITE_DELEG_NOT_SUPP_FTYPE, const.WND4_NOT_SUPP_UPGRADE, const.WND4_NOT_SUPP_DOWNGRADE, const.WND4_CANCELED, const.WND4_IS_DIR]:
            raise XDRError, 'value=%s not in enum why_no_delegation4' % data
        self.pack_int(data)

    def pack_open_none_delegation4(self, data):
        if hasattr(self, 'filter_open_none_delegation4'):
            data = getattr(self, 'filter_open_none_delegation4')(data)
        if data.ond_why is None:
            raise TypeError, 'data.ond_why == None'
        self.pack_why_no_delegation4(data.ond_why)
        if data.ond_why == const.WND4_CONTENTION:
            if data.ond_server_will_push_deleg is None:
                raise TypeError, 'data.ond_server_will_push_deleg == None'
            self.pack_bool(data.ond_server_will_push_deleg)
        elif data.ond_why == const.WND4_RESOURCE:
            if data.ond_server_will_signal_avail is None:
                raise TypeError, 'data.ond_server_will_signal_avail == None'
            self.pack_bool(data.ond_server_will_signal_avail)
        else:
            pass

    def pack_open_delegation4(self, data):
        if hasattr(self, 'filter_open_delegation4'):
            data = getattr(self, 'filter_open_delegation4')(data)
        if data.delegation_type is None:
            raise TypeError, 'data.delegation_type == None'
        self.pack_open_delegation_type4(data.delegation_type)
        if data.delegation_type == const.OPEN_DELEGATE_NONE:
            pass
        elif data.delegation_type == const.OPEN_DELEGATE_READ:
            if data.read is None:
                raise TypeError, 'data.read == None'
            self.pack_open_read_delegation4(data.read)
        elif data.delegation_type == const.OPEN_DELEGATE_WRITE:
            if data.write is None:
                raise TypeError, 'data.write == None'
            self.pack_open_write_delegation4(data.write)
        elif data.delegation_type == const.OPEN_DELEGATE_NONE_EXT:
            if data.od_whynone is None:
                raise TypeError, 'data.od_whynone == None'
            self.pack_open_none_delegation4(data.od_whynone)
        else:
            raise XDRError, 'bad switch=%s' % data.delegation_type

    def pack_OPEN4resok(self, data):
        if hasattr(self, 'filter_OPEN4resok'):
            data = getattr(self, 'filter_OPEN4resok')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.cinfo is None:
            raise TypeError, 'data.cinfo == None'
        self.pack_change_info4(data.cinfo)
        if data.rflags is None:
            raise TypeError, 'data.rflags == None'
        self.pack_uint32_t(data.rflags)
        if data.attrset is None:
            raise TypeError, 'data.attrset == None'
        self.pack_bitmap4(data.attrset)
        if data.delegation is None:
            raise TypeError, 'data.delegation == None'
        self.pack_open_delegation4(data.delegation)

    def pack_OPEN4res(self, data):
        if hasattr(self, 'filter_OPEN4res'):
            data = getattr(self, 'filter_OPEN4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_OPEN4resok(data.resok4)
        else:
            pass

    def pack_OPENATTR4args(self, data):
        if hasattr(self, 'filter_OPENATTR4args'):
            data = getattr(self, 'filter_OPENATTR4args')(data)
        if data.createdir is None:
            raise TypeError, 'data.createdir == None'
        self.pack_bool(data.createdir)

    def pack_OPENATTR4res(self, data):
        if hasattr(self, 'filter_OPENATTR4res'):
            data = getattr(self, 'filter_OPENATTR4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_OPEN_CONFIRM4args(self, data):
        if hasattr(self, 'filter_OPEN_CONFIRM4args'):
            data = getattr(self, 'filter_OPEN_CONFIRM4args')(data)
        if data.open_stateid is None:
            raise TypeError, 'data.open_stateid == None'
        self.pack_stateid4(data.open_stateid)
        if data.seqid is None:
            raise TypeError, 'data.seqid == None'
        self.pack_seqid4(data.seqid)

    def pack_OPEN_CONFIRM4resok(self, data):
        if hasattr(self, 'filter_OPEN_CONFIRM4resok'):
            data = getattr(self, 'filter_OPEN_CONFIRM4resok')(data)
        if data.open_stateid is None:
            raise TypeError, 'data.open_stateid == None'
        self.pack_stateid4(data.open_stateid)

    def pack_OPEN_CONFIRM4res(self, data):
        if hasattr(self, 'filter_OPEN_CONFIRM4res'):
            data = getattr(self, 'filter_OPEN_CONFIRM4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_OPEN_CONFIRM4resok(data.resok4)
        else:
            pass

    def pack_OPEN_DOWNGRADE4args(self, data):
        if hasattr(self, 'filter_OPEN_DOWNGRADE4args'):
            data = getattr(self, 'filter_OPEN_DOWNGRADE4args')(data)
        if data.open_stateid is None:
            raise TypeError, 'data.open_stateid == None'
        self.pack_stateid4(data.open_stateid)
        if data.seqid is None:
            raise TypeError, 'data.seqid == None'
        self.pack_seqid4(data.seqid)
        if data.share_access is None:
            raise TypeError, 'data.share_access == None'
        self.pack_uint32_t(data.share_access)
        if data.share_deny is None:
            raise TypeError, 'data.share_deny == None'
        self.pack_uint32_t(data.share_deny)

    def pack_OPEN_DOWNGRADE4resok(self, data):
        if hasattr(self, 'filter_OPEN_DOWNGRADE4resok'):
            data = getattr(self, 'filter_OPEN_DOWNGRADE4resok')(data)
        if data.open_stateid is None:
            raise TypeError, 'data.open_stateid == None'
        self.pack_stateid4(data.open_stateid)

    def pack_OPEN_DOWNGRADE4res(self, data):
        if hasattr(self, 'filter_OPEN_DOWNGRADE4res'):
            data = getattr(self, 'filter_OPEN_DOWNGRADE4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_OPEN_DOWNGRADE4resok(data.resok4)
        else:
            pass

    def pack_PUTFH4args(self, data):
        if hasattr(self, 'filter_PUTFH4args'):
            data = getattr(self, 'filter_PUTFH4args')(data)
        if data.object is None:
            raise TypeError, 'data.object == None'
        self.pack_nfs_fh4(data.object)

    def pack_PUTFH4res(self, data):
        if hasattr(self, 'filter_PUTFH4res'):
            data = getattr(self, 'filter_PUTFH4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_PUTPUBFH4res(self, data):
        if hasattr(self, 'filter_PUTPUBFH4res'):
            data = getattr(self, 'filter_PUTPUBFH4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_PUTROOTFH4res(self, data):
        if hasattr(self, 'filter_PUTROOTFH4res'):
            data = getattr(self, 'filter_PUTROOTFH4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_READ4args(self, data):
        if hasattr(self, 'filter_READ4args'):
            data = getattr(self, 'filter_READ4args')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.count is None:
            raise TypeError, 'data.count == None'
        self.pack_count4(data.count)

    def pack_READ4resok(self, data):
        if hasattr(self, 'filter_READ4resok'):
            data = getattr(self, 'filter_READ4resok')(data)
        if data.eof is None:
            raise TypeError, 'data.eof == None'
        self.pack_bool(data.eof)
        if data.data is None:
            raise TypeError, 'data.data == None'
        self.pack_opaque(data.data)

    def pack_READ4res(self, data):
        if hasattr(self, 'filter_READ4res'):
            data = getattr(self, 'filter_READ4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_READ4resok(data.resok4)
        else:
            pass

    def pack_READDIR4args(self, data):
        if hasattr(self, 'filter_READDIR4args'):
            data = getattr(self, 'filter_READDIR4args')(data)
        if data.cookie is None:
            raise TypeError, 'data.cookie == None'
        self.pack_nfs_cookie4(data.cookie)
        if data.cookieverf is None:
            raise TypeError, 'data.cookieverf == None'
        self.pack_verifier4(data.cookieverf)
        if data.dircount is None:
            raise TypeError, 'data.dircount == None'
        self.pack_count4(data.dircount)
        if data.maxcount is None:
            raise TypeError, 'data.maxcount == None'
        self.pack_count4(data.maxcount)
        if data.attr_request is None:
            raise TypeError, 'data.attr_request == None'
        self.pack_bitmap4(data.attr_request)

    def pack_entry4(self, data):
        if hasattr(self, 'filter_entry4'):
            data = getattr(self, 'filter_entry4')(data)
        if data.cookie is None:
            raise TypeError, 'data.cookie == None'
        self.pack_nfs_cookie4(data.cookie)
        if data.name is None:
            raise TypeError, 'data.name == None'
        self.pack_component4(data.name)
        if data.attrs is None:
            raise TypeError, 'data.attrs == None'
        self.pack_fattr4(data.attrs)
        if data.nextentry is None:
            raise TypeError, 'data.nextentry == None'
        if len(data.nextentry) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nextentry'
        self.pack_array(data.nextentry, self.pack_entry4)

    def pack_dirlist4(self, data):
        if hasattr(self, 'filter_dirlist4'):
            data = getattr(self, 'filter_dirlist4')(data)
        if data.entries is None:
            raise TypeError, 'data.entries == None'
        if len(data.entries) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.entries'
        self.pack_array(data.entries, self.pack_entry4)
        if data.eof is None:
            raise TypeError, 'data.eof == None'
        self.pack_bool(data.eof)

    def pack_READDIR4resok(self, data):
        if hasattr(self, 'filter_READDIR4resok'):
            data = getattr(self, 'filter_READDIR4resok')(data)
        if data.cookieverf is None:
            raise TypeError, 'data.cookieverf == None'
        self.pack_verifier4(data.cookieverf)
        if data.reply is None:
            raise TypeError, 'data.reply == None'
        self.pack_dirlist4(data.reply)

    def pack_READDIR4res(self, data):
        if hasattr(self, 'filter_READDIR4res'):
            data = getattr(self, 'filter_READDIR4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_READDIR4resok(data.resok4)
        else:
            pass

    def pack_READLINK4resok(self, data):
        if hasattr(self, 'filter_READLINK4resok'):
            data = getattr(self, 'filter_READLINK4resok')(data)
        if data.link is None:
            raise TypeError, 'data.link == None'
        self.pack_linktext4(data.link)

    def pack_READLINK4res(self, data):
        if hasattr(self, 'filter_READLINK4res'):
            data = getattr(self, 'filter_READLINK4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_READLINK4resok(data.resok4)
        else:
            pass

    def pack_REMOVE4args(self, data):
        if hasattr(self, 'filter_REMOVE4args'):
            data = getattr(self, 'filter_REMOVE4args')(data)
        if data.target is None:
            raise TypeError, 'data.target == None'
        self.pack_component4(data.target)

    def pack_REMOVE4resok(self, data):
        if hasattr(self, 'filter_REMOVE4resok'):
            data = getattr(self, 'filter_REMOVE4resok')(data)
        if data.cinfo is None:
            raise TypeError, 'data.cinfo == None'
        self.pack_change_info4(data.cinfo)

    def pack_REMOVE4res(self, data):
        if hasattr(self, 'filter_REMOVE4res'):
            data = getattr(self, 'filter_REMOVE4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_REMOVE4resok(data.resok4)
        else:
            pass

    def pack_RENAME4args(self, data):
        if hasattr(self, 'filter_RENAME4args'):
            data = getattr(self, 'filter_RENAME4args')(data)
        if data.oldname is None:
            raise TypeError, 'data.oldname == None'
        self.pack_component4(data.oldname)
        if data.newname is None:
            raise TypeError, 'data.newname == None'
        self.pack_component4(data.newname)

    def pack_RENAME4resok(self, data):
        if hasattr(self, 'filter_RENAME4resok'):
            data = getattr(self, 'filter_RENAME4resok')(data)
        if data.source_cinfo is None:
            raise TypeError, 'data.source_cinfo == None'
        self.pack_change_info4(data.source_cinfo)
        if data.target_cinfo is None:
            raise TypeError, 'data.target_cinfo == None'
        self.pack_change_info4(data.target_cinfo)

    def pack_RENAME4res(self, data):
        if hasattr(self, 'filter_RENAME4res'):
            data = getattr(self, 'filter_RENAME4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_RENAME4resok(data.resok4)
        else:
            pass

    def pack_RENEW4args(self, data):
        if hasattr(self, 'filter_RENEW4args'):
            data = getattr(self, 'filter_RENEW4args')(data)
        if data.clientid is None:
            raise TypeError, 'data.clientid == None'
        self.pack_clientid4(data.clientid)

    def pack_RENEW4res(self, data):
        if hasattr(self, 'filter_RENEW4res'):
            data = getattr(self, 'filter_RENEW4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_RESTOREFH4res(self, data):
        if hasattr(self, 'filter_RESTOREFH4res'):
            data = getattr(self, 'filter_RESTOREFH4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_SAVEFH4res(self, data):
        if hasattr(self, 'filter_SAVEFH4res'):
            data = getattr(self, 'filter_SAVEFH4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_SECINFO4args(self, data):
        if hasattr(self, 'filter_SECINFO4args'):
            data = getattr(self, 'filter_SECINFO4args')(data)
        if data.name is None:
            raise TypeError, 'data.name == None'
        self.pack_component4(data.name)

    def pack_rpc_gss_svc_t(self, data):
        if hasattr(self, 'filter_rpc_gss_svc_t'):
            data = getattr(self, 'filter_rpc_gss_svc_t')(data)
        if self.check_enum and data not in [const.RPC_GSS_SVC_NONE, const.RPC_GSS_SVC_INTEGRITY, const.RPC_GSS_SVC_PRIVACY]:
            raise XDRError, 'value=%s not in enum rpc_gss_svc_t' % data
        self.pack_int(data)

    def pack_rpcsec_gss_info(self, data):
        if hasattr(self, 'filter_rpcsec_gss_info'):
            data = getattr(self, 'filter_rpcsec_gss_info')(data)
        if data.oid is None:
            raise TypeError, 'data.oid == None'
        self.pack_sec_oid4(data.oid)
        if data.qop is None:
            raise TypeError, 'data.qop == None'
        self.pack_qop4(data.qop)
        if data.service is None:
            raise TypeError, 'data.service == None'
        self.pack_rpc_gss_svc_t(data.service)

    def pack_secinfo4(self, data):
        if hasattr(self, 'filter_secinfo4'):
            data = getattr(self, 'filter_secinfo4')(data)
        if data.flavor is None:
            raise TypeError, 'data.flavor == None'
        self.pack_uint32_t(data.flavor)
        if data.flavor == const.RPCSEC_GSS:
            if data.flavor_info is None:
                raise TypeError, 'data.flavor_info == None'
            self.pack_rpcsec_gss_info(data.flavor_info)
        else:
            pass

    def pack_SECINFO4resok(self, data):
        if hasattr(self, 'filter_SECINFO4resok'):
            data = getattr(self, 'filter_SECINFO4resok')(data)
        self.pack_array(data, self.pack_secinfo4)

    def pack_SECINFO4res(self, data):
        if hasattr(self, 'filter_SECINFO4res'):
            data = getattr(self, 'filter_SECINFO4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_SECINFO4resok(data.resok4)
        else:
            pass

    def pack_SETATTR4args(self, data):
        if hasattr(self, 'filter_SETATTR4args'):
            data = getattr(self, 'filter_SETATTR4args')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.obj_attributes is None:
            raise TypeError, 'data.obj_attributes == None'
        self.pack_fattr4(data.obj_attributes)

    def pack_SETATTR4res(self, data):
        if hasattr(self, 'filter_SETATTR4res'):
            data = getattr(self, 'filter_SETATTR4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.attrsset is None:
            raise TypeError, 'data.attrsset == None'
        self.pack_bitmap4(data.attrsset)

    def pack_SETCLIENTID4args(self, data):
        if hasattr(self, 'filter_SETCLIENTID4args'):
            data = getattr(self, 'filter_SETCLIENTID4args')(data)
        if data.client is None:
            raise TypeError, 'data.client == None'
        self.pack_nfs_client_id4(data.client)
        if data.callback is None:
            raise TypeError, 'data.callback == None'
        self.pack_cb_client4(data.callback)
        if data.callback_ident is None:
            raise TypeError, 'data.callback_ident == None'
        self.pack_uint32_t(data.callback_ident)

    def pack_SETCLIENTID4resok(self, data):
        if hasattr(self, 'filter_SETCLIENTID4resok'):
            data = getattr(self, 'filter_SETCLIENTID4resok')(data)
        if data.clientid is None:
            raise TypeError, 'data.clientid == None'
        self.pack_clientid4(data.clientid)
        if data.setclientid_confirm is None:
            raise TypeError, 'data.setclientid_confirm == None'
        self.pack_verifier4(data.setclientid_confirm)

    def pack_SETCLIENTID4res(self, data):
        if hasattr(self, 'filter_SETCLIENTID4res'):
            data = getattr(self, 'filter_SETCLIENTID4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_SETCLIENTID4resok(data.resok4)
        elif data.status == const.NFS4ERR_CLID_INUSE:
            if data.client_using is None:
                raise TypeError, 'data.client_using == None'
            self.pack_clientaddr4(data.client_using)
        else:
            pass

    def pack_SETCLIENTID_CONFIRM4args(self, data):
        if hasattr(self, 'filter_SETCLIENTID_CONFIRM4args'):
            data = getattr(self, 'filter_SETCLIENTID_CONFIRM4args')(data)
        if data.clientid is None:
            raise TypeError, 'data.clientid == None'
        self.pack_clientid4(data.clientid)
        if data.setclientid_confirm is None:
            raise TypeError, 'data.setclientid_confirm == None'
        self.pack_verifier4(data.setclientid_confirm)

    def pack_SETCLIENTID_CONFIRM4res(self, data):
        if hasattr(self, 'filter_SETCLIENTID_CONFIRM4res'):
            data = getattr(self, 'filter_SETCLIENTID_CONFIRM4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_VERIFY4args(self, data):
        if hasattr(self, 'filter_VERIFY4args'):
            data = getattr(self, 'filter_VERIFY4args')(data)
        if data.obj_attributes is None:
            raise TypeError, 'data.obj_attributes == None'
        self.pack_fattr4(data.obj_attributes)

    def pack_VERIFY4res(self, data):
        if hasattr(self, 'filter_VERIFY4res'):
            data = getattr(self, 'filter_VERIFY4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_stable_how4(self, data):
        if hasattr(self, 'filter_stable_how4'):
            data = getattr(self, 'filter_stable_how4')(data)
        if self.check_enum and data not in [const.UNSTABLE4, const.DATA_SYNC4, const.FILE_SYNC4]:
            raise XDRError, 'value=%s not in enum stable_how4' % data
        self.pack_int(data)

    def pack_WRITE4args(self, data):
        if hasattr(self, 'filter_WRITE4args'):
            data = getattr(self, 'filter_WRITE4args')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.offset is None:
            raise TypeError, 'data.offset == None'
        self.pack_offset4(data.offset)
        if data.stable is None:
            raise TypeError, 'data.stable == None'
        self.pack_stable_how4(data.stable)
        if data.data is None:
            raise TypeError, 'data.data == None'
        self.pack_opaque(data.data)

    def pack_WRITE4resok(self, data):
        if hasattr(self, 'filter_WRITE4resok'):
            data = getattr(self, 'filter_WRITE4resok')(data)
        if data.count is None:
            raise TypeError, 'data.count == None'
        self.pack_count4(data.count)
        if data.committed is None:
            raise TypeError, 'data.committed == None'
        self.pack_stable_how4(data.committed)
        if data.writeverf is None:
            raise TypeError, 'data.writeverf == None'
        self.pack_verifier4(data.writeverf)

    def pack_WRITE4res(self, data):
        if hasattr(self, 'filter_WRITE4res'):
            data = getattr(self, 'filter_WRITE4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_WRITE4resok(data.resok4)
        else:
            pass

    def pack_RELEASE_LOCKOWNER4args(self, data):
        if hasattr(self, 'filter_RELEASE_LOCKOWNER4args'):
            data = getattr(self, 'filter_RELEASE_LOCKOWNER4args')(data)
        if data.lock_owner is None:
            raise TypeError, 'data.lock_owner == None'
        self.pack_lock_owner4(data.lock_owner)

    def pack_RELEASE_LOCKOWNER4res(self, data):
        if hasattr(self, 'filter_RELEASE_LOCKOWNER4res'):
            data = getattr(self, 'filter_RELEASE_LOCKOWNER4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_ILLEGAL4res(self, data):
        if hasattr(self, 'filter_ILLEGAL4res'):
            data = getattr(self, 'filter_ILLEGAL4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_gsshandle4_t(self, data):
        if hasattr(self, 'filter_gsshandle4_t'):
            data = getattr(self, 'filter_gsshandle4_t')(data)
        self.pack_opaque(data)

    def pack_gss_cb_handles4(self, data):
        if hasattr(self, 'filter_gss_cb_handles4'):
            data = getattr(self, 'filter_gss_cb_handles4')(data)
        if data.gcbp_service is None:
            raise TypeError, 'data.gcbp_service == None'
        self.pack_rpc_gss_svc_t(data.gcbp_service)
        if data.gcbp_handle_from_server is None:
            raise TypeError, 'data.gcbp_handle_from_server == None'
        self.pack_gsshandle4_t(data.gcbp_handle_from_server)
        if data.gcbp_handle_from_client is None:
            raise TypeError, 'data.gcbp_handle_from_client == None'
        self.pack_gsshandle4_t(data.gcbp_handle_from_client)

    def pack_callback_sec_parms4(self, data):
        if hasattr(self, 'filter_callback_sec_parms4'):
            data = getattr(self, 'filter_callback_sec_parms4')(data)
        if data.cb_secflavor is None:
            raise TypeError, 'data.cb_secflavor == None'
        self.pack_uint32_t(data.cb_secflavor)
        if data.cb_secflavor == const.AUTH_NONE:
            pass
        elif data.cb_secflavor == const.AUTH_SYS:
            if data.cbsp_sys_cred is None:
                raise TypeError, 'data.cbsp_sys_cred == None'
            self.pack_authsys_parms(data.cbsp_sys_cred)
        elif data.cb_secflavor == const.RPCSEC_GSS:
            if data.cbsp_gss_handles is None:
                raise TypeError, 'data.cbsp_gss_handles == None'
            self.pack_gss_cb_handles4(data.cbsp_gss_handles)
        else:
            raise XDRError, 'bad switch=%s' % data.cb_secflavor

    def pack_BACKCHANNEL_CTL4args(self, data):
        if hasattr(self, 'filter_BACKCHANNEL_CTL4args'):
            data = getattr(self, 'filter_BACKCHANNEL_CTL4args')(data)
        if data.bca_cb_program is None:
            raise TypeError, 'data.bca_cb_program == None'
        self.pack_uint32_t(data.bca_cb_program)
        if data.bca_sec_parms is None:
            raise TypeError, 'data.bca_sec_parms == None'
        self.pack_array(data.bca_sec_parms, self.pack_callback_sec_parms4)

    def pack_BACKCHANNEL_CTL4res(self, data):
        if hasattr(self, 'filter_BACKCHANNEL_CTL4res'):
            data = getattr(self, 'filter_BACKCHANNEL_CTL4res')(data)
        if data.bcr_status is None:
            raise TypeError, 'data.bcr_status == None'
        self.pack_nfsstat4(data.bcr_status)

    def pack_channel_dir_from_client4(self, data):
        if hasattr(self, 'filter_channel_dir_from_client4'):
            data = getattr(self, 'filter_channel_dir_from_client4')(data)
        if self.check_enum and data not in [const.CDFC4_FORE, const.CDFC4_BACK, const.CDFC4_FORE_OR_BOTH, const.CDFC4_BACK_OR_BOTH]:
            raise XDRError, 'value=%s not in enum channel_dir_from_client4' % data
        self.pack_int(data)

    def pack_BIND_CONN_TO_SESSION4args(self, data):
        if hasattr(self, 'filter_BIND_CONN_TO_SESSION4args'):
            data = getattr(self, 'filter_BIND_CONN_TO_SESSION4args')(data)
        if data.bctsa_sessid is None:
            raise TypeError, 'data.bctsa_sessid == None'
        self.pack_sessionid4(data.bctsa_sessid)
        if data.bctsa_dir is None:
            raise TypeError, 'data.bctsa_dir == None'
        self.pack_channel_dir_from_client4(data.bctsa_dir)
        if data.bctsa_use_conn_in_rdma_mode is None:
            raise TypeError, 'data.bctsa_use_conn_in_rdma_mode == None'
        self.pack_bool(data.bctsa_use_conn_in_rdma_mode)

    def pack_channel_dir_from_server4(self, data):
        if hasattr(self, 'filter_channel_dir_from_server4'):
            data = getattr(self, 'filter_channel_dir_from_server4')(data)
        if self.check_enum and data not in [const.CDFS4_FORE, const.CDFS4_BACK, const.CDFS4_BOTH]:
            raise XDRError, 'value=%s not in enum channel_dir_from_server4' % data
        self.pack_int(data)

    def pack_BIND_CONN_TO_SESSION4resok(self, data):
        if hasattr(self, 'filter_BIND_CONN_TO_SESSION4resok'):
            data = getattr(self, 'filter_BIND_CONN_TO_SESSION4resok')(data)
        if data.bctsr_sessid is None:
            raise TypeError, 'data.bctsr_sessid == None'
        self.pack_sessionid4(data.bctsr_sessid)
        if data.bctsr_dir is None:
            raise TypeError, 'data.bctsr_dir == None'
        self.pack_channel_dir_from_server4(data.bctsr_dir)
        if data.bctsr_use_conn_in_rdma_mode is None:
            raise TypeError, 'data.bctsr_use_conn_in_rdma_mode == None'
        self.pack_bool(data.bctsr_use_conn_in_rdma_mode)

    def pack_BIND_CONN_TO_SESSION4res(self, data):
        if hasattr(self, 'filter_BIND_CONN_TO_SESSION4res'):
            data = getattr(self, 'filter_BIND_CONN_TO_SESSION4res')(data)
        if data.bctsr_status is None:
            raise TypeError, 'data.bctsr_status == None'
        self.pack_nfsstat4(data.bctsr_status)
        if data.bctsr_status == const.NFS4_OK:
            if data.bctsr_resok4 is None:
                raise TypeError, 'data.bctsr_resok4 == None'
            self.pack_BIND_CONN_TO_SESSION4resok(data.bctsr_resok4)
        else:
            pass

    def pack_state_protect_ops4(self, data):
        if hasattr(self, 'filter_state_protect_ops4'):
            data = getattr(self, 'filter_state_protect_ops4')(data)
        if data.spo_must_enforce is None:
            raise TypeError, 'data.spo_must_enforce == None'
        self.pack_bitmap4(data.spo_must_enforce)
        if data.spo_must_allow is None:
            raise TypeError, 'data.spo_must_allow == None'
        self.pack_bitmap4(data.spo_must_allow)

    def pack_ssv_sp_parms4(self, data):
        if hasattr(self, 'filter_ssv_sp_parms4'):
            data = getattr(self, 'filter_ssv_sp_parms4')(data)
        if data.ssp_ops is None:
            raise TypeError, 'data.ssp_ops == None'
        self.pack_state_protect_ops4(data.ssp_ops)
        if data.ssp_hash_algs is None:
            raise TypeError, 'data.ssp_hash_algs == None'
        self.pack_array(data.ssp_hash_algs, self.pack_sec_oid4)
        if data.ssp_encr_algs is None:
            raise TypeError, 'data.ssp_encr_algs == None'
        self.pack_array(data.ssp_encr_algs, self.pack_sec_oid4)
        if data.ssp_window is None:
            raise TypeError, 'data.ssp_window == None'
        self.pack_uint32_t(data.ssp_window)
        if data.ssp_num_gss_handles is None:
            raise TypeError, 'data.ssp_num_gss_handles == None'
        self.pack_uint32_t(data.ssp_num_gss_handles)

    def pack_state_protect_how4(self, data):
        if hasattr(self, 'filter_state_protect_how4'):
            data = getattr(self, 'filter_state_protect_how4')(data)
        if self.check_enum and data not in [const.SP4_NONE, const.SP4_MACH_CRED, const.SP4_SSV]:
            raise XDRError, 'value=%s not in enum state_protect_how4' % data
        self.pack_int(data)

    def pack_state_protect4_a(self, data):
        if hasattr(self, 'filter_state_protect4_a'):
            data = getattr(self, 'filter_state_protect4_a')(data)
        if data.spa_how is None:
            raise TypeError, 'data.spa_how == None'
        self.pack_state_protect_how4(data.spa_how)
        if data.spa_how == const.SP4_NONE:
            pass
        elif data.spa_how == const.SP4_MACH_CRED:
            if data.spa_mach_ops is None:
                raise TypeError, 'data.spa_mach_ops == None'
            self.pack_state_protect_ops4(data.spa_mach_ops)
        elif data.spa_how == const.SP4_SSV:
            if data.spa_ssv_parms is None:
                raise TypeError, 'data.spa_ssv_parms == None'
            self.pack_ssv_sp_parms4(data.spa_ssv_parms)
        else:
            raise XDRError, 'bad switch=%s' % data.spa_how

    def pack_EXCHANGE_ID4args(self, data):
        if hasattr(self, 'filter_EXCHANGE_ID4args'):
            data = getattr(self, 'filter_EXCHANGE_ID4args')(data)
        if data.eia_clientowner is None:
            raise TypeError, 'data.eia_clientowner == None'
        self.pack_client_owner4(data.eia_clientowner)
        if data.eia_flags is None:
            raise TypeError, 'data.eia_flags == None'
        self.pack_uint32_t(data.eia_flags)
        if data.eia_state_protect is None:
            raise TypeError, 'data.eia_state_protect == None'
        self.pack_state_protect4_a(data.eia_state_protect)
        if data.eia_client_impl_id is None:
            raise TypeError, 'data.eia_client_impl_id == None'
        if len(data.eia_client_impl_id) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.eia_client_impl_id'
        self.pack_array(data.eia_client_impl_id, self.pack_nfs_impl_id4)

    def pack_ssv_prot_info4(self, data):
        if hasattr(self, 'filter_ssv_prot_info4'):
            data = getattr(self, 'filter_ssv_prot_info4')(data)
        if data.spi_ops is None:
            raise TypeError, 'data.spi_ops == None'
        self.pack_state_protect_ops4(data.spi_ops)
        if data.spi_hash_alg is None:
            raise TypeError, 'data.spi_hash_alg == None'
        self.pack_uint32_t(data.spi_hash_alg)
        if data.spi_encr_alg is None:
            raise TypeError, 'data.spi_encr_alg == None'
        self.pack_uint32_t(data.spi_encr_alg)
        if data.spi_ssv_len is None:
            raise TypeError, 'data.spi_ssv_len == None'
        self.pack_uint32_t(data.spi_ssv_len)
        if data.spi_window is None:
            raise TypeError, 'data.spi_window == None'
        self.pack_uint32_t(data.spi_window)
        if data.spi_handles is None:
            raise TypeError, 'data.spi_handles == None'
        self.pack_array(data.spi_handles, self.pack_gsshandle4_t)

    def pack_state_protect4_r(self, data):
        if hasattr(self, 'filter_state_protect4_r'):
            data = getattr(self, 'filter_state_protect4_r')(data)
        if data.spr_how is None:
            raise TypeError, 'data.spr_how == None'
        self.pack_state_protect_how4(data.spr_how)
        if data.spr_how == const.SP4_NONE:
            pass
        elif data.spr_how == const.SP4_MACH_CRED:
            if data.spr_mach_ops is None:
                raise TypeError, 'data.spr_mach_ops == None'
            self.pack_state_protect_ops4(data.spr_mach_ops)
        elif data.spr_how == const.SP4_SSV:
            if data.spr_ssv_info is None:
                raise TypeError, 'data.spr_ssv_info == None'
            self.pack_ssv_prot_info4(data.spr_ssv_info)
        else:
            raise XDRError, 'bad switch=%s' % data.spr_how

    def pack_EXCHANGE_ID4resok(self, data):
        if hasattr(self, 'filter_EXCHANGE_ID4resok'):
            data = getattr(self, 'filter_EXCHANGE_ID4resok')(data)
        if data.eir_clientid is None:
            raise TypeError, 'data.eir_clientid == None'
        self.pack_clientid4(data.eir_clientid)
        if data.eir_sequenceid is None:
            raise TypeError, 'data.eir_sequenceid == None'
        self.pack_sequenceid4(data.eir_sequenceid)
        if data.eir_flags is None:
            raise TypeError, 'data.eir_flags == None'
        self.pack_uint32_t(data.eir_flags)
        if data.eir_state_protect is None:
            raise TypeError, 'data.eir_state_protect == None'
        self.pack_state_protect4_r(data.eir_state_protect)
        if data.eir_server_owner is None:
            raise TypeError, 'data.eir_server_owner == None'
        self.pack_server_owner4(data.eir_server_owner)
        if data.eir_server_scope is None:
            raise TypeError, 'data.eir_server_scope == None'
        if len(data.eir_server_scope) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.eir_server_scope'
        self.pack_opaque(data.eir_server_scope)
        if data.eir_server_impl_id is None:
            raise TypeError, 'data.eir_server_impl_id == None'
        if len(data.eir_server_impl_id) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.eir_server_impl_id'
        self.pack_array(data.eir_server_impl_id, self.pack_nfs_impl_id4)

    def pack_EXCHANGE_ID4res(self, data):
        if hasattr(self, 'filter_EXCHANGE_ID4res'):
            data = getattr(self, 'filter_EXCHANGE_ID4res')(data)
        if data.eir_status is None:
            raise TypeError, 'data.eir_status == None'
        self.pack_nfsstat4(data.eir_status)
        if data.eir_status == const.NFS4_OK:
            if data.eir_resok4 is None:
                raise TypeError, 'data.eir_resok4 == None'
            self.pack_EXCHANGE_ID4resok(data.eir_resok4)
        else:
            pass

    def pack_channel_attrs4(self, data):
        if hasattr(self, 'filter_channel_attrs4'):
            data = getattr(self, 'filter_channel_attrs4')(data)
        if data.ca_headerpadsize is None:
            raise TypeError, 'data.ca_headerpadsize == None'
        self.pack_count4(data.ca_headerpadsize)
        if data.ca_maxrequestsize is None:
            raise TypeError, 'data.ca_maxrequestsize == None'
        self.pack_count4(data.ca_maxrequestsize)
        if data.ca_maxresponsesize is None:
            raise TypeError, 'data.ca_maxresponsesize == None'
        self.pack_count4(data.ca_maxresponsesize)
        if data.ca_maxresponsesize_cached is None:
            raise TypeError, 'data.ca_maxresponsesize_cached == None'
        self.pack_count4(data.ca_maxresponsesize_cached)
        if data.ca_maxoperations is None:
            raise TypeError, 'data.ca_maxoperations == None'
        self.pack_count4(data.ca_maxoperations)
        if data.ca_maxrequests is None:
            raise TypeError, 'data.ca_maxrequests == None'
        self.pack_count4(data.ca_maxrequests)
        if data.ca_rdma_ird is None:
            raise TypeError, 'data.ca_rdma_ird == None'
        if len(data.ca_rdma_ird) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.ca_rdma_ird'
        self.pack_array(data.ca_rdma_ird, self.pack_uint32_t)

    def pack_CREATE_SESSION4args(self, data):
        if hasattr(self, 'filter_CREATE_SESSION4args'):
            data = getattr(self, 'filter_CREATE_SESSION4args')(data)
        if data.csa_clientid is None:
            raise TypeError, 'data.csa_clientid == None'
        self.pack_clientid4(data.csa_clientid)
        if data.csa_sequence is None:
            raise TypeError, 'data.csa_sequence == None'
        self.pack_sequenceid4(data.csa_sequence)
        if data.csa_flags is None:
            raise TypeError, 'data.csa_flags == None'
        self.pack_uint32_t(data.csa_flags)
        if data.csa_fore_chan_attrs is None:
            raise TypeError, 'data.csa_fore_chan_attrs == None'
        self.pack_channel_attrs4(data.csa_fore_chan_attrs)
        if data.csa_back_chan_attrs is None:
            raise TypeError, 'data.csa_back_chan_attrs == None'
        self.pack_channel_attrs4(data.csa_back_chan_attrs)
        if data.csa_cb_program is None:
            raise TypeError, 'data.csa_cb_program == None'
        self.pack_uint32_t(data.csa_cb_program)
        if data.csa_sec_parms is None:
            raise TypeError, 'data.csa_sec_parms == None'
        self.pack_array(data.csa_sec_parms, self.pack_callback_sec_parms4)

    def pack_CREATE_SESSION4resok(self, data):
        if hasattr(self, 'filter_CREATE_SESSION4resok'):
            data = getattr(self, 'filter_CREATE_SESSION4resok')(data)
        if data.csr_sessionid is None:
            raise TypeError, 'data.csr_sessionid == None'
        self.pack_sessionid4(data.csr_sessionid)
        if data.csr_sequence is None:
            raise TypeError, 'data.csr_sequence == None'
        self.pack_sequenceid4(data.csr_sequence)
        if data.csr_flags is None:
            raise TypeError, 'data.csr_flags == None'
        self.pack_uint32_t(data.csr_flags)
        if data.csr_fore_chan_attrs is None:
            raise TypeError, 'data.csr_fore_chan_attrs == None'
        self.pack_channel_attrs4(data.csr_fore_chan_attrs)
        if data.csr_back_chan_attrs is None:
            raise TypeError, 'data.csr_back_chan_attrs == None'
        self.pack_channel_attrs4(data.csr_back_chan_attrs)

    def pack_CREATE_SESSION4res(self, data):
        if hasattr(self, 'filter_CREATE_SESSION4res'):
            data = getattr(self, 'filter_CREATE_SESSION4res')(data)
        if data.csr_status is None:
            raise TypeError, 'data.csr_status == None'
        self.pack_nfsstat4(data.csr_status)
        if data.csr_status == const.NFS4_OK:
            if data.csr_resok4 is None:
                raise TypeError, 'data.csr_resok4 == None'
            self.pack_CREATE_SESSION4resok(data.csr_resok4)
        else:
            pass

    def pack_DESTROY_SESSION4args(self, data):
        if hasattr(self, 'filter_DESTROY_SESSION4args'):
            data = getattr(self, 'filter_DESTROY_SESSION4args')(data)
        if data.dsa_sessionid is None:
            raise TypeError, 'data.dsa_sessionid == None'
        self.pack_sessionid4(data.dsa_sessionid)

    def pack_DESTROY_SESSION4res(self, data):
        if hasattr(self, 'filter_DESTROY_SESSION4res'):
            data = getattr(self, 'filter_DESTROY_SESSION4res')(data)
        if data.dsr_status is None:
            raise TypeError, 'data.dsr_status == None'
        self.pack_nfsstat4(data.dsr_status)

    def pack_FREE_STATEID4args(self, data):
        if hasattr(self, 'filter_FREE_STATEID4args'):
            data = getattr(self, 'filter_FREE_STATEID4args')(data)
        if data.fsa_stateid is None:
            raise TypeError, 'data.fsa_stateid == None'
        self.pack_stateid4(data.fsa_stateid)

    def pack_FREE_STATEID4res(self, data):
        if hasattr(self, 'filter_FREE_STATEID4res'):
            data = getattr(self, 'filter_FREE_STATEID4res')(data)
        if data.fsr_status is None:
            raise TypeError, 'data.fsr_status == None'
        self.pack_nfsstat4(data.fsr_status)

    pack_attr_notice4 = pack_nfstime4

    def pack_GET_DIR_DELEGATION4args(self, data):
        if hasattr(self, 'filter_GET_DIR_DELEGATION4args'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4args')(data)
        if data.gdda_signal_deleg_avail is None:
            raise TypeError, 'data.gdda_signal_deleg_avail == None'
        self.pack_bool(data.gdda_signal_deleg_avail)
        if data.gdda_notification_types is None:
            raise TypeError, 'data.gdda_notification_types == None'
        self.pack_bitmap4(data.gdda_notification_types)
        if data.gdda_child_attr_delay is None:
            raise TypeError, 'data.gdda_child_attr_delay == None'
        self.pack_attr_notice4(data.gdda_child_attr_delay)
        if data.gdda_dir_attr_delay is None:
            raise TypeError, 'data.gdda_dir_attr_delay == None'
        self.pack_attr_notice4(data.gdda_dir_attr_delay)
        if data.gdda_child_attributes is None:
            raise TypeError, 'data.gdda_child_attributes == None'
        self.pack_bitmap4(data.gdda_child_attributes)
        if data.gdda_dir_attributes is None:
            raise TypeError, 'data.gdda_dir_attributes == None'
        self.pack_bitmap4(data.gdda_dir_attributes)

    def pack_GET_DIR_DELEGATION4resok(self, data):
        if hasattr(self, 'filter_GET_DIR_DELEGATION4resok'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4resok')(data)
        if data.gddr_cookieverf is None:
            raise TypeError, 'data.gddr_cookieverf == None'
        self.pack_verifier4(data.gddr_cookieverf)
        if data.gddr_stateid is None:
            raise TypeError, 'data.gddr_stateid == None'
        self.pack_stateid4(data.gddr_stateid)
        if data.gddr_notification is None:
            raise TypeError, 'data.gddr_notification == None'
        self.pack_bitmap4(data.gddr_notification)
        if data.gddr_child_attributes is None:
            raise TypeError, 'data.gddr_child_attributes == None'
        self.pack_bitmap4(data.gddr_child_attributes)
        if data.gddr_dir_attributes is None:
            raise TypeError, 'data.gddr_dir_attributes == None'
        self.pack_bitmap4(data.gddr_dir_attributes)

    def pack_gddrnf4_status(self, data):
        if hasattr(self, 'filter_gddrnf4_status'):
            data = getattr(self, 'filter_gddrnf4_status')(data)
        if self.check_enum and data not in [const.GDD4_OK, const.GDD4_UNAVAIL]:
            raise XDRError, 'value=%s not in enum gddrnf4_status' % data
        self.pack_int(data)

    def pack_GET_DIR_DELEGATION4res_non_fatal(self, data):
        if hasattr(self, 'filter_GET_DIR_DELEGATION4res_non_fatal'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4res_non_fatal')(data)
        if data.gddrnf_status is None:
            raise TypeError, 'data.gddrnf_status == None'
        self.pack_gddrnf4_status(data.gddrnf_status)
        if data.gddrnf_status == const.GDD4_OK:
            if data.gddrnf_resok4 is None:
                raise TypeError, 'data.gddrnf_resok4 == None'
            self.pack_GET_DIR_DELEGATION4resok(data.gddrnf_resok4)
        elif data.gddrnf_status == const.GDD4_UNAVAIL:
            if data.gddrnf_will_signal_deleg_avail is None:
                raise TypeError, 'data.gddrnf_will_signal_deleg_avail == None'
            self.pack_bool(data.gddrnf_will_signal_deleg_avail)
        else:
            raise XDRError, 'bad switch=%s' % data.gddrnf_status

    def pack_GET_DIR_DELEGATION4res(self, data):
        if hasattr(self, 'filter_GET_DIR_DELEGATION4res'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4res')(data)
        if data.gddr_status is None:
            raise TypeError, 'data.gddr_status == None'
        self.pack_nfsstat4(data.gddr_status)
        if data.gddr_status == const.NFS4_OK:
            if data.gddr_res_non_fatal4 is None:
                raise TypeError, 'data.gddr_res_non_fatal4 == None'
            self.pack_GET_DIR_DELEGATION4res_non_fatal(data.gddr_res_non_fatal4)
        else:
            pass

    def pack_GETDEVICEINFO4args(self, data):
        if hasattr(self, 'filter_GETDEVICEINFO4args'):
            data = getattr(self, 'filter_GETDEVICEINFO4args')(data)
        if data.gdia_device_id is None:
            raise TypeError, 'data.gdia_device_id == None'
        self.pack_deviceid4(data.gdia_device_id)
        if data.gdia_layout_type is None:
            raise TypeError, 'data.gdia_layout_type == None'
        self.pack_layouttype4(data.gdia_layout_type)
        if data.gdia_maxcount is None:
            raise TypeError, 'data.gdia_maxcount == None'
        self.pack_count4(data.gdia_maxcount)
        if data.gdia_notify_types is None:
            raise TypeError, 'data.gdia_notify_types == None'
        self.pack_bitmap4(data.gdia_notify_types)

    def pack_GETDEVICEINFO4resok(self, data):
        if hasattr(self, 'filter_GETDEVICEINFO4resok'):
            data = getattr(self, 'filter_GETDEVICEINFO4resok')(data)
        if data.gdir_device_addr is None:
            raise TypeError, 'data.gdir_device_addr == None'
        self.pack_device_addr4(data.gdir_device_addr)
        if data.gdir_notification is None:
            raise TypeError, 'data.gdir_notification == None'
        self.pack_bitmap4(data.gdir_notification)

    def pack_GETDEVICEINFO4res(self, data):
        if hasattr(self, 'filter_GETDEVICEINFO4res'):
            data = getattr(self, 'filter_GETDEVICEINFO4res')(data)
        if data.gdir_status is None:
            raise TypeError, 'data.gdir_status == None'
        self.pack_nfsstat4(data.gdir_status)
        if data.gdir_status == const.NFS4_OK:
            if data.gdir_resok4 is None:
                raise TypeError, 'data.gdir_resok4 == None'
            self.pack_GETDEVICEINFO4resok(data.gdir_resok4)
        elif data.gdir_status == const.NFS4ERR_TOOSMALL:
            if data.gdir_mincount is None:
                raise TypeError, 'data.gdir_mincount == None'
            self.pack_count4(data.gdir_mincount)
        else:
            pass

    def pack_GETDEVICELIST4args(self, data):
        if hasattr(self, 'filter_GETDEVICELIST4args'):
            data = getattr(self, 'filter_GETDEVICELIST4args')(data)
        if data.gdla_layout_type is None:
            raise TypeError, 'data.gdla_layout_type == None'
        self.pack_layouttype4(data.gdla_layout_type)
        if data.gdla_maxdevices is None:
            raise TypeError, 'data.gdla_maxdevices == None'
        self.pack_count4(data.gdla_maxdevices)
        if data.gdla_cookie is None:
            raise TypeError, 'data.gdla_cookie == None'
        self.pack_nfs_cookie4(data.gdla_cookie)
        if data.gdla_cookieverf is None:
            raise TypeError, 'data.gdla_cookieverf == None'
        self.pack_verifier4(data.gdla_cookieverf)

    def pack_GETDEVICELIST4resok(self, data):
        if hasattr(self, 'filter_GETDEVICELIST4resok'):
            data = getattr(self, 'filter_GETDEVICELIST4resok')(data)
        if data.gdlr_cookie is None:
            raise TypeError, 'data.gdlr_cookie == None'
        self.pack_nfs_cookie4(data.gdlr_cookie)
        if data.gdlr_cookieverf is None:
            raise TypeError, 'data.gdlr_cookieverf == None'
        self.pack_verifier4(data.gdlr_cookieverf)
        if data.gdlr_deviceid_list is None:
            raise TypeError, 'data.gdlr_deviceid_list == None'
        self.pack_array(data.gdlr_deviceid_list, self.pack_deviceid4)
        if data.gdlr_eof is None:
            raise TypeError, 'data.gdlr_eof == None'
        self.pack_bool(data.gdlr_eof)

    def pack_GETDEVICELIST4res(self, data):
        if hasattr(self, 'filter_GETDEVICELIST4res'):
            data = getattr(self, 'filter_GETDEVICELIST4res')(data)
        if data.gdlr_status is None:
            raise TypeError, 'data.gdlr_status == None'
        self.pack_nfsstat4(data.gdlr_status)
        if data.gdlr_status == const.NFS4_OK:
            if data.gdlr_resok4 is None:
                raise TypeError, 'data.gdlr_resok4 == None'
            self.pack_GETDEVICELIST4resok(data.gdlr_resok4)
        else:
            pass

    def pack_newtime4(self, data):
        if hasattr(self, 'filter_newtime4'):
            data = getattr(self, 'filter_newtime4')(data)
        if data.nt_timechanged is None:
            raise TypeError, 'data.nt_timechanged == None'
        self.pack_bool(data.nt_timechanged)
        if data.nt_timechanged == const.TRUE:
            if data.nt_time is None:
                raise TypeError, 'data.nt_time == None'
            self.pack_nfstime4(data.nt_time)
        elif data.nt_timechanged == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.nt_timechanged

    def pack_newoffset4(self, data):
        if hasattr(self, 'filter_newoffset4'):
            data = getattr(self, 'filter_newoffset4')(data)
        if data.no_newoffset is None:
            raise TypeError, 'data.no_newoffset == None'
        self.pack_bool(data.no_newoffset)
        if data.no_newoffset == const.TRUE:
            if data.no_offset is None:
                raise TypeError, 'data.no_offset == None'
            self.pack_offset4(data.no_offset)
        elif data.no_newoffset == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.no_newoffset

    def pack_LAYOUTCOMMIT4args(self, data):
        if hasattr(self, 'filter_LAYOUTCOMMIT4args'):
            data = getattr(self, 'filter_LAYOUTCOMMIT4args')(data)
        if data.loca_offset is None:
            raise TypeError, 'data.loca_offset == None'
        self.pack_offset4(data.loca_offset)
        if data.loca_length is None:
            raise TypeError, 'data.loca_length == None'
        self.pack_length4(data.loca_length)
        if data.loca_reclaim is None:
            raise TypeError, 'data.loca_reclaim == None'
        self.pack_bool(data.loca_reclaim)
        if data.loca_stateid is None:
            raise TypeError, 'data.loca_stateid == None'
        self.pack_stateid4(data.loca_stateid)
        if data.loca_last_write_offset is None:
            raise TypeError, 'data.loca_last_write_offset == None'
        self.pack_newoffset4(data.loca_last_write_offset)
        if data.loca_time_modify is None:
            raise TypeError, 'data.loca_time_modify == None'
        self.pack_newtime4(data.loca_time_modify)
        if data.loca_layoutupdate is None:
            raise TypeError, 'data.loca_layoutupdate == None'
        self.pack_layoutupdate4(data.loca_layoutupdate)

    def pack_newsize4(self, data):
        if hasattr(self, 'filter_newsize4'):
            data = getattr(self, 'filter_newsize4')(data)
        if data.ns_sizechanged is None:
            raise TypeError, 'data.ns_sizechanged == None'
        self.pack_bool(data.ns_sizechanged)
        if data.ns_sizechanged == const.TRUE:
            if data.ns_size is None:
                raise TypeError, 'data.ns_size == None'
            self.pack_length4(data.ns_size)
        elif data.ns_sizechanged == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.ns_sizechanged

    def pack_LAYOUTCOMMIT4resok(self, data):
        if hasattr(self, 'filter_LAYOUTCOMMIT4resok'):
            data = getattr(self, 'filter_LAYOUTCOMMIT4resok')(data)
        if data.locr_newsize is None:
            raise TypeError, 'data.locr_newsize == None'
        self.pack_newsize4(data.locr_newsize)

    def pack_LAYOUTCOMMIT4res(self, data):
        if hasattr(self, 'filter_LAYOUTCOMMIT4res'):
            data = getattr(self, 'filter_LAYOUTCOMMIT4res')(data)
        if data.locr_status is None:
            raise TypeError, 'data.locr_status == None'
        self.pack_nfsstat4(data.locr_status)
        if data.locr_status == const.NFS4_OK:
            if data.locr_resok4 is None:
                raise TypeError, 'data.locr_resok4 == None'
            self.pack_LAYOUTCOMMIT4resok(data.locr_resok4)
        else:
            pass

    def pack_LAYOUTGET4args(self, data):
        if hasattr(self, 'filter_LAYOUTGET4args'):
            data = getattr(self, 'filter_LAYOUTGET4args')(data)
        if data.loga_signal_layout_avail is None:
            raise TypeError, 'data.loga_signal_layout_avail == None'
        self.pack_bool(data.loga_signal_layout_avail)
        if data.loga_layout_type is None:
            raise TypeError, 'data.loga_layout_type == None'
        self.pack_layouttype4(data.loga_layout_type)
        if data.loga_iomode is None:
            raise TypeError, 'data.loga_iomode == None'
        self.pack_layoutiomode4(data.loga_iomode)
        if data.loga_offset is None:
            raise TypeError, 'data.loga_offset == None'
        self.pack_offset4(data.loga_offset)
        if data.loga_length is None:
            raise TypeError, 'data.loga_length == None'
        self.pack_length4(data.loga_length)
        if data.loga_minlength is None:
            raise TypeError, 'data.loga_minlength == None'
        self.pack_length4(data.loga_minlength)
        if data.loga_stateid is None:
            raise TypeError, 'data.loga_stateid == None'
        self.pack_stateid4(data.loga_stateid)
        if data.loga_maxcount is None:
            raise TypeError, 'data.loga_maxcount == None'
        self.pack_count4(data.loga_maxcount)

    def pack_LAYOUTGET4resok(self, data):
        if hasattr(self, 'filter_LAYOUTGET4resok'):
            data = getattr(self, 'filter_LAYOUTGET4resok')(data)
        if data.logr_return_on_close is None:
            raise TypeError, 'data.logr_return_on_close == None'
        self.pack_bool(data.logr_return_on_close)
        if data.logr_stateid is None:
            raise TypeError, 'data.logr_stateid == None'
        self.pack_stateid4(data.logr_stateid)
        if data.logr_layout is None:
            raise TypeError, 'data.logr_layout == None'
        self.pack_array(data.logr_layout, self.pack_layout4)

    def pack_LAYOUTGET4res(self, data):
        if hasattr(self, 'filter_LAYOUTGET4res'):
            data = getattr(self, 'filter_LAYOUTGET4res')(data)
        if data.logr_status is None:
            raise TypeError, 'data.logr_status == None'
        self.pack_nfsstat4(data.logr_status)
        if data.logr_status == const.NFS4_OK:
            if data.logr_resok4 is None:
                raise TypeError, 'data.logr_resok4 == None'
            self.pack_LAYOUTGET4resok(data.logr_resok4)
        elif data.logr_status == const.NFS4ERR_LAYOUTTRYLATER:
            if data.logr_will_signal_layout_avail is None:
                raise TypeError, 'data.logr_will_signal_layout_avail == None'
            self.pack_bool(data.logr_will_signal_layout_avail)
        else:
            pass

    def pack_LAYOUTRETURN4args(self, data):
        if hasattr(self, 'filter_LAYOUTRETURN4args'):
            data = getattr(self, 'filter_LAYOUTRETURN4args')(data)
        if data.lora_reclaim is None:
            raise TypeError, 'data.lora_reclaim == None'
        self.pack_bool(data.lora_reclaim)
        if data.lora_layout_type is None:
            raise TypeError, 'data.lora_layout_type == None'
        self.pack_layouttype4(data.lora_layout_type)
        if data.lora_iomode is None:
            raise TypeError, 'data.lora_iomode == None'
        self.pack_layoutiomode4(data.lora_iomode)
        if data.lora_layoutreturn is None:
            raise TypeError, 'data.lora_layoutreturn == None'
        self.pack_layoutreturn4(data.lora_layoutreturn)

    def pack_layoutreturn_stateid(self, data):
        if hasattr(self, 'filter_layoutreturn_stateid'):
            data = getattr(self, 'filter_layoutreturn_stateid')(data)
        if data.lrs_present is None:
            raise TypeError, 'data.lrs_present == None'
        self.pack_bool(data.lrs_present)
        if data.lrs_present == const.TRUE:
            if data.lrs_stateid is None:
                raise TypeError, 'data.lrs_stateid == None'
            self.pack_stateid4(data.lrs_stateid)
        elif data.lrs_present == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.lrs_present

    def pack_LAYOUTRETURN4res(self, data):
        if hasattr(self, 'filter_LAYOUTRETURN4res'):
            data = getattr(self, 'filter_LAYOUTRETURN4res')(data)
        if data.lorr_status is None:
            raise TypeError, 'data.lorr_status == None'
        self.pack_nfsstat4(data.lorr_status)
        if data.lorr_status == const.NFS4_OK:
            if data.lorr_stateid is None:
                raise TypeError, 'data.lorr_stateid == None'
            self.pack_layoutreturn_stateid(data.lorr_stateid)
        else:
            pass

    def pack_secinfo_style4(self, data):
        if hasattr(self, 'filter_secinfo_style4'):
            data = getattr(self, 'filter_secinfo_style4')(data)
        if self.check_enum and data not in [const.SECINFO_STYLE4_CURRENT_FH, const.SECINFO_STYLE4_PARENT]:
            raise XDRError, 'value=%s not in enum secinfo_style4' % data
        self.pack_int(data)

    pack_SECINFO_NO_NAME4args = pack_secinfo_style4

    pack_SECINFO_NO_NAME4res = pack_SECINFO4res

    def pack_SEQUENCE4args(self, data):
        if hasattr(self, 'filter_SEQUENCE4args'):
            data = getattr(self, 'filter_SEQUENCE4args')(data)
        if data.sa_sessionid is None:
            raise TypeError, 'data.sa_sessionid == None'
        self.pack_sessionid4(data.sa_sessionid)
        if data.sa_sequenceid is None:
            raise TypeError, 'data.sa_sequenceid == None'
        self.pack_sequenceid4(data.sa_sequenceid)
        if data.sa_slotid is None:
            raise TypeError, 'data.sa_slotid == None'
        self.pack_slotid4(data.sa_slotid)
        if data.sa_highest_slotid is None:
            raise TypeError, 'data.sa_highest_slotid == None'
        self.pack_slotid4(data.sa_highest_slotid)
        if data.sa_cachethis is None:
            raise TypeError, 'data.sa_cachethis == None'
        self.pack_bool(data.sa_cachethis)

    def pack_SEQUENCE4resok(self, data):
        if hasattr(self, 'filter_SEQUENCE4resok'):
            data = getattr(self, 'filter_SEQUENCE4resok')(data)
        if data.sr_sessionid is None:
            raise TypeError, 'data.sr_sessionid == None'
        self.pack_sessionid4(data.sr_sessionid)
        if data.sr_sequenceid is None:
            raise TypeError, 'data.sr_sequenceid == None'
        self.pack_sequenceid4(data.sr_sequenceid)
        if data.sr_slotid is None:
            raise TypeError, 'data.sr_slotid == None'
        self.pack_slotid4(data.sr_slotid)
        if data.sr_highest_slotid is None:
            raise TypeError, 'data.sr_highest_slotid == None'
        self.pack_slotid4(data.sr_highest_slotid)
        if data.sr_target_highest_slotid is None:
            raise TypeError, 'data.sr_target_highest_slotid == None'
        self.pack_slotid4(data.sr_target_highest_slotid)
        if data.sr_status_flags is None:
            raise TypeError, 'data.sr_status_flags == None'
        self.pack_uint32_t(data.sr_status_flags)

    def pack_SEQUENCE4res(self, data):
        if hasattr(self, 'filter_SEQUENCE4res'):
            data = getattr(self, 'filter_SEQUENCE4res')(data)
        if data.sr_status is None:
            raise TypeError, 'data.sr_status == None'
        self.pack_nfsstat4(data.sr_status)
        if data.sr_status == const.NFS4_OK:
            if data.sr_resok4 is None:
                raise TypeError, 'data.sr_resok4 == None'
            self.pack_SEQUENCE4resok(data.sr_resok4)
        else:
            pass

    def pack_ssa_digest_input4(self, data):
        if hasattr(self, 'filter_ssa_digest_input4'):
            data = getattr(self, 'filter_ssa_digest_input4')(data)
        if data.sdi_seqargs is None:
            raise TypeError, 'data.sdi_seqargs == None'
        self.pack_SEQUENCE4args(data.sdi_seqargs)

    def pack_SET_SSV4args(self, data):
        if hasattr(self, 'filter_SET_SSV4args'):
            data = getattr(self, 'filter_SET_SSV4args')(data)
        if data.ssa_ssv is None:
            raise TypeError, 'data.ssa_ssv == None'
        self.pack_opaque(data.ssa_ssv)
        if data.ssa_digest is None:
            raise TypeError, 'data.ssa_digest == None'
        self.pack_opaque(data.ssa_digest)

    def pack_ssr_digest_input4(self, data):
        if hasattr(self, 'filter_ssr_digest_input4'):
            data = getattr(self, 'filter_ssr_digest_input4')(data)
        if data.sdi_seqres is None:
            raise TypeError, 'data.sdi_seqres == None'
        self.pack_SEQUENCE4res(data.sdi_seqres)

    def pack_SET_SSV4resok(self, data):
        if hasattr(self, 'filter_SET_SSV4resok'):
            data = getattr(self, 'filter_SET_SSV4resok')(data)
        if data.ssr_digest is None:
            raise TypeError, 'data.ssr_digest == None'
        self.pack_opaque(data.ssr_digest)

    def pack_SET_SSV4res(self, data):
        if hasattr(self, 'filter_SET_SSV4res'):
            data = getattr(self, 'filter_SET_SSV4res')(data)
        if data.ssr_status is None:
            raise TypeError, 'data.ssr_status == None'
        self.pack_nfsstat4(data.ssr_status)
        if data.ssr_status == const.NFS4_OK:
            if data.ssr_resok4 is None:
                raise TypeError, 'data.ssr_resok4 == None'
            self.pack_SET_SSV4resok(data.ssr_resok4)
        else:
            pass

    def pack_TEST_STATEID4args(self, data):
        if hasattr(self, 'filter_TEST_STATEID4args'):
            data = getattr(self, 'filter_TEST_STATEID4args')(data)
        if data.ts_stateids is None:
            raise TypeError, 'data.ts_stateids == None'
        self.pack_array(data.ts_stateids, self.pack_stateid4)

    def pack_TEST_STATEID4resok(self, data):
        if hasattr(self, 'filter_TEST_STATEID4resok'):
            data = getattr(self, 'filter_TEST_STATEID4resok')(data)
        if data.tsr_status_codes is None:
            raise TypeError, 'data.tsr_status_codes == None'
        self.pack_array(data.tsr_status_codes, self.pack_nfsstat4)

    def pack_TEST_STATEID4res(self, data):
        if hasattr(self, 'filter_TEST_STATEID4res'):
            data = getattr(self, 'filter_TEST_STATEID4res')(data)
        if data.tsr_status is None:
            raise TypeError, 'data.tsr_status == None'
        self.pack_nfsstat4(data.tsr_status)
        if data.tsr_status == const.NFS4_OK:
            if data.tsr_resok4 is None:
                raise TypeError, 'data.tsr_resok4 == None'
            self.pack_TEST_STATEID4resok(data.tsr_resok4)
        else:
            pass

    def pack_deleg_claim4(self, data):
        if hasattr(self, 'filter_deleg_claim4'):
            data = getattr(self, 'filter_deleg_claim4')(data)
        if data.dc_claim is None:
            raise TypeError, 'data.dc_claim == None'
        self.pack_open_claim_type4(data.dc_claim)
        if data.dc_claim == const.CLAIM_FH:
            pass
        elif data.dc_claim == const.CLAIM_DELEG_PREV_FH:
            pass
        elif data.dc_claim == const.CLAIM_PREVIOUS:
            if data.dc_delegate_type is None:
                raise TypeError, 'data.dc_delegate_type == None'
            self.pack_open_delegation_type4(data.dc_delegate_type)
        else:
            raise XDRError, 'bad switch=%s' % data.dc_claim

    def pack_WANT_DELEGATION4args(self, data):
        if hasattr(self, 'filter_WANT_DELEGATION4args'):
            data = getattr(self, 'filter_WANT_DELEGATION4args')(data)
        if data.wda_want is None:
            raise TypeError, 'data.wda_want == None'
        self.pack_uint32_t(data.wda_want)
        if data.wda_claim is None:
            raise TypeError, 'data.wda_claim == None'
        self.pack_deleg_claim4(data.wda_claim)

    def pack_WANT_DELEGATION4res(self, data):
        if hasattr(self, 'filter_WANT_DELEGATION4res'):
            data = getattr(self, 'filter_WANT_DELEGATION4res')(data)
        if data.wdr_status is None:
            raise TypeError, 'data.wdr_status == None'
        self.pack_nfsstat4(data.wdr_status)
        if data.wdr_status == const.NFS4_OK:
            if data.wdr_resok4 is None:
                raise TypeError, 'data.wdr_resok4 == None'
            self.pack_open_delegation4(data.wdr_resok4)
        else:
            pass

    def pack_DESTROY_CLIENTID4args(self, data):
        if hasattr(self, 'filter_DESTROY_CLIENTID4args'):
            data = getattr(self, 'filter_DESTROY_CLIENTID4args')(data)
        if data.dca_clientid is None:
            raise TypeError, 'data.dca_clientid == None'
        self.pack_clientid4(data.dca_clientid)

    def pack_DESTROY_CLIENTID4res(self, data):
        if hasattr(self, 'filter_DESTROY_CLIENTID4res'):
            data = getattr(self, 'filter_DESTROY_CLIENTID4res')(data)
        if data.dcr_status is None:
            raise TypeError, 'data.dcr_status == None'
        self.pack_nfsstat4(data.dcr_status)

    def pack_RECLAIM_COMPLETE4args(self, data):
        if hasattr(self, 'filter_RECLAIM_COMPLETE4args'):
            data = getattr(self, 'filter_RECLAIM_COMPLETE4args')(data)
        if data.rca_one_fs is None:
            raise TypeError, 'data.rca_one_fs == None'
        self.pack_bool(data.rca_one_fs)

    def pack_RECLAIM_COMPLETE4res(self, data):
        if hasattr(self, 'filter_RECLAIM_COMPLETE4res'):
            data = getattr(self, 'filter_RECLAIM_COMPLETE4res')(data)
        if data.rcr_status is None:
            raise TypeError, 'data.rcr_status == None'
        self.pack_nfsstat4(data.rcr_status)

    def pack_nfs_opnum4(self, data):
        if hasattr(self, 'filter_nfs_opnum4'):
            data = getattr(self, 'filter_nfs_opnum4')(data)
        if self.check_enum and data not in [const.OP_ACCESS, const.OP_CLOSE, const.OP_COMMIT, const.OP_CREATE, const.OP_DELEGPURGE, const.OP_DELEGRETURN, const.OP_GETATTR, const.OP_GETFH, const.OP_LINK, const.OP_LOCK, const.OP_LOCKT, const.OP_LOCKU, const.OP_LOOKUP, const.OP_LOOKUPP, const.OP_NVERIFY, const.OP_OPEN, const.OP_OPENATTR, const.OP_OPEN_CONFIRM, const.OP_OPEN_DOWNGRADE, const.OP_PUTFH, const.OP_PUTPUBFH, const.OP_PUTROOTFH, const.OP_READ, const.OP_READDIR, const.OP_READLINK, const.OP_REMOVE, const.OP_RENAME, const.OP_RENEW, const.OP_RESTOREFH, const.OP_SAVEFH, const.OP_SECINFO, const.OP_SETATTR, const.OP_SETCLIENTID, const.OP_SETCLIENTID_CONFIRM, const.OP_VERIFY, const.OP_WRITE, const.OP_RELEASE_LOCKOWNER, const.OP_BACKCHANNEL_CTL, const.OP_BIND_CONN_TO_SESSION, const.OP_EXCHANGE_ID, const.OP_CREATE_SESSION, const.OP_DESTROY_SESSION, const.OP_FREE_STATEID, const.OP_GET_DIR_DELEGATION, const.OP_GETDEVICEINFO, const.OP_GETDEVICELIST, const.OP_LAYOUTCOMMIT, const.OP_LAYOUTGET, const.OP_LAYOUTRETURN, const.OP_SECINFO_NO_NAME, const.OP_SEQUENCE, const.OP_SET_SSV, const.OP_TEST_STATEID, const.OP_WANT_DELEGATION, const.OP_DESTROY_CLIENTID, const.OP_RECLAIM_COMPLETE, const.OP_ILLEGAL]:
            raise XDRError, 'value=%s not in enum nfs_opnum4' % data
        self.pack_int(data)

    def pack_nfs_argop4(self, data):
        if hasattr(self, 'filter_nfs_argop4'):
            data = getattr(self, 'filter_nfs_argop4')(data)
        if data.argop is None:
            raise TypeError, 'data.argop == None'
        self.pack_nfs_opnum4(data.argop)
        if data.argop == const.OP_ACCESS:
            if data.opaccess is None:
                raise TypeError, 'data.opaccess == None'
            self.pack_ACCESS4args(data.opaccess)
        elif data.argop == const.OP_CLOSE:
            if data.opclose is None:
                raise TypeError, 'data.opclose == None'
            self.pack_CLOSE4args(data.opclose)
        elif data.argop == const.OP_COMMIT:
            if data.opcommit is None:
                raise TypeError, 'data.opcommit == None'
            self.pack_COMMIT4args(data.opcommit)
        elif data.argop == const.OP_CREATE:
            if data.opcreate is None:
                raise TypeError, 'data.opcreate == None'
            self.pack_CREATE4args(data.opcreate)
        elif data.argop == const.OP_DELEGPURGE:
            if data.opdelegpurge is None:
                raise TypeError, 'data.opdelegpurge == None'
            self.pack_DELEGPURGE4args(data.opdelegpurge)
        elif data.argop == const.OP_DELEGRETURN:
            if data.opdelegreturn is None:
                raise TypeError, 'data.opdelegreturn == None'
            self.pack_DELEGRETURN4args(data.opdelegreturn)
        elif data.argop == const.OP_GETATTR:
            if data.opgetattr is None:
                raise TypeError, 'data.opgetattr == None'
            self.pack_GETATTR4args(data.opgetattr)
        elif data.argop == const.OP_GETFH:
            pass
        elif data.argop == const.OP_LINK:
            if data.oplink is None:
                raise TypeError, 'data.oplink == None'
            self.pack_LINK4args(data.oplink)
        elif data.argop == const.OP_LOCK:
            if data.oplock is None:
                raise TypeError, 'data.oplock == None'
            self.pack_LOCK4args(data.oplock)
        elif data.argop == const.OP_LOCKT:
            if data.oplockt is None:
                raise TypeError, 'data.oplockt == None'
            self.pack_LOCKT4args(data.oplockt)
        elif data.argop == const.OP_LOCKU:
            if data.oplocku is None:
                raise TypeError, 'data.oplocku == None'
            self.pack_LOCKU4args(data.oplocku)
        elif data.argop == const.OP_LOOKUP:
            if data.oplookup is None:
                raise TypeError, 'data.oplookup == None'
            self.pack_LOOKUP4args(data.oplookup)
        elif data.argop == const.OP_LOOKUPP:
            pass
        elif data.argop == const.OP_NVERIFY:
            if data.opnverify is None:
                raise TypeError, 'data.opnverify == None'
            self.pack_NVERIFY4args(data.opnverify)
        elif data.argop == const.OP_OPEN:
            if data.opopen is None:
                raise TypeError, 'data.opopen == None'
            self.pack_OPEN4args(data.opopen)
        elif data.argop == const.OP_OPENATTR:
            if data.opopenattr is None:
                raise TypeError, 'data.opopenattr == None'
            self.pack_OPENATTR4args(data.opopenattr)
        elif data.argop == const.OP_OPEN_CONFIRM:
            if data.opopen_confirm is None:
                raise TypeError, 'data.opopen_confirm == None'
            self.pack_OPEN_CONFIRM4args(data.opopen_confirm)
        elif data.argop == const.OP_OPEN_DOWNGRADE:
            if data.opopen_downgrade is None:
                raise TypeError, 'data.opopen_downgrade == None'
            self.pack_OPEN_DOWNGRADE4args(data.opopen_downgrade)
        elif data.argop == const.OP_PUTFH:
            if data.opputfh is None:
                raise TypeError, 'data.opputfh == None'
            self.pack_PUTFH4args(data.opputfh)
        elif data.argop == const.OP_PUTPUBFH:
            pass
        elif data.argop == const.OP_PUTROOTFH:
            pass
        elif data.argop == const.OP_READ:
            if data.opread is None:
                raise TypeError, 'data.opread == None'
            self.pack_READ4args(data.opread)
        elif data.argop == const.OP_READDIR:
            if data.opreaddir is None:
                raise TypeError, 'data.opreaddir == None'
            self.pack_READDIR4args(data.opreaddir)
        elif data.argop == const.OP_READLINK:
            pass
        elif data.argop == const.OP_REMOVE:
            if data.opremove is None:
                raise TypeError, 'data.opremove == None'
            self.pack_REMOVE4args(data.opremove)
        elif data.argop == const.OP_RENAME:
            if data.oprename is None:
                raise TypeError, 'data.oprename == None'
            self.pack_RENAME4args(data.oprename)
        elif data.argop == const.OP_RENEW:
            if data.oprenew is None:
                raise TypeError, 'data.oprenew == None'
            self.pack_RENEW4args(data.oprenew)
        elif data.argop == const.OP_RESTOREFH:
            pass
        elif data.argop == const.OP_SAVEFH:
            pass
        elif data.argop == const.OP_SECINFO:
            if data.opsecinfo is None:
                raise TypeError, 'data.opsecinfo == None'
            self.pack_SECINFO4args(data.opsecinfo)
        elif data.argop == const.OP_SETATTR:
            if data.opsetattr is None:
                raise TypeError, 'data.opsetattr == None'
            self.pack_SETATTR4args(data.opsetattr)
        elif data.argop == const.OP_SETCLIENTID:
            if data.opsetclientid is None:
                raise TypeError, 'data.opsetclientid == None'
            self.pack_SETCLIENTID4args(data.opsetclientid)
        elif data.argop == const.OP_SETCLIENTID_CONFIRM:
            if data.opsetclientid_confirm is None:
                raise TypeError, 'data.opsetclientid_confirm == None'
            self.pack_SETCLIENTID_CONFIRM4args(data.opsetclientid_confirm)
        elif data.argop == const.OP_VERIFY:
            if data.opverify is None:
                raise TypeError, 'data.opverify == None'
            self.pack_VERIFY4args(data.opverify)
        elif data.argop == const.OP_WRITE:
            if data.opwrite is None:
                raise TypeError, 'data.opwrite == None'
            self.pack_WRITE4args(data.opwrite)
        elif data.argop == const.OP_RELEASE_LOCKOWNER:
            if data.oprelease_lockowner is None:
                raise TypeError, 'data.oprelease_lockowner == None'
            self.pack_RELEASE_LOCKOWNER4args(data.oprelease_lockowner)
        elif data.argop == const.OP_BACKCHANNEL_CTL:
            if data.opbackchannel_ctl is None:
                raise TypeError, 'data.opbackchannel_ctl == None'
            self.pack_BACKCHANNEL_CTL4args(data.opbackchannel_ctl)
        elif data.argop == const.OP_BIND_CONN_TO_SESSION:
            if data.opbind_conn_to_session is None:
                raise TypeError, 'data.opbind_conn_to_session == None'
            self.pack_BIND_CONN_TO_SESSION4args(data.opbind_conn_to_session)
        elif data.argop == const.OP_EXCHANGE_ID:
            if data.opexchange_id is None:
                raise TypeError, 'data.opexchange_id == None'
            self.pack_EXCHANGE_ID4args(data.opexchange_id)
        elif data.argop == const.OP_CREATE_SESSION:
            if data.opcreate_session is None:
                raise TypeError, 'data.opcreate_session == None'
            self.pack_CREATE_SESSION4args(data.opcreate_session)
        elif data.argop == const.OP_DESTROY_SESSION:
            if data.opdestroy_session is None:
                raise TypeError, 'data.opdestroy_session == None'
            self.pack_DESTROY_SESSION4args(data.opdestroy_session)
        elif data.argop == const.OP_FREE_STATEID:
            if data.opfree_stateid is None:
                raise TypeError, 'data.opfree_stateid == None'
            self.pack_FREE_STATEID4args(data.opfree_stateid)
        elif data.argop == const.OP_GET_DIR_DELEGATION:
            if data.opget_dir_delegation is None:
                raise TypeError, 'data.opget_dir_delegation == None'
            self.pack_GET_DIR_DELEGATION4args(data.opget_dir_delegation)
        elif data.argop == const.OP_GETDEVICEINFO:
            if data.opgetdeviceinfo is None:
                raise TypeError, 'data.opgetdeviceinfo == None'
            self.pack_GETDEVICEINFO4args(data.opgetdeviceinfo)
        elif data.argop == const.OP_GETDEVICELIST:
            if data.opgetdevicelist is None:
                raise TypeError, 'data.opgetdevicelist == None'
            self.pack_GETDEVICELIST4args(data.opgetdevicelist)
        elif data.argop == const.OP_LAYOUTCOMMIT:
            if data.oplayoutcommit is None:
                raise TypeError, 'data.oplayoutcommit == None'
            self.pack_LAYOUTCOMMIT4args(data.oplayoutcommit)
        elif data.argop == const.OP_LAYOUTGET:
            if data.oplayoutget is None:
                raise TypeError, 'data.oplayoutget == None'
            self.pack_LAYOUTGET4args(data.oplayoutget)
        elif data.argop == const.OP_LAYOUTRETURN:
            if data.oplayoutreturn is None:
                raise TypeError, 'data.oplayoutreturn == None'
            self.pack_LAYOUTRETURN4args(data.oplayoutreturn)
        elif data.argop == const.OP_SECINFO_NO_NAME:
            if data.opsecinfo_no_name is None:
                raise TypeError, 'data.opsecinfo_no_name == None'
            self.pack_SECINFO_NO_NAME4args(data.opsecinfo_no_name)
        elif data.argop == const.OP_SEQUENCE:
            if data.opsequence is None:
                raise TypeError, 'data.opsequence == None'
            self.pack_SEQUENCE4args(data.opsequence)
        elif data.argop == const.OP_SET_SSV:
            if data.opset_ssv is None:
                raise TypeError, 'data.opset_ssv == None'
            self.pack_SET_SSV4args(data.opset_ssv)
        elif data.argop == const.OP_TEST_STATEID:
            if data.optest_stateid is None:
                raise TypeError, 'data.optest_stateid == None'
            self.pack_TEST_STATEID4args(data.optest_stateid)
        elif data.argop == const.OP_WANT_DELEGATION:
            if data.opwant_delegation is None:
                raise TypeError, 'data.opwant_delegation == None'
            self.pack_WANT_DELEGATION4args(data.opwant_delegation)
        elif data.argop == const.OP_DESTROY_CLIENTID:
            if data.opdestroy_clientid is None:
                raise TypeError, 'data.opdestroy_clientid == None'
            self.pack_DESTROY_CLIENTID4args(data.opdestroy_clientid)
        elif data.argop == const.OP_RECLAIM_COMPLETE:
            if data.opreclaim_complete is None:
                raise TypeError, 'data.opreclaim_complete == None'
            self.pack_RECLAIM_COMPLETE4args(data.opreclaim_complete)
        elif data.argop == const.OP_ILLEGAL:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.argop

    def pack_nfs_resop4(self, data):
        if hasattr(self, 'filter_nfs_resop4'):
            data = getattr(self, 'filter_nfs_resop4')(data)
        if data.resop is None:
            raise TypeError, 'data.resop == None'
        self.pack_nfs_opnum4(data.resop)
        if data.resop == const.OP_ACCESS:
            if data.opaccess is None:
                raise TypeError, 'data.opaccess == None'
            self.pack_ACCESS4res(data.opaccess)
        elif data.resop == const.OP_CLOSE:
            if data.opclose is None:
                raise TypeError, 'data.opclose == None'
            self.pack_CLOSE4res(data.opclose)
        elif data.resop == const.OP_COMMIT:
            if data.opcommit is None:
                raise TypeError, 'data.opcommit == None'
            self.pack_COMMIT4res(data.opcommit)
        elif data.resop == const.OP_CREATE:
            if data.opcreate is None:
                raise TypeError, 'data.opcreate == None'
            self.pack_CREATE4res(data.opcreate)
        elif data.resop == const.OP_DELEGPURGE:
            if data.opdelegpurge is None:
                raise TypeError, 'data.opdelegpurge == None'
            self.pack_DELEGPURGE4res(data.opdelegpurge)
        elif data.resop == const.OP_DELEGRETURN:
            if data.opdelegreturn is None:
                raise TypeError, 'data.opdelegreturn == None'
            self.pack_DELEGRETURN4res(data.opdelegreturn)
        elif data.resop == const.OP_GETATTR:
            if data.opgetattr is None:
                raise TypeError, 'data.opgetattr == None'
            self.pack_GETATTR4res(data.opgetattr)
        elif data.resop == const.OP_GETFH:
            if data.opgetfh is None:
                raise TypeError, 'data.opgetfh == None'
            self.pack_GETFH4res(data.opgetfh)
        elif data.resop == const.OP_LINK:
            if data.oplink is None:
                raise TypeError, 'data.oplink == None'
            self.pack_LINK4res(data.oplink)
        elif data.resop == const.OP_LOCK:
            if data.oplock is None:
                raise TypeError, 'data.oplock == None'
            self.pack_LOCK4res(data.oplock)
        elif data.resop == const.OP_LOCKT:
            if data.oplockt is None:
                raise TypeError, 'data.oplockt == None'
            self.pack_LOCKT4res(data.oplockt)
        elif data.resop == const.OP_LOCKU:
            if data.oplocku is None:
                raise TypeError, 'data.oplocku == None'
            self.pack_LOCKU4res(data.oplocku)
        elif data.resop == const.OP_LOOKUP:
            if data.oplookup is None:
                raise TypeError, 'data.oplookup == None'
            self.pack_LOOKUP4res(data.oplookup)
        elif data.resop == const.OP_LOOKUPP:
            if data.oplookupp is None:
                raise TypeError, 'data.oplookupp == None'
            self.pack_LOOKUPP4res(data.oplookupp)
        elif data.resop == const.OP_NVERIFY:
            if data.opnverify is None:
                raise TypeError, 'data.opnverify == None'
            self.pack_NVERIFY4res(data.opnverify)
        elif data.resop == const.OP_OPEN:
            if data.opopen is None:
                raise TypeError, 'data.opopen == None'
            self.pack_OPEN4res(data.opopen)
        elif data.resop == const.OP_OPENATTR:
            if data.opopenattr is None:
                raise TypeError, 'data.opopenattr == None'
            self.pack_OPENATTR4res(data.opopenattr)
        elif data.resop == const.OP_OPEN_CONFIRM:
            if data.opopen_confirm is None:
                raise TypeError, 'data.opopen_confirm == None'
            self.pack_OPEN_CONFIRM4res(data.opopen_confirm)
        elif data.resop == const.OP_OPEN_DOWNGRADE:
            if data.opopen_downgrade is None:
                raise TypeError, 'data.opopen_downgrade == None'
            self.pack_OPEN_DOWNGRADE4res(data.opopen_downgrade)
        elif data.resop == const.OP_PUTFH:
            if data.opputfh is None:
                raise TypeError, 'data.opputfh == None'
            self.pack_PUTFH4res(data.opputfh)
        elif data.resop == const.OP_PUTPUBFH:
            if data.opputpubfh is None:
                raise TypeError, 'data.opputpubfh == None'
            self.pack_PUTPUBFH4res(data.opputpubfh)
        elif data.resop == const.OP_PUTROOTFH:
            if data.opputrootfh is None:
                raise TypeError, 'data.opputrootfh == None'
            self.pack_PUTROOTFH4res(data.opputrootfh)
        elif data.resop == const.OP_READ:
            if data.opread is None:
                raise TypeError, 'data.opread == None'
            self.pack_READ4res(data.opread)
        elif data.resop == const.OP_READDIR:
            if data.opreaddir is None:
                raise TypeError, 'data.opreaddir == None'
            self.pack_READDIR4res(data.opreaddir)
        elif data.resop == const.OP_READLINK:
            if data.opreadlink is None:
                raise TypeError, 'data.opreadlink == None'
            self.pack_READLINK4res(data.opreadlink)
        elif data.resop == const.OP_REMOVE:
            if data.opremove is None:
                raise TypeError, 'data.opremove == None'
            self.pack_REMOVE4res(data.opremove)
        elif data.resop == const.OP_RENAME:
            if data.oprename is None:
                raise TypeError, 'data.oprename == None'
            self.pack_RENAME4res(data.oprename)
        elif data.resop == const.OP_RENEW:
            if data.oprenew is None:
                raise TypeError, 'data.oprenew == None'
            self.pack_RENEW4res(data.oprenew)
        elif data.resop == const.OP_RESTOREFH:
            if data.oprestorefh is None:
                raise TypeError, 'data.oprestorefh == None'
            self.pack_RESTOREFH4res(data.oprestorefh)
        elif data.resop == const.OP_SAVEFH:
            if data.opsavefh is None:
                raise TypeError, 'data.opsavefh == None'
            self.pack_SAVEFH4res(data.opsavefh)
        elif data.resop == const.OP_SECINFO:
            if data.opsecinfo is None:
                raise TypeError, 'data.opsecinfo == None'
            self.pack_SECINFO4res(data.opsecinfo)
        elif data.resop == const.OP_SETATTR:
            if data.opsetattr is None:
                raise TypeError, 'data.opsetattr == None'
            self.pack_SETATTR4res(data.opsetattr)
        elif data.resop == const.OP_SETCLIENTID:
            if data.opsetclientid is None:
                raise TypeError, 'data.opsetclientid == None'
            self.pack_SETCLIENTID4res(data.opsetclientid)
        elif data.resop == const.OP_SETCLIENTID_CONFIRM:
            if data.opsetclientid_confirm is None:
                raise TypeError, 'data.opsetclientid_confirm == None'
            self.pack_SETCLIENTID_CONFIRM4res(data.opsetclientid_confirm)
        elif data.resop == const.OP_VERIFY:
            if data.opverify is None:
                raise TypeError, 'data.opverify == None'
            self.pack_VERIFY4res(data.opverify)
        elif data.resop == const.OP_WRITE:
            if data.opwrite is None:
                raise TypeError, 'data.opwrite == None'
            self.pack_WRITE4res(data.opwrite)
        elif data.resop == const.OP_RELEASE_LOCKOWNER:
            if data.oprelease_lockowner is None:
                raise TypeError, 'data.oprelease_lockowner == None'
            self.pack_RELEASE_LOCKOWNER4res(data.oprelease_lockowner)
        elif data.resop == const.OP_BACKCHANNEL_CTL:
            if data.opbackchannel_ctl is None:
                raise TypeError, 'data.opbackchannel_ctl == None'
            self.pack_BACKCHANNEL_CTL4res(data.opbackchannel_ctl)
        elif data.resop == const.OP_BIND_CONN_TO_SESSION:
            if data.opbind_conn_to_session is None:
                raise TypeError, 'data.opbind_conn_to_session == None'
            self.pack_BIND_CONN_TO_SESSION4res(data.opbind_conn_to_session)
        elif data.resop == const.OP_EXCHANGE_ID:
            if data.opexchange_id is None:
                raise TypeError, 'data.opexchange_id == None'
            self.pack_EXCHANGE_ID4res(data.opexchange_id)
        elif data.resop == const.OP_CREATE_SESSION:
            if data.opcreate_session is None:
                raise TypeError, 'data.opcreate_session == None'
            self.pack_CREATE_SESSION4res(data.opcreate_session)
        elif data.resop == const.OP_DESTROY_SESSION:
            if data.opdestroy_session is None:
                raise TypeError, 'data.opdestroy_session == None'
            self.pack_DESTROY_SESSION4res(data.opdestroy_session)
        elif data.resop == const.OP_FREE_STATEID:
            if data.opfree_stateid is None:
                raise TypeError, 'data.opfree_stateid == None'
            self.pack_FREE_STATEID4res(data.opfree_stateid)
        elif data.resop == const.OP_GET_DIR_DELEGATION:
            if data.opget_dir_delegation is None:
                raise TypeError, 'data.opget_dir_delegation == None'
            self.pack_GET_DIR_DELEGATION4res(data.opget_dir_delegation)
        elif data.resop == const.OP_GETDEVICEINFO:
            if data.opgetdeviceinfo is None:
                raise TypeError, 'data.opgetdeviceinfo == None'
            self.pack_GETDEVICEINFO4res(data.opgetdeviceinfo)
        elif data.resop == const.OP_GETDEVICELIST:
            if data.opgetdevicelist is None:
                raise TypeError, 'data.opgetdevicelist == None'
            self.pack_GETDEVICELIST4res(data.opgetdevicelist)
        elif data.resop == const.OP_LAYOUTCOMMIT:
            if data.oplayoutcommit is None:
                raise TypeError, 'data.oplayoutcommit == None'
            self.pack_LAYOUTCOMMIT4res(data.oplayoutcommit)
        elif data.resop == const.OP_LAYOUTGET:
            if data.oplayoutget is None:
                raise TypeError, 'data.oplayoutget == None'
            self.pack_LAYOUTGET4res(data.oplayoutget)
        elif data.resop == const.OP_LAYOUTRETURN:
            if data.oplayoutreturn is None:
                raise TypeError, 'data.oplayoutreturn == None'
            self.pack_LAYOUTRETURN4res(data.oplayoutreturn)
        elif data.resop == const.OP_SECINFO_NO_NAME:
            if data.opsecinfo_no_name is None:
                raise TypeError, 'data.opsecinfo_no_name == None'
            self.pack_SECINFO_NO_NAME4res(data.opsecinfo_no_name)
        elif data.resop == const.OP_SEQUENCE:
            if data.opsequence is None:
                raise TypeError, 'data.opsequence == None'
            self.pack_SEQUENCE4res(data.opsequence)
        elif data.resop == const.OP_SET_SSV:
            if data.opset_ssv is None:
                raise TypeError, 'data.opset_ssv == None'
            self.pack_SET_SSV4res(data.opset_ssv)
        elif data.resop == const.OP_TEST_STATEID:
            if data.optest_stateid is None:
                raise TypeError, 'data.optest_stateid == None'
            self.pack_TEST_STATEID4res(data.optest_stateid)
        elif data.resop == const.OP_WANT_DELEGATION:
            if data.opwant_delegation is None:
                raise TypeError, 'data.opwant_delegation == None'
            self.pack_WANT_DELEGATION4res(data.opwant_delegation)
        elif data.resop == const.OP_DESTROY_CLIENTID:
            if data.opdestroy_clientid is None:
                raise TypeError, 'data.opdestroy_clientid == None'
            self.pack_DESTROY_CLIENTID4res(data.opdestroy_clientid)
        elif data.resop == const.OP_RECLAIM_COMPLETE:
            if data.opreclaim_complete is None:
                raise TypeError, 'data.opreclaim_complete == None'
            self.pack_RECLAIM_COMPLETE4res(data.opreclaim_complete)
        elif data.resop == const.OP_ILLEGAL:
            if data.opillegal is None:
                raise TypeError, 'data.opillegal == None'
            self.pack_ILLEGAL4res(data.opillegal)
        else:
            raise XDRError, 'bad switch=%s' % data.resop

    def pack_COMPOUND4args(self, data):
        if hasattr(self, 'filter_COMPOUND4args'):
            data = getattr(self, 'filter_COMPOUND4args')(data)
        if data.tag is None:
            raise TypeError, 'data.tag == None'
        self.pack_utf8str_cs(data.tag)
        if data.minorversion is None:
            raise TypeError, 'data.minorversion == None'
        self.pack_uint32_t(data.minorversion)
        if data.argarray is None:
            raise TypeError, 'data.argarray == None'
        self.pack_array(data.argarray, self.pack_nfs_argop4)

    def pack_COMPOUND4res(self, data):
        if hasattr(self, 'filter_COMPOUND4res'):
            data = getattr(self, 'filter_COMPOUND4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.tag is None:
            raise TypeError, 'data.tag == None'
        self.pack_utf8str_cs(data.tag)
        if data.resarray is None:
            raise TypeError, 'data.resarray == None'
        self.pack_array(data.resarray, self.pack_nfs_resop4)

    def pack_CB_GETATTR4args(self, data):
        if hasattr(self, 'filter_CB_GETATTR4args'):
            data = getattr(self, 'filter_CB_GETATTR4args')(data)
        if data.fh is None:
            raise TypeError, 'data.fh == None'
        self.pack_nfs_fh4(data.fh)
        if data.attr_request is None:
            raise TypeError, 'data.attr_request == None'
        self.pack_bitmap4(data.attr_request)

    def pack_CB_GETATTR4resok(self, data):
        if hasattr(self, 'filter_CB_GETATTR4resok'):
            data = getattr(self, 'filter_CB_GETATTR4resok')(data)
        if data.obj_attributes is None:
            raise TypeError, 'data.obj_attributes == None'
        self.pack_fattr4(data.obj_attributes)

    def pack_CB_GETATTR4res(self, data):
        if hasattr(self, 'filter_CB_GETATTR4res'):
            data = getattr(self, 'filter_CB_GETATTR4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.status == const.NFS4_OK:
            if data.resok4 is None:
                raise TypeError, 'data.resok4 == None'
            self.pack_CB_GETATTR4resok(data.resok4)
        else:
            pass

    def pack_CB_RECALL4args(self, data):
        if hasattr(self, 'filter_CB_RECALL4args'):
            data = getattr(self, 'filter_CB_RECALL4args')(data)
        if data.stateid is None:
            raise TypeError, 'data.stateid == None'
        self.pack_stateid4(data.stateid)
        if data.truncate is None:
            raise TypeError, 'data.truncate == None'
        self.pack_bool(data.truncate)
        if data.fh is None:
            raise TypeError, 'data.fh == None'
        self.pack_nfs_fh4(data.fh)

    def pack_CB_RECALL4res(self, data):
        if hasattr(self, 'filter_CB_RECALL4res'):
            data = getattr(self, 'filter_CB_RECALL4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_CB_ILLEGAL4res(self, data):
        if hasattr(self, 'filter_CB_ILLEGAL4res'):
            data = getattr(self, 'filter_CB_ILLEGAL4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)

    def pack_layoutrecall_type4(self, data):
        if hasattr(self, 'filter_layoutrecall_type4'):
            data = getattr(self, 'filter_layoutrecall_type4')(data)
        if self.check_enum and data not in [const.LAYOUTRECALL4_FILE, const.LAYOUTRECALL4_FSID, const.LAYOUTRECALL4_ALL]:
            raise XDRError, 'value=%s not in enum layoutrecall_type4' % data
        self.pack_int(data)

    def pack_layoutrecall_file4(self, data):
        if hasattr(self, 'filter_layoutrecall_file4'):
            data = getattr(self, 'filter_layoutrecall_file4')(data)
        if data.lor_fh is None:
            raise TypeError, 'data.lor_fh == None'
        self.pack_nfs_fh4(data.lor_fh)
        if data.lor_offset is None:
            raise TypeError, 'data.lor_offset == None'
        self.pack_offset4(data.lor_offset)
        if data.lor_length is None:
            raise TypeError, 'data.lor_length == None'
        self.pack_length4(data.lor_length)
        if data.lor_stateid is None:
            raise TypeError, 'data.lor_stateid == None'
        self.pack_stateid4(data.lor_stateid)

    def pack_layoutrecall4(self, data):
        if hasattr(self, 'filter_layoutrecall4'):
            data = getattr(self, 'filter_layoutrecall4')(data)
        if data.lor_recalltype is None:
            raise TypeError, 'data.lor_recalltype == None'
        self.pack_layoutrecall_type4(data.lor_recalltype)
        if data.lor_recalltype == const.LAYOUTRECALL4_FILE:
            if data.lor_layout is None:
                raise TypeError, 'data.lor_layout == None'
            self.pack_layoutrecall_file4(data.lor_layout)
        elif data.lor_recalltype == const.LAYOUTRECALL4_FSID:
            if data.lor_fsid is None:
                raise TypeError, 'data.lor_fsid == None'
            self.pack_fsid4(data.lor_fsid)
        elif data.lor_recalltype == const.LAYOUTRECALL4_ALL:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.lor_recalltype

    def pack_CB_LAYOUTRECALL4args(self, data):
        if hasattr(self, 'filter_CB_LAYOUTRECALL4args'):
            data = getattr(self, 'filter_CB_LAYOUTRECALL4args')(data)
        if data.clora_type is None:
            raise TypeError, 'data.clora_type == None'
        self.pack_layouttype4(data.clora_type)
        if data.clora_iomode is None:
            raise TypeError, 'data.clora_iomode == None'
        self.pack_layoutiomode4(data.clora_iomode)
        if data.clora_changed is None:
            raise TypeError, 'data.clora_changed == None'
        self.pack_bool(data.clora_changed)
        if data.clora_recall is None:
            raise TypeError, 'data.clora_recall == None'
        self.pack_layoutrecall4(data.clora_recall)

    def pack_CB_LAYOUTRECALL4res(self, data):
        if hasattr(self, 'filter_CB_LAYOUTRECALL4res'):
            data = getattr(self, 'filter_CB_LAYOUTRECALL4res')(data)
        if data.clorr_status is None:
            raise TypeError, 'data.clorr_status == None'
        self.pack_nfsstat4(data.clorr_status)

    def pack_notify_type4(self, data):
        if hasattr(self, 'filter_notify_type4'):
            data = getattr(self, 'filter_notify_type4')(data)
        if self.check_enum and data not in [const.NOTIFY4_CHANGE_CHILD_ATTRS, const.NOTIFY4_CHANGE_DIR_ATTRS, const.NOTIFY4_REMOVE_ENTRY, const.NOTIFY4_ADD_ENTRY, const.NOTIFY4_RENAME_ENTRY, const.NOTIFY4_CHANGE_COOKIE_VERIFIER]:
            raise XDRError, 'value=%s not in enum notify_type4' % data
        self.pack_int(data)

    def pack_notify_entry4(self, data):
        if hasattr(self, 'filter_notify_entry4'):
            data = getattr(self, 'filter_notify_entry4')(data)
        if data.ne_file is None:
            raise TypeError, 'data.ne_file == None'
        self.pack_component4(data.ne_file)
        if data.ne_attrs is None:
            raise TypeError, 'data.ne_attrs == None'
        self.pack_fattr4(data.ne_attrs)

    def pack_prev_entry4(self, data):
        if hasattr(self, 'filter_prev_entry4'):
            data = getattr(self, 'filter_prev_entry4')(data)
        if data.pe_prev_entry is None:
            raise TypeError, 'data.pe_prev_entry == None'
        self.pack_notify_entry4(data.pe_prev_entry)
        if data.pe_prev_entry_cookie is None:
            raise TypeError, 'data.pe_prev_entry_cookie == None'
        self.pack_nfs_cookie4(data.pe_prev_entry_cookie)

    def pack_notify_remove4(self, data):
        if hasattr(self, 'filter_notify_remove4'):
            data = getattr(self, 'filter_notify_remove4')(data)
        if data.nrm_old_entry is None:
            raise TypeError, 'data.nrm_old_entry == None'
        self.pack_notify_entry4(data.nrm_old_entry)
        if data.nrm_old_entry_cookie is None:
            raise TypeError, 'data.nrm_old_entry_cookie == None'
        self.pack_nfs_cookie4(data.nrm_old_entry_cookie)

    def pack_notify_add4(self, data):
        if hasattr(self, 'filter_notify_add4'):
            data = getattr(self, 'filter_notify_add4')(data)
        if data.nad_old_entry is None:
            raise TypeError, 'data.nad_old_entry == None'
        if len(data.nad_old_entry) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nad_old_entry'
        self.pack_array(data.nad_old_entry, self.pack_notify_remove4)
        if data.nad_new_entry is None:
            raise TypeError, 'data.nad_new_entry == None'
        self.pack_notify_entry4(data.nad_new_entry)
        if data.nad_new_entry_cookie is None:
            raise TypeError, 'data.nad_new_entry_cookie == None'
        if len(data.nad_new_entry_cookie) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nad_new_entry_cookie'
        self.pack_array(data.nad_new_entry_cookie, self.pack_nfs_cookie4)
        if data.nad_prev_entry is None:
            raise TypeError, 'data.nad_prev_entry == None'
        if len(data.nad_prev_entry) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nad_prev_entry'
        self.pack_array(data.nad_prev_entry, self.pack_prev_entry4)
        if data.nad_last_entry is None:
            raise TypeError, 'data.nad_last_entry == None'
        self.pack_bool(data.nad_last_entry)

    def pack_notify_attr4(self, data):
        if hasattr(self, 'filter_notify_attr4'):
            data = getattr(self, 'filter_notify_attr4')(data)
        if data.na_changed_entry is None:
            raise TypeError, 'data.na_changed_entry == None'
        self.pack_notify_entry4(data.na_changed_entry)

    def pack_notify_rename4(self, data):
        if hasattr(self, 'filter_notify_rename4'):
            data = getattr(self, 'filter_notify_rename4')(data)
        if data.nrn_old_entry is None:
            raise TypeError, 'data.nrn_old_entry == None'
        self.pack_notify_remove4(data.nrn_old_entry)
        if data.nrn_new_entry is None:
            raise TypeError, 'data.nrn_new_entry == None'
        self.pack_notify_add4(data.nrn_new_entry)

    def pack_notify_verifier4(self, data):
        if hasattr(self, 'filter_notify_verifier4'):
            data = getattr(self, 'filter_notify_verifier4')(data)
        if data.nv_old_cookieverf is None:
            raise TypeError, 'data.nv_old_cookieverf == None'
        self.pack_verifier4(data.nv_old_cookieverf)
        if data.nv_new_cookieverf is None:
            raise TypeError, 'data.nv_new_cookieverf == None'
        self.pack_verifier4(data.nv_new_cookieverf)

    def pack_notifylist4(self, data):
        if hasattr(self, 'filter_notifylist4'):
            data = getattr(self, 'filter_notifylist4')(data)
        self.pack_opaque(data)

    def pack_notify4(self, data):
        if hasattr(self, 'filter_notify4'):
            data = getattr(self, 'filter_notify4')(data)
        if data.notify_mask is None:
            raise TypeError, 'data.notify_mask == None'
        self.pack_bitmap4(data.notify_mask)
        if data.notify_vals is None:
            raise TypeError, 'data.notify_vals == None'
        self.pack_notifylist4(data.notify_vals)

    def pack_CB_NOTIFY4args(self, data):
        if hasattr(self, 'filter_CB_NOTIFY4args'):
            data = getattr(self, 'filter_CB_NOTIFY4args')(data)
        if data.cna_stateid is None:
            raise TypeError, 'data.cna_stateid == None'
        self.pack_stateid4(data.cna_stateid)
        if data.cna_fh is None:
            raise TypeError, 'data.cna_fh == None'
        self.pack_nfs_fh4(data.cna_fh)
        if data.cna_changes is None:
            raise TypeError, 'data.cna_changes == None'
        self.pack_array(data.cna_changes, self.pack_notify4)

    def pack_CB_NOTIFY4res(self, data):
        if hasattr(self, 'filter_CB_NOTIFY4res'):
            data = getattr(self, 'filter_CB_NOTIFY4res')(data)
        if data.cnr_status is None:
            raise TypeError, 'data.cnr_status == None'
        self.pack_nfsstat4(data.cnr_status)

    def pack_CB_PUSH_DELEG4args(self, data):
        if hasattr(self, 'filter_CB_PUSH_DELEG4args'):
            data = getattr(self, 'filter_CB_PUSH_DELEG4args')(data)
        if data.cpda_fh is None:
            raise TypeError, 'data.cpda_fh == None'
        self.pack_nfs_fh4(data.cpda_fh)
        if data.cpda_delegation is None:
            raise TypeError, 'data.cpda_delegation == None'
        self.pack_open_delegation4(data.cpda_delegation)

    def pack_CB_PUSH_DELEG4res(self, data):
        if hasattr(self, 'filter_CB_PUSH_DELEG4res'):
            data = getattr(self, 'filter_CB_PUSH_DELEG4res')(data)
        if data.cpdr_status is None:
            raise TypeError, 'data.cpdr_status == None'
        self.pack_nfsstat4(data.cpdr_status)

    def pack_CB_RECALL_ANY4args(self, data):
        if hasattr(self, 'filter_CB_RECALL_ANY4args'):
            data = getattr(self, 'filter_CB_RECALL_ANY4args')(data)
        if data.craa_objects_to_keep is None:
            raise TypeError, 'data.craa_objects_to_keep == None'
        self.pack_uint32_t(data.craa_objects_to_keep)
        if data.craa_type_mask is None:
            raise TypeError, 'data.craa_type_mask == None'
        self.pack_bitmap4(data.craa_type_mask)

    def pack_CB_RECALL_ANY4res(self, data):
        if hasattr(self, 'filter_CB_RECALL_ANY4res'):
            data = getattr(self, 'filter_CB_RECALL_ANY4res')(data)
        if data.crar_status is None:
            raise TypeError, 'data.crar_status == None'
        self.pack_nfsstat4(data.crar_status)

    pack_CB_RECALLABLE_OBJ_AVAIL4args = pack_CB_RECALL_ANY4args

    def pack_CB_RECALLABLE_OBJ_AVAIL4res(self, data):
        if hasattr(self, 'filter_CB_RECALLABLE_OBJ_AVAIL4res'):
            data = getattr(self, 'filter_CB_RECALLABLE_OBJ_AVAIL4res')(data)
        if data.croa_status is None:
            raise TypeError, 'data.croa_status == None'
        self.pack_nfsstat4(data.croa_status)

    def pack_CB_RECALL_SLOT4args(self, data):
        if hasattr(self, 'filter_CB_RECALL_SLOT4args'):
            data = getattr(self, 'filter_CB_RECALL_SLOT4args')(data)
        if data.rsa_target_highest_slotid is None:
            raise TypeError, 'data.rsa_target_highest_slotid == None'
        self.pack_slotid4(data.rsa_target_highest_slotid)

    def pack_CB_RECALL_SLOT4res(self, data):
        if hasattr(self, 'filter_CB_RECALL_SLOT4res'):
            data = getattr(self, 'filter_CB_RECALL_SLOT4res')(data)
        if data.rsr_status is None:
            raise TypeError, 'data.rsr_status == None'
        self.pack_nfsstat4(data.rsr_status)

    def pack_referring_call4(self, data):
        if hasattr(self, 'filter_referring_call4'):
            data = getattr(self, 'filter_referring_call4')(data)
        if data.rc_sequenceid is None:
            raise TypeError, 'data.rc_sequenceid == None'
        self.pack_sequenceid4(data.rc_sequenceid)
        if data.rc_slotid is None:
            raise TypeError, 'data.rc_slotid == None'
        self.pack_slotid4(data.rc_slotid)

    def pack_referring_call_list4(self, data):
        if hasattr(self, 'filter_referring_call_list4'):
            data = getattr(self, 'filter_referring_call_list4')(data)
        if data.rcl_sessionid is None:
            raise TypeError, 'data.rcl_sessionid == None'
        self.pack_sessionid4(data.rcl_sessionid)
        if data.rcl_referring_calls is None:
            raise TypeError, 'data.rcl_referring_calls == None'
        self.pack_array(data.rcl_referring_calls, self.pack_referring_call4)

    def pack_CB_SEQUENCE4args(self, data):
        if hasattr(self, 'filter_CB_SEQUENCE4args'):
            data = getattr(self, 'filter_CB_SEQUENCE4args')(data)
        if data.csa_sessionid is None:
            raise TypeError, 'data.csa_sessionid == None'
        self.pack_sessionid4(data.csa_sessionid)
        if data.csa_sequenceid is None:
            raise TypeError, 'data.csa_sequenceid == None'
        self.pack_sequenceid4(data.csa_sequenceid)
        if data.csa_slotid is None:
            raise TypeError, 'data.csa_slotid == None'
        self.pack_slotid4(data.csa_slotid)
        if data.csa_highest_slotid is None:
            raise TypeError, 'data.csa_highest_slotid == None'
        self.pack_slotid4(data.csa_highest_slotid)
        if data.csa_cachethis is None:
            raise TypeError, 'data.csa_cachethis == None'
        self.pack_bool(data.csa_cachethis)
        if data.csa_referring_call_lists is None:
            raise TypeError, 'data.csa_referring_call_lists == None'
        self.pack_array(data.csa_referring_call_lists, self.pack_referring_call_list4)

    def pack_CB_SEQUENCE4resok(self, data):
        if hasattr(self, 'filter_CB_SEQUENCE4resok'):
            data = getattr(self, 'filter_CB_SEQUENCE4resok')(data)
        if data.csr_sessionid is None:
            raise TypeError, 'data.csr_sessionid == None'
        self.pack_sessionid4(data.csr_sessionid)
        if data.csr_sequenceid is None:
            raise TypeError, 'data.csr_sequenceid == None'
        self.pack_sequenceid4(data.csr_sequenceid)
        if data.csr_slotid is None:
            raise TypeError, 'data.csr_slotid == None'
        self.pack_slotid4(data.csr_slotid)
        if data.csr_highest_slotid is None:
            raise TypeError, 'data.csr_highest_slotid == None'
        self.pack_slotid4(data.csr_highest_slotid)
        if data.csr_target_highest_slotid is None:
            raise TypeError, 'data.csr_target_highest_slotid == None'
        self.pack_slotid4(data.csr_target_highest_slotid)

    def pack_CB_SEQUENCE4res(self, data):
        if hasattr(self, 'filter_CB_SEQUENCE4res'):
            data = getattr(self, 'filter_CB_SEQUENCE4res')(data)
        if data.csr_status is None:
            raise TypeError, 'data.csr_status == None'
        self.pack_nfsstat4(data.csr_status)
        if data.csr_status == const.NFS4_OK:
            if data.csr_resok4 is None:
                raise TypeError, 'data.csr_resok4 == None'
            self.pack_CB_SEQUENCE4resok(data.csr_resok4)
        else:
            pass

    def pack_CB_WANTS_CANCELLED4args(self, data):
        if hasattr(self, 'filter_CB_WANTS_CANCELLED4args'):
            data = getattr(self, 'filter_CB_WANTS_CANCELLED4args')(data)
        if data.cwca_contended_wants_cancelled is None:
            raise TypeError, 'data.cwca_contended_wants_cancelled == None'
        self.pack_bool(data.cwca_contended_wants_cancelled)
        if data.cwca_resourced_wants_cancelled is None:
            raise TypeError, 'data.cwca_resourced_wants_cancelled == None'
        self.pack_bool(data.cwca_resourced_wants_cancelled)

    def pack_CB_WANTS_CANCELLED4res(self, data):
        if hasattr(self, 'filter_CB_WANTS_CANCELLED4res'):
            data = getattr(self, 'filter_CB_WANTS_CANCELLED4res')(data)
        if data.cwcr_status is None:
            raise TypeError, 'data.cwcr_status == None'
        self.pack_nfsstat4(data.cwcr_status)

    def pack_CB_NOTIFY_LOCK4args(self, data):
        if hasattr(self, 'filter_CB_NOTIFY_LOCK4args'):
            data = getattr(self, 'filter_CB_NOTIFY_LOCK4args')(data)
        if data.cnla_fh is None:
            raise TypeError, 'data.cnla_fh == None'
        self.pack_nfs_fh4(data.cnla_fh)
        if data.cnla_lock_owner is None:
            raise TypeError, 'data.cnla_lock_owner == None'
        self.pack_lock_owner4(data.cnla_lock_owner)

    def pack_CB_NOTIFY_LOCK4res(self, data):
        if hasattr(self, 'filter_CB_NOTIFY_LOCK4res'):
            data = getattr(self, 'filter_CB_NOTIFY_LOCK4res')(data)
        if data.cnlr_status is None:
            raise TypeError, 'data.cnlr_status == None'
        self.pack_nfsstat4(data.cnlr_status)

    def pack_notify_deviceid_type4(self, data):
        if hasattr(self, 'filter_notify_deviceid_type4'):
            data = getattr(self, 'filter_notify_deviceid_type4')(data)
        if self.check_enum and data not in [const.NOTIFY_DEVICEID4_CHANGE, const.NOTIFY_DEVICEID4_DELETE]:
            raise XDRError, 'value=%s not in enum notify_deviceid_type4' % data
        self.pack_int(data)

    def pack_notify_deviceid_delete4(self, data):
        if hasattr(self, 'filter_notify_deviceid_delete4'):
            data = getattr(self, 'filter_notify_deviceid_delete4')(data)
        if data.ndd_layouttype is None:
            raise TypeError, 'data.ndd_layouttype == None'
        self.pack_layouttype4(data.ndd_layouttype)
        if data.ndd_deviceid is None:
            raise TypeError, 'data.ndd_deviceid == None'
        self.pack_deviceid4(data.ndd_deviceid)

    def pack_notify_deviceid_change4(self, data):
        if hasattr(self, 'filter_notify_deviceid_change4'):
            data = getattr(self, 'filter_notify_deviceid_change4')(data)
        if data.ndc_layouttype is None:
            raise TypeError, 'data.ndc_layouttype == None'
        self.pack_layouttype4(data.ndc_layouttype)
        if data.ndc_deviceid is None:
            raise TypeError, 'data.ndc_deviceid == None'
        self.pack_deviceid4(data.ndc_deviceid)
        if data.ndc_immediate is None:
            raise TypeError, 'data.ndc_immediate == None'
        self.pack_bool(data.ndc_immediate)

    def pack_CB_NOTIFY_DEVICEID4args(self, data):
        if hasattr(self, 'filter_CB_NOTIFY_DEVICEID4args'):
            data = getattr(self, 'filter_CB_NOTIFY_DEVICEID4args')(data)
        if data.cnda_changes is None:
            raise TypeError, 'data.cnda_changes == None'
        self.pack_array(data.cnda_changes, self.pack_notify4)

    def pack_CB_NOTIFY_DEVICEID4res(self, data):
        if hasattr(self, 'filter_CB_NOTIFY_DEVICEID4res'):
            data = getattr(self, 'filter_CB_NOTIFY_DEVICEID4res')(data)
        if data.cndr_status is None:
            raise TypeError, 'data.cndr_status == None'
        self.pack_nfsstat4(data.cndr_status)

    def pack_nfs_cb_opnum4(self, data):
        if hasattr(self, 'filter_nfs_cb_opnum4'):
            data = getattr(self, 'filter_nfs_cb_opnum4')(data)
        if self.check_enum and data not in [const.OP_CB_GETATTR, const.OP_CB_RECALL, const.OP_CB_LAYOUTRECALL, const.OP_CB_NOTIFY, const.OP_CB_PUSH_DELEG, const.OP_CB_RECALL_ANY, const.OP_CB_RECALLABLE_OBJ_AVAIL, const.OP_CB_RECALL_SLOT, const.OP_CB_SEQUENCE, const.OP_CB_WANTS_CANCELLED, const.OP_CB_NOTIFY_LOCK, const.OP_CB_NOTIFY_DEVICEID, const.OP_CB_ILLEGAL]:
            raise XDRError, 'value=%s not in enum nfs_cb_opnum4' % data
        self.pack_int(data)

    def pack_nfs_cb_argop4(self, data):
        if hasattr(self, 'filter_nfs_cb_argop4'):
            data = getattr(self, 'filter_nfs_cb_argop4')(data)
        if data.argop is None:
            raise TypeError, 'data.argop == None'
        self.pack_nfs_cb_opnum4(data.argop)
        if data.argop == const.OP_CB_GETATTR:
            if data.opcbgetattr is None:
                raise TypeError, 'data.opcbgetattr == None'
            self.pack_CB_GETATTR4args(data.opcbgetattr)
        elif data.argop == const.OP_CB_RECALL:
            if data.opcbrecall is None:
                raise TypeError, 'data.opcbrecall == None'
            self.pack_CB_RECALL4args(data.opcbrecall)
        elif data.argop == const.OP_CB_LAYOUTRECALL:
            if data.opcblayoutrecall is None:
                raise TypeError, 'data.opcblayoutrecall == None'
            self.pack_CB_LAYOUTRECALL4args(data.opcblayoutrecall)
        elif data.argop == const.OP_CB_NOTIFY:
            if data.opcbnotify is None:
                raise TypeError, 'data.opcbnotify == None'
            self.pack_CB_NOTIFY4args(data.opcbnotify)
        elif data.argop == const.OP_CB_PUSH_DELEG:
            if data.opcbpush_deleg is None:
                raise TypeError, 'data.opcbpush_deleg == None'
            self.pack_CB_PUSH_DELEG4args(data.opcbpush_deleg)
        elif data.argop == const.OP_CB_RECALL_ANY:
            if data.opcbrecall_any is None:
                raise TypeError, 'data.opcbrecall_any == None'
            self.pack_CB_RECALL_ANY4args(data.opcbrecall_any)
        elif data.argop == const.OP_CB_RECALLABLE_OBJ_AVAIL:
            if data.opcbrecallable_obj_avail is None:
                raise TypeError, 'data.opcbrecallable_obj_avail == None'
            self.pack_CB_RECALLABLE_OBJ_AVAIL4args(data.opcbrecallable_obj_avail)
        elif data.argop == const.OP_CB_RECALL_SLOT:
            if data.opcbrecall_slot is None:
                raise TypeError, 'data.opcbrecall_slot == None'
            self.pack_CB_RECALL_SLOT4args(data.opcbrecall_slot)
        elif data.argop == const.OP_CB_SEQUENCE:
            if data.opcbsequence is None:
                raise TypeError, 'data.opcbsequence == None'
            self.pack_CB_SEQUENCE4args(data.opcbsequence)
        elif data.argop == const.OP_CB_WANTS_CANCELLED:
            if data.opcbwants_cancelled is None:
                raise TypeError, 'data.opcbwants_cancelled == None'
            self.pack_CB_WANTS_CANCELLED4args(data.opcbwants_cancelled)
        elif data.argop == const.OP_CB_NOTIFY_LOCK:
            if data.opcbnotify_lock is None:
                raise TypeError, 'data.opcbnotify_lock == None'
            self.pack_CB_NOTIFY_LOCK4args(data.opcbnotify_lock)
        elif data.argop == const.OP_CB_NOTIFY_DEVICEID:
            if data.opcbnotify_deviceid is None:
                raise TypeError, 'data.opcbnotify_deviceid == None'
            self.pack_CB_NOTIFY_DEVICEID4args(data.opcbnotify_deviceid)
        elif data.argop == const.OP_CB_ILLEGAL:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.argop

    def pack_nfs_cb_resop4(self, data):
        if hasattr(self, 'filter_nfs_cb_resop4'):
            data = getattr(self, 'filter_nfs_cb_resop4')(data)
        if data.resop is None:
            raise TypeError, 'data.resop == None'
        self.pack_nfs_cb_opnum4(data.resop)
        if data.resop == const.OP_CB_GETATTR:
            if data.opcbgetattr is None:
                raise TypeError, 'data.opcbgetattr == None'
            self.pack_CB_GETATTR4res(data.opcbgetattr)
        elif data.resop == const.OP_CB_RECALL:
            if data.opcbrecall is None:
                raise TypeError, 'data.opcbrecall == None'
            self.pack_CB_RECALL4res(data.opcbrecall)
        elif data.resop == const.OP_CB_LAYOUTRECALL:
            if data.opcblayoutrecall is None:
                raise TypeError, 'data.opcblayoutrecall == None'
            self.pack_CB_LAYOUTRECALL4res(data.opcblayoutrecall)
        elif data.resop == const.OP_CB_NOTIFY:
            if data.opcbnotify is None:
                raise TypeError, 'data.opcbnotify == None'
            self.pack_CB_NOTIFY4res(data.opcbnotify)
        elif data.resop == const.OP_CB_PUSH_DELEG:
            if data.opcbpush_deleg is None:
                raise TypeError, 'data.opcbpush_deleg == None'
            self.pack_CB_PUSH_DELEG4res(data.opcbpush_deleg)
        elif data.resop == const.OP_CB_RECALL_ANY:
            if data.opcbrecall_any is None:
                raise TypeError, 'data.opcbrecall_any == None'
            self.pack_CB_RECALL_ANY4res(data.opcbrecall_any)
        elif data.resop == const.OP_CB_RECALLABLE_OBJ_AVAIL:
            if data.opcbrecallable_obj_avail is None:
                raise TypeError, 'data.opcbrecallable_obj_avail == None'
            self.pack_CB_RECALLABLE_OBJ_AVAIL4res(data.opcbrecallable_obj_avail)
        elif data.resop == const.OP_CB_RECALL_SLOT:
            if data.opcbrecall_slot is None:
                raise TypeError, 'data.opcbrecall_slot == None'
            self.pack_CB_RECALL_SLOT4res(data.opcbrecall_slot)
        elif data.resop == const.OP_CB_SEQUENCE:
            if data.opcbsequence is None:
                raise TypeError, 'data.opcbsequence == None'
            self.pack_CB_SEQUENCE4res(data.opcbsequence)
        elif data.resop == const.OP_CB_WANTS_CANCELLED:
            if data.opcbwants_cancelled is None:
                raise TypeError, 'data.opcbwants_cancelled == None'
            self.pack_CB_WANTS_CANCELLED4res(data.opcbwants_cancelled)
        elif data.resop == const.OP_CB_NOTIFY_LOCK:
            if data.opcbnotify_lock is None:
                raise TypeError, 'data.opcbnotify_lock == None'
            self.pack_CB_NOTIFY_LOCK4res(data.opcbnotify_lock)
        elif data.resop == const.OP_CB_NOTIFY_DEVICEID:
            if data.opcbnotify_deviceid is None:
                raise TypeError, 'data.opcbnotify_deviceid == None'
            self.pack_CB_NOTIFY_DEVICEID4res(data.opcbnotify_deviceid)
        elif data.resop == const.OP_CB_ILLEGAL:
            if data.opcbillegal is None:
                raise TypeError, 'data.opcbillegal == None'
            self.pack_CB_ILLEGAL4res(data.opcbillegal)
        else:
            raise XDRError, 'bad switch=%s' % data.resop

    def pack_CB_COMPOUND4args(self, data):
        if hasattr(self, 'filter_CB_COMPOUND4args'):
            data = getattr(self, 'filter_CB_COMPOUND4args')(data)
        if data.tag is None:
            raise TypeError, 'data.tag == None'
        self.pack_utf8str_cs(data.tag)
        if data.minorversion is None:
            raise TypeError, 'data.minorversion == None'
        self.pack_uint32_t(data.minorversion)
        if data.callback_ident is None:
            raise TypeError, 'data.callback_ident == None'
        self.pack_uint32_t(data.callback_ident)
        if data.argarray is None:
            raise TypeError, 'data.argarray == None'
        self.pack_array(data.argarray, self.pack_nfs_cb_argop4)

    def pack_CB_COMPOUND4res(self, data):
        if hasattr(self, 'filter_CB_COMPOUND4res'):
            data = getattr(self, 'filter_CB_COMPOUND4res')(data)
        if data.status is None:
            raise TypeError, 'data.status == None'
        self.pack_nfsstat4(data.status)
        if data.tag is None:
            raise TypeError, 'data.tag == None'
        self.pack_utf8str_cs(data.tag)
        if data.resarray is None:
            raise TypeError, 'data.resarray == None'
        self.pack_array(data.resarray, self.pack_nfs_cb_resop4)

class NFS4Unpacker(xdrlib.Unpacker):
    def __init__(self, data, check_enum=True, check_array=True):
        xdrlib.Unpacker.__init__(self, data)
        self.check_enum = check_enum
        self.check_array = check_array

    unpack_hyper = xdrlib.Unpacker.unpack_hyper
    unpack_string = xdrlib.Unpacker.unpack_string
    unpack_int = xdrlib.Unpacker.unpack_int
    unpack_float = xdrlib.Unpacker.unpack_float
    unpack_uint = xdrlib.Unpacker.unpack_uint
    unpack_opaque = xdrlib.Unpacker.unpack_opaque
    unpack_double = xdrlib.Unpacker.unpack_double
    unpack_unsigned = xdrlib.Unpacker.unpack_uint
    unpack_quadruple = xdrlib.Unpacker.unpack_double
    unpack_uhyper = xdrlib.Unpacker.unpack_uhyper
    unpack_bool = xdrlib.Unpacker.unpack_bool
    unpack_int32_t = unpack_int

    unpack_uint32_t = unpack_uint

    unpack_int64_t = unpack_hyper

    unpack_uint64_t = unpack_uhyper

    def unpack_authsys_parms(self):
        data = types.authsys_parms()
        data.stamp = self.unpack_uint()
        data.machinename = self.unpack_string()
        if len(data.machinename) > 255 and self.check_array:
            raise XDRError, 'array length too long for data.machinename'
        data.uid = self.unpack_uint()
        data.gid = self.unpack_uint()
        data.gids = self.unpack_array(self.unpack_uint)
        if len(data.gids) > 16 and self.check_array:
            raise XDRError, 'array length too long for data.gids'
        if hasattr(self, 'filter_authsys_parms'):
            data = getattr(self, 'filter_authsys_parms')(data)
        return data

    def unpack_nfs_ftype4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.NF4REG, const.NF4DIR, const.NF4BLK, const.NF4CHR, const.NF4LNK, const.NF4SOCK, const.NF4FIFO, const.NF4ATTRDIR, const.NF4NAMEDATTR]:
            raise XDRError, 'value=%s not in enum nfs_ftype4' % data
        if hasattr(self, 'filter_nfs_ftype4'):
            data = getattr(self, 'filter_nfs_ftype4')(data)
        return data

    def unpack_nfsstat4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.NFS4_OK, const.NFS4ERR_PERM, const.NFS4ERR_NOENT, const.NFS4ERR_IO, const.NFS4ERR_NXIO, const.NFS4ERR_ACCESS, const.NFS4ERR_EXIST, const.NFS4ERR_XDEV, const.NFS4ERR_NOTDIR, const.NFS4ERR_ISDIR, const.NFS4ERR_INVAL, const.NFS4ERR_FBIG, const.NFS4ERR_NOSPC, const.NFS4ERR_ROFS, const.NFS4ERR_MLINK, const.NFS4ERR_NAMETOOLONG, const.NFS4ERR_NOTEMPTY, const.NFS4ERR_DQUOT, const.NFS4ERR_STALE, const.NFS4ERR_BADHANDLE, const.NFS4ERR_BAD_COOKIE, const.NFS4ERR_NOTSUPP, const.NFS4ERR_TOOSMALL, const.NFS4ERR_SERVERFAULT, const.NFS4ERR_BADTYPE, const.NFS4ERR_DELAY, const.NFS4ERR_SAME, const.NFS4ERR_DENIED, const.NFS4ERR_EXPIRED, const.NFS4ERR_LOCKED, const.NFS4ERR_GRACE, const.NFS4ERR_FHEXPIRED, const.NFS4ERR_SHARE_DENIED, const.NFS4ERR_WRONGSEC, const.NFS4ERR_CLID_INUSE, const.NFS4ERR_RESOURCE, const.NFS4ERR_MOVED, const.NFS4ERR_NOFILEHANDLE, const.NFS4ERR_MINOR_VERS_MISMATCH, const.NFS4ERR_STALE_CLIENTID, const.NFS4ERR_STALE_STATEID, const.NFS4ERR_OLD_STATEID, const.NFS4ERR_BAD_STATEID, const.NFS4ERR_BAD_SEQID, const.NFS4ERR_NOT_SAME, const.NFS4ERR_LOCK_RANGE, const.NFS4ERR_SYMLINK, const.NFS4ERR_RESTOREFH, const.NFS4ERR_LEASE_MOVED, const.NFS4ERR_ATTRNOTSUPP, const.NFS4ERR_NO_GRACE, const.NFS4ERR_RECLAIM_BAD, const.NFS4ERR_RECLAIM_CONFLICT, const.NFS4ERR_BADXDR, const.NFS4ERR_LOCKS_HELD, const.NFS4ERR_OPENMODE, const.NFS4ERR_BADOWNER, const.NFS4ERR_BADCHAR, const.NFS4ERR_BADNAME, const.NFS4ERR_BAD_RANGE, const.NFS4ERR_LOCK_NOTSUPP, const.NFS4ERR_OP_ILLEGAL, const.NFS4ERR_DEADLOCK, const.NFS4ERR_FILE_OPEN, const.NFS4ERR_ADMIN_REVOKED, const.NFS4ERR_CB_PATH_DOWN, const.NFS4ERR_BADIOMODE, const.NFS4ERR_BADLAYOUT, const.NFS4ERR_BAD_SESSION_DIGEST, const.NFS4ERR_BADSESSION, const.NFS4ERR_BADSLOT, const.NFS4ERR_COMPLETE_ALREADY, const.NFS4ERR_CONN_NOT_BOUND_TO_SESSION, const.NFS4ERR_DELEG_ALREADY_WANTED, const.NFS4ERR_BACK_CHAN_BUSY, const.NFS4ERR_LAYOUTTRYLATER, const.NFS4ERR_LAYOUTUNAVAILABLE, const.NFS4ERR_NOMATCHING_LAYOUT, const.NFS4ERR_RECALLCONFLICT, const.NFS4ERR_UNKNOWN_LAYOUTTYPE, const.NFS4ERR_SEQ_MISORDERED, const.NFS4ERR_SEQUENCE_POS, const.NFS4ERR_REQ_TOO_BIG, const.NFS4ERR_REP_TOO_BIG, const.NFS4ERR_REP_TOO_BIG_TO_CACHE, const.NFS4ERR_RETRY_UNCACHED_REP, const.NFS4ERR_UNSAFE_COMPOUND, const.NFS4ERR_TOO_MANY_OPS, const.NFS4ERR_OP_NOT_IN_SESSION, const.NFS4ERR_HASH_ALG_UNSUPP, const.NFS4ERR_CONN_BINDING_NOT_ENFORCED, const.NFS4ERR_CLIENTID_BUSY, const.NFS4ERR_PNFS_IO_HOLE, const.NFS4ERR_SEQ_FALSE_RETRY, const.NFS4ERR_BAD_HIGH_SLOT, const.NFS4ERR_DEADSESSION, const.NFS4ERR_ENCR_ALG_UNSUPP, const.NFS4ERR_PNFS_NO_LAYOUT, const.NFS4ERR_NOT_ONLY_OP, const.NFS4ERR_WRONG_CRED, const.NFS4ERR_WRONG_TYPE, const.NFS4ERR_DIRDELEG_UNAVAIL, const.NFS4ERR_REJECT_DELEG, const.NFS4ERR_RETURNCONFLICT]:
            raise XDRError, 'value=%s not in enum nfsstat4' % data
        if hasattr(self, 'filter_nfsstat4'):
            data = getattr(self, 'filter_nfsstat4')(data)
        return data

    def unpack_attrlist4(self):
        data = self.unpack_opaque()
        if hasattr(self, 'filter_attrlist4'):
            data = getattr(self, 'filter_attrlist4')(data)
        return data

    def unpack_bitmap4(self):
        data = self.unpack_array(self.unpack_uint32_t)
        if hasattr(self, 'filter_bitmap4'):
            data = getattr(self, 'filter_bitmap4')(data)
        return data

    unpack_changeid4 = unpack_uint64_t

    unpack_clientid4 = unpack_uint64_t

    unpack_count4 = unpack_uint32_t

    unpack_length4 = unpack_uint64_t

    unpack_mode4 = unpack_uint32_t

    unpack_nfs_cookie4 = unpack_uint64_t

    def unpack_nfs_fh4(self):
        data = self.unpack_opaque()
        if len(data) > const.NFS4_FHSIZE and self.check_array:
            raise XDRError, 'array length too long for data'
        if hasattr(self, 'filter_nfs_fh4'):
            data = getattr(self, 'filter_nfs_fh4')(data)
        return data

    unpack_offset4 = unpack_uint64_t

    unpack_qop4 = unpack_uint32_t

    def unpack_sec_oid4(self):
        data = self.unpack_opaque()
        if hasattr(self, 'filter_sec_oid4'):
            data = getattr(self, 'filter_sec_oid4')(data)
        return data

    unpack_sequenceid4 = unpack_uint32_t

    unpack_seqid4 = unpack_uint32_t

    def unpack_sessionid4(self):
        data = self.unpack_fopaque(const.NFS4_SESSIONID_SIZE)
        if hasattr(self, 'filter_sessionid4'):
            data = getattr(self, 'filter_sessionid4')(data)
        return data

    unpack_slotid4 = unpack_uint32_t

    def unpack_utf8string(self):
        data = self.unpack_opaque()
        if hasattr(self, 'filter_utf8string'):
            data = getattr(self, 'filter_utf8string')(data)
        return data

    unpack_utf8str_cis = unpack_utf8string

    unpack_utf8str_cs = unpack_utf8string

    unpack_utf8str_mixed = unpack_utf8string

    unpack_component4 = unpack_utf8str_cs

    unpack_linktext4 = unpack_utf8str_cs

    def unpack_pathname4(self):
        data = self.unpack_array(self.unpack_component4)
        if hasattr(self, 'filter_pathname4'):
            data = getattr(self, 'filter_pathname4')(data)
        return data

    def unpack_verifier4(self):
        data = self.unpack_fopaque(const.NFS4_VERIFIER_SIZE)
        if hasattr(self, 'filter_verifier4'):
            data = getattr(self, 'filter_verifier4')(data)
        return data

    def unpack_nfstime4(self):
        data = types.nfstime4()
        data.seconds = self.unpack_int64_t()
        data.nseconds = self.unpack_uint32_t()
        if hasattr(self, 'filter_nfstime4'):
            data = getattr(self, 'filter_nfstime4')(data)
        return data

    def unpack_time_how4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.SET_TO_SERVER_TIME4, const.SET_TO_CLIENT_TIME4]:
            raise XDRError, 'value=%s not in enum time_how4' % data
        if hasattr(self, 'filter_time_how4'):
            data = getattr(self, 'filter_time_how4')(data)
        return data

    def unpack_settime4(self):
        data = types.settime4()
        data.set_it = self.unpack_time_how4()
        if data.set_it == const.SET_TO_CLIENT_TIME4:
            data.time = self.unpack_nfstime4()
        else:
            pass
        if hasattr(self, 'filter_settime4'):
            data = getattr(self, 'filter_settime4')(data)
        return data

    unpack_nfs_lease4 = unpack_uint32_t

    def unpack_fsid4(self):
        data = types.fsid4()
        data.major = self.unpack_uint64_t()
        data.minor = self.unpack_uint64_t()
        if hasattr(self, 'filter_fsid4'):
            data = getattr(self, 'filter_fsid4')(data)
        return data

    def unpack_change_policy4(self):
        data = types.change_policy4()
        data.cp_major = self.unpack_uint64_t()
        data.cp_minor = self.unpack_uint64_t()
        if hasattr(self, 'filter_change_policy4'):
            data = getattr(self, 'filter_change_policy4')(data)
        return data

    def unpack_fs_location4(self):
        data = types.fs_location4()
        data.server = self.unpack_array(self.unpack_utf8str_cis)
        data.rootpath = self.unpack_pathname4()
        if hasattr(self, 'filter_fs_location4'):
            data = getattr(self, 'filter_fs_location4')(data)
        return data

    def unpack_fs_locations4(self):
        data = types.fs_locations4()
        data.fs_root = self.unpack_pathname4()
        data.locations = self.unpack_array(self.unpack_fs_location4)
        if hasattr(self, 'filter_fs_locations4'):
            data = getattr(self, 'filter_fs_locations4')(data)
        return data

    unpack_acetype4 = unpack_uint32_t

    unpack_aceflag4 = unpack_uint32_t

    unpack_acemask4 = unpack_uint32_t

    def unpack_nfsace4(self):
        data = types.nfsace4()
        data.type = self.unpack_acetype4()
        data.flag = self.unpack_aceflag4()
        data.access_mask = self.unpack_acemask4()
        data.who = self.unpack_utf8str_mixed()
        if hasattr(self, 'filter_nfsace4'):
            data = getattr(self, 'filter_nfsace4')(data)
        return data

    unpack_aclflag4 = unpack_uint32_t

    def unpack_nfsacl41(self):
        data = types.nfsacl41()
        data.na41_flag = self.unpack_aclflag4()
        data.na41_aces = self.unpack_array(self.unpack_nfsace4)
        if hasattr(self, 'filter_nfsacl41'):
            data = getattr(self, 'filter_nfsacl41')(data)
        return data

    def unpack_mode_masked4(self):
        data = types.mode_masked4()
        data.mm_value_to_set = self.unpack_mode4()
        data.mm_mask_bits = self.unpack_mode4()
        if hasattr(self, 'filter_mode_masked4'):
            data = getattr(self, 'filter_mode_masked4')(data)
        return data

    def unpack_specdata4(self):
        data = types.specdata4()
        data.specdata1 = self.unpack_uint32_t()
        data.specdata2 = self.unpack_uint32_t()
        if hasattr(self, 'filter_specdata4'):
            data = getattr(self, 'filter_specdata4')(data)
        return data

    def unpack_netaddr4(self):
        data = types.netaddr4()
        data.na_r_netid = self.unpack_string()
        data.na_r_addr = self.unpack_string()
        if hasattr(self, 'filter_netaddr4'):
            data = getattr(self, 'filter_netaddr4')(data)
        return data

    def unpack_nfs_impl_id4(self):
        data = types.nfs_impl_id4()
        data.nii_domain = self.unpack_utf8str_cis()
        data.nii_name = self.unpack_utf8str_cs()
        data.nii_date = self.unpack_nfstime4()
        if hasattr(self, 'filter_nfs_impl_id4'):
            data = getattr(self, 'filter_nfs_impl_id4')(data)
        return data

    def unpack_stateid4(self):
        data = types.stateid4()
        data.seqid = self.unpack_uint32_t()
        data.other = self.unpack_fopaque(12)
        if hasattr(self, 'filter_stateid4'):
            data = getattr(self, 'filter_stateid4')(data)
        return data

    def unpack_layouttype4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.LAYOUT4_NFSV4_1_FILES, const.LAYOUT4_OSD2_OBJECTS, const.LAYOUT4_BLOCK_VOLUME]:
            raise XDRError, 'value=%s not in enum layouttype4' % data
        if hasattr(self, 'filter_layouttype4'):
            data = getattr(self, 'filter_layouttype4')(data)
        return data

    def unpack_layout_content4(self):
        data = types.layout_content4()
        data.loc_type = self.unpack_layouttype4()
        data.loc_body = self.unpack_opaque()
        if hasattr(self, 'filter_layout_content4'):
            data = getattr(self, 'filter_layout_content4')(data)
        return data

    def unpack_layouthint4(self):
        data = types.layouthint4()
        data.loh_type = self.unpack_layouttype4()
        data.loh_body = self.unpack_opaque()
        if hasattr(self, 'filter_layouthint4'):
            data = getattr(self, 'filter_layouthint4')(data)
        return data

    def unpack_layoutiomode4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.LAYOUTIOMODE4_READ, const.LAYOUTIOMODE4_RW, const.LAYOUTIOMODE4_ANY]:
            raise XDRError, 'value=%s not in enum layoutiomode4' % data
        if hasattr(self, 'filter_layoutiomode4'):
            data = getattr(self, 'filter_layoutiomode4')(data)
        return data

    def unpack_layout4(self):
        data = types.layout4()
        data.lo_offset = self.unpack_offset4()
        data.lo_length = self.unpack_length4()
        data.lo_iomode = self.unpack_layoutiomode4()
        data.lo_content = self.unpack_layout_content4()
        if hasattr(self, 'filter_layout4'):
            data = getattr(self, 'filter_layout4')(data)
        return data

    def unpack_deviceid4(self):
        data = self.unpack_fopaque(const.NFS4_DEVICEID4_SIZE)
        if hasattr(self, 'filter_deviceid4'):
            data = getattr(self, 'filter_deviceid4')(data)
        return data

    def unpack_device_addr4(self):
        data = types.device_addr4()
        data.da_layout_type = self.unpack_layouttype4()
        data.da_addr_body = self.unpack_opaque()
        if hasattr(self, 'filter_device_addr4'):
            data = getattr(self, 'filter_device_addr4')(data)
        return data

    def unpack_layoutupdate4(self):
        data = types.layoutupdate4()
        data.lou_type = self.unpack_layouttype4()
        data.lou_body = self.unpack_opaque()
        if hasattr(self, 'filter_layoutupdate4'):
            data = getattr(self, 'filter_layoutupdate4')(data)
        return data

    def unpack_layoutreturn_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.LAYOUTRETURN4_FILE, const.LAYOUTRETURN4_FSID, const.LAYOUTRETURN4_ALL]:
            raise XDRError, 'value=%s not in enum layoutreturn_type4' % data
        if hasattr(self, 'filter_layoutreturn_type4'):
            data = getattr(self, 'filter_layoutreturn_type4')(data)
        return data

    def unpack_layoutreturn_file4(self):
        data = types.layoutreturn_file4()
        data.lrf_offset = self.unpack_offset4()
        data.lrf_length = self.unpack_length4()
        data.lrf_stateid = self.unpack_stateid4()
        data.lrf_body = self.unpack_opaque()
        if hasattr(self, 'filter_layoutreturn_file4'):
            data = getattr(self, 'filter_layoutreturn_file4')(data)
        return data

    def unpack_layoutreturn4(self):
        data = types.layoutreturn4()
        data.lr_returntype = self.unpack_layoutreturn_type4()
        if data.lr_returntype == const.LAYOUTRETURN4_FILE:
            data.lr_layout = self.unpack_layoutreturn_file4()
        else:
            pass
        if hasattr(self, 'filter_layoutreturn4'):
            data = getattr(self, 'filter_layoutreturn4')(data)
        return data

    def unpack_fs4_status_type(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.STATUS4_FIXED, const.STATUS4_UPDATED, const.STATUS4_VERSIONED, const.STATUS4_WRITABLE, const.STATUS4_REFERRAL]:
            raise XDRError, 'value=%s not in enum fs4_status_type' % data
        if hasattr(self, 'filter_fs4_status_type'):
            data = getattr(self, 'filter_fs4_status_type')(data)
        return data

    def unpack_fs4_status(self):
        data = types.fs4_status()
        data.fss_absent = self.unpack_bool()
        data.fss_type = self.unpack_fs4_status_type()
        data.fss_source = self.unpack_utf8str_cs()
        data.fss_current = self.unpack_utf8str_cs()
        data.fss_age = self.unpack_int32_t()
        data.fss_version = self.unpack_nfstime4()
        if hasattr(self, 'filter_fs4_status'):
            data = getattr(self, 'filter_fs4_status')(data)
        return data

    unpack_threshold4_read_size = unpack_length4

    unpack_threshold4_write_size = unpack_length4

    unpack_threshold4_read_iosize = unpack_length4

    unpack_threshold4_write_iosize = unpack_length4

    def unpack_threshold_item4(self):
        data = types.threshold_item4()
        data.thi_layout_type = self.unpack_layouttype4()
        data.thi_hintset = self.unpack_bitmap4()
        data.thi_hintlist = self.unpack_opaque()
        if hasattr(self, 'filter_threshold_item4'):
            data = getattr(self, 'filter_threshold_item4')(data)
        return data

    def unpack_mdsthreshold4(self):
        data = types.mdsthreshold4()
        data.mth_hints = self.unpack_array(self.unpack_threshold_item4)
        if hasattr(self, 'filter_mdsthreshold4'):
            data = getattr(self, 'filter_mdsthreshold4')(data)
        return data

    def unpack_retention_get4(self):
        data = types.retention_get4()
        data.rg_duration = self.unpack_uint64_t()
        data.rg_begin_time = self.unpack_array(self.unpack_nfstime4)
        if len(data.rg_begin_time) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.rg_begin_time'
        if hasattr(self, 'filter_retention_get4'):
            data = getattr(self, 'filter_retention_get4')(data)
        return data

    def unpack_retention_set4(self):
        data = types.retention_set4()
        data.rs_enable = self.unpack_bool()
        data.rs_duration = self.unpack_array(self.unpack_uint64_t)
        if len(data.rs_duration) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.rs_duration'
        if hasattr(self, 'filter_retention_set4'):
            data = getattr(self, 'filter_retention_set4')(data)
        return data

    unpack_fs_charset_cap4 = unpack_uint32_t

    unpack_fattr4_supported_attrs = unpack_bitmap4

    unpack_fattr4_suppattr_exclcreat = unpack_bitmap4

    unpack_fattr4_type = unpack_nfs_ftype4

    unpack_fattr4_fh_expire_type = unpack_uint32_t

    unpack_fattr4_change = unpack_changeid4

    unpack_fattr4_size = unpack_uint64_t

    unpack_fattr4_link_support = unpack_bool

    unpack_fattr4_symlink_support = unpack_bool

    unpack_fattr4_named_attr = unpack_bool

    unpack_fattr4_fsid = unpack_fsid4

    unpack_fattr4_unique_handles = unpack_bool

    unpack_fattr4_lease_time = unpack_nfs_lease4

    unpack_fattr4_rdattr_error = unpack_nfsstat4

    def unpack_fattr4_acl(self):
        data = self.unpack_array(self.unpack_nfsace4)
        if hasattr(self, 'filter_fattr4_acl'):
            data = getattr(self, 'filter_fattr4_acl')(data)
        return data

    unpack_fattr4_aclsupport = unpack_uint32_t

    unpack_fattr4_archive = unpack_bool

    unpack_fattr4_cansettime = unpack_bool

    unpack_fattr4_case_insensitive = unpack_bool

    unpack_fattr4_case_preserving = unpack_bool

    unpack_fattr4_chown_restricted = unpack_bool

    unpack_fattr4_fileid = unpack_uint64_t

    unpack_fattr4_files_avail = unpack_uint64_t

    unpack_fattr4_filehandle = unpack_nfs_fh4

    unpack_fattr4_files_free = unpack_uint64_t

    unpack_fattr4_files_total = unpack_uint64_t

    unpack_fattr4_fs_locations = unpack_fs_locations4

    unpack_fattr4_hidden = unpack_bool

    unpack_fattr4_homogeneous = unpack_bool

    unpack_fattr4_maxfilesize = unpack_uint64_t

    unpack_fattr4_maxlink = unpack_uint32_t

    unpack_fattr4_maxname = unpack_uint32_t

    unpack_fattr4_maxread = unpack_uint64_t

    unpack_fattr4_maxwrite = unpack_uint64_t

    unpack_fattr4_mimetype = unpack_utf8str_cs

    unpack_fattr4_mode = unpack_mode4

    unpack_fattr4_mode_set_masked = unpack_mode_masked4

    unpack_fattr4_mounted_on_fileid = unpack_uint64_t

    unpack_fattr4_no_trunc = unpack_bool

    unpack_fattr4_numlinks = unpack_uint32_t

    unpack_fattr4_owner = unpack_utf8str_mixed

    unpack_fattr4_owner_group = unpack_utf8str_mixed

    unpack_fattr4_quota_avail_hard = unpack_uint64_t

    unpack_fattr4_quota_avail_soft = unpack_uint64_t

    unpack_fattr4_quota_used = unpack_uint64_t

    unpack_fattr4_rawdev = unpack_specdata4

    unpack_fattr4_space_avail = unpack_uint64_t

    unpack_fattr4_space_free = unpack_uint64_t

    unpack_fattr4_space_total = unpack_uint64_t

    unpack_fattr4_space_used = unpack_uint64_t

    unpack_fattr4_system = unpack_bool

    unpack_fattr4_time_access = unpack_nfstime4

    unpack_fattr4_time_access_set = unpack_settime4

    unpack_fattr4_time_backup = unpack_nfstime4

    unpack_fattr4_time_create = unpack_nfstime4

    unpack_fattr4_time_delta = unpack_nfstime4

    unpack_fattr4_time_metadata = unpack_nfstime4

    unpack_fattr4_time_modify = unpack_nfstime4

    unpack_fattr4_time_modify_set = unpack_settime4

    unpack_fattr4_dir_notif_delay = unpack_nfstime4

    unpack_fattr4_dirent_notif_delay = unpack_nfstime4

    unpack_fattr4_absent = unpack_bool

    def unpack_fattr4_fs_layout_type(self):
        data = self.unpack_array(self.unpack_layouttype4)
        if hasattr(self, 'filter_fattr4_fs_layout_type'):
            data = getattr(self, 'filter_fattr4_fs_layout_type')(data)
        return data

    unpack_fattr4_fs_status = unpack_fs4_status

    unpack_fattr4_fs_charset_cap4 = unpack_fs_charset_cap4

    unpack_fattr4_layout_alignment = unpack_uint32_t

    unpack_fattr4_layout_blksize = unpack_uint32_t

    unpack_fattr4_layout_hint = unpack_layouthint4

    def unpack_fattr4_layout_type(self):
        data = self.unpack_array(self.unpack_layouttype4)
        if hasattr(self, 'filter_fattr4_layout_type'):
            data = getattr(self, 'filter_fattr4_layout_type')(data)
        return data

    unpack_fattr4_mdsthreshold = unpack_mdsthreshold4

    unpack_fattr4_retention_get = unpack_retention_get4

    unpack_fattr4_retention_set = unpack_retention_set4

    unpack_fattr4_retentevt_get = unpack_retention_get4

    unpack_fattr4_retentevt_set = unpack_retention_set4

    unpack_fattr4_retention_hold = unpack_uint64_t

    unpack_fattr4_dacl = unpack_nfsacl41

    unpack_fattr4_sacl = unpack_nfsacl41

    def unpack_fattr4(self):
        data = types.fattr4()
        data.attrmask = self.unpack_bitmap4()
        data.attr_vals = self.unpack_attrlist4()
        if hasattr(self, 'filter_fattr4'):
            data = getattr(self, 'filter_fattr4')(data)
        return data

    def unpack_change_info4(self):
        data = types.change_info4()
        data.atomic = self.unpack_bool()
        data.before = self.unpack_changeid4()
        data.after = self.unpack_changeid4()
        if hasattr(self, 'filter_change_info4'):
            data = getattr(self, 'filter_change_info4')(data)
        return data

    unpack_clientaddr4 = unpack_netaddr4

    def unpack_cb_client4(self):
        data = types.cb_client4()
        data.cb_program = self.unpack_uint32_t()
        data.cb_location = self.unpack_netaddr4()
        if hasattr(self, 'filter_cb_client4'):
            data = getattr(self, 'filter_cb_client4')(data)
        return data

    def unpack_nfs_client_id4(self):
        data = types.nfs_client_id4()
        data.verifier = self.unpack_verifier4()
        data.id = self.unpack_opaque()
        if len(data.id) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.id'
        if hasattr(self, 'filter_nfs_client_id4'):
            data = getattr(self, 'filter_nfs_client_id4')(data)
        return data

    def unpack_client_owner4(self):
        data = types.client_owner4()
        data.co_verifier = self.unpack_verifier4()
        data.co_ownerid = self.unpack_opaque()
        if len(data.co_ownerid) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.co_ownerid'
        if hasattr(self, 'filter_client_owner4'):
            data = getattr(self, 'filter_client_owner4')(data)
        return data

    def unpack_server_owner4(self):
        data = types.server_owner4()
        data.so_minor_id = self.unpack_uint64_t()
        data.so_major_id = self.unpack_opaque()
        if len(data.so_major_id) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.so_major_id'
        if hasattr(self, 'filter_server_owner4'):
            data = getattr(self, 'filter_server_owner4')(data)
        return data

    def unpack_state_owner4(self):
        data = types.state_owner4()
        data.clientid = self.unpack_clientid4()
        data.owner = self.unpack_opaque()
        if len(data.owner) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.owner'
        if hasattr(self, 'filter_state_owner4'):
            data = getattr(self, 'filter_state_owner4')(data)
        return data

    unpack_open_owner4 = unpack_state_owner4

    unpack_lock_owner4 = unpack_state_owner4

    def unpack_nfs_lock_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.READ_LT, const.WRITE_LT, const.READW_LT, const.WRITEW_LT]:
            raise XDRError, 'value=%s not in enum nfs_lock_type4' % data
        if hasattr(self, 'filter_nfs_lock_type4'):
            data = getattr(self, 'filter_nfs_lock_type4')(data)
        return data

    def unpack_ssv_subkey4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.SSV4_SUBKEY_MIC_I2T, const.SSV4_SUBKEY_MIC_T2I, const.SSV4_SUBKEY_SEAL_I2T, const.SSV4_SUBKEY_SEAL_T2I]:
            raise XDRError, 'value=%s not in enum ssv_subkey4' % data
        if hasattr(self, 'filter_ssv_subkey4'):
            data = getattr(self, 'filter_ssv_subkey4')(data)
        return data

    def unpack_ssv_mic_plain_tkn4(self):
        data = types.ssv_mic_plain_tkn4()
        data.smpt_ssv_seq = self.unpack_uint32_t()
        data.smpt_orig_plain = self.unpack_opaque()
        if hasattr(self, 'filter_ssv_mic_plain_tkn4'):
            data = getattr(self, 'filter_ssv_mic_plain_tkn4')(data)
        return data

    def unpack_ssv_mic_tkn4(self):
        data = types.ssv_mic_tkn4()
        data.smt_ssv_seq = self.unpack_uint32_t()
        data.smt_hmac = self.unpack_opaque()
        if hasattr(self, 'filter_ssv_mic_tkn4'):
            data = getattr(self, 'filter_ssv_mic_tkn4')(data)
        return data

    def unpack_ssv_seal_plain_tkn4(self):
        data = types.ssv_seal_plain_tkn4()
        data.sspt_confounder = self.unpack_opaque()
        data.sspt_ssv_seq = self.unpack_uint32_t()
        data.sspt_orig_plain = self.unpack_opaque()
        data.sspt_pad = self.unpack_opaque()
        if hasattr(self, 'filter_ssv_seal_plain_tkn4'):
            data = getattr(self, 'filter_ssv_seal_plain_tkn4')(data)
        return data

    def unpack_ssv_seal_cipher_tkn4(self):
        data = types.ssv_seal_cipher_tkn4()
        data.ssct_ssv_seq = self.unpack_uint32_t()
        data.ssct_iv = self.unpack_opaque()
        data.ssct_encr_data = self.unpack_opaque()
        data.ssct_hmac = self.unpack_opaque()
        if hasattr(self, 'filter_ssv_seal_cipher_tkn4'):
            data = getattr(self, 'filter_ssv_seal_cipher_tkn4')(data)
        return data

    def unpack_fs_locations_server4(self):
        data = types.fs_locations_server4()
        data.fls_currency = self.unpack_int32_t()
        data.fls_info = self.unpack_opaque()
        data.fls_server = self.unpack_utf8str_cis()
        if hasattr(self, 'filter_fs_locations_server4'):
            data = getattr(self, 'filter_fs_locations_server4')(data)
        return data

    def unpack_fs_locations_item4(self):
        data = types.fs_locations_item4()
        data.fli_entries = self.unpack_array(self.unpack_fs_locations_server4)
        data.fli_rootpath = self.unpack_pathname4()
        if hasattr(self, 'filter_fs_locations_item4'):
            data = getattr(self, 'filter_fs_locations_item4')(data)
        return data

    def unpack_fs_locations_info4(self):
        data = types.fs_locations_info4()
        data.fli_flags = self.unpack_uint32_t()
        data.fli_valid_for = self.unpack_int32_t()
        data.fli_fs_root = self.unpack_pathname4()
        data.fli_items = self.unpack_array(self.unpack_fs_locations_item4)
        if hasattr(self, 'filter_fs_locations_info4'):
            data = getattr(self, 'filter_fs_locations_info4')(data)
        return data

    unpack_fattr4_fs_locations_info = unpack_fs_locations_info4

    unpack_nfl_util4 = unpack_uint32_t

    def unpack_filelayout_hint_care4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.NFLH4_CARE_DENSE, const.NFLH4_CARE_COMMIT_THRU_MDS, const.NFLH4_CARE_STRIPE_UNIT_SIZE, const.NFLH4_CARE_STRIPE_COUNT]:
            raise XDRError, 'value=%s not in enum filelayout_hint_care4' % data
        if hasattr(self, 'filter_filelayout_hint_care4'):
            data = getattr(self, 'filter_filelayout_hint_care4')(data)
        return data

    def unpack_nfsv4_1_file_layouthint4(self):
        data = types.nfsv4_1_file_layouthint4()
        data.nflh_care = self.unpack_uint32_t()
        data.nflh_util = self.unpack_nfl_util4()
        data.nflh_stripe_count = self.unpack_count4()
        if hasattr(self, 'filter_nfsv4_1_file_layouthint4'):
            data = getattr(self, 'filter_nfsv4_1_file_layouthint4')(data)
        return data

    def unpack_multipath_list4(self):
        data = self.unpack_array(self.unpack_netaddr4)
        if hasattr(self, 'filter_multipath_list4'):
            data = getattr(self, 'filter_multipath_list4')(data)
        return data

    def unpack_nfsv4_1_file_layout_ds_addr4(self):
        data = types.nfsv4_1_file_layout_ds_addr4()
        data.nflda_stripe_indices = self.unpack_array(self.unpack_uint32_t)
        data.nflda_multipath_ds_list = self.unpack_array(self.unpack_multipath_list4)
        if hasattr(self, 'filter_nfsv4_1_file_layout_ds_addr4'):
            data = getattr(self, 'filter_nfsv4_1_file_layout_ds_addr4')(data)
        return data

    def unpack_nfsv4_1_file_layout4(self):
        data = types.nfsv4_1_file_layout4()
        data.nfl_deviceid = self.unpack_deviceid4()
        data.nfl_util = self.unpack_nfl_util4()
        data.nfl_first_stripe_index = self.unpack_uint32_t()
        data.nfl_pattern_offset = self.unpack_offset4()
        data.nfl_fh_list = self.unpack_array(self.unpack_nfs_fh4)
        if hasattr(self, 'filter_nfsv4_1_file_layout4'):
            data = getattr(self, 'filter_nfsv4_1_file_layout4')(data)
        return data

    def unpack_ACCESS4args(self):
        data = types.ACCESS4args()
        data.access = self.unpack_uint32_t()
        if hasattr(self, 'filter_ACCESS4args'):
            data = getattr(self, 'filter_ACCESS4args')(data)
        return data

    def unpack_ACCESS4resok(self):
        data = types.ACCESS4resok()
        data.supported = self.unpack_uint32_t()
        data.access = self.unpack_uint32_t()
        if hasattr(self, 'filter_ACCESS4resok'):
            data = getattr(self, 'filter_ACCESS4resok')(data)
        return data

    def unpack_ACCESS4res(self):
        data = types.ACCESS4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_ACCESS4resok()
        else:
            pass
        if hasattr(self, 'filter_ACCESS4res'):
            data = getattr(self, 'filter_ACCESS4res')(data)
        return data

    def unpack_CLOSE4args(self):
        data = types.CLOSE4args()
        data.seqid = self.unpack_seqid4()
        data.open_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_CLOSE4args'):
            data = getattr(self, 'filter_CLOSE4args')(data)
        return data

    def unpack_CLOSE4res(self):
        data = types.CLOSE4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.open_stateid = self.unpack_stateid4()
        else:
            pass
        if hasattr(self, 'filter_CLOSE4res'):
            data = getattr(self, 'filter_CLOSE4res')(data)
        return data

    def unpack_COMMIT4args(self):
        data = types.COMMIT4args()
        data.offset = self.unpack_offset4()
        data.count = self.unpack_count4()
        if hasattr(self, 'filter_COMMIT4args'):
            data = getattr(self, 'filter_COMMIT4args')(data)
        return data

    def unpack_COMMIT4resok(self):
        data = types.COMMIT4resok()
        data.writeverf = self.unpack_verifier4()
        if hasattr(self, 'filter_COMMIT4resok'):
            data = getattr(self, 'filter_COMMIT4resok')(data)
        return data

    def unpack_COMMIT4res(self):
        data = types.COMMIT4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_COMMIT4resok()
        else:
            pass
        if hasattr(self, 'filter_COMMIT4res'):
            data = getattr(self, 'filter_COMMIT4res')(data)
        return data

    def unpack_createtype4(self):
        data = types.createtype4()
        data.type = self.unpack_nfs_ftype4()
        if data.type == const.NF4LNK:
            data.linkdata = self.unpack_linktext4()
        elif data.type == const.NF4BLK or data.type == const.NF4CHR:
            data.devdata = self.unpack_specdata4()
        elif data.type == const.NF4SOCK or data.type == const.NF4FIFO or data.type == const.NF4DIR:
            pass
        else:
            pass
        if hasattr(self, 'filter_createtype4'):
            data = getattr(self, 'filter_createtype4')(data)
        return data

    def unpack_CREATE4args(self):
        data = types.CREATE4args()
        data.objtype = self.unpack_createtype4()
        data.objname = self.unpack_component4()
        data.createattrs = self.unpack_fattr4()
        if hasattr(self, 'filter_CREATE4args'):
            data = getattr(self, 'filter_CREATE4args')(data)
        return data

    def unpack_CREATE4resok(self):
        data = types.CREATE4resok()
        data.cinfo = self.unpack_change_info4()
        data.attrset = self.unpack_bitmap4()
        if hasattr(self, 'filter_CREATE4resok'):
            data = getattr(self, 'filter_CREATE4resok')(data)
        return data

    def unpack_CREATE4res(self):
        data = types.CREATE4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_CREATE4resok()
        else:
            pass
        if hasattr(self, 'filter_CREATE4res'):
            data = getattr(self, 'filter_CREATE4res')(data)
        return data

    def unpack_DELEGPURGE4args(self):
        data = types.DELEGPURGE4args()
        data.clientid = self.unpack_clientid4()
        if hasattr(self, 'filter_DELEGPURGE4args'):
            data = getattr(self, 'filter_DELEGPURGE4args')(data)
        return data

    def unpack_DELEGPURGE4res(self):
        data = types.DELEGPURGE4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_DELEGPURGE4res'):
            data = getattr(self, 'filter_DELEGPURGE4res')(data)
        return data

    def unpack_DELEGRETURN4args(self):
        data = types.DELEGRETURN4args()
        data.deleg_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_DELEGRETURN4args'):
            data = getattr(self, 'filter_DELEGRETURN4args')(data)
        return data

    def unpack_DELEGRETURN4res(self):
        data = types.DELEGRETURN4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_DELEGRETURN4res'):
            data = getattr(self, 'filter_DELEGRETURN4res')(data)
        return data

    def unpack_GETATTR4args(self):
        data = types.GETATTR4args()
        data.attr_request = self.unpack_bitmap4()
        if hasattr(self, 'filter_GETATTR4args'):
            data = getattr(self, 'filter_GETATTR4args')(data)
        return data

    def unpack_GETATTR4resok(self):
        data = types.GETATTR4resok()
        data.obj_attributes = self.unpack_fattr4()
        if hasattr(self, 'filter_GETATTR4resok'):
            data = getattr(self, 'filter_GETATTR4resok')(data)
        return data

    def unpack_GETATTR4res(self):
        data = types.GETATTR4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_GETATTR4resok()
        else:
            pass
        if hasattr(self, 'filter_GETATTR4res'):
            data = getattr(self, 'filter_GETATTR4res')(data)
        return data

    def unpack_GETFH4resok(self):
        data = types.GETFH4resok()
        data.object = self.unpack_nfs_fh4()
        if hasattr(self, 'filter_GETFH4resok'):
            data = getattr(self, 'filter_GETFH4resok')(data)
        return data

    def unpack_GETFH4res(self):
        data = types.GETFH4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_GETFH4resok()
        else:
            pass
        if hasattr(self, 'filter_GETFH4res'):
            data = getattr(self, 'filter_GETFH4res')(data)
        return data

    def unpack_LINK4args(self):
        data = types.LINK4args()
        data.newname = self.unpack_component4()
        if hasattr(self, 'filter_LINK4args'):
            data = getattr(self, 'filter_LINK4args')(data)
        return data

    def unpack_LINK4resok(self):
        data = types.LINK4resok()
        data.cinfo = self.unpack_change_info4()
        if hasattr(self, 'filter_LINK4resok'):
            data = getattr(self, 'filter_LINK4resok')(data)
        return data

    def unpack_LINK4res(self):
        data = types.LINK4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_LINK4resok()
        else:
            pass
        if hasattr(self, 'filter_LINK4res'):
            data = getattr(self, 'filter_LINK4res')(data)
        return data

    def unpack_open_to_lock_owner4(self):
        data = types.open_to_lock_owner4()
        data.open_seqid = self.unpack_seqid4()
        data.open_stateid = self.unpack_stateid4()
        data.lock_seqid = self.unpack_seqid4()
        data.lock_owner = self.unpack_lock_owner4()
        if hasattr(self, 'filter_open_to_lock_owner4'):
            data = getattr(self, 'filter_open_to_lock_owner4')(data)
        return data

    def unpack_exist_lock_owner4(self):
        data = types.exist_lock_owner4()
        data.lock_stateid = self.unpack_stateid4()
        data.lock_seqid = self.unpack_seqid4()
        if hasattr(self, 'filter_exist_lock_owner4'):
            data = getattr(self, 'filter_exist_lock_owner4')(data)
        return data

    def unpack_locker4(self):
        data = types.locker4()
        data.new_lock_owner = self.unpack_bool()
        if data.new_lock_owner == const.TRUE:
            data.open_owner = self.unpack_open_to_lock_owner4()
        elif data.new_lock_owner == const.FALSE:
            data.lock_owner = self.unpack_exist_lock_owner4()
        else:
            raise XDRError, 'bad switch=%s' % data.new_lock_owner
        if hasattr(self, 'filter_locker4'):
            data = getattr(self, 'filter_locker4')(data)
        return data

    def unpack_LOCK4args(self):
        data = types.LOCK4args()
        data.locktype = self.unpack_nfs_lock_type4()
        data.reclaim = self.unpack_bool()
        data.offset = self.unpack_offset4()
        data.length = self.unpack_length4()
        data.locker = self.unpack_locker4()
        if hasattr(self, 'filter_LOCK4args'):
            data = getattr(self, 'filter_LOCK4args')(data)
        return data

    def unpack_LOCK4denied(self):
        data = types.LOCK4denied()
        data.offset = self.unpack_offset4()
        data.length = self.unpack_length4()
        data.locktype = self.unpack_nfs_lock_type4()
        data.owner = self.unpack_lock_owner4()
        if hasattr(self, 'filter_LOCK4denied'):
            data = getattr(self, 'filter_LOCK4denied')(data)
        return data

    def unpack_LOCK4resok(self):
        data = types.LOCK4resok()
        data.lock_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_LOCK4resok'):
            data = getattr(self, 'filter_LOCK4resok')(data)
        return data

    def unpack_LOCK4res(self):
        data = types.LOCK4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_LOCK4resok()
        elif data.status == const.NFS4ERR_DENIED:
            data.denied = self.unpack_LOCK4denied()
        else:
            pass
        if hasattr(self, 'filter_LOCK4res'):
            data = getattr(self, 'filter_LOCK4res')(data)
        return data

    def unpack_LOCKT4args(self):
        data = types.LOCKT4args()
        data.locktype = self.unpack_nfs_lock_type4()
        data.offset = self.unpack_offset4()
        data.length = self.unpack_length4()
        data.owner = self.unpack_lock_owner4()
        if hasattr(self, 'filter_LOCKT4args'):
            data = getattr(self, 'filter_LOCKT4args')(data)
        return data

    def unpack_LOCKT4res(self):
        data = types.LOCKT4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4ERR_DENIED:
            data.denied = self.unpack_LOCK4denied()
        elif data.status == const.NFS4_OK:
            pass
        else:
            pass
        if hasattr(self, 'filter_LOCKT4res'):
            data = getattr(self, 'filter_LOCKT4res')(data)
        return data

    def unpack_LOCKU4args(self):
        data = types.LOCKU4args()
        data.locktype = self.unpack_nfs_lock_type4()
        data.seqid = self.unpack_seqid4()
        data.lock_stateid = self.unpack_stateid4()
        data.offset = self.unpack_offset4()
        data.length = self.unpack_length4()
        if hasattr(self, 'filter_LOCKU4args'):
            data = getattr(self, 'filter_LOCKU4args')(data)
        return data

    def unpack_LOCKU4res(self):
        data = types.LOCKU4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.lock_stateid = self.unpack_stateid4()
        else:
            pass
        if hasattr(self, 'filter_LOCKU4res'):
            data = getattr(self, 'filter_LOCKU4res')(data)
        return data

    def unpack_LOOKUP4args(self):
        data = types.LOOKUP4args()
        data.objname = self.unpack_component4()
        if hasattr(self, 'filter_LOOKUP4args'):
            data = getattr(self, 'filter_LOOKUP4args')(data)
        return data

    def unpack_LOOKUP4res(self):
        data = types.LOOKUP4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_LOOKUP4res'):
            data = getattr(self, 'filter_LOOKUP4res')(data)
        return data

    def unpack_LOOKUPP4res(self):
        data = types.LOOKUPP4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_LOOKUPP4res'):
            data = getattr(self, 'filter_LOOKUPP4res')(data)
        return data

    def unpack_NVERIFY4args(self):
        data = types.NVERIFY4args()
        data.obj_attributes = self.unpack_fattr4()
        if hasattr(self, 'filter_NVERIFY4args'):
            data = getattr(self, 'filter_NVERIFY4args')(data)
        return data

    def unpack_NVERIFY4res(self):
        data = types.NVERIFY4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_NVERIFY4res'):
            data = getattr(self, 'filter_NVERIFY4res')(data)
        return data

    def unpack_createmode4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.UNCHECKED4, const.GUARDED4, const.EXCLUSIVE4, const.EXCLUSIVE4_1]:
            raise XDRError, 'value=%s not in enum createmode4' % data
        if hasattr(self, 'filter_createmode4'):
            data = getattr(self, 'filter_createmode4')(data)
        return data

    def unpack_creatverfattr(self):
        data = types.creatverfattr()
        data.cva_verf = self.unpack_verifier4()
        data.cva_attrs = self.unpack_fattr4()
        if hasattr(self, 'filter_creatverfattr'):
            data = getattr(self, 'filter_creatverfattr')(data)
        return data

    def unpack_createhow4(self):
        data = types.createhow4()
        data.mode = self.unpack_createmode4()
        if data.mode == const.UNCHECKED4 or data.mode == const.GUARDED4:
            data.createattrs = self.unpack_fattr4()
        elif data.mode == const.EXCLUSIVE4:
            data.createverf = self.unpack_verifier4()
        elif data.mode == const.EXCLUSIVE4_1:
            data.ch_createboth = self.unpack_creatverfattr()
        else:
            raise XDRError, 'bad switch=%s' % data.mode
        if hasattr(self, 'filter_createhow4'):
            data = getattr(self, 'filter_createhow4')(data)
        return data

    def unpack_opentype4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.OPEN4_NOCREATE, const.OPEN4_CREATE]:
            raise XDRError, 'value=%s not in enum opentype4' % data
        if hasattr(self, 'filter_opentype4'):
            data = getattr(self, 'filter_opentype4')(data)
        return data

    def unpack_openflag4(self):
        data = types.openflag4()
        data.opentype = self.unpack_opentype4()
        if data.opentype == const.OPEN4_CREATE:
            data.how = self.unpack_createhow4()
        else:
            pass
        if hasattr(self, 'filter_openflag4'):
            data = getattr(self, 'filter_openflag4')(data)
        return data

    def unpack_limit_by4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.NFS_LIMIT_SIZE, const.NFS_LIMIT_BLOCKS]:
            raise XDRError, 'value=%s not in enum limit_by4' % data
        if hasattr(self, 'filter_limit_by4'):
            data = getattr(self, 'filter_limit_by4')(data)
        return data

    def unpack_nfs_modified_limit4(self):
        data = types.nfs_modified_limit4()
        data.num_blocks = self.unpack_uint32_t()
        data.bytes_per_block = self.unpack_uint32_t()
        if hasattr(self, 'filter_nfs_modified_limit4'):
            data = getattr(self, 'filter_nfs_modified_limit4')(data)
        return data

    def unpack_nfs_space_limit4(self):
        data = types.nfs_space_limit4()
        data.limitby = self.unpack_limit_by4()
        if data.limitby == const.NFS_LIMIT_SIZE:
            data.filesize = self.unpack_uint64_t()
        elif data.limitby == const.NFS_LIMIT_BLOCKS:
            data.mod_blocks = self.unpack_nfs_modified_limit4()
        else:
            raise XDRError, 'bad switch=%s' % data.limitby
        if hasattr(self, 'filter_nfs_space_limit4'):
            data = getattr(self, 'filter_nfs_space_limit4')(data)
        return data

    def unpack_open_delegation_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.OPEN_DELEGATE_NONE, const.OPEN_DELEGATE_READ, const.OPEN_DELEGATE_WRITE, const.OPEN_DELEGATE_NONE_EXT]:
            raise XDRError, 'value=%s not in enum open_delegation_type4' % data
        if hasattr(self, 'filter_open_delegation_type4'):
            data = getattr(self, 'filter_open_delegation_type4')(data)
        return data

    def unpack_open_claim_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.CLAIM_NULL, const.CLAIM_PREVIOUS, const.CLAIM_DELEGATE_CUR, const.CLAIM_DELEGATE_PREV, const.CLAIM_FH, const.CLAIM_DELEG_CUR_FH, const.CLAIM_DELEG_PREV_FH]:
            raise XDRError, 'value=%s not in enum open_claim_type4' % data
        if hasattr(self, 'filter_open_claim_type4'):
            data = getattr(self, 'filter_open_claim_type4')(data)
        return data

    def unpack_open_claim_delegate_cur4(self):
        data = types.open_claim_delegate_cur4()
        data.delegate_stateid = self.unpack_stateid4()
        data.file = self.unpack_component4()
        if hasattr(self, 'filter_open_claim_delegate_cur4'):
            data = getattr(self, 'filter_open_claim_delegate_cur4')(data)
        return data

    def unpack_open_claim4(self):
        data = types.open_claim4()
        data.claim = self.unpack_open_claim_type4()
        if data.claim == const.CLAIM_NULL:
            data.file = self.unpack_component4()
        elif data.claim == const.CLAIM_PREVIOUS:
            data.delegate_type = self.unpack_open_delegation_type4()
        elif data.claim == const.CLAIM_DELEGATE_CUR:
            data.delegate_cur_info = self.unpack_open_claim_delegate_cur4()
        elif data.claim == const.CLAIM_DELEGATE_PREV:
            data.file_delegate_prev = self.unpack_component4()
        elif data.claim == const.CLAIM_FH:
            pass
        elif data.claim == const.CLAIM_DELEG_PREV_FH:
            pass
        elif data.claim == const.CLAIM_DELEG_CUR_FH:
            data.oc_delegate_stateid = self.unpack_stateid4()
        else:
            raise XDRError, 'bad switch=%s' % data.claim
        if hasattr(self, 'filter_open_claim4'):
            data = getattr(self, 'filter_open_claim4')(data)
        return data

    def unpack_OPEN4args(self):
        data = types.OPEN4args()
        data.seqid = self.unpack_seqid4()
        data.share_access = self.unpack_uint32_t()
        data.share_deny = self.unpack_uint32_t()
        data.owner = self.unpack_open_owner4()
        data.openhow = self.unpack_openflag4()
        data.claim = self.unpack_open_claim4()
        if hasattr(self, 'filter_OPEN4args'):
            data = getattr(self, 'filter_OPEN4args')(data)
        return data

    def unpack_open_read_delegation4(self):
        data = types.open_read_delegation4()
        data.stateid = self.unpack_stateid4()
        data.recall = self.unpack_bool()
        data.permissions = self.unpack_nfsace4()
        if hasattr(self, 'filter_open_read_delegation4'):
            data = getattr(self, 'filter_open_read_delegation4')(data)
        return data

    def unpack_open_write_delegation4(self):
        data = types.open_write_delegation4()
        data.stateid = self.unpack_stateid4()
        data.recall = self.unpack_bool()
        data.space_limit = self.unpack_nfs_space_limit4()
        data.permissions = self.unpack_nfsace4()
        if hasattr(self, 'filter_open_write_delegation4'):
            data = getattr(self, 'filter_open_write_delegation4')(data)
        return data

    def unpack_why_no_delegation4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.WND4_NOT_WANTED, const.WND4_CONTENTION, const.WND4_RESOURCE, const.WND4_NOT_SUPP_FTYPE, const.WND4_WRITE_DELEG_NOT_SUPP_FTYPE, const.WND4_NOT_SUPP_UPGRADE, const.WND4_NOT_SUPP_DOWNGRADE, const.WND4_CANCELED, const.WND4_IS_DIR]:
            raise XDRError, 'value=%s not in enum why_no_delegation4' % data
        if hasattr(self, 'filter_why_no_delegation4'):
            data = getattr(self, 'filter_why_no_delegation4')(data)
        return data

    def unpack_open_none_delegation4(self):
        data = types.open_none_delegation4()
        data.ond_why = self.unpack_why_no_delegation4()
        if data.ond_why == const.WND4_CONTENTION:
            data.ond_server_will_push_deleg = self.unpack_bool()
        elif data.ond_why == const.WND4_RESOURCE:
            data.ond_server_will_signal_avail = self.unpack_bool()
        else:
            pass
        if hasattr(self, 'filter_open_none_delegation4'):
            data = getattr(self, 'filter_open_none_delegation4')(data)
        return data

    def unpack_open_delegation4(self):
        data = types.open_delegation4()
        data.delegation_type = self.unpack_open_delegation_type4()
        if data.delegation_type == const.OPEN_DELEGATE_NONE:
            pass
        elif data.delegation_type == const.OPEN_DELEGATE_READ:
            data.read = self.unpack_open_read_delegation4()
        elif data.delegation_type == const.OPEN_DELEGATE_WRITE:
            data.write = self.unpack_open_write_delegation4()
        elif data.delegation_type == const.OPEN_DELEGATE_NONE_EXT:
            data.od_whynone = self.unpack_open_none_delegation4()
        else:
            raise XDRError, 'bad switch=%s' % data.delegation_type
        if hasattr(self, 'filter_open_delegation4'):
            data = getattr(self, 'filter_open_delegation4')(data)
        return data

    def unpack_OPEN4resok(self):
        data = types.OPEN4resok()
        data.stateid = self.unpack_stateid4()
        data.cinfo = self.unpack_change_info4()
        data.rflags = self.unpack_uint32_t()
        data.attrset = self.unpack_bitmap4()
        data.delegation = self.unpack_open_delegation4()
        if hasattr(self, 'filter_OPEN4resok'):
            data = getattr(self, 'filter_OPEN4resok')(data)
        return data

    def unpack_OPEN4res(self):
        data = types.OPEN4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_OPEN4resok()
        else:
            pass
        if hasattr(self, 'filter_OPEN4res'):
            data = getattr(self, 'filter_OPEN4res')(data)
        return data

    def unpack_OPENATTR4args(self):
        data = types.OPENATTR4args()
        data.createdir = self.unpack_bool()
        if hasattr(self, 'filter_OPENATTR4args'):
            data = getattr(self, 'filter_OPENATTR4args')(data)
        return data

    def unpack_OPENATTR4res(self):
        data = types.OPENATTR4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_OPENATTR4res'):
            data = getattr(self, 'filter_OPENATTR4res')(data)
        return data

    def unpack_OPEN_CONFIRM4args(self):
        data = types.OPEN_CONFIRM4args()
        data.open_stateid = self.unpack_stateid4()
        data.seqid = self.unpack_seqid4()
        if hasattr(self, 'filter_OPEN_CONFIRM4args'):
            data = getattr(self, 'filter_OPEN_CONFIRM4args')(data)
        return data

    def unpack_OPEN_CONFIRM4resok(self):
        data = types.OPEN_CONFIRM4resok()
        data.open_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_OPEN_CONFIRM4resok'):
            data = getattr(self, 'filter_OPEN_CONFIRM4resok')(data)
        return data

    def unpack_OPEN_CONFIRM4res(self):
        data = types.OPEN_CONFIRM4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_OPEN_CONFIRM4resok()
        else:
            pass
        if hasattr(self, 'filter_OPEN_CONFIRM4res'):
            data = getattr(self, 'filter_OPEN_CONFIRM4res')(data)
        return data

    def unpack_OPEN_DOWNGRADE4args(self):
        data = types.OPEN_DOWNGRADE4args()
        data.open_stateid = self.unpack_stateid4()
        data.seqid = self.unpack_seqid4()
        data.share_access = self.unpack_uint32_t()
        data.share_deny = self.unpack_uint32_t()
        if hasattr(self, 'filter_OPEN_DOWNGRADE4args'):
            data = getattr(self, 'filter_OPEN_DOWNGRADE4args')(data)
        return data

    def unpack_OPEN_DOWNGRADE4resok(self):
        data = types.OPEN_DOWNGRADE4resok()
        data.open_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_OPEN_DOWNGRADE4resok'):
            data = getattr(self, 'filter_OPEN_DOWNGRADE4resok')(data)
        return data

    def unpack_OPEN_DOWNGRADE4res(self):
        data = types.OPEN_DOWNGRADE4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_OPEN_DOWNGRADE4resok()
        else:
            pass
        if hasattr(self, 'filter_OPEN_DOWNGRADE4res'):
            data = getattr(self, 'filter_OPEN_DOWNGRADE4res')(data)
        return data

    def unpack_PUTFH4args(self):
        data = types.PUTFH4args()
        data.object = self.unpack_nfs_fh4()
        if hasattr(self, 'filter_PUTFH4args'):
            data = getattr(self, 'filter_PUTFH4args')(data)
        return data

    def unpack_PUTFH4res(self):
        data = types.PUTFH4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_PUTFH4res'):
            data = getattr(self, 'filter_PUTFH4res')(data)
        return data

    def unpack_PUTPUBFH4res(self):
        data = types.PUTPUBFH4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_PUTPUBFH4res'):
            data = getattr(self, 'filter_PUTPUBFH4res')(data)
        return data

    def unpack_PUTROOTFH4res(self):
        data = types.PUTROOTFH4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_PUTROOTFH4res'):
            data = getattr(self, 'filter_PUTROOTFH4res')(data)
        return data

    def unpack_READ4args(self):
        data = types.READ4args()
        data.stateid = self.unpack_stateid4()
        data.offset = self.unpack_offset4()
        data.count = self.unpack_count4()
        if hasattr(self, 'filter_READ4args'):
            data = getattr(self, 'filter_READ4args')(data)
        return data

    def unpack_READ4resok(self):
        data = types.READ4resok()
        data.eof = self.unpack_bool()
        data.data = self.unpack_opaque()
        if hasattr(self, 'filter_READ4resok'):
            data = getattr(self, 'filter_READ4resok')(data)
        return data

    def unpack_READ4res(self):
        data = types.READ4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_READ4resok()
        else:
            pass
        if hasattr(self, 'filter_READ4res'):
            data = getattr(self, 'filter_READ4res')(data)
        return data

    def unpack_READDIR4args(self):
        data = types.READDIR4args()
        data.cookie = self.unpack_nfs_cookie4()
        data.cookieverf = self.unpack_verifier4()
        data.dircount = self.unpack_count4()
        data.maxcount = self.unpack_count4()
        data.attr_request = self.unpack_bitmap4()
        if hasattr(self, 'filter_READDIR4args'):
            data = getattr(self, 'filter_READDIR4args')(data)
        return data

    def unpack_entry4(self):
        data = types.entry4()
        data.cookie = self.unpack_nfs_cookie4()
        data.name = self.unpack_component4()
        data.attrs = self.unpack_fattr4()
        data.nextentry = self.unpack_array(self.unpack_entry4)
        if len(data.nextentry) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nextentry'
        if hasattr(self, 'filter_entry4'):
            data = getattr(self, 'filter_entry4')(data)
        return data

    def unpack_dirlist4(self):
        data = types.dirlist4()
        data.entries = self.unpack_array(self.unpack_entry4)
        if len(data.entries) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.entries'
        data.eof = self.unpack_bool()
        if hasattr(self, 'filter_dirlist4'):
            data = getattr(self, 'filter_dirlist4')(data)
        return data

    def unpack_READDIR4resok(self):
        data = types.READDIR4resok()
        data.cookieverf = self.unpack_verifier4()
        data.reply = self.unpack_dirlist4()
        if hasattr(self, 'filter_READDIR4resok'):
            data = getattr(self, 'filter_READDIR4resok')(data)
        return data

    def unpack_READDIR4res(self):
        data = types.READDIR4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_READDIR4resok()
        else:
            pass
        if hasattr(self, 'filter_READDIR4res'):
            data = getattr(self, 'filter_READDIR4res')(data)
        return data

    def unpack_READLINK4resok(self):
        data = types.READLINK4resok()
        data.link = self.unpack_linktext4()
        if hasattr(self, 'filter_READLINK4resok'):
            data = getattr(self, 'filter_READLINK4resok')(data)
        return data

    def unpack_READLINK4res(self):
        data = types.READLINK4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_READLINK4resok()
        else:
            pass
        if hasattr(self, 'filter_READLINK4res'):
            data = getattr(self, 'filter_READLINK4res')(data)
        return data

    def unpack_REMOVE4args(self):
        data = types.REMOVE4args()
        data.target = self.unpack_component4()
        if hasattr(self, 'filter_REMOVE4args'):
            data = getattr(self, 'filter_REMOVE4args')(data)
        return data

    def unpack_REMOVE4resok(self):
        data = types.REMOVE4resok()
        data.cinfo = self.unpack_change_info4()
        if hasattr(self, 'filter_REMOVE4resok'):
            data = getattr(self, 'filter_REMOVE4resok')(data)
        return data

    def unpack_REMOVE4res(self):
        data = types.REMOVE4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_REMOVE4resok()
        else:
            pass
        if hasattr(self, 'filter_REMOVE4res'):
            data = getattr(self, 'filter_REMOVE4res')(data)
        return data

    def unpack_RENAME4args(self):
        data = types.RENAME4args()
        data.oldname = self.unpack_component4()
        data.newname = self.unpack_component4()
        if hasattr(self, 'filter_RENAME4args'):
            data = getattr(self, 'filter_RENAME4args')(data)
        return data

    def unpack_RENAME4resok(self):
        data = types.RENAME4resok()
        data.source_cinfo = self.unpack_change_info4()
        data.target_cinfo = self.unpack_change_info4()
        if hasattr(self, 'filter_RENAME4resok'):
            data = getattr(self, 'filter_RENAME4resok')(data)
        return data

    def unpack_RENAME4res(self):
        data = types.RENAME4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_RENAME4resok()
        else:
            pass
        if hasattr(self, 'filter_RENAME4res'):
            data = getattr(self, 'filter_RENAME4res')(data)
        return data

    def unpack_RENEW4args(self):
        data = types.RENEW4args()
        data.clientid = self.unpack_clientid4()
        if hasattr(self, 'filter_RENEW4args'):
            data = getattr(self, 'filter_RENEW4args')(data)
        return data

    def unpack_RENEW4res(self):
        data = types.RENEW4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_RENEW4res'):
            data = getattr(self, 'filter_RENEW4res')(data)
        return data

    def unpack_RESTOREFH4res(self):
        data = types.RESTOREFH4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_RESTOREFH4res'):
            data = getattr(self, 'filter_RESTOREFH4res')(data)
        return data

    def unpack_SAVEFH4res(self):
        data = types.SAVEFH4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_SAVEFH4res'):
            data = getattr(self, 'filter_SAVEFH4res')(data)
        return data

    def unpack_SECINFO4args(self):
        data = types.SECINFO4args()
        data.name = self.unpack_component4()
        if hasattr(self, 'filter_SECINFO4args'):
            data = getattr(self, 'filter_SECINFO4args')(data)
        return data

    def unpack_rpc_gss_svc_t(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.RPC_GSS_SVC_NONE, const.RPC_GSS_SVC_INTEGRITY, const.RPC_GSS_SVC_PRIVACY]:
            raise XDRError, 'value=%s not in enum rpc_gss_svc_t' % data
        if hasattr(self, 'filter_rpc_gss_svc_t'):
            data = getattr(self, 'filter_rpc_gss_svc_t')(data)
        return data

    def unpack_rpcsec_gss_info(self):
        data = types.rpcsec_gss_info()
        data.oid = self.unpack_sec_oid4()
        data.qop = self.unpack_qop4()
        data.service = self.unpack_rpc_gss_svc_t()
        if hasattr(self, 'filter_rpcsec_gss_info'):
            data = getattr(self, 'filter_rpcsec_gss_info')(data)
        return data

    def unpack_secinfo4(self):
        data = types.secinfo4()
        data.flavor = self.unpack_uint32_t()
        if data.flavor == const.RPCSEC_GSS:
            data.flavor_info = self.unpack_rpcsec_gss_info()
        else:
            pass
        if hasattr(self, 'filter_secinfo4'):
            data = getattr(self, 'filter_secinfo4')(data)
        return data

    def unpack_SECINFO4resok(self):
        data = self.unpack_array(self.unpack_secinfo4)
        if hasattr(self, 'filter_SECINFO4resok'):
            data = getattr(self, 'filter_SECINFO4resok')(data)
        return data

    def unpack_SECINFO4res(self):
        data = types.SECINFO4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_SECINFO4resok()
        else:
            pass
        if hasattr(self, 'filter_SECINFO4res'):
            data = getattr(self, 'filter_SECINFO4res')(data)
        return data

    def unpack_SETATTR4args(self):
        data = types.SETATTR4args()
        data.stateid = self.unpack_stateid4()
        data.obj_attributes = self.unpack_fattr4()
        if hasattr(self, 'filter_SETATTR4args'):
            data = getattr(self, 'filter_SETATTR4args')(data)
        return data

    def unpack_SETATTR4res(self):
        data = types.SETATTR4res()
        data.status = self.unpack_nfsstat4()
        data.attrsset = self.unpack_bitmap4()
        if hasattr(self, 'filter_SETATTR4res'):
            data = getattr(self, 'filter_SETATTR4res')(data)
        return data

    def unpack_SETCLIENTID4args(self):
        data = types.SETCLIENTID4args()
        data.client = self.unpack_nfs_client_id4()
        data.callback = self.unpack_cb_client4()
        data.callback_ident = self.unpack_uint32_t()
        if hasattr(self, 'filter_SETCLIENTID4args'):
            data = getattr(self, 'filter_SETCLIENTID4args')(data)
        return data

    def unpack_SETCLIENTID4resok(self):
        data = types.SETCLIENTID4resok()
        data.clientid = self.unpack_clientid4()
        data.setclientid_confirm = self.unpack_verifier4()
        if hasattr(self, 'filter_SETCLIENTID4resok'):
            data = getattr(self, 'filter_SETCLIENTID4resok')(data)
        return data

    def unpack_SETCLIENTID4res(self):
        data = types.SETCLIENTID4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_SETCLIENTID4resok()
        elif data.status == const.NFS4ERR_CLID_INUSE:
            data.client_using = self.unpack_clientaddr4()
        else:
            pass
        if hasattr(self, 'filter_SETCLIENTID4res'):
            data = getattr(self, 'filter_SETCLIENTID4res')(data)
        return data

    def unpack_SETCLIENTID_CONFIRM4args(self):
        data = types.SETCLIENTID_CONFIRM4args()
        data.clientid = self.unpack_clientid4()
        data.setclientid_confirm = self.unpack_verifier4()
        if hasattr(self, 'filter_SETCLIENTID_CONFIRM4args'):
            data = getattr(self, 'filter_SETCLIENTID_CONFIRM4args')(data)
        return data

    def unpack_SETCLIENTID_CONFIRM4res(self):
        data = types.SETCLIENTID_CONFIRM4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_SETCLIENTID_CONFIRM4res'):
            data = getattr(self, 'filter_SETCLIENTID_CONFIRM4res')(data)
        return data

    def unpack_VERIFY4args(self):
        data = types.VERIFY4args()
        data.obj_attributes = self.unpack_fattr4()
        if hasattr(self, 'filter_VERIFY4args'):
            data = getattr(self, 'filter_VERIFY4args')(data)
        return data

    def unpack_VERIFY4res(self):
        data = types.VERIFY4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_VERIFY4res'):
            data = getattr(self, 'filter_VERIFY4res')(data)
        return data

    def unpack_stable_how4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.UNSTABLE4, const.DATA_SYNC4, const.FILE_SYNC4]:
            raise XDRError, 'value=%s not in enum stable_how4' % data
        if hasattr(self, 'filter_stable_how4'):
            data = getattr(self, 'filter_stable_how4')(data)
        return data

    def unpack_WRITE4args(self):
        data = types.WRITE4args()
        data.stateid = self.unpack_stateid4()
        data.offset = self.unpack_offset4()
        data.stable = self.unpack_stable_how4()
        data.data = self.unpack_opaque()
        if hasattr(self, 'filter_WRITE4args'):
            data = getattr(self, 'filter_WRITE4args')(data)
        return data

    def unpack_WRITE4resok(self):
        data = types.WRITE4resok()
        data.count = self.unpack_count4()
        data.committed = self.unpack_stable_how4()
        data.writeverf = self.unpack_verifier4()
        if hasattr(self, 'filter_WRITE4resok'):
            data = getattr(self, 'filter_WRITE4resok')(data)
        return data

    def unpack_WRITE4res(self):
        data = types.WRITE4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_WRITE4resok()
        else:
            pass
        if hasattr(self, 'filter_WRITE4res'):
            data = getattr(self, 'filter_WRITE4res')(data)
        return data

    def unpack_RELEASE_LOCKOWNER4args(self):
        data = types.RELEASE_LOCKOWNER4args()
        data.lock_owner = self.unpack_lock_owner4()
        if hasattr(self, 'filter_RELEASE_LOCKOWNER4args'):
            data = getattr(self, 'filter_RELEASE_LOCKOWNER4args')(data)
        return data

    def unpack_RELEASE_LOCKOWNER4res(self):
        data = types.RELEASE_LOCKOWNER4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_RELEASE_LOCKOWNER4res'):
            data = getattr(self, 'filter_RELEASE_LOCKOWNER4res')(data)
        return data

    def unpack_ILLEGAL4res(self):
        data = types.ILLEGAL4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_ILLEGAL4res'):
            data = getattr(self, 'filter_ILLEGAL4res')(data)
        return data

    def unpack_gsshandle4_t(self):
        data = self.unpack_opaque()
        if hasattr(self, 'filter_gsshandle4_t'):
            data = getattr(self, 'filter_gsshandle4_t')(data)
        return data

    def unpack_gss_cb_handles4(self):
        data = types.gss_cb_handles4()
        data.gcbp_service = self.unpack_rpc_gss_svc_t()
        data.gcbp_handle_from_server = self.unpack_gsshandle4_t()
        data.gcbp_handle_from_client = self.unpack_gsshandle4_t()
        if hasattr(self, 'filter_gss_cb_handles4'):
            data = getattr(self, 'filter_gss_cb_handles4')(data)
        return data

    def unpack_callback_sec_parms4(self):
        data = types.callback_sec_parms4()
        data.cb_secflavor = self.unpack_uint32_t()
        if data.cb_secflavor == const.AUTH_NONE:
            pass
        elif data.cb_secflavor == const.AUTH_SYS:
            data.cbsp_sys_cred = self.unpack_authsys_parms()
        elif data.cb_secflavor == const.RPCSEC_GSS:
            data.cbsp_gss_handles = self.unpack_gss_cb_handles4()
        else:
            raise XDRError, 'bad switch=%s' % data.cb_secflavor
        if hasattr(self, 'filter_callback_sec_parms4'):
            data = getattr(self, 'filter_callback_sec_parms4')(data)
        return data

    def unpack_BACKCHANNEL_CTL4args(self):
        data = types.BACKCHANNEL_CTL4args()
        data.bca_cb_program = self.unpack_uint32_t()
        data.bca_sec_parms = self.unpack_array(self.unpack_callback_sec_parms4)
        if hasattr(self, 'filter_BACKCHANNEL_CTL4args'):
            data = getattr(self, 'filter_BACKCHANNEL_CTL4args')(data)
        return data

    def unpack_BACKCHANNEL_CTL4res(self):
        data = types.BACKCHANNEL_CTL4res()
        data.bcr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_BACKCHANNEL_CTL4res'):
            data = getattr(self, 'filter_BACKCHANNEL_CTL4res')(data)
        return data

    def unpack_channel_dir_from_client4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.CDFC4_FORE, const.CDFC4_BACK, const.CDFC4_FORE_OR_BOTH, const.CDFC4_BACK_OR_BOTH]:
            raise XDRError, 'value=%s not in enum channel_dir_from_client4' % data
        if hasattr(self, 'filter_channel_dir_from_client4'):
            data = getattr(self, 'filter_channel_dir_from_client4')(data)
        return data

    def unpack_BIND_CONN_TO_SESSION4args(self):
        data = types.BIND_CONN_TO_SESSION4args()
        data.bctsa_sessid = self.unpack_sessionid4()
        data.bctsa_dir = self.unpack_channel_dir_from_client4()
        data.bctsa_use_conn_in_rdma_mode = self.unpack_bool()
        if hasattr(self, 'filter_BIND_CONN_TO_SESSION4args'):
            data = getattr(self, 'filter_BIND_CONN_TO_SESSION4args')(data)
        return data

    def unpack_channel_dir_from_server4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.CDFS4_FORE, const.CDFS4_BACK, const.CDFS4_BOTH]:
            raise XDRError, 'value=%s not in enum channel_dir_from_server4' % data
        if hasattr(self, 'filter_channel_dir_from_server4'):
            data = getattr(self, 'filter_channel_dir_from_server4')(data)
        return data

    def unpack_BIND_CONN_TO_SESSION4resok(self):
        data = types.BIND_CONN_TO_SESSION4resok()
        data.bctsr_sessid = self.unpack_sessionid4()
        data.bctsr_dir = self.unpack_channel_dir_from_server4()
        data.bctsr_use_conn_in_rdma_mode = self.unpack_bool()
        if hasattr(self, 'filter_BIND_CONN_TO_SESSION4resok'):
            data = getattr(self, 'filter_BIND_CONN_TO_SESSION4resok')(data)
        return data

    def unpack_BIND_CONN_TO_SESSION4res(self):
        data = types.BIND_CONN_TO_SESSION4res()
        data.bctsr_status = self.unpack_nfsstat4()
        if data.bctsr_status == const.NFS4_OK:
            data.bctsr_resok4 = self.unpack_BIND_CONN_TO_SESSION4resok()
        else:
            pass
        if hasattr(self, 'filter_BIND_CONN_TO_SESSION4res'):
            data = getattr(self, 'filter_BIND_CONN_TO_SESSION4res')(data)
        return data

    def unpack_state_protect_ops4(self):
        data = types.state_protect_ops4()
        data.spo_must_enforce = self.unpack_bitmap4()
        data.spo_must_allow = self.unpack_bitmap4()
        if hasattr(self, 'filter_state_protect_ops4'):
            data = getattr(self, 'filter_state_protect_ops4')(data)
        return data

    def unpack_ssv_sp_parms4(self):
        data = types.ssv_sp_parms4()
        data.ssp_ops = self.unpack_state_protect_ops4()
        data.ssp_hash_algs = self.unpack_array(self.unpack_sec_oid4)
        data.ssp_encr_algs = self.unpack_array(self.unpack_sec_oid4)
        data.ssp_window = self.unpack_uint32_t()
        data.ssp_num_gss_handles = self.unpack_uint32_t()
        if hasattr(self, 'filter_ssv_sp_parms4'):
            data = getattr(self, 'filter_ssv_sp_parms4')(data)
        return data

    def unpack_state_protect_how4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.SP4_NONE, const.SP4_MACH_CRED, const.SP4_SSV]:
            raise XDRError, 'value=%s not in enum state_protect_how4' % data
        if hasattr(self, 'filter_state_protect_how4'):
            data = getattr(self, 'filter_state_protect_how4')(data)
        return data

    def unpack_state_protect4_a(self):
        data = types.state_protect4_a()
        data.spa_how = self.unpack_state_protect_how4()
        if data.spa_how == const.SP4_NONE:
            pass
        elif data.spa_how == const.SP4_MACH_CRED:
            data.spa_mach_ops = self.unpack_state_protect_ops4()
        elif data.spa_how == const.SP4_SSV:
            data.spa_ssv_parms = self.unpack_ssv_sp_parms4()
        else:
            raise XDRError, 'bad switch=%s' % data.spa_how
        if hasattr(self, 'filter_state_protect4_a'):
            data = getattr(self, 'filter_state_protect4_a')(data)
        return data

    def unpack_EXCHANGE_ID4args(self):
        data = types.EXCHANGE_ID4args()
        data.eia_clientowner = self.unpack_client_owner4()
        data.eia_flags = self.unpack_uint32_t()
        data.eia_state_protect = self.unpack_state_protect4_a()
        data.eia_client_impl_id = self.unpack_array(self.unpack_nfs_impl_id4)
        if len(data.eia_client_impl_id) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.eia_client_impl_id'
        if hasattr(self, 'filter_EXCHANGE_ID4args'):
            data = getattr(self, 'filter_EXCHANGE_ID4args')(data)
        return data

    def unpack_ssv_prot_info4(self):
        data = types.ssv_prot_info4()
        data.spi_ops = self.unpack_state_protect_ops4()
        data.spi_hash_alg = self.unpack_uint32_t()
        data.spi_encr_alg = self.unpack_uint32_t()
        data.spi_ssv_len = self.unpack_uint32_t()
        data.spi_window = self.unpack_uint32_t()
        data.spi_handles = self.unpack_array(self.unpack_gsshandle4_t)
        if hasattr(self, 'filter_ssv_prot_info4'):
            data = getattr(self, 'filter_ssv_prot_info4')(data)
        return data

    def unpack_state_protect4_r(self):
        data = types.state_protect4_r()
        data.spr_how = self.unpack_state_protect_how4()
        if data.spr_how == const.SP4_NONE:
            pass
        elif data.spr_how == const.SP4_MACH_CRED:
            data.spr_mach_ops = self.unpack_state_protect_ops4()
        elif data.spr_how == const.SP4_SSV:
            data.spr_ssv_info = self.unpack_ssv_prot_info4()
        else:
            raise XDRError, 'bad switch=%s' % data.spr_how
        if hasattr(self, 'filter_state_protect4_r'):
            data = getattr(self, 'filter_state_protect4_r')(data)
        return data

    def unpack_EXCHANGE_ID4resok(self):
        data = types.EXCHANGE_ID4resok()
        data.eir_clientid = self.unpack_clientid4()
        data.eir_sequenceid = self.unpack_sequenceid4()
        data.eir_flags = self.unpack_uint32_t()
        data.eir_state_protect = self.unpack_state_protect4_r()
        data.eir_server_owner = self.unpack_server_owner4()
        data.eir_server_scope = self.unpack_opaque()
        if len(data.eir_server_scope) > const.NFS4_OPAQUE_LIMIT and self.check_array:
            raise XDRError, 'array length too long for data.eir_server_scope'
        data.eir_server_impl_id = self.unpack_array(self.unpack_nfs_impl_id4)
        if len(data.eir_server_impl_id) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.eir_server_impl_id'
        if hasattr(self, 'filter_EXCHANGE_ID4resok'):
            data = getattr(self, 'filter_EXCHANGE_ID4resok')(data)
        return data

    def unpack_EXCHANGE_ID4res(self):
        data = types.EXCHANGE_ID4res()
        data.eir_status = self.unpack_nfsstat4()
        if data.eir_status == const.NFS4_OK:
            data.eir_resok4 = self.unpack_EXCHANGE_ID4resok()
        else:
            pass
        if hasattr(self, 'filter_EXCHANGE_ID4res'):
            data = getattr(self, 'filter_EXCHANGE_ID4res')(data)
        return data

    def unpack_channel_attrs4(self):
        data = types.channel_attrs4()
        data.ca_headerpadsize = self.unpack_count4()
        data.ca_maxrequestsize = self.unpack_count4()
        data.ca_maxresponsesize = self.unpack_count4()
        data.ca_maxresponsesize_cached = self.unpack_count4()
        data.ca_maxoperations = self.unpack_count4()
        data.ca_maxrequests = self.unpack_count4()
        data.ca_rdma_ird = self.unpack_array(self.unpack_uint32_t)
        if len(data.ca_rdma_ird) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.ca_rdma_ird'
        if hasattr(self, 'filter_channel_attrs4'):
            data = getattr(self, 'filter_channel_attrs4')(data)
        return data

    def unpack_CREATE_SESSION4args(self):
        data = types.CREATE_SESSION4args()
        data.csa_clientid = self.unpack_clientid4()
        data.csa_sequence = self.unpack_sequenceid4()
        data.csa_flags = self.unpack_uint32_t()
        data.csa_fore_chan_attrs = self.unpack_channel_attrs4()
        data.csa_back_chan_attrs = self.unpack_channel_attrs4()
        data.csa_cb_program = self.unpack_uint32_t()
        data.csa_sec_parms = self.unpack_array(self.unpack_callback_sec_parms4)
        if hasattr(self, 'filter_CREATE_SESSION4args'):
            data = getattr(self, 'filter_CREATE_SESSION4args')(data)
        return data

    def unpack_CREATE_SESSION4resok(self):
        data = types.CREATE_SESSION4resok()
        data.csr_sessionid = self.unpack_sessionid4()
        data.csr_sequence = self.unpack_sequenceid4()
        data.csr_flags = self.unpack_uint32_t()
        data.csr_fore_chan_attrs = self.unpack_channel_attrs4()
        data.csr_back_chan_attrs = self.unpack_channel_attrs4()
        if hasattr(self, 'filter_CREATE_SESSION4resok'):
            data = getattr(self, 'filter_CREATE_SESSION4resok')(data)
        return data

    def unpack_CREATE_SESSION4res(self):
        data = types.CREATE_SESSION4res()
        data.csr_status = self.unpack_nfsstat4()
        if data.csr_status == const.NFS4_OK:
            data.csr_resok4 = self.unpack_CREATE_SESSION4resok()
        else:
            pass
        if hasattr(self, 'filter_CREATE_SESSION4res'):
            data = getattr(self, 'filter_CREATE_SESSION4res')(data)
        return data

    def unpack_DESTROY_SESSION4args(self):
        data = types.DESTROY_SESSION4args()
        data.dsa_sessionid = self.unpack_sessionid4()
        if hasattr(self, 'filter_DESTROY_SESSION4args'):
            data = getattr(self, 'filter_DESTROY_SESSION4args')(data)
        return data

    def unpack_DESTROY_SESSION4res(self):
        data = types.DESTROY_SESSION4res()
        data.dsr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_DESTROY_SESSION4res'):
            data = getattr(self, 'filter_DESTROY_SESSION4res')(data)
        return data

    def unpack_FREE_STATEID4args(self):
        data = types.FREE_STATEID4args()
        data.fsa_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_FREE_STATEID4args'):
            data = getattr(self, 'filter_FREE_STATEID4args')(data)
        return data

    def unpack_FREE_STATEID4res(self):
        data = types.FREE_STATEID4res()
        data.fsr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_FREE_STATEID4res'):
            data = getattr(self, 'filter_FREE_STATEID4res')(data)
        return data

    unpack_attr_notice4 = unpack_nfstime4

    def unpack_GET_DIR_DELEGATION4args(self):
        data = types.GET_DIR_DELEGATION4args()
        data.gdda_signal_deleg_avail = self.unpack_bool()
        data.gdda_notification_types = self.unpack_bitmap4()
        data.gdda_child_attr_delay = self.unpack_attr_notice4()
        data.gdda_dir_attr_delay = self.unpack_attr_notice4()
        data.gdda_child_attributes = self.unpack_bitmap4()
        data.gdda_dir_attributes = self.unpack_bitmap4()
        if hasattr(self, 'filter_GET_DIR_DELEGATION4args'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4args')(data)
        return data

    def unpack_GET_DIR_DELEGATION4resok(self):
        data = types.GET_DIR_DELEGATION4resok()
        data.gddr_cookieverf = self.unpack_verifier4()
        data.gddr_stateid = self.unpack_stateid4()
        data.gddr_notification = self.unpack_bitmap4()
        data.gddr_child_attributes = self.unpack_bitmap4()
        data.gddr_dir_attributes = self.unpack_bitmap4()
        if hasattr(self, 'filter_GET_DIR_DELEGATION4resok'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4resok')(data)
        return data

    def unpack_gddrnf4_status(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.GDD4_OK, const.GDD4_UNAVAIL]:
            raise XDRError, 'value=%s not in enum gddrnf4_status' % data
        if hasattr(self, 'filter_gddrnf4_status'):
            data = getattr(self, 'filter_gddrnf4_status')(data)
        return data

    def unpack_GET_DIR_DELEGATION4res_non_fatal(self):
        data = types.GET_DIR_DELEGATION4res_non_fatal()
        data.gddrnf_status = self.unpack_gddrnf4_status()
        if data.gddrnf_status == const.GDD4_OK:
            data.gddrnf_resok4 = self.unpack_GET_DIR_DELEGATION4resok()
        elif data.gddrnf_status == const.GDD4_UNAVAIL:
            data.gddrnf_will_signal_deleg_avail = self.unpack_bool()
        else:
            raise XDRError, 'bad switch=%s' % data.gddrnf_status
        if hasattr(self, 'filter_GET_DIR_DELEGATION4res_non_fatal'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4res_non_fatal')(data)
        return data

    def unpack_GET_DIR_DELEGATION4res(self):
        data = types.GET_DIR_DELEGATION4res()
        data.gddr_status = self.unpack_nfsstat4()
        if data.gddr_status == const.NFS4_OK:
            data.gddr_res_non_fatal4 = self.unpack_GET_DIR_DELEGATION4res_non_fatal()
        else:
            pass
        if hasattr(self, 'filter_GET_DIR_DELEGATION4res'):
            data = getattr(self, 'filter_GET_DIR_DELEGATION4res')(data)
        return data

    def unpack_GETDEVICEINFO4args(self):
        data = types.GETDEVICEINFO4args()
        data.gdia_device_id = self.unpack_deviceid4()
        data.gdia_layout_type = self.unpack_layouttype4()
        data.gdia_maxcount = self.unpack_count4()
        data.gdia_notify_types = self.unpack_bitmap4()
        if hasattr(self, 'filter_GETDEVICEINFO4args'):
            data = getattr(self, 'filter_GETDEVICEINFO4args')(data)
        return data

    def unpack_GETDEVICEINFO4resok(self):
        data = types.GETDEVICEINFO4resok()
        data.gdir_device_addr = self.unpack_device_addr4()
        data.gdir_notification = self.unpack_bitmap4()
        if hasattr(self, 'filter_GETDEVICEINFO4resok'):
            data = getattr(self, 'filter_GETDEVICEINFO4resok')(data)
        return data

    def unpack_GETDEVICEINFO4res(self):
        data = types.GETDEVICEINFO4res()
        data.gdir_status = self.unpack_nfsstat4()
        if data.gdir_status == const.NFS4_OK:
            data.gdir_resok4 = self.unpack_GETDEVICEINFO4resok()
        elif data.gdir_status == const.NFS4ERR_TOOSMALL:
            data.gdir_mincount = self.unpack_count4()
        else:
            pass
        if hasattr(self, 'filter_GETDEVICEINFO4res'):
            data = getattr(self, 'filter_GETDEVICEINFO4res')(data)
        return data

    def unpack_GETDEVICELIST4args(self):
        data = types.GETDEVICELIST4args()
        data.gdla_layout_type = self.unpack_layouttype4()
        data.gdla_maxdevices = self.unpack_count4()
        data.gdla_cookie = self.unpack_nfs_cookie4()
        data.gdla_cookieverf = self.unpack_verifier4()
        if hasattr(self, 'filter_GETDEVICELIST4args'):
            data = getattr(self, 'filter_GETDEVICELIST4args')(data)
        return data

    def unpack_GETDEVICELIST4resok(self):
        data = types.GETDEVICELIST4resok()
        data.gdlr_cookie = self.unpack_nfs_cookie4()
        data.gdlr_cookieverf = self.unpack_verifier4()
        data.gdlr_deviceid_list = self.unpack_array(self.unpack_deviceid4)
        data.gdlr_eof = self.unpack_bool()
        if hasattr(self, 'filter_GETDEVICELIST4resok'):
            data = getattr(self, 'filter_GETDEVICELIST4resok')(data)
        return data

    def unpack_GETDEVICELIST4res(self):
        data = types.GETDEVICELIST4res()
        data.gdlr_status = self.unpack_nfsstat4()
        if data.gdlr_status == const.NFS4_OK:
            data.gdlr_resok4 = self.unpack_GETDEVICELIST4resok()
        else:
            pass
        if hasattr(self, 'filter_GETDEVICELIST4res'):
            data = getattr(self, 'filter_GETDEVICELIST4res')(data)
        return data

    def unpack_newtime4(self):
        data = types.newtime4()
        data.nt_timechanged = self.unpack_bool()
        if data.nt_timechanged == const.TRUE:
            data.nt_time = self.unpack_nfstime4()
        elif data.nt_timechanged == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.nt_timechanged
        if hasattr(self, 'filter_newtime4'):
            data = getattr(self, 'filter_newtime4')(data)
        return data

    def unpack_newoffset4(self):
        data = types.newoffset4()
        data.no_newoffset = self.unpack_bool()
        if data.no_newoffset == const.TRUE:
            data.no_offset = self.unpack_offset4()
        elif data.no_newoffset == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.no_newoffset
        if hasattr(self, 'filter_newoffset4'):
            data = getattr(self, 'filter_newoffset4')(data)
        return data

    def unpack_LAYOUTCOMMIT4args(self):
        data = types.LAYOUTCOMMIT4args()
        data.loca_offset = self.unpack_offset4()
        data.loca_length = self.unpack_length4()
        data.loca_reclaim = self.unpack_bool()
        data.loca_stateid = self.unpack_stateid4()
        data.loca_last_write_offset = self.unpack_newoffset4()
        data.loca_time_modify = self.unpack_newtime4()
        data.loca_layoutupdate = self.unpack_layoutupdate4()
        if hasattr(self, 'filter_LAYOUTCOMMIT4args'):
            data = getattr(self, 'filter_LAYOUTCOMMIT4args')(data)
        return data

    def unpack_newsize4(self):
        data = types.newsize4()
        data.ns_sizechanged = self.unpack_bool()
        if data.ns_sizechanged == const.TRUE:
            data.ns_size = self.unpack_length4()
        elif data.ns_sizechanged == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.ns_sizechanged
        if hasattr(self, 'filter_newsize4'):
            data = getattr(self, 'filter_newsize4')(data)
        return data

    def unpack_LAYOUTCOMMIT4resok(self):
        data = types.LAYOUTCOMMIT4resok()
        data.locr_newsize = self.unpack_newsize4()
        if hasattr(self, 'filter_LAYOUTCOMMIT4resok'):
            data = getattr(self, 'filter_LAYOUTCOMMIT4resok')(data)
        return data

    def unpack_LAYOUTCOMMIT4res(self):
        data = types.LAYOUTCOMMIT4res()
        data.locr_status = self.unpack_nfsstat4()
        if data.locr_status == const.NFS4_OK:
            data.locr_resok4 = self.unpack_LAYOUTCOMMIT4resok()
        else:
            pass
        if hasattr(self, 'filter_LAYOUTCOMMIT4res'):
            data = getattr(self, 'filter_LAYOUTCOMMIT4res')(data)
        return data

    def unpack_LAYOUTGET4args(self):
        data = types.LAYOUTGET4args()
        data.loga_signal_layout_avail = self.unpack_bool()
        data.loga_layout_type = self.unpack_layouttype4()
        data.loga_iomode = self.unpack_layoutiomode4()
        data.loga_offset = self.unpack_offset4()
        data.loga_length = self.unpack_length4()
        data.loga_minlength = self.unpack_length4()
        data.loga_stateid = self.unpack_stateid4()
        data.loga_maxcount = self.unpack_count4()
        if hasattr(self, 'filter_LAYOUTGET4args'):
            data = getattr(self, 'filter_LAYOUTGET4args')(data)
        return data

    def unpack_LAYOUTGET4resok(self):
        data = types.LAYOUTGET4resok()
        data.logr_return_on_close = self.unpack_bool()
        data.logr_stateid = self.unpack_stateid4()
        data.logr_layout = self.unpack_array(self.unpack_layout4)
        if hasattr(self, 'filter_LAYOUTGET4resok'):
            data = getattr(self, 'filter_LAYOUTGET4resok')(data)
        return data

    def unpack_LAYOUTGET4res(self):
        data = types.LAYOUTGET4res()
        data.logr_status = self.unpack_nfsstat4()
        if data.logr_status == const.NFS4_OK:
            data.logr_resok4 = self.unpack_LAYOUTGET4resok()
        elif data.logr_status == const.NFS4ERR_LAYOUTTRYLATER:
            data.logr_will_signal_layout_avail = self.unpack_bool()
        else:
            pass
        if hasattr(self, 'filter_LAYOUTGET4res'):
            data = getattr(self, 'filter_LAYOUTGET4res')(data)
        return data

    def unpack_LAYOUTRETURN4args(self):
        data = types.LAYOUTRETURN4args()
        data.lora_reclaim = self.unpack_bool()
        data.lora_layout_type = self.unpack_layouttype4()
        data.lora_iomode = self.unpack_layoutiomode4()
        data.lora_layoutreturn = self.unpack_layoutreturn4()
        if hasattr(self, 'filter_LAYOUTRETURN4args'):
            data = getattr(self, 'filter_LAYOUTRETURN4args')(data)
        return data

    def unpack_layoutreturn_stateid(self):
        data = types.layoutreturn_stateid()
        data.lrs_present = self.unpack_bool()
        if data.lrs_present == const.TRUE:
            data.lrs_stateid = self.unpack_stateid4()
        elif data.lrs_present == const.FALSE:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.lrs_present
        if hasattr(self, 'filter_layoutreturn_stateid'):
            data = getattr(self, 'filter_layoutreturn_stateid')(data)
        return data

    def unpack_LAYOUTRETURN4res(self):
        data = types.LAYOUTRETURN4res()
        data.lorr_status = self.unpack_nfsstat4()
        if data.lorr_status == const.NFS4_OK:
            data.lorr_stateid = self.unpack_layoutreturn_stateid()
        else:
            pass
        if hasattr(self, 'filter_LAYOUTRETURN4res'):
            data = getattr(self, 'filter_LAYOUTRETURN4res')(data)
        return data

    def unpack_secinfo_style4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.SECINFO_STYLE4_CURRENT_FH, const.SECINFO_STYLE4_PARENT]:
            raise XDRError, 'value=%s not in enum secinfo_style4' % data
        if hasattr(self, 'filter_secinfo_style4'):
            data = getattr(self, 'filter_secinfo_style4')(data)
        return data

    unpack_SECINFO_NO_NAME4args = unpack_secinfo_style4

    unpack_SECINFO_NO_NAME4res = unpack_SECINFO4res

    def unpack_SEQUENCE4args(self):
        data = types.SEQUENCE4args()
        data.sa_sessionid = self.unpack_sessionid4()
        data.sa_sequenceid = self.unpack_sequenceid4()
        data.sa_slotid = self.unpack_slotid4()
        data.sa_highest_slotid = self.unpack_slotid4()
        data.sa_cachethis = self.unpack_bool()
        if hasattr(self, 'filter_SEQUENCE4args'):
            data = getattr(self, 'filter_SEQUENCE4args')(data)
        return data

    def unpack_SEQUENCE4resok(self):
        data = types.SEQUENCE4resok()
        data.sr_sessionid = self.unpack_sessionid4()
        data.sr_sequenceid = self.unpack_sequenceid4()
        data.sr_slotid = self.unpack_slotid4()
        data.sr_highest_slotid = self.unpack_slotid4()
        data.sr_target_highest_slotid = self.unpack_slotid4()
        data.sr_status_flags = self.unpack_uint32_t()
        if hasattr(self, 'filter_SEQUENCE4resok'):
            data = getattr(self, 'filter_SEQUENCE4resok')(data)
        return data

    def unpack_SEQUENCE4res(self):
        data = types.SEQUENCE4res()
        data.sr_status = self.unpack_nfsstat4()
        if data.sr_status == const.NFS4_OK:
            data.sr_resok4 = self.unpack_SEQUENCE4resok()
        else:
            pass
        if hasattr(self, 'filter_SEQUENCE4res'):
            data = getattr(self, 'filter_SEQUENCE4res')(data)
        return data

    def unpack_ssa_digest_input4(self):
        data = types.ssa_digest_input4()
        data.sdi_seqargs = self.unpack_SEQUENCE4args()
        if hasattr(self, 'filter_ssa_digest_input4'):
            data = getattr(self, 'filter_ssa_digest_input4')(data)
        return data

    def unpack_SET_SSV4args(self):
        data = types.SET_SSV4args()
        data.ssa_ssv = self.unpack_opaque()
        data.ssa_digest = self.unpack_opaque()
        if hasattr(self, 'filter_SET_SSV4args'):
            data = getattr(self, 'filter_SET_SSV4args')(data)
        return data

    def unpack_ssr_digest_input4(self):
        data = types.ssr_digest_input4()
        data.sdi_seqres = self.unpack_SEQUENCE4res()
        if hasattr(self, 'filter_ssr_digest_input4'):
            data = getattr(self, 'filter_ssr_digest_input4')(data)
        return data

    def unpack_SET_SSV4resok(self):
        data = types.SET_SSV4resok()
        data.ssr_digest = self.unpack_opaque()
        if hasattr(self, 'filter_SET_SSV4resok'):
            data = getattr(self, 'filter_SET_SSV4resok')(data)
        return data

    def unpack_SET_SSV4res(self):
        data = types.SET_SSV4res()
        data.ssr_status = self.unpack_nfsstat4()
        if data.ssr_status == const.NFS4_OK:
            data.ssr_resok4 = self.unpack_SET_SSV4resok()
        else:
            pass
        if hasattr(self, 'filter_SET_SSV4res'):
            data = getattr(self, 'filter_SET_SSV4res')(data)
        return data

    def unpack_TEST_STATEID4args(self):
        data = types.TEST_STATEID4args()
        data.ts_stateids = self.unpack_array(self.unpack_stateid4)
        if hasattr(self, 'filter_TEST_STATEID4args'):
            data = getattr(self, 'filter_TEST_STATEID4args')(data)
        return data

    def unpack_TEST_STATEID4resok(self):
        data = types.TEST_STATEID4resok()
        data.tsr_status_codes = self.unpack_array(self.unpack_nfsstat4)
        if hasattr(self, 'filter_TEST_STATEID4resok'):
            data = getattr(self, 'filter_TEST_STATEID4resok')(data)
        return data

    def unpack_TEST_STATEID4res(self):
        data = types.TEST_STATEID4res()
        data.tsr_status = self.unpack_nfsstat4()
        if data.tsr_status == const.NFS4_OK:
            data.tsr_resok4 = self.unpack_TEST_STATEID4resok()
        else:
            pass
        if hasattr(self, 'filter_TEST_STATEID4res'):
            data = getattr(self, 'filter_TEST_STATEID4res')(data)
        return data

    def unpack_deleg_claim4(self):
        data = types.deleg_claim4()
        data.dc_claim = self.unpack_open_claim_type4()
        if data.dc_claim == const.CLAIM_FH:
            pass
        elif data.dc_claim == const.CLAIM_DELEG_PREV_FH:
            pass
        elif data.dc_claim == const.CLAIM_PREVIOUS:
            data.dc_delegate_type = self.unpack_open_delegation_type4()
        else:
            raise XDRError, 'bad switch=%s' % data.dc_claim
        if hasattr(self, 'filter_deleg_claim4'):
            data = getattr(self, 'filter_deleg_claim4')(data)
        return data

    def unpack_WANT_DELEGATION4args(self):
        data = types.WANT_DELEGATION4args()
        data.wda_want = self.unpack_uint32_t()
        data.wda_claim = self.unpack_deleg_claim4()
        if hasattr(self, 'filter_WANT_DELEGATION4args'):
            data = getattr(self, 'filter_WANT_DELEGATION4args')(data)
        return data

    def unpack_WANT_DELEGATION4res(self):
        data = types.WANT_DELEGATION4res()
        data.wdr_status = self.unpack_nfsstat4()
        if data.wdr_status == const.NFS4_OK:
            data.wdr_resok4 = self.unpack_open_delegation4()
        else:
            pass
        if hasattr(self, 'filter_WANT_DELEGATION4res'):
            data = getattr(self, 'filter_WANT_DELEGATION4res')(data)
        return data

    def unpack_DESTROY_CLIENTID4args(self):
        data = types.DESTROY_CLIENTID4args()
        data.dca_clientid = self.unpack_clientid4()
        if hasattr(self, 'filter_DESTROY_CLIENTID4args'):
            data = getattr(self, 'filter_DESTROY_CLIENTID4args')(data)
        return data

    def unpack_DESTROY_CLIENTID4res(self):
        data = types.DESTROY_CLIENTID4res()
        data.dcr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_DESTROY_CLIENTID4res'):
            data = getattr(self, 'filter_DESTROY_CLIENTID4res')(data)
        return data

    def unpack_RECLAIM_COMPLETE4args(self):
        data = types.RECLAIM_COMPLETE4args()
        data.rca_one_fs = self.unpack_bool()
        if hasattr(self, 'filter_RECLAIM_COMPLETE4args'):
            data = getattr(self, 'filter_RECLAIM_COMPLETE4args')(data)
        return data

    def unpack_RECLAIM_COMPLETE4res(self):
        data = types.RECLAIM_COMPLETE4res()
        data.rcr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_RECLAIM_COMPLETE4res'):
            data = getattr(self, 'filter_RECLAIM_COMPLETE4res')(data)
        return data

    def unpack_nfs_opnum4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.OP_ACCESS, const.OP_CLOSE, const.OP_COMMIT, const.OP_CREATE, const.OP_DELEGPURGE, const.OP_DELEGRETURN, const.OP_GETATTR, const.OP_GETFH, const.OP_LINK, const.OP_LOCK, const.OP_LOCKT, const.OP_LOCKU, const.OP_LOOKUP, const.OP_LOOKUPP, const.OP_NVERIFY, const.OP_OPEN, const.OP_OPENATTR, const.OP_OPEN_CONFIRM, const.OP_OPEN_DOWNGRADE, const.OP_PUTFH, const.OP_PUTPUBFH, const.OP_PUTROOTFH, const.OP_READ, const.OP_READDIR, const.OP_READLINK, const.OP_REMOVE, const.OP_RENAME, const.OP_RENEW, const.OP_RESTOREFH, const.OP_SAVEFH, const.OP_SECINFO, const.OP_SETATTR, const.OP_SETCLIENTID, const.OP_SETCLIENTID_CONFIRM, const.OP_VERIFY, const.OP_WRITE, const.OP_RELEASE_LOCKOWNER, const.OP_BACKCHANNEL_CTL, const.OP_BIND_CONN_TO_SESSION, const.OP_EXCHANGE_ID, const.OP_CREATE_SESSION, const.OP_DESTROY_SESSION, const.OP_FREE_STATEID, const.OP_GET_DIR_DELEGATION, const.OP_GETDEVICEINFO, const.OP_GETDEVICELIST, const.OP_LAYOUTCOMMIT, const.OP_LAYOUTGET, const.OP_LAYOUTRETURN, const.OP_SECINFO_NO_NAME, const.OP_SEQUENCE, const.OP_SET_SSV, const.OP_TEST_STATEID, const.OP_WANT_DELEGATION, const.OP_DESTROY_CLIENTID, const.OP_RECLAIM_COMPLETE, const.OP_ILLEGAL]:
            raise XDRError, 'value=%s not in enum nfs_opnum4' % data
        if hasattr(self, 'filter_nfs_opnum4'):
            data = getattr(self, 'filter_nfs_opnum4')(data)
        return data

    def unpack_nfs_argop4(self):
        data = types.nfs_argop4()
        data.argop = self.unpack_nfs_opnum4()
        if data.argop == const.OP_ACCESS:
            data.opaccess = self.unpack_ACCESS4args()
        elif data.argop == const.OP_CLOSE:
            data.opclose = self.unpack_CLOSE4args()
        elif data.argop == const.OP_COMMIT:
            data.opcommit = self.unpack_COMMIT4args()
        elif data.argop == const.OP_CREATE:
            data.opcreate = self.unpack_CREATE4args()
        elif data.argop == const.OP_DELEGPURGE:
            data.opdelegpurge = self.unpack_DELEGPURGE4args()
        elif data.argop == const.OP_DELEGRETURN:
            data.opdelegreturn = self.unpack_DELEGRETURN4args()
        elif data.argop == const.OP_GETATTR:
            data.opgetattr = self.unpack_GETATTR4args()
        elif data.argop == const.OP_GETFH:
            pass
        elif data.argop == const.OP_LINK:
            data.oplink = self.unpack_LINK4args()
        elif data.argop == const.OP_LOCK:
            data.oplock = self.unpack_LOCK4args()
        elif data.argop == const.OP_LOCKT:
            data.oplockt = self.unpack_LOCKT4args()
        elif data.argop == const.OP_LOCKU:
            data.oplocku = self.unpack_LOCKU4args()
        elif data.argop == const.OP_LOOKUP:
            data.oplookup = self.unpack_LOOKUP4args()
        elif data.argop == const.OP_LOOKUPP:
            pass
        elif data.argop == const.OP_NVERIFY:
            data.opnverify = self.unpack_NVERIFY4args()
        elif data.argop == const.OP_OPEN:
            data.opopen = self.unpack_OPEN4args()
        elif data.argop == const.OP_OPENATTR:
            data.opopenattr = self.unpack_OPENATTR4args()
        elif data.argop == const.OP_OPEN_CONFIRM:
            data.opopen_confirm = self.unpack_OPEN_CONFIRM4args()
        elif data.argop == const.OP_OPEN_DOWNGRADE:
            data.opopen_downgrade = self.unpack_OPEN_DOWNGRADE4args()
        elif data.argop == const.OP_PUTFH:
            data.opputfh = self.unpack_PUTFH4args()
        elif data.argop == const.OP_PUTPUBFH:
            pass
        elif data.argop == const.OP_PUTROOTFH:
            pass
        elif data.argop == const.OP_READ:
            data.opread = self.unpack_READ4args()
        elif data.argop == const.OP_READDIR:
            data.opreaddir = self.unpack_READDIR4args()
        elif data.argop == const.OP_READLINK:
            pass
        elif data.argop == const.OP_REMOVE:
            data.opremove = self.unpack_REMOVE4args()
        elif data.argop == const.OP_RENAME:
            data.oprename = self.unpack_RENAME4args()
        elif data.argop == const.OP_RENEW:
            data.oprenew = self.unpack_RENEW4args()
        elif data.argop == const.OP_RESTOREFH:
            pass
        elif data.argop == const.OP_SAVEFH:
            pass
        elif data.argop == const.OP_SECINFO:
            data.opsecinfo = self.unpack_SECINFO4args()
        elif data.argop == const.OP_SETATTR:
            data.opsetattr = self.unpack_SETATTR4args()
        elif data.argop == const.OP_SETCLIENTID:
            data.opsetclientid = self.unpack_SETCLIENTID4args()
        elif data.argop == const.OP_SETCLIENTID_CONFIRM:
            data.opsetclientid_confirm = self.unpack_SETCLIENTID_CONFIRM4args()
        elif data.argop == const.OP_VERIFY:
            data.opverify = self.unpack_VERIFY4args()
        elif data.argop == const.OP_WRITE:
            data.opwrite = self.unpack_WRITE4args()
        elif data.argop == const.OP_RELEASE_LOCKOWNER:
            data.oprelease_lockowner = self.unpack_RELEASE_LOCKOWNER4args()
        elif data.argop == const.OP_BACKCHANNEL_CTL:
            data.opbackchannel_ctl = self.unpack_BACKCHANNEL_CTL4args()
        elif data.argop == const.OP_BIND_CONN_TO_SESSION:
            data.opbind_conn_to_session = self.unpack_BIND_CONN_TO_SESSION4args()
        elif data.argop == const.OP_EXCHANGE_ID:
            data.opexchange_id = self.unpack_EXCHANGE_ID4args()
        elif data.argop == const.OP_CREATE_SESSION:
            data.opcreate_session = self.unpack_CREATE_SESSION4args()
        elif data.argop == const.OP_DESTROY_SESSION:
            data.opdestroy_session = self.unpack_DESTROY_SESSION4args()
        elif data.argop == const.OP_FREE_STATEID:
            data.opfree_stateid = self.unpack_FREE_STATEID4args()
        elif data.argop == const.OP_GET_DIR_DELEGATION:
            data.opget_dir_delegation = self.unpack_GET_DIR_DELEGATION4args()
        elif data.argop == const.OP_GETDEVICEINFO:
            data.opgetdeviceinfo = self.unpack_GETDEVICEINFO4args()
        elif data.argop == const.OP_GETDEVICELIST:
            data.opgetdevicelist = self.unpack_GETDEVICELIST4args()
        elif data.argop == const.OP_LAYOUTCOMMIT:
            data.oplayoutcommit = self.unpack_LAYOUTCOMMIT4args()
        elif data.argop == const.OP_LAYOUTGET:
            data.oplayoutget = self.unpack_LAYOUTGET4args()
        elif data.argop == const.OP_LAYOUTRETURN:
            data.oplayoutreturn = self.unpack_LAYOUTRETURN4args()
        elif data.argop == const.OP_SECINFO_NO_NAME:
            data.opsecinfo_no_name = self.unpack_SECINFO_NO_NAME4args()
        elif data.argop == const.OP_SEQUENCE:
            data.opsequence = self.unpack_SEQUENCE4args()
        elif data.argop == const.OP_SET_SSV:
            data.opset_ssv = self.unpack_SET_SSV4args()
        elif data.argop == const.OP_TEST_STATEID:
            data.optest_stateid = self.unpack_TEST_STATEID4args()
        elif data.argop == const.OP_WANT_DELEGATION:
            data.opwant_delegation = self.unpack_WANT_DELEGATION4args()
        elif data.argop == const.OP_DESTROY_CLIENTID:
            data.opdestroy_clientid = self.unpack_DESTROY_CLIENTID4args()
        elif data.argop == const.OP_RECLAIM_COMPLETE:
            data.opreclaim_complete = self.unpack_RECLAIM_COMPLETE4args()
        elif data.argop == const.OP_ILLEGAL:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.argop
        if hasattr(self, 'filter_nfs_argop4'):
            data = getattr(self, 'filter_nfs_argop4')(data)
        return data

    def unpack_nfs_resop4(self):
        data = types.nfs_resop4()
        data.resop = self.unpack_nfs_opnum4()
        if data.resop == const.OP_ACCESS:
            data.opaccess = self.unpack_ACCESS4res()
        elif data.resop == const.OP_CLOSE:
            data.opclose = self.unpack_CLOSE4res()
        elif data.resop == const.OP_COMMIT:
            data.opcommit = self.unpack_COMMIT4res()
        elif data.resop == const.OP_CREATE:
            data.opcreate = self.unpack_CREATE4res()
        elif data.resop == const.OP_DELEGPURGE:
            data.opdelegpurge = self.unpack_DELEGPURGE4res()
        elif data.resop == const.OP_DELEGRETURN:
            data.opdelegreturn = self.unpack_DELEGRETURN4res()
        elif data.resop == const.OP_GETATTR:
            data.opgetattr = self.unpack_GETATTR4res()
        elif data.resop == const.OP_GETFH:
            data.opgetfh = self.unpack_GETFH4res()
        elif data.resop == const.OP_LINK:
            data.oplink = self.unpack_LINK4res()
        elif data.resop == const.OP_LOCK:
            data.oplock = self.unpack_LOCK4res()
        elif data.resop == const.OP_LOCKT:
            data.oplockt = self.unpack_LOCKT4res()
        elif data.resop == const.OP_LOCKU:
            data.oplocku = self.unpack_LOCKU4res()
        elif data.resop == const.OP_LOOKUP:
            data.oplookup = self.unpack_LOOKUP4res()
        elif data.resop == const.OP_LOOKUPP:
            data.oplookupp = self.unpack_LOOKUPP4res()
        elif data.resop == const.OP_NVERIFY:
            data.opnverify = self.unpack_NVERIFY4res()
        elif data.resop == const.OP_OPEN:
            data.opopen = self.unpack_OPEN4res()
        elif data.resop == const.OP_OPENATTR:
            data.opopenattr = self.unpack_OPENATTR4res()
        elif data.resop == const.OP_OPEN_CONFIRM:
            data.opopen_confirm = self.unpack_OPEN_CONFIRM4res()
        elif data.resop == const.OP_OPEN_DOWNGRADE:
            data.opopen_downgrade = self.unpack_OPEN_DOWNGRADE4res()
        elif data.resop == const.OP_PUTFH:
            data.opputfh = self.unpack_PUTFH4res()
        elif data.resop == const.OP_PUTPUBFH:
            data.opputpubfh = self.unpack_PUTPUBFH4res()
        elif data.resop == const.OP_PUTROOTFH:
            data.opputrootfh = self.unpack_PUTROOTFH4res()
        elif data.resop == const.OP_READ:
            data.opread = self.unpack_READ4res()
        elif data.resop == const.OP_READDIR:
            data.opreaddir = self.unpack_READDIR4res()
        elif data.resop == const.OP_READLINK:
            data.opreadlink = self.unpack_READLINK4res()
        elif data.resop == const.OP_REMOVE:
            data.opremove = self.unpack_REMOVE4res()
        elif data.resop == const.OP_RENAME:
            data.oprename = self.unpack_RENAME4res()
        elif data.resop == const.OP_RENEW:
            data.oprenew = self.unpack_RENEW4res()
        elif data.resop == const.OP_RESTOREFH:
            data.oprestorefh = self.unpack_RESTOREFH4res()
        elif data.resop == const.OP_SAVEFH:
            data.opsavefh = self.unpack_SAVEFH4res()
        elif data.resop == const.OP_SECINFO:
            data.opsecinfo = self.unpack_SECINFO4res()
        elif data.resop == const.OP_SETATTR:
            data.opsetattr = self.unpack_SETATTR4res()
        elif data.resop == const.OP_SETCLIENTID:
            data.opsetclientid = self.unpack_SETCLIENTID4res()
        elif data.resop == const.OP_SETCLIENTID_CONFIRM:
            data.opsetclientid_confirm = self.unpack_SETCLIENTID_CONFIRM4res()
        elif data.resop == const.OP_VERIFY:
            data.opverify = self.unpack_VERIFY4res()
        elif data.resop == const.OP_WRITE:
            data.opwrite = self.unpack_WRITE4res()
        elif data.resop == const.OP_RELEASE_LOCKOWNER:
            data.oprelease_lockowner = self.unpack_RELEASE_LOCKOWNER4res()
        elif data.resop == const.OP_BACKCHANNEL_CTL:
            data.opbackchannel_ctl = self.unpack_BACKCHANNEL_CTL4res()
        elif data.resop == const.OP_BIND_CONN_TO_SESSION:
            data.opbind_conn_to_session = self.unpack_BIND_CONN_TO_SESSION4res()
        elif data.resop == const.OP_EXCHANGE_ID:
            data.opexchange_id = self.unpack_EXCHANGE_ID4res()
        elif data.resop == const.OP_CREATE_SESSION:
            data.opcreate_session = self.unpack_CREATE_SESSION4res()
        elif data.resop == const.OP_DESTROY_SESSION:
            data.opdestroy_session = self.unpack_DESTROY_SESSION4res()
        elif data.resop == const.OP_FREE_STATEID:
            data.opfree_stateid = self.unpack_FREE_STATEID4res()
        elif data.resop == const.OP_GET_DIR_DELEGATION:
            data.opget_dir_delegation = self.unpack_GET_DIR_DELEGATION4res()
        elif data.resop == const.OP_GETDEVICEINFO:
            data.opgetdeviceinfo = self.unpack_GETDEVICEINFO4res()
        elif data.resop == const.OP_GETDEVICELIST:
            data.opgetdevicelist = self.unpack_GETDEVICELIST4res()
        elif data.resop == const.OP_LAYOUTCOMMIT:
            data.oplayoutcommit = self.unpack_LAYOUTCOMMIT4res()
        elif data.resop == const.OP_LAYOUTGET:
            data.oplayoutget = self.unpack_LAYOUTGET4res()
        elif data.resop == const.OP_LAYOUTRETURN:
            data.oplayoutreturn = self.unpack_LAYOUTRETURN4res()
        elif data.resop == const.OP_SECINFO_NO_NAME:
            data.opsecinfo_no_name = self.unpack_SECINFO_NO_NAME4res()
        elif data.resop == const.OP_SEQUENCE:
            data.opsequence = self.unpack_SEQUENCE4res()
        elif data.resop == const.OP_SET_SSV:
            data.opset_ssv = self.unpack_SET_SSV4res()
        elif data.resop == const.OP_TEST_STATEID:
            data.optest_stateid = self.unpack_TEST_STATEID4res()
        elif data.resop == const.OP_WANT_DELEGATION:
            data.opwant_delegation = self.unpack_WANT_DELEGATION4res()
        elif data.resop == const.OP_DESTROY_CLIENTID:
            data.opdestroy_clientid = self.unpack_DESTROY_CLIENTID4res()
        elif data.resop == const.OP_RECLAIM_COMPLETE:
            data.opreclaim_complete = self.unpack_RECLAIM_COMPLETE4res()
        elif data.resop == const.OP_ILLEGAL:
            data.opillegal = self.unpack_ILLEGAL4res()
        else:
            raise XDRError, 'bad switch=%s' % data.resop
        if hasattr(self, 'filter_nfs_resop4'):
            data = getattr(self, 'filter_nfs_resop4')(data)
        return data

    def unpack_COMPOUND4args(self):
        data = types.COMPOUND4args()
        data.tag = self.unpack_utf8str_cs()
        data.minorversion = self.unpack_uint32_t()
        data.argarray = self.unpack_array(self.unpack_nfs_argop4)
        if hasattr(self, 'filter_COMPOUND4args'):
            data = getattr(self, 'filter_COMPOUND4args')(data)
        return data

    def unpack_COMPOUND4res(self):
        data = types.COMPOUND4res()
        data.status = self.unpack_nfsstat4()
        data.tag = self.unpack_utf8str_cs()
        data.resarray = self.unpack_array(self.unpack_nfs_resop4)
        if hasattr(self, 'filter_COMPOUND4res'):
            data = getattr(self, 'filter_COMPOUND4res')(data)
        return data

    def unpack_CB_GETATTR4args(self):
        data = types.CB_GETATTR4args()
        data.fh = self.unpack_nfs_fh4()
        data.attr_request = self.unpack_bitmap4()
        if hasattr(self, 'filter_CB_GETATTR4args'):
            data = getattr(self, 'filter_CB_GETATTR4args')(data)
        return data

    def unpack_CB_GETATTR4resok(self):
        data = types.CB_GETATTR4resok()
        data.obj_attributes = self.unpack_fattr4()
        if hasattr(self, 'filter_CB_GETATTR4resok'):
            data = getattr(self, 'filter_CB_GETATTR4resok')(data)
        return data

    def unpack_CB_GETATTR4res(self):
        data = types.CB_GETATTR4res()
        data.status = self.unpack_nfsstat4()
        if data.status == const.NFS4_OK:
            data.resok4 = self.unpack_CB_GETATTR4resok()
        else:
            pass
        if hasattr(self, 'filter_CB_GETATTR4res'):
            data = getattr(self, 'filter_CB_GETATTR4res')(data)
        return data

    def unpack_CB_RECALL4args(self):
        data = types.CB_RECALL4args()
        data.stateid = self.unpack_stateid4()
        data.truncate = self.unpack_bool()
        data.fh = self.unpack_nfs_fh4()
        if hasattr(self, 'filter_CB_RECALL4args'):
            data = getattr(self, 'filter_CB_RECALL4args')(data)
        return data

    def unpack_CB_RECALL4res(self):
        data = types.CB_RECALL4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_RECALL4res'):
            data = getattr(self, 'filter_CB_RECALL4res')(data)
        return data

    def unpack_CB_ILLEGAL4res(self):
        data = types.CB_ILLEGAL4res()
        data.status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_ILLEGAL4res'):
            data = getattr(self, 'filter_CB_ILLEGAL4res')(data)
        return data

    def unpack_layoutrecall_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.LAYOUTRECALL4_FILE, const.LAYOUTRECALL4_FSID, const.LAYOUTRECALL4_ALL]:
            raise XDRError, 'value=%s not in enum layoutrecall_type4' % data
        if hasattr(self, 'filter_layoutrecall_type4'):
            data = getattr(self, 'filter_layoutrecall_type4')(data)
        return data

    def unpack_layoutrecall_file4(self):
        data = types.layoutrecall_file4()
        data.lor_fh = self.unpack_nfs_fh4()
        data.lor_offset = self.unpack_offset4()
        data.lor_length = self.unpack_length4()
        data.lor_stateid = self.unpack_stateid4()
        if hasattr(self, 'filter_layoutrecall_file4'):
            data = getattr(self, 'filter_layoutrecall_file4')(data)
        return data

    def unpack_layoutrecall4(self):
        data = types.layoutrecall4()
        data.lor_recalltype = self.unpack_layoutrecall_type4()
        if data.lor_recalltype == const.LAYOUTRECALL4_FILE:
            data.lor_layout = self.unpack_layoutrecall_file4()
        elif data.lor_recalltype == const.LAYOUTRECALL4_FSID:
            data.lor_fsid = self.unpack_fsid4()
        elif data.lor_recalltype == const.LAYOUTRECALL4_ALL:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.lor_recalltype
        if hasattr(self, 'filter_layoutrecall4'):
            data = getattr(self, 'filter_layoutrecall4')(data)
        return data

    def unpack_CB_LAYOUTRECALL4args(self):
        data = types.CB_LAYOUTRECALL4args()
        data.clora_type = self.unpack_layouttype4()
        data.clora_iomode = self.unpack_layoutiomode4()
        data.clora_changed = self.unpack_bool()
        data.clora_recall = self.unpack_layoutrecall4()
        if hasattr(self, 'filter_CB_LAYOUTRECALL4args'):
            data = getattr(self, 'filter_CB_LAYOUTRECALL4args')(data)
        return data

    def unpack_CB_LAYOUTRECALL4res(self):
        data = types.CB_LAYOUTRECALL4res()
        data.clorr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_LAYOUTRECALL4res'):
            data = getattr(self, 'filter_CB_LAYOUTRECALL4res')(data)
        return data

    def unpack_notify_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.NOTIFY4_CHANGE_CHILD_ATTRS, const.NOTIFY4_CHANGE_DIR_ATTRS, const.NOTIFY4_REMOVE_ENTRY, const.NOTIFY4_ADD_ENTRY, const.NOTIFY4_RENAME_ENTRY, const.NOTIFY4_CHANGE_COOKIE_VERIFIER]:
            raise XDRError, 'value=%s not in enum notify_type4' % data
        if hasattr(self, 'filter_notify_type4'):
            data = getattr(self, 'filter_notify_type4')(data)
        return data

    def unpack_notify_entry4(self):
        data = types.notify_entry4()
        data.ne_file = self.unpack_component4()
        data.ne_attrs = self.unpack_fattr4()
        if hasattr(self, 'filter_notify_entry4'):
            data = getattr(self, 'filter_notify_entry4')(data)
        return data

    def unpack_prev_entry4(self):
        data = types.prev_entry4()
        data.pe_prev_entry = self.unpack_notify_entry4()
        data.pe_prev_entry_cookie = self.unpack_nfs_cookie4()
        if hasattr(self, 'filter_prev_entry4'):
            data = getattr(self, 'filter_prev_entry4')(data)
        return data

    def unpack_notify_remove4(self):
        data = types.notify_remove4()
        data.nrm_old_entry = self.unpack_notify_entry4()
        data.nrm_old_entry_cookie = self.unpack_nfs_cookie4()
        if hasattr(self, 'filter_notify_remove4'):
            data = getattr(self, 'filter_notify_remove4')(data)
        return data

    def unpack_notify_add4(self):
        data = types.notify_add4()
        data.nad_old_entry = self.unpack_array(self.unpack_notify_remove4)
        if len(data.nad_old_entry) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nad_old_entry'
        data.nad_new_entry = self.unpack_notify_entry4()
        data.nad_new_entry_cookie = self.unpack_array(self.unpack_nfs_cookie4)
        if len(data.nad_new_entry_cookie) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nad_new_entry_cookie'
        data.nad_prev_entry = self.unpack_array(self.unpack_prev_entry4)
        if len(data.nad_prev_entry) > 1 and self.check_array:
            raise XDRError, 'array length too long for data.nad_prev_entry'
        data.nad_last_entry = self.unpack_bool()
        if hasattr(self, 'filter_notify_add4'):
            data = getattr(self, 'filter_notify_add4')(data)
        return data

    def unpack_notify_attr4(self):
        data = types.notify_attr4()
        data.na_changed_entry = self.unpack_notify_entry4()
        if hasattr(self, 'filter_notify_attr4'):
            data = getattr(self, 'filter_notify_attr4')(data)
        return data

    def unpack_notify_rename4(self):
        data = types.notify_rename4()
        data.nrn_old_entry = self.unpack_notify_remove4()
        data.nrn_new_entry = self.unpack_notify_add4()
        if hasattr(self, 'filter_notify_rename4'):
            data = getattr(self, 'filter_notify_rename4')(data)
        return data

    def unpack_notify_verifier4(self):
        data = types.notify_verifier4()
        data.nv_old_cookieverf = self.unpack_verifier4()
        data.nv_new_cookieverf = self.unpack_verifier4()
        if hasattr(self, 'filter_notify_verifier4'):
            data = getattr(self, 'filter_notify_verifier4')(data)
        return data

    def unpack_notifylist4(self):
        data = self.unpack_opaque()
        if hasattr(self, 'filter_notifylist4'):
            data = getattr(self, 'filter_notifylist4')(data)
        return data

    def unpack_notify4(self):
        data = types.notify4()
        data.notify_mask = self.unpack_bitmap4()
        data.notify_vals = self.unpack_notifylist4()
        if hasattr(self, 'filter_notify4'):
            data = getattr(self, 'filter_notify4')(data)
        return data

    def unpack_CB_NOTIFY4args(self):
        data = types.CB_NOTIFY4args()
        data.cna_stateid = self.unpack_stateid4()
        data.cna_fh = self.unpack_nfs_fh4()
        data.cna_changes = self.unpack_array(self.unpack_notify4)
        if hasattr(self, 'filter_CB_NOTIFY4args'):
            data = getattr(self, 'filter_CB_NOTIFY4args')(data)
        return data

    def unpack_CB_NOTIFY4res(self):
        data = types.CB_NOTIFY4res()
        data.cnr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_NOTIFY4res'):
            data = getattr(self, 'filter_CB_NOTIFY4res')(data)
        return data

    def unpack_CB_PUSH_DELEG4args(self):
        data = types.CB_PUSH_DELEG4args()
        data.cpda_fh = self.unpack_nfs_fh4()
        data.cpda_delegation = self.unpack_open_delegation4()
        if hasattr(self, 'filter_CB_PUSH_DELEG4args'):
            data = getattr(self, 'filter_CB_PUSH_DELEG4args')(data)
        return data

    def unpack_CB_PUSH_DELEG4res(self):
        data = types.CB_PUSH_DELEG4res()
        data.cpdr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_PUSH_DELEG4res'):
            data = getattr(self, 'filter_CB_PUSH_DELEG4res')(data)
        return data

    def unpack_CB_RECALL_ANY4args(self):
        data = types.CB_RECALL_ANY4args()
        data.craa_objects_to_keep = self.unpack_uint32_t()
        data.craa_type_mask = self.unpack_bitmap4()
        if hasattr(self, 'filter_CB_RECALL_ANY4args'):
            data = getattr(self, 'filter_CB_RECALL_ANY4args')(data)
        return data

    def unpack_CB_RECALL_ANY4res(self):
        data = types.CB_RECALL_ANY4res()
        data.crar_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_RECALL_ANY4res'):
            data = getattr(self, 'filter_CB_RECALL_ANY4res')(data)
        return data

    unpack_CB_RECALLABLE_OBJ_AVAIL4args = unpack_CB_RECALL_ANY4args

    def unpack_CB_RECALLABLE_OBJ_AVAIL4res(self):
        data = types.CB_RECALLABLE_OBJ_AVAIL4res()
        data.croa_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_RECALLABLE_OBJ_AVAIL4res'):
            data = getattr(self, 'filter_CB_RECALLABLE_OBJ_AVAIL4res')(data)
        return data

    def unpack_CB_RECALL_SLOT4args(self):
        data = types.CB_RECALL_SLOT4args()
        data.rsa_target_highest_slotid = self.unpack_slotid4()
        if hasattr(self, 'filter_CB_RECALL_SLOT4args'):
            data = getattr(self, 'filter_CB_RECALL_SLOT4args')(data)
        return data

    def unpack_CB_RECALL_SLOT4res(self):
        data = types.CB_RECALL_SLOT4res()
        data.rsr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_RECALL_SLOT4res'):
            data = getattr(self, 'filter_CB_RECALL_SLOT4res')(data)
        return data

    def unpack_referring_call4(self):
        data = types.referring_call4()
        data.rc_sequenceid = self.unpack_sequenceid4()
        data.rc_slotid = self.unpack_slotid4()
        if hasattr(self, 'filter_referring_call4'):
            data = getattr(self, 'filter_referring_call4')(data)
        return data

    def unpack_referring_call_list4(self):
        data = types.referring_call_list4()
        data.rcl_sessionid = self.unpack_sessionid4()
        data.rcl_referring_calls = self.unpack_array(self.unpack_referring_call4)
        if hasattr(self, 'filter_referring_call_list4'):
            data = getattr(self, 'filter_referring_call_list4')(data)
        return data

    def unpack_CB_SEQUENCE4args(self):
        data = types.CB_SEQUENCE4args()
        data.csa_sessionid = self.unpack_sessionid4()
        data.csa_sequenceid = self.unpack_sequenceid4()
        data.csa_slotid = self.unpack_slotid4()
        data.csa_highest_slotid = self.unpack_slotid4()
        data.csa_cachethis = self.unpack_bool()
        data.csa_referring_call_lists = self.unpack_array(self.unpack_referring_call_list4)
        if hasattr(self, 'filter_CB_SEQUENCE4args'):
            data = getattr(self, 'filter_CB_SEQUENCE4args')(data)
        return data

    def unpack_CB_SEQUENCE4resok(self):
        data = types.CB_SEQUENCE4resok()
        data.csr_sessionid = self.unpack_sessionid4()
        data.csr_sequenceid = self.unpack_sequenceid4()
        data.csr_slotid = self.unpack_slotid4()
        data.csr_highest_slotid = self.unpack_slotid4()
        data.csr_target_highest_slotid = self.unpack_slotid4()
        if hasattr(self, 'filter_CB_SEQUENCE4resok'):
            data = getattr(self, 'filter_CB_SEQUENCE4resok')(data)
        return data

    def unpack_CB_SEQUENCE4res(self):
        data = types.CB_SEQUENCE4res()
        data.csr_status = self.unpack_nfsstat4()
        if data.csr_status == const.NFS4_OK:
            data.csr_resok4 = self.unpack_CB_SEQUENCE4resok()
        else:
            pass
        if hasattr(self, 'filter_CB_SEQUENCE4res'):
            data = getattr(self, 'filter_CB_SEQUENCE4res')(data)
        return data

    def unpack_CB_WANTS_CANCELLED4args(self):
        data = types.CB_WANTS_CANCELLED4args()
        data.cwca_contended_wants_cancelled = self.unpack_bool()
        data.cwca_resourced_wants_cancelled = self.unpack_bool()
        if hasattr(self, 'filter_CB_WANTS_CANCELLED4args'):
            data = getattr(self, 'filter_CB_WANTS_CANCELLED4args')(data)
        return data

    def unpack_CB_WANTS_CANCELLED4res(self):
        data = types.CB_WANTS_CANCELLED4res()
        data.cwcr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_WANTS_CANCELLED4res'):
            data = getattr(self, 'filter_CB_WANTS_CANCELLED4res')(data)
        return data

    def unpack_CB_NOTIFY_LOCK4args(self):
        data = types.CB_NOTIFY_LOCK4args()
        data.cnla_fh = self.unpack_nfs_fh4()
        data.cnla_lock_owner = self.unpack_lock_owner4()
        if hasattr(self, 'filter_CB_NOTIFY_LOCK4args'):
            data = getattr(self, 'filter_CB_NOTIFY_LOCK4args')(data)
        return data

    def unpack_CB_NOTIFY_LOCK4res(self):
        data = types.CB_NOTIFY_LOCK4res()
        data.cnlr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_NOTIFY_LOCK4res'):
            data = getattr(self, 'filter_CB_NOTIFY_LOCK4res')(data)
        return data

    def unpack_notify_deviceid_type4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.NOTIFY_DEVICEID4_CHANGE, const.NOTIFY_DEVICEID4_DELETE]:
            raise XDRError, 'value=%s not in enum notify_deviceid_type4' % data
        if hasattr(self, 'filter_notify_deviceid_type4'):
            data = getattr(self, 'filter_notify_deviceid_type4')(data)
        return data

    def unpack_notify_deviceid_delete4(self):
        data = types.notify_deviceid_delete4()
        data.ndd_layouttype = self.unpack_layouttype4()
        data.ndd_deviceid = self.unpack_deviceid4()
        if hasattr(self, 'filter_notify_deviceid_delete4'):
            data = getattr(self, 'filter_notify_deviceid_delete4')(data)
        return data

    def unpack_notify_deviceid_change4(self):
        data = types.notify_deviceid_change4()
        data.ndc_layouttype = self.unpack_layouttype4()
        data.ndc_deviceid = self.unpack_deviceid4()
        data.ndc_immediate = self.unpack_bool()
        if hasattr(self, 'filter_notify_deviceid_change4'):
            data = getattr(self, 'filter_notify_deviceid_change4')(data)
        return data

    def unpack_CB_NOTIFY_DEVICEID4args(self):
        data = types.CB_NOTIFY_DEVICEID4args()
        data.cnda_changes = self.unpack_array(self.unpack_notify4)
        if hasattr(self, 'filter_CB_NOTIFY_DEVICEID4args'):
            data = getattr(self, 'filter_CB_NOTIFY_DEVICEID4args')(data)
        return data

    def unpack_CB_NOTIFY_DEVICEID4res(self):
        data = types.CB_NOTIFY_DEVICEID4res()
        data.cndr_status = self.unpack_nfsstat4()
        if hasattr(self, 'filter_CB_NOTIFY_DEVICEID4res'):
            data = getattr(self, 'filter_CB_NOTIFY_DEVICEID4res')(data)
        return data

    def unpack_nfs_cb_opnum4(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.OP_CB_GETATTR, const.OP_CB_RECALL, const.OP_CB_LAYOUTRECALL, const.OP_CB_NOTIFY, const.OP_CB_PUSH_DELEG, const.OP_CB_RECALL_ANY, const.OP_CB_RECALLABLE_OBJ_AVAIL, const.OP_CB_RECALL_SLOT, const.OP_CB_SEQUENCE, const.OP_CB_WANTS_CANCELLED, const.OP_CB_NOTIFY_LOCK, const.OP_CB_NOTIFY_DEVICEID, const.OP_CB_ILLEGAL]:
            raise XDRError, 'value=%s not in enum nfs_cb_opnum4' % data
        if hasattr(self, 'filter_nfs_cb_opnum4'):
            data = getattr(self, 'filter_nfs_cb_opnum4')(data)
        return data

    def unpack_nfs_cb_argop4(self):
        data = types.nfs_cb_argop4()
        data.argop = self.unpack_nfs_cb_opnum4()
        if data.argop == const.OP_CB_GETATTR:
            data.opcbgetattr = self.unpack_CB_GETATTR4args()
        elif data.argop == const.OP_CB_RECALL:
            data.opcbrecall = self.unpack_CB_RECALL4args()
        elif data.argop == const.OP_CB_LAYOUTRECALL:
            data.opcblayoutrecall = self.unpack_CB_LAYOUTRECALL4args()
        elif data.argop == const.OP_CB_NOTIFY:
            data.opcbnotify = self.unpack_CB_NOTIFY4args()
        elif data.argop == const.OP_CB_PUSH_DELEG:
            data.opcbpush_deleg = self.unpack_CB_PUSH_DELEG4args()
        elif data.argop == const.OP_CB_RECALL_ANY:
            data.opcbrecall_any = self.unpack_CB_RECALL_ANY4args()
        elif data.argop == const.OP_CB_RECALLABLE_OBJ_AVAIL:
            data.opcbrecallable_obj_avail = self.unpack_CB_RECALLABLE_OBJ_AVAIL4args()
        elif data.argop == const.OP_CB_RECALL_SLOT:
            data.opcbrecall_slot = self.unpack_CB_RECALL_SLOT4args()
        elif data.argop == const.OP_CB_SEQUENCE:
            data.opcbsequence = self.unpack_CB_SEQUENCE4args()
        elif data.argop == const.OP_CB_WANTS_CANCELLED:
            data.opcbwants_cancelled = self.unpack_CB_WANTS_CANCELLED4args()
        elif data.argop == const.OP_CB_NOTIFY_LOCK:
            data.opcbnotify_lock = self.unpack_CB_NOTIFY_LOCK4args()
        elif data.argop == const.OP_CB_NOTIFY_DEVICEID:
            data.opcbnotify_deviceid = self.unpack_CB_NOTIFY_DEVICEID4args()
        elif data.argop == const.OP_CB_ILLEGAL:
            pass
        else:
            raise XDRError, 'bad switch=%s' % data.argop
        if hasattr(self, 'filter_nfs_cb_argop4'):
            data = getattr(self, 'filter_nfs_cb_argop4')(data)
        return data

    def unpack_nfs_cb_resop4(self):
        data = types.nfs_cb_resop4()
        data.resop = self.unpack_nfs_cb_opnum4()
        if data.resop == const.OP_CB_GETATTR:
            data.opcbgetattr = self.unpack_CB_GETATTR4res()
        elif data.resop == const.OP_CB_RECALL:
            data.opcbrecall = self.unpack_CB_RECALL4res()
        elif data.resop == const.OP_CB_LAYOUTRECALL:
            data.opcblayoutrecall = self.unpack_CB_LAYOUTRECALL4res()
        elif data.resop == const.OP_CB_NOTIFY:
            data.opcbnotify = self.unpack_CB_NOTIFY4res()
        elif data.resop == const.OP_CB_PUSH_DELEG:
            data.opcbpush_deleg = self.unpack_CB_PUSH_DELEG4res()
        elif data.resop == const.OP_CB_RECALL_ANY:
            data.opcbrecall_any = self.unpack_CB_RECALL_ANY4res()
        elif data.resop == const.OP_CB_RECALLABLE_OBJ_AVAIL:
            data.opcbrecallable_obj_avail = self.unpack_CB_RECALLABLE_OBJ_AVAIL4res()
        elif data.resop == const.OP_CB_RECALL_SLOT:
            data.opcbrecall_slot = self.unpack_CB_RECALL_SLOT4res()
        elif data.resop == const.OP_CB_SEQUENCE:
            data.opcbsequence = self.unpack_CB_SEQUENCE4res()
        elif data.resop == const.OP_CB_WANTS_CANCELLED:
            data.opcbwants_cancelled = self.unpack_CB_WANTS_CANCELLED4res()
        elif data.resop == const.OP_CB_NOTIFY_LOCK:
            data.opcbnotify_lock = self.unpack_CB_NOTIFY_LOCK4res()
        elif data.resop == const.OP_CB_NOTIFY_DEVICEID:
            data.opcbnotify_deviceid = self.unpack_CB_NOTIFY_DEVICEID4res()
        elif data.resop == const.OP_CB_ILLEGAL:
            data.opcbillegal = self.unpack_CB_ILLEGAL4res()
        else:
            raise XDRError, 'bad switch=%s' % data.resop
        if hasattr(self, 'filter_nfs_cb_resop4'):
            data = getattr(self, 'filter_nfs_cb_resop4')(data)
        return data

    def unpack_CB_COMPOUND4args(self):
        data = types.CB_COMPOUND4args()
        data.tag = self.unpack_utf8str_cs()
        data.minorversion = self.unpack_uint32_t()
        data.callback_ident = self.unpack_uint32_t()
        data.argarray = self.unpack_array(self.unpack_nfs_cb_argop4)
        if hasattr(self, 'filter_CB_COMPOUND4args'):
            data = getattr(self, 'filter_CB_COMPOUND4args')(data)
        return data

    def unpack_CB_COMPOUND4res(self):
        data = types.CB_COMPOUND4res()
        data.status = self.unpack_nfsstat4()
        data.tag = self.unpack_utf8str_cs()
        data.resarray = self.unpack_array(self.unpack_nfs_cb_resop4)
        if hasattr(self, 'filter_CB_COMPOUND4res'):
            data = getattr(self, 'filter_CB_COMPOUND4res')(data)
        return data

