/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import org.glite.lb.Sources;

public class SeqCode {
    public static final int NORMAL = 1;
    public static final int DUPLICATE = 11;
    public static final int PBS = 2;
    public static final int CONDOR = 4;
    public static final int CREAM = 4;
    public static final int CREAMWMS = 5;
    private int[] seqCode = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int type = 0;
    private String cream_code;

    public SeqCode() {
    }

    public SeqCode(int n, String string) {
        this.getSeqCodeFromString(n, string);
    }

    public void incrementSeqCode(Sources sources) {
        int n = sources.source;
        switch (this.type) {
            case 1: 
            case 11: {
                if (sources == null) {
                    throw new IllegalArgumentException("SeqCode part");
                }
                int n2 = n - 1;
                this.seqCode[n2] = this.seqCode[n2] + 1;
                break;
            }
            case 5: {
                if (sources == null) {
                    throw new IllegalArgumentException("SeqCode part");
                }
                int n3 = 7 - 1;
                this.seqCode[n3] = this.seqCode[n3] + 1000;
                break;
            }
        }
    }

    public void getSeqCodeFromString(int n, String string) {
        switch (n) {
            case 1: 
            case 5: 
            case 11: {
                if (!string.matches("UI=\\d{1,}:NS=\\d{1,}:WM=\\d{1,}:BH=\\d{1,}:JSS=\\d{1,}:LM=\\d{1,}:LRMS=\\d{1,}:APP=\\d{1,}:LBS=\\d{1,}")) {
                    throw new IllegalArgumentException("this is not correct sequence code: " + string);
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i <= 8; ++i) {
                    n3 = string.indexOf(61, n2);
                    n4 = i == 8 ? string.length() : string.indexOf(58, n2);
                    this.seqCode[i] = new Integer(string.substring(n3 + 1, n4));
                    n2 = n4 + 1;
                }
                break;
            }
            case 4: {
                this.cream_code = string;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported seqcode type " + n);
            }
        }
        this.type = n;
    }

    public String toString() {
        switch (this.type) {
            case 1: 
            case 5: 
            case 11: {
                String string = Integer.toString(this.seqCode[0]);
                String string2 = "UI=";
                string2 = string2 + "000000".substring(0, 6 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "NS=";
                string = Integer.toString(this.seqCode[1]);
                string2 = string2 + "0000000000".substring(0, 10 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "WM=";
                string = Integer.toString(this.seqCode[2]);
                string2 = string2 + "0000000000".substring(0, 6 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "BH=";
                string = Integer.toString(this.seqCode[3]);
                string2 = string2 + "0000000000".substring(0, 10 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "JSS=";
                string = Integer.toString(this.seqCode[4]);
                string2 = string2 + "0000000000".substring(0, 6 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "LM=";
                string = Integer.toString(this.seqCode[5]);
                string2 = string2 + "0000000000".substring(0, 6 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "LRMS=";
                string = Integer.toString(this.seqCode[6]);
                string2 = string2 + "0000000000".substring(0, 6 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "APP=";
                string = Integer.toString(this.seqCode[7]);
                string2 = string2 + "0000000000".substring(0, 6 - string.length()) + string;
                string2 = string2 + ":";
                string2 = string2 + "LBS=";
                string = Integer.toString(this.seqCode[8]);
                string2 = string2 + "0000000000".substring(0, 6 - string.length()) + string;
                return string2;
            }
            case 4: {
                return this.cream_code;
            }
        }
        throw new IllegalArgumentException("unitialized seqcode");
    }
}

