/*
Copyright (c) Members of the EGEE Collaboration. 2004-2010.
See http://www.eu-egee.org/partners for details on the copyright holders.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#ifndef GLITE_LB_JOBSTATUS_HPP
#define GLITE_LB_JOBSTATUS_HPP

/*

  !! Automatically generated file
  !! Do not edit, your changes will be discarded upon build
  !! Change the corresponding template file ./interface/JobStatus.h.T

*/


#include <sys/time.h>
#include <string>
#include <utility>
#include <vector>

#include "glite/jobid/JobId.h"

#include "glite/lb/jobstat.h"
#include "glite/lb/CountRef.h"

EWL_BEGIN_NAMESPACE;

/** Class representing status of job.
 * 
 * This class is used to represent all information about the job status
 * as computed and stored in the bookkeeping server's database. Job
 * status is, like Event, list of attribute -- value pairs. One of the
 * attributes is the job's state as seen by the L&B, ie. something
 * like <tt>RUNNING</tt> or  * <tt>DONE</tt>, other attributes contain
 * more information about the job.
 *
 * The JobStatus class provides methods for reading values of these
 * attributes and it is used as a result of server queries.
 */
class JobStatus {
	friend class Job;
	friend class CountRef<JobStatus>;
public:

	/** Symbolic names of job states. */
	enum Code {
		UNDEF = 0,	/**< Indicates invalid, i.e. uninitialized instance. */
		SUBMITTED,	/**< Entered by the user to the User Interface or registered by Job Partitioner. */
		WAITING,	/**< Accepted by WMS, waiting for resource allocation. */
		READY,	/**< Matching resources found. */
		SCHEDULED,	/**< Accepted by LRMS queue. */
		RUNNING,	/**< Executable is running. */
		DONE,	/**< Execution finished, output is available. */
		CLEARED,	/**< Output transfered back to user and freed. */
		ABORTED,	/**< Aborted by system (at any stage). */
		CANCELLED,	/**< Cancelled by user. */
		UNKNOWN,	/**< Status cannot be determined. */
		PURGED,	/**< Job has been purged from bookkeeping server (for LB-RGMA interface). */
		CODE_MAX /**< Limit for range checking. */
	};

	/** Symbolic names of attributes.
	 *
	 * These constants are used for naming individual attributes
	 * when invoking their access methods.
	 */
	enum Attr {
	/** List of access rights (human readable variant of acl) */
		ACCESS_RIGHTS = 95,
	/** ACL of the job */
		ACL = 0,
	/** Reason of cancel */
		CANCEL_REASON = 1,
	/** Cancellation request in progress */
		CANCELLING = 2,
	/** Worker node where the job is executed */
		CE_NODE = 3,
	/** list of subjob IDs */
		CHILDREN = 4,
	/** summary (histogram) of children job states */
		CHILDREN_HIST = 5,
	/** number of subjobs */
		CHILDREN_NUM = 6,
	/** full status information of the children */
		CHILDREN_STATES = 7,
	/** Id within Condor-G */
		CONDOR_ID = 8,
	/** Hostname of node where job is running */
		CONDOR_DEST_HOST = 9,
	/** Glued error descriptions from error events */
		CONDOR_ERROR_DESC = 10,
	/** ClassAd passed to Condor-G for last job execution */
		CONDOR_JDL = 11,
	/** Job exit status */
		CONDOR_JOB_EXIT_STATUS = 12,
	/** PID of running job */
		CONDOR_JOB_PID = 13,
	/** Job owner */
		CONDOR_OWNER = 14,
	/** Job preempting */
		CONDOR_PREEMPTING = 15,
	/** Glued reasons/errors leading to pending events */
		CONDOR_REASON = 16,
	/** Condor shadow exit status (see h/exit.h) */
		CONDOR_SHADOW_EXIT_STATUS = 17,
	/** PID of Shadow */
		CONDOR_SHADOW_PID = 18,
	/** Condor starter exit status */
		CONDOR_STARTER_EXIT_STATUS = 19,
	/** PID of Starter */
		CONDOR_STARTER_PID = 20,
	/** Condor job status  */
		CONDOR_STATUS = 21,
	/** Condor job Universe (in job ClassAds) */
		CONDOR_UNIVERSE = 22,
	/** Consumed CPU time */
		CPU_TIME = 23,
	/** Cancellation request in process */
		CREAM_CANCELLING = 74,
	/** Consumed CPU time */
		CREAM_CPU_TIME = 75,
	/** Job done code, uses done_code enum */
		CREAM_DONE_CODE = 76,
	/** Address of the CREAM service */
		CREAM_ENDPOINT = 77,
	/** Job exit code */
		CREAM_EXIT_CODE = 78,
	/** Reason of any failure */
		CREAM_FAILURE_REASON = 92,
	/** CREAM local job id */
		CREAM_ID = 93,
	/** JDL passed to the CREAM */
		CREAM_JDL = 79,
	/** Users jw_status enum */
		CREAM_JW_STATUS = 80,
	/** LRMS local id */
		CREAM_LRMS_ID = 81,
	/** Worker node where the job is executed */
		CREAM_NODE = 82,
	/** Job owner */
		CREAM_OWNER = 83,
	/** Reason of the state or command */
		CREAM_REASON = 84,
	/** CREAM job state */
		CREAM_STATE = 85,
	/** ID of CE where the job is being sent */
		DESTINATION = 24,
	/** Return code */
		DONE_CODE = 25,
	/** Unix exit code */
		EXIT_CODE = 26,
	/** Sources of the missing information */
		EXPECT_FROM = 27,
	/** Some logged information has not arrived yet */
		EXPECT_UPDATE = 28,
	/** Concatenated job failure reasons, possibly from deeper middleware layers */
		FAILURE_REASONS = 29,
	/** Compute job corresponding to file transfer */
		FT_COMPUTE_JOB = 86,
	/** File transfer destination */
		FT_DEST = 89,
	/** Type of sandbox */
		FT_SANDBOX_TYPE = 87,
	/** File transfer source */
		FT_SRC = 88,
	/** Globus allocated Id */
		GLOBUS_ID = 30,
	/** Job history. */
		HISTORY = 96,
	/** Input sandbox corresponding to the job */
		ISB_TRANSFER = 90,
	/** User submitted job description */
		JDL = 31,
	/** Unparsed JDL classad */
		JDL_CLASSAD = 72,
	/** Id of the job */
		JOB_ID = 32,
	/** Type of job */
		JOBTYPE = 33,
	/** Status of Job wrapper */
		JW_STATUS = 71,
	/** Last known event of the job */
		LAST_UPDATE_TIME = 34,
	/** Id within LRMS */
		LOCAL_ID = 35,
	/** Where the job is being processed */
		LOCATION = 36,
	/** Full job description after matchmaking */
		MATCHED_JDL = 37,
	/** Network server handling the job */
		NETWORK_SERVER = 38,
	/** Output sandbox corresponding to the job */
		OSB_TRANSFER = 91,
	/** Job owner */
		OWNER = 39,
	/** parent job of subjob */
		PARENT_JOB = 40,
	/** Owner of the actual job payload (e.g., for pilot jobs) */
		PAYLOAD_OWNER = 94,
	/** User payload started */
		PAYLOAD_RUNNING = 41,
	/** Hostname of node where job is running */
		PBS_DEST_HOST = 42,
	/** Glued error descriptions from error events */
		PBS_ERROR_DESC = 43,
	/** Job exit status */
		PBS_EXIT_STATUS = 44,
	/** Name of job */
		PBS_NAME = 45,
	/** Owner of job */
		PBS_OWNER = 46,
	/** PID of running job */
		PBS_PID = 47,
	/** Name of queue in which is job queued */
		PBS_QUEUE = 48,
	/** Glued reasons/errors leading to pending events */
		PBS_REASON = 49,
	/** Resources requested */
		PBS_RESOURCE_REQUESTED = 50,
	/** Resource usage */
		PBS_RESOURCE_USAGE = 52,
	/** Name of pbs scheduler */
		PBS_SCHEDULER = 53,
	/** Job state which would probably return PBS qstat (Q/R/C/....) */
		PBS_STATE = 54,
	/** Job substate */
		PBS_SUBSTATE = 51,
	/** CE nodes matching to possible_destinations */
		POSSIBLE_CE_NODES = 55,
	/** Possible job destinations */
		POSSIBLE_DESTINATIONS = 56,
	/** Reason of being in this status, if any */
		REASON = 57,
	/** Job reached final status and may be removed from proxy */
		REMOVE_FROM_PROXY = 67,
	/** The job was resubmitted */
		RESUBMITTED = 58,
	/** Job RSL sent to Globus */
		RSL = 59,
	/** Flag is set on incomming Clear event */
		SANDBOX_RETRIEVED = 70,
	/** string used for generation of subjob IDs */
		SEED = 60,
	/** When entered this status */
		STATE_ENTER_TIME = 61,
	/** When all previous states were entered */
		STATE_ENTER_TIMES = 62,
	/** Subjob failed (the parent job will fail too) */
		SUBJOB_FAILED = 63,
	/** Reason for the suspend */
		SUSPEND_REASON = 64,
	/** Job is suspended */
		SUSPENDED = 65,
	/** Hostname or address of UI used to submit the job */
		UI_HOST = 68,
	/** FQAN used to register the job */
		USER_FQANS = 69,
	/** List of pairs (user_tag, user_value) */
		USER_TAGS = 66,
	/** VM hostname */
		VM_HOSTNAME = 97,
	/** VM id */
		VM_ID = 103,
	/** VM image */
		VM_IMAGE = 98,
	/** physical machine on which VM runs */
		VM_MACHINE = 99,
	/** name of the VM manager */
		VM_MANAGER = 107,
	/** VM name */
		VM_NAME = 104,
	/** hostname of physical machine running VM */
		VM_PHY_HOSTNAME = 105,
	/** VM requirement on physical machine */
		VM_REQUIRE = 100,
	/** VM job state */
		VM_STATE = 101,
	/** system is shooting down */
		VM_SYSTEM_HALTING = 106,
	/** VM usage */
		VM_USAGE = 102,
		ATTR_MAX = 108 /**< Limit for range checking. */
	};

	enum {
		CREAM_STATE_CREAM_REGISTERED,	/**< registered */
		CREAM_STATE_CREAM_PENDING,	/**< pending */
		CREAM_STATE_CREAM_IDLE,	/**< idle */
		CREAM_STATE_CREAM_RUNNING,	/**< running */
		CREAM_STATE_CREAM_REALLY_RUNNING,	/**< really-running */
		CREAM_STATE_CREAM_HELD,	/**< held */
		CREAM_STATE_CREAM_DONE_OK,	/**< done-ok */
		CREAM_STATE_CREAM_DONE_FAILED,	/**< done-failed */
		CREAM_STATE_CREAM_ABORTED,	/**< aborted */
		CREAM_STATE_CREAM_CANCELLED,	/**< cancelled */
		CREAM_STATE_CREAM_PURGED,	/**< purged */
	};
	enum {
		JW_STATUS_UNKNOWN,	/**< Status of JW unknown */
		JW_STATUS_WRAPPER_RUNNING,	/**< Wrapper started */
		JW_STATUS_PAYLOAD_RUNNING,	/**< Payload running */
		JW_STATUS_DONE,	/**< JW finished */
	};
	enum {
		VM_STATE_VM_PENDING,	/**< pending */
		VM_STATE_VM_BOOT,	/**< boot */
		VM_STATE_VM_RUNNING,	/**< running */
		VM_STATE_VM_REALLY_RUNNING,	/**< really running */
		VM_STATE_VM_SHUTDOWN,	/**< shutdown */
		VM_STATE_VM_STOPPED,	/**< stopped */
		VM_STATE_VM_DONE,	/**< done */
		VM_STATE_VM_FAILURE,	/**< failure */
	};
	enum {
		DONE_CODE_OK,	/**< Finished correctly */
		DONE_CODE_FAILED,	/**< Execution failed */
		DONE_CODE_CANCELLED,	/**< Cancelled by user */
	};
	enum {
		FT_SANDBOX_TYPE_INPUT,	/**< input */
		FT_SANDBOX_TYPE_OUTPUT,	/**< output */
	};
	enum {
		JOBTYPE_SIMPLE,	/**< simple job */
		JOBTYPE_DAG,	/**< composite job */
		JOBTYPE__PARTITIONABLE_UNUSED,	/**< placholder for unused code */
		JOBTYPE__PARTITIONED_UNUSED,	/**< placholder for unused code */
		JOBTYPE_COLLECTION,	/**< parent of collection of jobs */
		JOBTYPE_PBS,	/**< PBS job */
		JOBTYPE_CONDOR,	/**< Condor job */
		JOBTYPE_CREAM,	/**< CREAM job */
		JOBTYPE_FILE_TRANSFER_COLLECTION,	/**< job containing all file transfers (i.e. sandbox) */
		JOBTYPE_FILE_TRANSFER,	/**< subjob holding one file transfer */
		JOBTYPE_VIRTUAL_MACHINE,	/**< job representing virtual machine */
	};
	enum {
		SANDBOX_RETRIEVED_NOTYET,	/**< Sandbox was not retrieved yet. */
		SANDBOX_RETRIEVED_USER,	/**< User retrieved output sandbox. */
		SANDBOX_RETRIEVED_TIMEOUT,	/**< Timed out, resource forced purge of the sandbox. */
		SANDBOX_RETRIEVED_NOOUTPUT,	/**< No output was generated. */
	};
	/** Symbolic names of attribute types.
	 *
	 * These constants are used to name the various attribute
	 * types.
	 */
	enum AttrType { INT_T, /**< Integer type. */
			STRING_T, /**< String type. */
			TIMEVAL_T, /**< <tt>struct timeval</tt> type. */
			BOOL_T, /**< Boolean type (true or false). */
			JOBID_T, /**< Job id type. */
			INTLIST_T, /**< List of integer values. */
			STRLIST_T, /**< List of string values. */
			TAGLIST_T, /**< List of user tags. */
			STSLIST_T,  /**< List of states. */
			CCLASSAD_T /**< Unparsed classad */
	};
  
	/** Numeric status code. 
	 *
	 * This code represents the state of the job.
	 * \see Code.
	 */
	Code	status;
  
	/** Get state name.
	 *
	 * Returns string representation of the job's state.
	 */
	const std::string & name(void) const;
  
	/** Access method for attribute values.
	 *
	 * Retrieve integer value of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	int	getValInt(Attr name) const;
  
	/** Access method for attribute values.
	 *
	 * Retrieve string value of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	std::string getValString(Attr name) const;
  
	/** Access method for attribute values.
	 *
	 * Retrieve <tt>struct timeval</tt>  value of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	struct timeval	getValTime(Attr name) const;
  
	/** Access method for attribute values.
	 *
	 * Retrieve JobId value of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	const glite::jobid::JobId  getValJobId(Attr name) const;

	/** Access method for attribute values.
	 *
	 * Retrieve <tt>bool</tt> value of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	bool getValBool(Attr name) const;

	/** Access method for attribute values.
	 *
	 * Retrieve integer values of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	const std::vector<int> getValIntList(Attr name) const;

	/** Access method for attribute values.
	 *
	 * Retrieve string values of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	const std::vector<std::string> getValStringList(Attr name) const;

	/** Access method for attribute values.
	 *
	 * Retrieve user tags values of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	const std::vector<std::pair<std::string,std::string> > getValTagList(Attr name) const;

	/** Access method for attribute values.
	 *
	 * Retrieve status values of named attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Value of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	const std::vector<JobStatus> getValJobStatusList(Attr name) const;

	/** Get name of attribute.
	 *
	 * Retrieve string representation of symbolic name of attribute.
	 * \param[in] name Symbolic name of attribute.
	 * \returns Name of attribute.
	 * \throws LoggingException Invalid attribute name.
	 */
	static const std::string& getAttrName(Attr name);

	/** Find attribute by name (case insensitive)
	 * \param[in] name String name.
	 * \returns enum attr value.
	 * \throws LoggingException Invalid attribute name.
	 */
	static Attr attrByName(std::string const &);
  
	/** List of attributes and their types valid for this
	 * instance.
	 *
	 * Returns the vector of (attribute, attribute type) pairs
	 * that this instance of JobStatus contains. 
	 * \returns List of attributes.
	 */
	const std::vector<std::pair<Attr,AttrType> >& getAttrs(void) const;

	/** Get name of state.
	 *
	 * Retrieve string representation of symbolic job state.
	 * \param[in] state Symbolic state name.
	 * \returns String state name.
	 * \throw Exception Invalid state.
	 *
	 */
	static const std::string &getStateName(Code state);
  
	/** Default constructor.
	 *
	 * Initializes an empty instance.
	 */
	JobStatus(void);

        /** Copy constructor.
	 *
	 * Creates identical copy of the original object.
	 * The underlying C struct edg_wll_JobStatus is shared using
	 * the CountRef mechanism.
	 * \param[in] orig Original.
	 */
	JobStatus(const JobStatus &orig);

	/** Assignment operator.
	 *
	 * Creates identical copy of the original object.
	 * The underlying C struct edg_wll_JobStatus is shared using
	 * the CountRef mechanism.
	 * \param[in] orig Original.
	 */
	JobStatus & operator=(const JobStatus &orig);

        /** Constructor from the C type.
	 *
	 * Encapsulates the given struct.
	 * \param[in] src C struct that holds the status.
	 * \param[in] destroy destroy src after use.
	 */
	JobStatus(const edg_wll_JobStat &src,int destroy = 1);

        /** Assignment from the C type.
	 *
	 * Encapsulates the given struct.
	 * \param[in] src C struct that holds the status.
	 */
	JobStatus & operator=(const edg_wll_JobStat& src);

        /** Destructor.
	 *
	 * Releases the encapsulated C struct.
	 */
	virtual ~JobStatus();

protected:
	edg_wll_JobStat *c_ptr(void);

private:
	static void	destroyFlesh(void *);
	CountRef<JobStatus> *flesh;
};

EWL_END_NAMESPACE;

#endif /* GLITE_LB_JOBSTATUS_HPP */
