#ifndef GLITE_LB_EVENT_HPP
#define GLITE_LB_EVENT_HPP


#ident "$Header: /cvs/glite/org.glite.lb.client/interface/Event.h.T,v 1.6 2012/05/16 07:54:03 mvocu Exp $"
/*
Copyright (c) Members of the EGEE Collaboration. 2004-2010.
See http://www.eu-egee.org/partners for details on the copyright holders.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/


/** @file Event.h
 *  @version $Revision: 1.6 $
 */

/*

  !! Automatically generated file
  !! Do not edit, your changes will be discarded upon build
  !! Change the corresponding template file ./interface/Event.h.T

*/

#include <utility>
#include <vector>
#include <string>

#include "glite/jobid/JobId.h"

#ifdef BUILDING_LB_COMMON
#include "CountRef.h"
#include "events.h"
#include "notifid.h"
#else
#include "glite/lb/CountRef.h"
#include "glite/lb/events.h"
#include "glite/lb/notifid.h"
#endif

EWL_BEGIN_NAMESPACE

/** Class representing one event in the L&B database.
 *
 * This class represents a L&B event, which is basically list of
 * attribute -- value pairs. For each particular event type (returned
 * by name()) there is a list of allowed attributes (returned by
 * getAttrs()). The Event class provides methods for reading these
 * attributes, but no means of changing the 
 * event are provided; this class is used as a result of L&B queries.
 */
class Event {
	friend class Job;
	friend class ServerConnection;
	friend class CountRef<Event>;
public:
	/** Event type codes
	 * identify which of the event fields are valid.
	 */
	enum Type {
		UNDEF = 0, /**< Undefined event type. */
		TRANSFER = EDG_WLL_EVENT_TRANSFER,	/**< Start, success, or failure of job transfer to another component. */
		ACCEPTED = EDG_WLL_EVENT_ACCEPTED,	/**< Accepting job (successful counterpart to Transfer). */
		REFUSED = EDG_WLL_EVENT_REFUSED,	/**< Refusing job (unsuccessful counterpart to Transfer). */
		ENQUEUED = EDG_WLL_EVENT_ENQUEUED,	/**< The job has been enqueued in an inter-component queue. */
		DEQUEUED = EDG_WLL_EVENT_DEQUEUED,	/**< The job has been dequeued from an inter-component queue. */
		HELPERCALL = EDG_WLL_EVENT_HELPERCALL,	/**< Helper component is called. */
		HELPERRETURN = EDG_WLL_EVENT_HELPERRETURN,	/**< Helper component is returning the control. */
		RUNNING = EDG_WLL_EVENT_RUNNING,	/**< Job wrapper started. */
		RESUBMISSION = EDG_WLL_EVENT_RESUBMISSION,	/**< Result of resubmission decision. */
		DONE = EDG_WLL_EVENT_DONE,	/**< Execution terminated (normally or abnormally). */
		CANCEL = EDG_WLL_EVENT_CANCEL,	/**< Cancel operation has been attempted on the job. */
		ABORT = EDG_WLL_EVENT_ABORT,	/**< Job aborted by system. */
		CLEAR = EDG_WLL_EVENT_CLEAR,	/**< Job cleared, output sandbox removed */
		PURGE = EDG_WLL_EVENT_PURGE,	/**< Job is purged from bookkepping server. */
		MATCH = EDG_WLL_EVENT_MATCH,	/**< Matching CE found. */
		PENDING = EDG_WLL_EVENT_PENDING,	/**< No matching CE found yet. */
		REGJOB = EDG_WLL_EVENT_REGJOB,	/**< New job registration. */
		CHKPT = EDG_WLL_EVENT_CHKPT,	/**< Application-specific checkpoint record. */
		LISTENER = EDG_WLL_EVENT_LISTENER,	/**< Listening network port for interactive control. */
		CURDESCR = EDG_WLL_EVENT_CURDESCR,	/**< Current state of job processing (optional event). */
		USERTAG = EDG_WLL_EVENT_USERTAG,	/**< User tag -- arbitrary name=value pair. */
		CHANGEACL = EDG_WLL_EVENT_CHANGEACL,	/**< Management of ACL stored on bookkepping server. */
		NOTIFICATION = EDG_WLL_EVENT_NOTIFICATION,	/**< Management of notification service. */
		RESOURCEUSAGE = EDG_WLL_EVENT_RESOURCEUSAGE,	/**< Resource (CPU, memory etc.) consumption. */
		REALLYRUNNING = EDG_WLL_EVENT_REALLYRUNNING,	/**< User payload started. */
		SUSPEND = EDG_WLL_EVENT_SUSPEND,	/**< Job execution (queuing) was suspended. */
		RESUME = EDG_WLL_EVENT_RESUME,	/**< Job execution (queuing) was resumed. */
		COLLECTIONSTATE = EDG_WLL_EVENT_COLLECTIONSTATE,	/**< State of the collection. */
		GRANTPAYLOADOWNERSHIP = EDG_WLL_EVENT_GRANTPAYLOADOWNERSHIP,	/**< Hand over ownership of actual job payload (e.g. of a pilot job) */
		TAKEPAYLOADOWNERSHIP = EDG_WLL_EVENT_TAKEPAYLOADOWNERSHIP,	/**< Take over ownership of actual job payload */
		CONNECTJOB = EDG_WLL_EVENT_CONNECTJOB,	/**< Connect two jobs */
		DISCONNECTJOB = EDG_WLL_EVENT_DISCONNECTJOB,	/**< Disconnect two jobs */
		PBSINTERNALSTATECHANGE = EDG_WLL_EVENT_PBSINTERNALSTATECHANGE,	/**< Change of internal PBS job state */
		PBSTRANSFER = EDG_WLL_EVENT_PBSTRANSFER,	/**< Start, success, or failure of job transfer to another component. */
		PBSACCEPTED = EDG_WLL_EVENT_PBSACCEPTED,	/**< Accepting job (successful counterpart to Transfer). */
		PBSREFUSED = EDG_WLL_EVENT_PBSREFUSED,	/**< Refusing job (unsuccessful counterpart to Transfer). */
		PBSQUEUED = EDG_WLL_EVENT_PBSQUEUED,	/**< Job enqued */
		PBSDEQUEUED = EDG_WLL_EVENT_PBSDEQUEUED,	/**< Job dequeued */
		PBSMATCH = EDG_WLL_EVENT_PBSMATCH,	/**< Scheduler created exec host */
		PBSPENDING = EDG_WLL_EVENT_PBSPENDING,	/**< Scheduler is not able to find exec host, or some error occured */
		PBSWAITING = EDG_WLL_EVENT_PBSWAITING,	/**< Job is waiting for some condition */
		PBSRUN = EDG_WLL_EVENT_PBSRUN,	/**< Job attempted to be run by the logging component */
		PBSRERUN = EDG_WLL_EVENT_PBSRERUN,	/**< Job rerun requested */
		PBSABORT = EDG_WLL_EVENT_PBSABORT,	/**< Job aborted */
		PBSDONE = EDG_WLL_EVENT_PBSDONE,	/**< Job terminated */
		PBSRESOURCEUSAGE = EDG_WLL_EVENT_PBSRESOURCEUSAGE,	/**< Resources requested/consumed */
		PBSERROR = EDG_WLL_EVENT_PBSERROR,	/**< Any error occured */
		CONDORMATCH = EDG_WLL_EVENT_CONDORMATCH,	/**< Job MATCHed */
		CONDORREJECT = EDG_WLL_EVENT_CONDORREJECT,	/**< Job REJECTed */
		CONDORSHADOWSTARTED = EDG_WLL_EVENT_CONDORSHADOWSTARTED,	/**< Condor Shadow Started */
		CONDORSHADOWEXITED = EDG_WLL_EVENT_CONDORSHADOWEXITED,	/**< Condor Shadow Exited */
		CONDORSTARTERSTARTED = EDG_WLL_EVENT_CONDORSTARTERSTARTED,	/**< Condor Starter Started */
		CONDORSTARTEREXITED = EDG_WLL_EVENT_CONDORSTARTEREXITED,	/**< Condor Starter Exited */
		CONDORRESOURCEUSAGE = EDG_WLL_EVENT_CONDORRESOURCEUSAGE,	/**< Resources requested/consumed */
		CONDORERROR = EDG_WLL_EVENT_CONDORERROR,	/**< Any Error occured */
		CREAMSTART = EDG_WLL_EVENT_CREAMSTART,	/**< Start processing registered job */
		CREAMPURGE = EDG_WLL_EVENT_CREAMPURGE,	/**< Purge request (by user) */
		CREAMACCEPTED = EDG_WLL_EVENT_CREAMACCEPTED,	/**< Accepting job (successful counterpart to Transfer). */
		CREAMSTORE = EDG_WLL_EVENT_CREAMSTORE,	/**<  */
		CREAMCALL = EDG_WLL_EVENT_CREAMCALL,	/**< Processing command and calling BLAH or LRMS */
		CREAMRUNNING = EDG_WLL_EVENT_CREAMRUNNING,	/**<  */
		CREAMREALLYRUNNING = EDG_WLL_EVENT_CREAMREALLYRUNNING,	/**<  */
		CREAMDONE = EDG_WLL_EVENT_CREAMDONE,	/**<  */
		CREAMCANCEL = EDG_WLL_EVENT_CREAMCANCEL,	/**<  */
		CREAMABORT = EDG_WLL_EVENT_CREAMABORT,	/**<  */
		CREAMSTATUS = EDG_WLL_EVENT_CREAMSTATUS,	/**<  */
		CREAMSUSPEND = EDG_WLL_EVENT_CREAMSUSPEND,	/**< Job execution (queuing) was suspended. */
		CREAMRESUME = EDG_WLL_EVENT_CREAMRESUME,	/**< Job execution (queuing) was resumed. */
		FILETRANSFERREGISTER = EDG_WLL_EVENT_FILETRANSFERREGISTER,	/**< register file transfer */
		FILETRANSFER = EDG_WLL_EVENT_FILETRANSFER,	/**< transfer job logs progress */
		SANDBOX = EDG_WLL_EVENT_SANDBOX,	/**< event for logging relationship between (compute) job and (file) transfer job */
		VMCREATE = EDG_WLL_EVENT_VMCREATE,	/**< create (register) virtual machine */
		VMHOST = EDG_WLL_EVENT_VMHOST,	/**<  */
		VMIMAGE = EDG_WLL_EVENT_VMIMAGE,	/**<  */
		VMRUNNING = EDG_WLL_EVENT_VMRUNNING,	/**< VM is running */
		VMSHUTDOWN = EDG_WLL_EVENT_VMSHUTDOWN,	/**<  */
		VMSTOP = EDG_WLL_EVENT_VMSTOP,	/**<  */
		VMRESUME = EDG_WLL_EVENT_VMRESUME,	/**<  */
		VMDONE = EDG_WLL_EVENT_VMDONE,	/**<  */
		TYPE_MAX = EDG_WLL_EVENT__LAST /**< Limit for checking type validity. */
	};

	/** Event attribute symbolic identifier. 
	 * These symbols provide symbolic names for event
	 * attributes. In braces are shown the event types for which the
	 * attribute is defined, for each event type the attribute
	 * meaning is described.
	 */
	enum Attr {
	/**
	 * \n[CREAMStatus] jobId from the LRMS
	 */
		LRMS_JOBID = 92,
	/**
	 * \n[common] Time the event was stored into the bookkeeping server database.
	 */
		ARRIVED = 0,
	/**
	 * \n[CREAMCall] Called component
	 */
		CALLEE = 81,
	/**
	 * \n[CollectionState] JobId of subjob, which triggered the state change.	
	 */
		CHILD = 1,
	/**
	 * \n[CollectionState] Event which triggered the state change.	
	 */
		CHILD_EVENT = 2,
	/**
	 * \n[Chkpt] Application specific checkpoint value.
	 */
		CLASSAD = 3,
	/**
	 * \n[CREAMCall] Id of the command, as stored previously
	 * \n[CREAMStore] Id of the command in store
	 */
		CMDID = 80,
	/**
	 * \n[CREAMCall] Command to store
	 * \n[CREAMStore] Command to store
	 */
		COMMAND = 79,
	/**
	 * \n[Sandbox] Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
	 */
		COMPUTE_JOB = 90,
	/**
	 * \n[CREAMStatus] More detailed description
	 * \n[CurDescr] Description of the current job transformation (output of the helper).
	 */
		DESCR = 4,
	/**
	 * \n[FileTransferRegister] Destination of file transfer.
	 */
		DEST = 87,
	/**
	 * \n[CondorMatch] Matched host
	 * \n[Notification] Hostname the notification is sent to.
	 * \n[PBSMatch] Aka exec host
	 * \n[PBSRun] Where to run the job
	 * \n[Transfer] Hostname of server that takes over control of the job.
	 */
		DEST_HOST = 5,
	/**
	 * \n[Match] Identification of the queue on the CE that the job could be send to.
	 */
		DEST_ID = 6,
	/**
	 * \n[PBSTransfer] Service (instance) that takes over control of the job.
	 * \n[Transfer] Service (instance) that takes over control of the job.
	 */
		DEST_INSTANCE = 7,
	/**
	 * \n[ConnectJob] ID of connected job
	 * \n[DisconnectJob] ID of connected job
	 * \n[PBSTransfer] Job id as assigned by the receiving software component.
	 * \n[Transfer] Job id as assigned by the receiving software component.
	 */
		DEST_JOBID = 8,
	/**
	 * \n[Notification] Port number the notification is sent to.
	 */
		DEST_PORT = 9,
	/**
	 * \n[Notification] Destination URL (preferred over host and port).
	 */
		DEST_URL = 91,
	/**
	 * \n[CREAMCall] Destination ID
	 */
		DESTID = 82,
	/**
	 * \n[PBSTransfer] Destination where the job is being transfered to.
	 * \n[Transfer] Destination where the job is being transfered to.
	 */
		DESTINATION = 10,
	/**
	 * \n[CollectionState] In case of (state == Done) contains done code 
	 */
		DONE_CODE = 11,
	/**
	 * \n[CondorError] Error reason
	 * \n[PBSError] Error reason
	 */
		ERROR_DESC = 12,
	/**
	 * \n[CREAMDone] Exit code
	 * \n[CREAMStatus] Exit code
	 * \n[Done] Exit code of the job's process.
	 */
		EXIT_CODE = 13,
	/**
	 * \n[PBSDone] Exit status
	 */
		EXIT_STATUS = 14,
	/**
	 * \n[Notification] When the notification expires
	 */
		EXPIRES = 78,
	/**
	 * \n[CREAMStatus] Reason for the failure
	 */
		FAILURE_REASON = 94,
	/**
	 * \n[Accepted] The software component  the job was received from.
	 * \n[PBSAccepted] The software component  the job was received from.
	 * \n[PBSRefused] The software component that tried to send the job.
	 * \n[Refused] The software component that tried to send the job.
	 */
		FROM = 15,
	/**
	 * \n[Accepted] Hostname of the component the job was received from.
	 * \n[Refused] Hostname of the component that tried to send the job.
	 */
		FROM_HOST = 16,
	/**
	 * \n[Accepted] Instance of the component the job was received from.
	 * \n[PBSAccepted] Instance of the component the job was received from.
	 * \n[PBSRefused] Instance of the component that tried to send the job.
	 * \n[Refused] Instance of the component that tried to send the job.
	 */
		FROM_INSTANCE = 17,
	/**
	 * \n[HelperCall] Name of the called helper component.
	 * \n[HelperReturn] Name of the called helper component.
	 */
		HELPER_NAME = 18,
	/**
	 * \n[HelperCall] Parameters of the call to the helper component.
	 */
		HELPER_PARAMS = 19,
	/**
	 * \n[CollectionState] User readable histogram; useful for debugging.
	 */
		HISTOGRAM = 20,
	/**
	 * \n[common] Hostname of the machine where the event was generated.
	 */
		HOST = 21,
	/**
	 * \n[VMCreate] hostname of VM
	 * \n[VMHost] hostname of physical machine of VM
	 */
		HOSTNAME = 104,
	/**
	 * \n[VMCreate] machine id
	 */
		ID = 105,
	/**
	 * \n[VMCreate] machine image
	 * \n[VMImage] machine image
	 */
		IMAGE = 102,
	/**
	 * \n[RegJob] Job description of the job being registered.
	 */
		JDL = 22,
	/**
	 * \n[EnQueued] Job description in the receiver's language.
	 * \n[Transfer] Job description in receiver's language.
	 */
		JOB = 23,
	/**
	 * \n[common] Grid job id of the job the event belongs to.
	 */
		JOBID = 24,
	/**
	 * \n[CondorStarterExited] Job exit status
	 */
		JOB_EXIT_STATUS = 25,
	/**
	 * \n[CondorStarterExited] PID of running job
	 */
		JOB_PID = 26,
	/**
	 * \n[Notification] Status of the job (the notification content).
	 */
		JOBSTAT = 27,
	/**
	 * \n[ConnectJob] Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.).
	 * \n[RegJob] Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.).
	 */
		JOBTYPE = 28,
	/**
	 * \n[common] Logging level (in the range from DEBUG to EMERGENCY).
	 */
		LEVEL = 29,
	/**
	 * \n[Accepted] New job id as assigned by the receiving component.
	 * \n[CREAMAccepted] New job id as assigned by the receiving component.
	 * \n[DeQueued] New job id as assigned by the retreiving component.
	 * \n[PBSAccepted] New job id as assigned by the receiving component.
	 */
		LOCAL_JOBID = 30,
	/**
	 * \n[VMCreate] VM manager
	 */
		MANAGER = 106,
	/**
	 * \n[CondorResourceUsage] Name of resource
	 * \n[PBSQueued] Job name
	 * \n[UserTag] Arbitrary user tag name.
	 * \n[VMCreate] machine name
	 */
		NAME = 31,
	/**
	 * \n[CREAMStatus] New status
	 */
		NEW_STATE = 83,
	/**
	 * \n[PBSInternalStateChange] 
	 */
		NEWSTATE = 99,
	/**
	 * \n[PBSInternalStateChange] 
	 */
		NEWSUBSTATE = 100,
	/**
	 * \n[CREAMRunning] Node where CREAM job is running
	 * \n[Running] Worker node on which the job executable is being run.
	 */
		NODE = 32,
	/**
	 * \n[Notification] Notification id.
	 */
		NOTIFID = 33,
	/**
	 * \n[RegJob] NetworkServer/CE endpoint etc. handling the newly registered job.
	 */
		NS = 34,
	/**
	 * \n[RegJob] Number of subjobs this job plans to spawn.
	 */
		NSUBJOBS = 35,
	/**
	 * \n[CREAMStatus] Old status
	 */
		OLD_STATE = 84,
	/**
	 * \n[PBSInternalStateChange] 
	 */
		OLDSTATE = 97,
	/**
	 * \n[PBSInternalStateChange] 
	 */
		OLDSUBSTATE = 98,
	/**
	 * \n[ChangeACL] Operation requested to perform with ACL.
	 */
		OPERATION = 36,
	/**
	 * \n[CREAMStatus] Original timestamp of the job state change
	 */
		ORIG_TIMESTAMP = 85,
	/**
	 * \n[CondorMatch] Owner
	 * \n[CondorReject] Owner
	 * \n[Notification] Identification of the job owner (certificate subject).
	 * \n[PBSQueued] Job owner
	 * \n[VMCreate] machine owner
	 */
		OWNER = 37,
	/**
	 * \n[RegJob] Grid job id of the parent job registering this new one.
	 */
		PARENT = 38,
	/**
	 * \n[GrantPayloadOwnership] Identity (certificate subject) of the payload owner.
	 */
		PAYLOAD_OWNER = 96,
	/**
	 * \n[ChangeACL] ACL permission to change.
	 */
		PERMISSION = 39,
	/**
	 * \n[ChangeACL] Type of permission requested.
	 */
		PERMISSION_TYPE = 40,
	/**
	 * \n[PBSRun] Actual process ID
	 */
		PID = 41,
	/**
	 * \n[CondorMatch] Preempting
	 */
		PREEMPTING = 42,
	/**
	 * \n[common] Message priority (yet 0 for asynchronous and 1 for synchronous transfers).
	 */
		PRIORITY = 43,
	/**
	 * \n[CondorResourceUsage] The quantity
	 * \n[ResourceUsage] Resources's quantity (how much).
	 */
		QUANTITY = 44,
	/**
	 * \n[DeQueued] Name of the queue the job was obtained from.
	 * \n[EnQueued] Queue into which the job has been stored for retrieval by another component.
	 * \n[PBSQueued] Queue name
	 */
		QUEUE = 45,
	/**
	 * \n[Abort] Reason why the job was aborted by the system.
	 * \n[CREAMAbort] Reason for aborting the job
	 * \n[CREAMCall] Reason for the possible CREAM call failure
	 * \n[CREAMCancel] Reason for cancelling the job
	 * \n[CREAMDone] Reason for the status
	 * \n[CREAMResume] Reason for the resume.
	 * \n[CREAMStore] failure_reason
	 * \n[CREAMSuspend] Reason for the suspend.
	 * \n[Cancel] Detailed description of the attempt to cancel the job, especially the reason of failure.
	 * \n[Clear] Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT).
	 * \n[Done] Detailed description why the job was terminated.
	 * \n[EnQueued] Detailed description of the attempt to enqueue the job, especially the reason of failure.
	 * \n[FileTransfer] The reason of file transfer failure.
	 * \n[PBSPending] Reasons of job pendation or errors
	 * \n[PBSRefused] Description of the reason why the job was refused.
	 * \n[PBSTransfer] Detailed description of the transfer, especially reason of failure.
	 * \n[Pending] Description why the matching CE for the job was not found (yet).
	 * \n[Refused] Description of the reason why the job was refused.
	 * \n[Resubmission] Reason why the job will or will not be resubmitted.
	 * \n[Resume] Reason for the resume.
	 * \n[Suspend] Reason for the suspend.
	 * \n[Transfer] Detailed description of the transfer, especially reason of failure.
	 */
		REASON = 46,
	/**
	 * \n[VMCreate] machine requirements
	 */
		REQUIRE = 103,
	/**
	 * \n[ResourceUsage] Resource's name.
	 */
		RESOURCE = 47,
	/**
	 * \n[PBSResourceUsage] List of resources
	 */
		RESOURCES = 101,
	/**
	 * \n[CREAMCall] Result code of the CREAM call (START, OK, REFUSED or FAIL)
	 * \n[CREAMStatus] Result of the job state change
	 * \n[CREAMStore] store phase/result
	 * \n[EnQueued] Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL).
	 * \n[FileTransfer] Result code of the file transfer attemp.
	 * \n[PBSTransfer] Result code of the transfer attempt (START, OK, REFUSED or FAIL).
	 * \n[Resubmission] Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW).
	 * \n[Transfer] Result code of the transfer attempt (START, OK, REFUSED or FAIL).
	 */
		RESULT = 48,
	/**
	 * \n[HelperReturn] Data returned by the call to the helper component.
	 */
		RETVAL = 49,
	/**
	 * \n[Sandbox] Type of sandbox.
	 */
		SANDBOX_TYPE = 88,
	/**
	 * \n[PBSRun] Scheduler ID
	 */
		SCHEDULER = 50,
	/**
	 * \n[RegJob] Seed for subjob id generation.
	 */
		SEED = 51,
	/**
	 * \n[common] Sequence code assigned to the event.
	 */
		SEQCODE = 52,
	/**
	 * \n[CondorShadowExited] Exit status of shadow process
	 */
		SHADOW_EXIT_STATUS = 53,
	/**
	 * \n[CondorShadowStarted] Shadow host
	 */
		SHADOW_HOST = 54,
	/**
	 * \n[CondorShadowExited] PID of shadow process
	 * \n[CondorShadowStarted] PID of shadow process
	 */
		SHADOW_PID = 55,
	/**
	 * \n[CondorShadowStarted] Shadow port
	 */
		SHADOW_PORT = 56,
	/**
	 * \n[CondorShadowStarted] Shadow status
	 */
		SHADOW_STATUS = 57,
	/**
	 * \n[common] Source (software component) which generated this event.
	 */
		SOURCE = 58,
	/**
	 * \n[FileTransferRegister] Source of file transfer.
	 */
		SRC = 86,
	/**
	 * \n[common] Instance of source component (e.g. service communication endpoint).
	 */
		SRC_INSTANCE = 59,
	/**
	 * \n[HelperCall] The role the event sender is playing in the helper call (CALLING or CALLEE).
	 * \n[HelperReturn] The role the event sender is playing in the helper call (CALLING or CALLEE).
	 */
		SRC_ROLE = 60,
	/**
	 * \n[CondorStarterExited] Exit status of starter process
	 */
		STARTER_EXIT_STATUS = 61,
	/**
	 * \n[CondorStarterExited] PID of starter process
	 * \n[CondorStarterStarted] PID of starter process
	 */
		STARTER_PID = 62,
	/**
	 * \n[CollectionState] New collection state.
	 */
		STATE = 63,
	/**
	 * \n[CREAMCancel] Status code of CREAM Cancel
	 * \n[CREAMDone] Status code of the CREAM Done
	 * \n[CREAMResume] Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT).
	 * \n[CREAMSuspend] Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT).
	 * \n[Cancel] Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT).
	 * \n[CondorReject] Reason code for the rejection of the job
	 * \n[Done] Reason code for the termination of the job (OK, FAILED or CANCELLED).
	 * \n[VMDone] 
	 */
		STATUS_CODE = 64,
	/**
	 * \n[Listener] Hostname of the interactive job controller.
	 */
		SVC_HOST = 65,
	/**
	 * \n[Listener] Name of the port instance for interactive job control.
	 */
		SVC_NAME = 66,
	/**
	 * \n[Listener] Port number of the interactive job controller.
	 */
		SVC_PORT = 67,
	/**
	 * \n[Chkpt] Application specific checkpoint tag.
	 * \n[Resubmission] Value of the attribute on which the decision to resubmit the job was based.
	 */
		TAG = 68,
	/**
	 * \n[common] Time the event was generated.
	 */
		TIMESTAMP = 69,
	/**
	 * \n[Sandbox] Jobid of transfer job (collection) containing set of file transfers (subjobs).
	 */
		TRANSFER_JOB = 89,
	/**
	 * \n[CondorResourceUsage] Units (sec, kB, etc.)
	 * \n[ResourceUsage] Units (sec, kB, etc.).
	 */
		UNIT = 70,
	/**
	 * \n[CondorStarterStarted] Condor Universe
	 */
		UNIVERSE = 71,
	/**
	 * \n[CondorResourceUsage] Type of record
	 * \n[PBSResourceUsage] Type of record
	 * \n[VMDone] 
	 * \n[VMShutdown] 
	 */
		USAGE = 72,
	/**
	 * \n[common] Identity (certificate subject) of the event sender.
	 */
		USER = 73,
	/**
	 * \n[ChangeACL] Certificate or VOMS parameter.
	 */
		USER_ID = 74,
	/**
	 * \n[ChangeACL] Type of information given in user_id.
	 */
		USER_ID_TYPE = 75,
	/**
	 * \n[UserTag] Arbitrary user tag value.
	 */
		VALUE = 76,
	/**
	 * \n[RegJob] DN of WMS handling the job
	 */
		WMS_DN = 95,
	/**
	 * \n[ReallyRunning] Sequence code on the worker node.
	 */
		WN_SEQ = 77,
	/**
	 * \n[CREAMStatus] Worker node
	 */
		WORKER_NODE = 93,
		ATTR_MAX = 107	/**< Limit for checking attribute code validity. */
	};

       /** Type of information given in user_id. */
	enum ChangeACLUserIdTypeCode {
		CHANGEACL_DN = EDG_WLL_CHANGEACL_DN,	/**< Certificate subject name */
		CHANGEACL_GROUP = EDG_WLL_CHANGEACL_GROUP,	/**< VO group (must be specified as "vo":"group") */
		CHANGEACL_FQAN = EDG_WLL_CHANGEACL_FQAN,	/**< Standard Full Qualified Attribute Name (FQAN) */
	};
/* backward compatibility */
#define ChangeACLCode ChangeACLUserIdTypeCode

       /** Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT). */
	enum ClearReasonCode {
		CLEAR_USER = EDG_WLL_CLEAR_USER,	/**< User retrieved output sandbox. */
		CLEAR_TIMEOUT = EDG_WLL_CLEAR_TIMEOUT,	/**< Timed out, resource forced purge of the sandbox. */
		CLEAR_NOOUTPUT = EDG_WLL_CLEAR_NOOUTPUT,	/**< No output was generated. */
	};
/* backward compatibility */
#define ClearCode ClearReasonCode

       /** Result of the job state change */
	enum CREAMStatusResultCode {
		CREAMSTATUS_ARRIVED = EDG_WLL_CREAMSTATUS_ARRIVED,	/**< arrived */
		CREAMSTATUS_DONE = EDG_WLL_CREAMSTATUS_DONE,	/**< done */
	};
/* backward compatibility */
#define CREAMStatusCode CREAMStatusResultCode

       /** store phase/result */
	enum CREAMStoreResultCode {
		CREAMSTORE_START = EDG_WLL_CREAMSTORE_START,	/**< start */
		CREAMSTORE_OK = EDG_WLL_CREAMSTORE_OK,	/**< ok */
		CREAMSTORE_FAILED = EDG_WLL_CREAMSTORE_FAILED,	/**< failed */
	};
/* backward compatibility */
#define CREAMStoreCode CREAMStoreResultCode

       /** Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW). */
	enum ResubmissionResultCode {
		RESUBMISSION_WILLRESUB = EDG_WLL_RESUBMISSION_WILLRESUB,	/**< The job will be resubmitted (deep resubmission). */
		RESUBMISSION_WONTRESUB = EDG_WLL_RESUBMISSION_WONTRESUB,	/**< The job will not be resubmitted. */
		RESUBMISSION_SHALLOW = EDG_WLL_RESUBMISSION_SHALLOW,	/**< Shallow resubmission (user payload has not started yet) */
	};
/* backward compatibility */
#define ResubmissionCode ResubmissionResultCode

       /** Result code of the CREAM call (START, OK, REFUSED or FAIL) */
	enum CREAMCallResultCode {
		CREAMCALL_START = EDG_WLL_CREAMCALL_START,	/**< start */
		CREAMCALL_OK = EDG_WLL_CREAMCALL_OK,	/**< ok */
		CREAMCALL_FAILED = EDG_WLL_CREAMCALL_FAILED,	/**< failed */
	};
/* backward compatibility */
#define CREAMCallCode CREAMCallResultCode

       /** Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL). */
	enum EnQueuedResultCode {
		ENQUEUED_START = EDG_WLL_ENQUEUED_START,	/**< The sending component has started or is about to start enqueuing the job. */
		ENQUEUED_OK = EDG_WLL_ENQUEUED_OK,	/**< The job was enqueued successfully. */
		ENQUEUED_REFUSED = EDG_WLL_ENQUEUED_REFUSED,	/**< The job was refused by the other component. */
		ENQUEUED_FAIL = EDG_WLL_ENQUEUED_FAIL,	/**< The transfer failed for other reason than explicit refusal. */
	};
/* backward compatibility */
#define EnQueuedCode EnQueuedResultCode

       /** Result code of the transfer attempt (START, OK, REFUSED or FAIL). */
	enum TransferResultCode {
		TRANSFER_START = EDG_WLL_TRANSFER_START,	/**< The sending component has started or is about to start the transfer. */
		TRANSFER_OK = EDG_WLL_TRANSFER_OK,	/**< The job was sent successfully. */
		TRANSFER_REFUSED = EDG_WLL_TRANSFER_REFUSED,	/**< The job was refused by the other component. */
		TRANSFER_FAIL = EDG_WLL_TRANSFER_FAIL,	/**< The transfer failed for other reason than explicit refusal (eg. network timeout). */
	};
/* backward compatibility */
#define TransferCode TransferResultCode

       /** Result code of the file transfer attemp. */
	enum FileTransferResultCode {
		FILETRANSFER_START = EDG_WLL_FILETRANSFER_START,	/**< The sending component has started or is about to start the file transfer. */
		FILETRANSFER_OK = EDG_WLL_FILETRANSFER_OK,	/**< The file was transfered successfully. */
		FILETRANSFER_FAIL = EDG_WLL_FILETRANSFER_FAIL,	/**< The file transfer failed (see reason) */
	};
/* backward compatibility */
#define FileTransferCode FileTransferResultCode

       /** Result code of the transfer attempt (START, OK, REFUSED or FAIL). */
	enum PBSTransferResultCode {
		PBSTRANSFER_START = EDG_WLL_PBSTRANSFER_START,	/**< The sending component has started or is about to start the transfer. */
		PBSTRANSFER_OK = EDG_WLL_PBSTRANSFER_OK,	/**< The job was sent successfully. */
		PBSTRANSFER_REFUSED = EDG_WLL_PBSTRANSFER_REFUSED,	/**< The job was refused by the other component. */
		PBSTRANSFER_FAIL = EDG_WLL_PBSTRANSFER_FAIL,	/**< The transfer failed for other reason than explicit refusal (eg. network timeout). */
	};
/* backward compatibility */
#define PBSTransferCode PBSTransferResultCode

       /** Operation requested to perform with ACL. */
	enum ChangeACLOperationCode {
		CHANGEACL_ADD = EDG_WLL_CHANGEACL_ADD,	/**< Add the record to the ACL */
		CHANGEACL_REMOVE = EDG_WLL_CHANGEACL_REMOVE,	/**< Remove the record from the ACL */
	};
       /** Command to store */
	enum CREAMStoreCommandCode {
		CREAMSTORE_CMDSTART = EDG_WLL_CREAMSTORE_CMDSTART,	/**< Start registered job */
		CREAMSTORE_CMDCANCEL = EDG_WLL_CREAMSTORE_CMDCANCEL,	/**< Cancel job */
		CREAMSTORE_CMDPURGE = EDG_WLL_CREAMSTORE_CMDPURGE,	/**< Purge request */
		CREAMSTORE_CMDSUSPEND = EDG_WLL_CREAMSTORE_CMDSUSPEND,	/**< Suspend running job */
		CREAMSTORE_CMDRESUME = EDG_WLL_CREAMSTORE_CMDRESUME,	/**< Resume suspended job */
	};
       /** Command to store */
	enum CREAMCallCommandCode {
		CREAMCALL_CMDSTART = EDG_WLL_CREAMCALL_CMDSTART,	/**< Start registered job */
		CREAMCALL_CMDCANCEL = EDG_WLL_CREAMCALL_CMDCANCEL,	/**< Cancel job */
		CREAMCALL_CMDPURGE = EDG_WLL_CREAMCALL_CMDPURGE,	/**< Purge request */
		CREAMCALL_CMDSUSPEND = EDG_WLL_CREAMCALL_CMDSUSPEND,	/**< Suspend running job */
		CREAMCALL_CMDRESUME = EDG_WLL_CREAMCALL_CMDRESUME,	/**< Resume suspended job */
	};
       /** Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT). */
	enum CancelStatusCodeCode {
		CANCEL_REQ = EDG_WLL_CANCEL_REQ,	/**< The request was acknowledged. */
		CANCEL_REFUSE = EDG_WLL_CANCEL_REFUSE,	/**< The request was declined by this component. */
		CANCEL_DONE = EDG_WLL_CANCEL_DONE,	/**< The request was completed by whole WMS. */
		CANCEL_ABORT = EDG_WLL_CANCEL_ABORT,	/**< The request was refused by whole WMS. */
	};
/* backward compatibility */
#define CancelCode CancelStatusCodeCode

       /**  */
	enum VMDoneStatusCodeCode {
		VMDONE_OK = EDG_WLL_VMDONE_OK,	/**<  */
		VMDONE_DELETE = EDG_WLL_VMDONE_DELETE,	/**<  */
		VMDONE_FAILURE = EDG_WLL_VMDONE_FAILURE,	/**<  */
	};
/* backward compatibility */
#define VMDoneCode VMDoneStatusCodeCode

       /** Reason code for the termination of the job (OK, FAILED or CANCELLED). */
	enum DoneStatusCodeCode {
		DONE_OK = EDG_WLL_DONE_OK,	/**< The job terminated by itself. */
		DONE_FAILED = EDG_WLL_DONE_FAILED,	/**< The job disappeared from LRMS. */
		DONE_CANCELLED = EDG_WLL_DONE_CANCELLED,	/**< The job was cancelled by user request. */
		DONE_KILLED = EDG_WLL_DONE_KILLED,	/**< The job was killed (in Job Wrapper). */
	};
/* backward compatibility */
#define DoneCode DoneStatusCodeCode

       /** Status code of CREAM Cancel */
	enum CREAMCancelStatusCodeCode {
		CREAMCANCEL_REQ = EDG_WLL_CREAMCANCEL_REQ,	/**< req */
		CREAMCANCEL_REFUSE = EDG_WLL_CREAMCANCEL_REFUSE,	/**< refuse */
		CREAMCANCEL_DONE = EDG_WLL_CREAMCANCEL_DONE,	/**< done */
		CREAMCANCEL_ABORT = EDG_WLL_CREAMCANCEL_ABORT,	/**< abort */
	};
/* backward compatibility */
#define CREAMCancelCode CREAMCancelStatusCodeCode

       /** Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT). */
	enum CREAMResumeStatusCodeCode {
		CREAMRESUME_REQ = EDG_WLL_CREAMRESUME_REQ,	/**< The request was acknowledged. */
		CREAMRESUME_REFUSE = EDG_WLL_CREAMRESUME_REFUSE,	/**< The request was declined by this component. */
		CREAMRESUME_DONE = EDG_WLL_CREAMRESUME_DONE,	/**< The request was completed by whole system. */
		CREAMRESUME_ABORT = EDG_WLL_CREAMRESUME_ABORT,	/**< The request was refused by whole system. */
	};
/* backward compatibility */
#define CREAMResumeCode CREAMResumeStatusCodeCode

       /** Reason code for the rejection of the job */
	enum CondorRejectStatusCodeCode {
		CONDORREJECT_NOMATCH = EDG_WLL_CONDORREJECT_NOMATCH,	/**< No match found */
		CONDORREJECT_OTHER = EDG_WLL_CONDORREJECT_OTHER,	/**< Other reason */
	};
/* backward compatibility */
#define CondorRejectCode CondorRejectStatusCodeCode

       /** Status code of the CREAM Done */
	enum CREAMDoneStatusCodeCode {
		CREAMDONE_OK = EDG_WLL_CREAMDONE_OK,	/**< ok */
		CREAMDONE_FAILED = EDG_WLL_CREAMDONE_FAILED,	/**< failed */
		CREAMDONE_CANCELLED = EDG_WLL_CREAMDONE_CANCELLED,	/**< cancelled */
		CREAMDONE_KILLED = EDG_WLL_CREAMDONE_KILLED,	/**< killed */
	};
/* backward compatibility */
#define CREAMDoneCode CREAMDoneStatusCodeCode

       /** Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT). */
	enum CREAMSuspendStatusCodeCode {
		CREAMSUSPEND_REQ = EDG_WLL_CREAMSUSPEND_REQ,	/**< The request was acknowledged. */
		CREAMSUSPEND_REFUSE = EDG_WLL_CREAMSUSPEND_REFUSE,	/**< The request was declined by this component. */
		CREAMSUSPEND_DONE = EDG_WLL_CREAMSUSPEND_DONE,	/**< The request was completed by whole system. */
		CREAMSUSPEND_ABORT = EDG_WLL_CREAMSUSPEND_ABORT,	/**< The request was refused by whole system. */
	};
/* backward compatibility */
#define CREAMSuspendCode CREAMSuspendStatusCodeCode

       /** Type of permission requested. */
	enum ChangeACLPermissionTypeCode {
		CHANGEACL_ALLOW = EDG_WLL_CHANGEACL_ALLOW,	/**< Grant the permission specified */
		CHANGEACL_DENY = EDG_WLL_CHANGEACL_DENY,	/**< Deny the permission specified */
	};
       /** ACL permission to change. */
	enum ChangeACLPermissionCode {
		CHANGEACL_READ = EDG_WLL_CHANGEACL_READ,	/**< Get job information */
		CHANGEACL_TAG = EDG_WLL_CHANGEACL_TAG,	/**< Add a user tag */
	};
       /** Type of sandbox. */
	enum SandboxSandboxTypeCode {
		SANDBOX_INPUT = EDG_WLL_SANDBOX_INPUT,	/**< input */
		SANDBOX_OUTPUT = EDG_WLL_SANDBOX_OUTPUT,	/**< output */
	};
/* backward compatibility */
#define SandboxCode SandboxSandboxTypeCode

       /** Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.). */
	enum RegJobJobtypeCode {
		REGJOB_SIMPLE = EDG_WLL_REGJOB_SIMPLE,	/**< The job is simple job. */
		REGJOB_DAG = EDG_WLL_REGJOB_DAG,	/**< The job is dag (containing static set of subjobs). */
		REGJOB_PARTITIONABLE = EDG_WLL_REGJOB_PARTITIONABLE,	/**< The job is partitionable (may become partitioned). */
		REGJOB_PARTITIONED = EDG_WLL_REGJOB_PARTITIONED,	/**< The job is partitioned (dynamically created dag). */
		REGJOB_COLLECTION = EDG_WLL_REGJOB_COLLECTION,	/**< The job is collection (containing static set of subjobs). */
		REGJOB_PBS = EDG_WLL_REGJOB_PBS,	/**< PBS job */
		REGJOB_CONDOR = EDG_WLL_REGJOB_CONDOR,	/**< Condor job */
		REGJOB_CREAM = EDG_WLL_REGJOB_CREAM,	/**< CREAM job */
		REGJOB_FILE_TRANSFER_COLLECTION = EDG_WLL_REGJOB_FILE_TRANSFER_COLLECTION,	/**< File transfer collection */
		REGJOB_FILE_TRANSFER = EDG_WLL_REGJOB_FILE_TRANSFER,	/**< File transfer */
		REGJOB_VIRTUAL_MACHINE = EDG_WLL_REGJOB_VIRTUAL_MACHINE,	/**< Virtual machine  */
	};
/* backward compatibility */
#define RegJobCode RegJobJobtypeCode

       /** Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.). */
	enum ConnectJobJobtypeCode {
		CONNECTJOB_SIMPLE = EDG_WLL_CONNECTJOB_SIMPLE,	/**< The job is simple job. */
		CONNECTJOB_DAG = EDG_WLL_CONNECTJOB_DAG,	/**< The job is dag (containing static set of subjobs). */
		CONNECTJOB_PARTITIONABLE = EDG_WLL_CONNECTJOB_PARTITIONABLE,	/**< The job is partitionable (may become partitioned). */
		CONNECTJOB_PARTITIONED = EDG_WLL_CONNECTJOB_PARTITIONED,	/**< The job is partitioned (dynamically created dag). */
		CONNECTJOB_COLLECTION = EDG_WLL_CONNECTJOB_COLLECTION,	/**< The job is collection (containing static set of subjobs). */
		CONNECTJOB_PBS = EDG_WLL_CONNECTJOB_PBS,	/**< PBS job */
		CONNECTJOB_CONDOR = EDG_WLL_CONNECTJOB_CONDOR,	/**< Condor job */
		CONNECTJOB_CREAM = EDG_WLL_CONNECTJOB_CREAM,	/**< CREAM job */
		CONNECTJOB_FILE_TRANSFER_COLLECTION = EDG_WLL_CONNECTJOB_FILE_TRANSFER_COLLECTION,	/**< File transfer collection */
		CONNECTJOB_FILE_TRANSFER = EDG_WLL_CONNECTJOB_FILE_TRANSFER,	/**< File transfer */
		CONNECTJOB_VIRTUAL_MACHINE = EDG_WLL_CONNECTJOB_VIRTUAL_MACHINE,	/**< Virtual machine */
	};
/* backward compatibility */
#define ConnectJobCode ConnectJobJobtypeCode

       /** Type of record */
	enum PBSResourceUsageUsageCode {
		PBSRESOURCEUSAGE_REQUESTED = EDG_WLL_PBSRESOURCEUSAGE_REQUESTED,	/**< Requested value */
		PBSRESOURCEUSAGE_USED = EDG_WLL_PBSRESOURCEUSAGE_USED,	/**< Consumed quantity */
	};
/* backward compatibility */
#define PBSResourceUsageCode PBSResourceUsageUsageCode

       /** Type of record */
	enum CondorResourceUsageUsageCode {
		CONDORRESOURCEUSAGE_REQUESTED = EDG_WLL_CONDORRESOURCEUSAGE_REQUESTED,	/**< Requested value */
		CONDORRESOURCEUSAGE_USED = EDG_WLL_CONDORRESOURCEUSAGE_USED,	/**< Consumed quantity */
	};
/* backward compatibility */
#define CondorResourceUsageCode CondorResourceUsageUsageCode

       /** The role the event sender is playing in the helper call (CALLING or CALLEE). */
	enum HelperCallSrcRoleCode {
		HELPERCALL_CALLING = EDG_WLL_HELPERCALL_CALLING,	/**< The logging component is caller. */
		HELPERCALL_CALLED = EDG_WLL_HELPERCALL_CALLED,	/**< The logging component is callee. */
	};
/* backward compatibility */
#define HelperCallCode HelperCallSrcRoleCode

       /** The role the event sender is playing in the helper call (CALLING or CALLEE). */
	enum HelperReturnSrcRoleCode {
		HELPERRETURN_CALLING = EDG_WLL_HELPERRETURN_CALLING,	/**< The logging component is caller. */
		HELPERRETURN_CALLED = EDG_WLL_HELPERRETURN_CALLED,	/**< The logging component is callee. */
	};
/* backward compatibility */
#define HelperReturnCode HelperReturnSrcRoleCode


	/** Symbolic names for types of attribute values. */
	enum AttrType { INT_T,           /**< Integer value. */
			STRING_T,        /**< String value.  */
			TIMEVAL_T,       /**< Time value (ie. struct
					    timeval). */
			PORT_T,          /**< Service port  (integer). */
			LOGSRC_T,        /**< Source of the event
					    (integer). */
			JOBID_T,         /**< JobId value. */
			NOTIFID_T,        /**< NotifId value. */
			FLOAT_T,         /**< Float value.  */
			DOUBLE_T,        /**< Double value.  */
			TAGLIST_T,       /**< List of user tags (name = value pairs). */
	};

	Type 	type; /**< Type of the event as defined by Type. */

	/** Default constructor.
	 *
	 * Initializes an empty event.
	 */
	Event(void);

	/** Constructor from corresponding C type.
	 *
	 * Initializes the object from the corresponding C struct, in
	 * fact holding the pointer to it.
	 */
        Event(edg_wll_Event *);

	/** Copy constructor.
	 *
	 * Creates a copy of the object by sharing the C struct
	 * with the original.
	 */
	Event(const Event &);

	/** Destructor.
	 *
	 * Releases the C struct (possibly deallocating it).
	 */
	~Event(void);


	/** Assign new Event to an existing instance. 
	 *
	 * The original data are released and new ones are made
	 * accessible.
	 * \returns Reference to this object.
	 */
	Event & operator= (const Event &);

	/** String representation of the event type.
	 * 
	 * Returns string representing the event type.
	 * \returns Name of the event.
	 * \throw Exception Invalid event type.
	 */
	const std::string & name(void) const;

	/** Retrieve integer attribute.
	 * 
	 * Retrieves value for attributes of integer type.
	 * \param[in] name Name of the attribute to retrieve.
	 * \returns Integer value of the attribute.
	 * \throw Exception Invalid event type or attribute not
	 * defined for this event.
	 */
	int	getValInt(Attr name) const;

	/** Retrieve float attribute.
	 * 
	 * Retrieves value for attributes of float type.
	 * \param[in] name Name of the attribute to retrieve.
	 * \returns Integer value of the attribute.
	 * \throw Exception Invalid event type or attribute not
	 * defined for this event.
	 */
	float	getValFloat(Attr name) const;

	/** Retrieve double attribute.
	 * 
	 * Retrieves value for attributes of double type.
	 * \param[in] name Name of the attribute to retrieve.
	 * \returns Integer value of the attribute.
	 * \throw Exception Invalid event type or attribute not
	 * defined for this event.
	 */
	double	getValDouble(Attr name) const;

	/** Retrieve string attribute.
	 *
	 * Retrieves value for attributes of string type.
	 * \param[in] name Name of the attribute to retrieve.
	 * \returns String value of the attribute.
	 * \throw Exception Invalid event type or attribute not
	 * defined for this event.
	 */
	std::string getValString(Attr name) const;

        /** Retrieve time attribute.
	 *
	 * Retrieves value for attributes of timeval type.
	 * \param[in] name Name of the attribute to retrieve.
	 * \returns struct timeval  value of the attribute.
	 */
        struct timeval	getValTime(Attr name) const;
		
        /** Retrieve jobid attribute 
	 *
	 * Retrieves value for attributes of JobId type.
	 * \param[in] name Name of the attribute to retrieve.
	 * \returns JobId value of the attribute.
	 * \throw Exception Invalid event type or attribute not
	 * defined for this event.
	 */
        const glite::jobid::JobId getValJobId(Attr name) const;

	/** Attribute name.
	 *
	 * Retrieves string representation of the attribute name.
	 * \param[in] name Symbolic name of the attribute.
	 * \returns String name of the attribute.
	 * \throw Exception Invalid attribute name.
	 * 
	 */
	static const std::string & getAttrName(Attr name);

	/** List of attributes and types valid for this instance.
	 *
	 * Retrieves description of all attributes defined for this event.
	 * \returns Vector of Attr -- AttrType pairs.
	 * \throw Exception Invalid event type.
	 */
	const std::vector<std::pair<Attr,AttrType> >  &	getAttrs(void) const;

	/** Event name.
	 *
	 * Retrieves string representation of the event type.
	 * \param[in] type Symbolic name of the event type.
	 * \returns String name of the event.
	 * \throw Exception Invalid event type.
	 *
	 */
	static const std::string getEventName(Type type);

private:
	std::string	my_name;
	static void	destroyFlesh(void *);
	CountRef<Event>	*flesh;
};

EWL_END_NAMESPACE

#endif /* GLITE_LB_EVENT_HPP */
