#!/bin/sh

# Copyright (c) Members of the EGEE Collaboration. 2009.
# See http://www.eu-egee.org/partners/ for details on the copyright
# holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors: Jan Just Keijser 
#      NIKHEF Amsterdam, the Netherlands
#      janjust@nikhef.nl

if test $# -eq 0
then
    echo "Usage: $(basename $0) <command>"
    exit 1
fi

if test -n "${GLEXEC_LOCATION}"
then
    BASEDIR="${GLEXEC_LOCATION}"
elif test -n "${GLITE_LOCATION}"
then
    BASEDIR="${GLITE_LOCATION}"
else
    BASEDIR="/usr"
fi


cd ${BASEDIR}
export GLEXEC_ENV=`${0%/*}/glexec_wrapenv.pl`
exec ${BASEDIR}/sbin/glexec ${0%/*}/glexec_unwrapenv.pl -- $@
