

## gfal 2.0 tools core logic of checksum 
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##



import gfal2
import sys
from gfal_tools_arg_parser import *
from gfal_tools_parameters import applys_option
from gfal_tools_verbose import set_verbose_mode
from gfal_tools_errors import gfal_catch_gerror



	
def setup_verbose_from_opt(params):
	vlvl = params.verbose
	if(vlvl > 0):
		print "verbose mode"

def create_gfal_sum_parser():
	p = create_basic_parser()
        p.add_argument( 'FILE', nargs=1, type=str, help="file uri to use for checksum calculation")
        p.add_argument( 'CHECKSUM_TYPE', nargs=1, type=str, help="checksum algorithm to use ( ex: ADLER32, CRC32, MD5, etc.. )")
	return p
	
@gfal_catch_gerror
def gfal_sum_main():
        params = create_gfal_sum_parser().parse_args(sys.argv[1:])
	set_verbose_mode(params)	
	c = gfal2.creat_context()
        applys_option(c,params)
	my_file = params.FILE[0]
        r= c.checksum(my_file, params.CHECKSUM_TYPE[0])
        print "%s\t%s"%(my_file, r)
	return 0
