

## gfal 2.0 tools core logic of copy
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##



import gfal2
import sys
from gfal_tools_arg_parser import *
from gfal_tools_parameters import applys_option
from gfal_tools_verbose import set_verbose_mode
from gfal_tools_errors import gfal_catch_gerror



def print_file_list_simple(fdesc, f_list):
	[ fdesc.write("%s\n")%file_name for file_name in f_list ]


def filter_hiden(f_list):
	def filter_f_list(mfile):
		return (mfile[0] is not '.')
	return filter(filter_f_list, f_list)

	
def setup_verbose_from_opt(params):
	vlvl = params.verbose
	if(vlvl > 0):
		print "verbose mode"

def create_gfal_cp_parser():
	p = create_basic_parser()
        p.add_argument('-f',"--force", action='store_true', help="if destionation file(s) cannot be overwritten, delete it and try again")
        p.add_argument('-n',"--nbstreams", nargs=1, type=int, default=0, help="specify the maximum number of parallel streams to use for the copy")
        p.add_argument('-s',"--src-spacetoken", nargs=1, type=str, default="", help="source spacetoken to use for the transfer")
        p.add_argument('-S',"--dst-spacetoken", nargs=1, type=str, default="", help="destination spacetoken to use for the transfer")
        p.add_argument('-t',"--timeout", nargs=1, type=int, default=0, help="global timeout for the transfer operation")
        p.add_argument( 'SRC', nargs=1, type=str, help="source file")
        p.add_argument( 'DST', nargs=1, type=str, help="destination file")
	return p
	
def apply_transfer_options(t,params):
    if(params.nbstreams != 0):
        t.nbstreams = params.nbstreams[0]
    if(params.timeout !=0):
        t.timeout = params.timeout[0]
    if(len(params.src_spacetoken) > 0):
            t.src_spacetoken = params.src_spacetoken[0]
    if(len(params.dst_spacetoken) > 0):
            t.dst_spacetoken = params.dst_spacetoken[0]

@gfal_catch_gerror
def gfal_copy_main():
        params = create_gfal_cp_parser().parse_args(sys.argv[1:])
	set_verbose_mode(params)	
	c = gfal2.creat_context()
	applys_option(c,params)
        t = c.transfer_parameters()
        apply_transfer_options(t,params)
        c.filecopy(t, params.SRC[0], params.DST[0])
        return 0
