
## gfal 2.0 tools core logic of cat
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##



import gfal2
import sys
from gfal_tools_arg_parser import *
from gfal_tools_parameters import applys_option
from gfal_tools_verbose import set_verbose_mode
from gfal_tools_errors import gfal_catch_gerror

	
def create_gfal_cat_parser():
	p = create_basic_parser()
	p.add_argument("file_uri",type=str, nargs=1)
	return p
	
def internal_readder(context, uri, func_out):
	f = context.open(uri,"r")
	content = "r"
	while(content is not ""):
		content = f.read(65000)
		func_out(content)	
	
@gfal_catch_gerror
def gfal_cat_main():
	params = create_gfal_cat_parser().parse_args(sys.argv[1:])
	set_verbose_mode(params)

	o = sys.stdout
	def std_writer(content):
		o.write(content)
	c = gfal2.creat_context()
	applys_option(c,params)
	internal_readder(c, params.file_uri[0], std_writer)
        return 0



