

## gfal 2.0 tools core logic of ls
## @author Adrien Devresse <adevress@cern.ch> CERN
## @license GPLv3
##



import gfal2
import sys
from gfal2_utils_arg_parser import *
from gfal2_utils_parameters import applys_option
from gfal2_utils_verbose import set_verbose_mode
from gfal2_utils_errors import gfal_catch_gerror




def print_file_list_simple(fdesc, f_list):
	[ fdesc.write("%s\n")%file_name for file_name in f_list ]


def filter_hiden(f_list):
	def filter_f_list(mfile):
		return (mfile[0] is not '.')
	return filter(filter_f_list, f_list)


	
def create_gfal_ls_parser():
	p = create_basic_parser()
	p.add_argument('-a',"--all", action='store_true', help="display the hidden files")	
	p.add_argument("file_uri",type=str, nargs=1)
	return p

@gfal_catch_gerror
def gfal_ls_main():
	params = create_gfal_ls_parser().parse_args(sys.argv[1:])
	set_verbose_mode(params)
	c = gfal2.creat_context()
	applys_option(c,params)
#	print c.get_opt_string("LFC PLUGIN","LFC_HOST")

	dir_content = c.listdir(params.file_uri[0])
	if(params.all is False):
		dir_content = filter_hiden(dir_content)
	o = sys.stdout
	for file_name in dir_content:	
		o.write("%s\n"%file_name)
        return 0
