/*!

	\file		eef_plugin.h
	\brief	API for EEF plugins
	\author	Aram Verstegen

	This header contains the declarations of functions that should be provided by all plugins.
	It contains the following core functions:
	-# plugin_initialize(argc, argv): initializes plugin
	-# plugin_run(): runs plugin
	-# plugin_terminate(): terminates plugin

*/
#ifndef PLUGIN_H
#define PLUGIN_H
#include "eef_log.h"
#include "eef_return_codes.h"
#include "eef_aos.h"

EES_PL_RC plugin_initialize(int argc, char* argv[]);
EES_PL_RC plugin_run(void);
EES_PL_RC plugin_terminate(void);
extern char* EEF_getRunningPluginName(void);

#endif
