#ifdef sun
#define SOLARIS 1
#endif
typedef struct globus_l_gfs_dpm_handle_s
{
    int                                 fd;
    globus_mutex_t                      mutex;
    globus_gfs_operation_t              op;
    globus_bool_t                       done;
    int                                 outstanding;
    int                                 optimal_count;
    globus_size_t                       block_size;
    globus_result_t                     cached_res;
    globus_off_t                        blk_length;
    globus_off_t                        blk_offset;
    char *                              subject;
                                                                                                                             
} globus_l_gfs_dpm_handle_t;
                                                                                                                             


/* function declaration */
int dsilogit(char *func, char *msg, ...);

int dpm_handle_open(char *path, int flags, int mode,  char *id);
int dpm_handle_stat(char *path, struct stat64 *st, char *id);
int dpm_handle_statc(char *path, struct Cns_filestatg *st, char *id);

                                                                                                                             
static globus_bool_t
globus_l_gfs_dpm_send_next_to_client(globus_l_gfs_dpm_handle_t *);
                                                                                                                             
static void
globus_l_gfs_dpm_read_from_net(globus_l_gfs_dpm_handle_t *);
