/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation.impl;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyCSR;
import eu.emi.security.authn.x509.proxy.ProxyCSRGenerator;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyChainInfo;
import eu.emi.security.authn.x509.proxy.ProxyType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.glite.security.delegation.CertInfoTriple;
import org.glite.security.delegation.DelegationException;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.delegation.GrDProxyDlgeeOptions;
import org.glite.security.delegation.NewProxyReq;
import org.glite.security.delegation.storage.GrDPStorage;
import org.glite.security.delegation.storage.GrDPStorageCacheElement;
import org.glite.security.delegation.storage.GrDPStorageElement;
import org.glite.security.delegation.storage.GrDPStorageException;
import org.glite.security.delegation.storage.GrDPStorageFactory;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStores;

public class GliteDelegation {
    public static Logger logger = Logger.getLogger(GliteDelegation.class);
    private int DEFAULT_KEY_SIZE = 1024;
    private boolean m_bad_config = true;
    private GrDPStorage m_storage = null;
    private int m_keySize;
    private static boolean requireVomsAttrs = true;
    private static VOMSACValidator vomsValidator = null;
    private boolean limited = false;

    public GliteDelegation() throws Exception {
        this(new GrDProxyDlgeeOptions(GrDPX509Util.getDlgeePropertyFile()));
    }

    public GliteDelegation(GrDProxyDlgeeOptions dlgeeOpt) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using DLGEE properties: DN: " + dlgeeOpt.getDlgeeDN() + ". Pass: <hidden>. proxyFile: " + dlgeeOpt.getDlgeeProxyFile() + ". " + "delegationStorageFactory: " + dlgeeOpt.getDlgeeStorageFactory()));
        }
        try {
            GrDPStorageFactory stgFactory = GrDPX509Util.getGrDPStorageFactory(dlgeeOpt.getDlgeeStorageFactory());
            this.m_storage = stgFactory.createGrDPStorage(dlgeeOpt);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get a GrDPStorage instance. Delegation is not active.", (Throwable)e);
            this.m_bad_config = true;
            return;
        }
        requireVomsAttrs = dlgeeOpt.isRequireVomsAttributes();
        this.limited = dlgeeOpt.isLimited();
        this.m_keySize = dlgeeOpt.getDlgeeKeySize();
        if (this.m_keySize == -1 || this.m_keySize < this.DEFAULT_KEY_SIZE) {
            this.m_keySize = this.DEFAULT_KEY_SIZE;
        }
        try {
            VOMSTrustStore vomsTrustStore = null;
            String vomsDirString = dlgeeOpt.getVomsDir();
            if (vomsDirString != null) {
                ArrayList<String> trustDirStrings = new ArrayList<String>();
                trustDirStrings.add(vomsDirString);
                vomsTrustStore = VOMSTrustStores.newTrustStore(trustDirStrings);
            } else {
                vomsTrustStore = VOMSTrustStores.newTrustStore();
            }
            StoreUpdateListener listener = new StoreUpdateListener(){

                public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
                    if (level != StoreUpdateListener.Severity.NOTIFICATION) {
                        logger.error((Object)("Error when creating or using SSL socket. Type " + type + " level: " + level + (cause == null ? "" : " cause: " + cause.getClass() + ":" + cause.getMessage())));
                    }
                }
            };
            ArrayList<1> listenerList = new ArrayList<1>();
            listenerList.add(listener);
            RevocationParameters revParam = new RevocationParameters(CrlCheckingMode.REQUIRE, new OCSPParametes(), false, RevocationParameters.RevocationCheckingOrder.CRL_OCSP);
            String crlCheckingMode = dlgeeOpt.getRevocationChecking();
            if (crlCheckingMode != null) {
                if (crlCheckingMode.equalsIgnoreCase("ifvalid")) {
                    revParam = new RevocationParameters(CrlCheckingMode.IF_VALID, new OCSPParametes(), false, RevocationParameters.RevocationCheckingOrder.CRL_OCSP);
                }
                if (crlCheckingMode.equalsIgnoreCase("ignore")) {
                    revParam = new RevocationParameters(CrlCheckingMode.IGNORE, new OCSPParametes(), false, RevocationParameters.RevocationCheckingOrder.CRL_OCSP);
                }
            }
            ValidatorParams validatorParams = new ValidatorParams(revParam, ProxySupport.ALLOW, listenerList);
            String trustStoreLocation = dlgeeOpt.getVomsCAs();
            if (trustStoreLocation == null) {
                trustStoreLocation = "/etc/grid-security/certificates";
            }
            String namespaceModeString = dlgeeOpt.getNamespace();
            NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS;
            if (namespaceModeString != null) {
                if (namespaceModeString.equalsIgnoreCase("no") || namespaceModeString.equalsIgnoreCase("false") || namespaceModeString.equalsIgnoreCase("off")) {
                    namespaceMode = NamespaceCheckingMode.IGNORE;
                } else if (namespaceModeString.equalsIgnoreCase("require")) {
                    namespaceMode = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS_REQUIRE;
                }
            }
            String intervalString = dlgeeOpt.getUpdateInterval();
            long intervalMS = 3600000L;
            if (intervalString != null) {
                intervalMS = Long.parseLong(intervalString);
            }
            OpensslCertChainValidator validator = new OpensslCertChainValidator(trustStoreLocation, namespaceMode, intervalMS, validatorParams);
            ValidationErrorListener validationListener = new ValidationErrorListener(){

                public boolean onValidationError(ValidationError error) {
                    X509Certificate[] chain;
                    logger.info((Object)("Error when validating incoming certificate: " + error.getMessage() + " position: " + error.getPosition() + " " + error.getParameters()));
                    for (X509Certificate cert : chain = error.getChain()) {
                        logger.info((Object)cert.toString());
                    }
                    return false;
                }
            };
            validator.addValidationListener(validationListener);
            vomsValidator = VOMSValidators.newValidator((VOMSTrustStore)vomsTrustStore, (X509CertChainValidatorExt)validator);
        }
        catch (Exception e) {
            if (requireVomsAttrs) {
                logger.error((Object)("Error while creating VOMS validator: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            logger.warn((Object)("Error while creating VOMS validator: " + e.getMessage()), (Throwable)e);
        }
        this.m_bad_config = false;
    }

    public String getProxyReq(String inDelegationID, X509Certificate[] certs) throws DelegationException {
        logger.debug((Object)"Processing getProxyReq.");
        if (certs == null || certs.length == 0) {
            logger.error((Object)"Did not get any certificates.");
            throw new DelegationException("Did not get any certificates.");
        }
        logger.debug((Object)("Got " + certs.length + " certs."));
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        CertInfoTriple info = null;
        try {
            info = new CertInfoTriple(certs, vomsValidator, requireVomsAttrs);
        }
        catch (Exception e) {
            logger.error((Object)("Getting info from the certificate chain failed: " + e.getClass() + " " + e.getMessage()), (Throwable)e);
            throw new DelegationException("Getting info from the certificate chain failed: " + e.getClass() + " " + e.getMessage(), e);
        }
        logger.debug((Object)("Got get proxy req request from client '" + info.dn + "', got VOMS attributes : " + info.vomsAttributes));
        if (info.vomsAttributes != null) {
            for (String attrib : info.vomsAttributes) {
                logger.debug((Object)("Voms attrib : " + attrib));
            }
        }
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(info.dn, info.vomsAttributes);
        }
        logger.debug((Object)("Delegation id is: " + delegationID));
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem != null) {
            String vomsAttrsStr = GrDPX509Util.toStringVOMSAttrs(info.vomsAttributes);
            logger.debug((Object)("Delegation ID '" + delegationID + "' already exists" + " for client (DN='" + info.dn + "; VOMS ATTRS='" + vomsAttrsStr + "'). Call renewProxyReq."));
            throw new DelegationException("Delegation ID '" + delegationID + "' already exists" + " for client (DN='" + info.dn + "; VOMS ATTRS='" + vomsAttrsStr + "'). Call renewProxyReq.");
        }
        return this.createAndStoreCertificateRequest(certs, delegationID, info.dn, info.vomsAttributes);
    }

    public NewProxyReq getNewProxyReq(String inDelegationID, X509Certificate[] certs) throws DelegationException {
        logger.debug((Object)"Processing getNewProxyReq.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        CertInfoTriple info = new CertInfoTriple(certs, vomsValidator, requireVomsAttrs);
        logger.debug((Object)("Got get new proxy req request from client '" + info.dn + "'"));
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(info.dn, info.vomsAttributes);
        }
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem != null) {
            String vomsAttrsStr = GrDPX509Util.toStringVOMSAttrs(info.vomsAttributes);
            String errorMsg = "Delegation ID '" + delegationID + "' already exists" + " for client (DN='" + info.dn + "; VOMS ATTRS='" + vomsAttrsStr + "'). Call renewProxyReq.";
            logger.debug((Object)errorMsg);
            throw new DelegationException(errorMsg);
        }
        String certRequest = this.createAndStoreCertificateRequest(certs, delegationID, info.dn, info.vomsAttributes);
        NewProxyReq newProxyReq = new NewProxyReq();
        newProxyReq.setDelegationID(delegationID);
        newProxyReq.setProxyRequest(certRequest);
        return newProxyReq;
    }

    public String renewProxyReq(String inDelegationID, X509Certificate[] certs) throws DelegationException {
        logger.debug((Object)"Processing renewProxyReq.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        CertInfoTriple info = new CertInfoTriple(certs, vomsValidator, requireVomsAttrs);
        logger.debug((Object)("Got renew proxy request from client '" + info.dn + "'"));
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(info.dn, info.vomsAttributes);
        }
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem == null) {
            logger.debug((Object)("Failed to renew credential as there was no delegation with ID '" + delegationID + "' for client '" + info.dn + "'"));
        }
        return this.createAndStoreCertificateRequest(certs, delegationID, info.dn, info.vomsAttributes);
    }

    public void putProxy(String inDelegationID, String proxy, X509Certificate[] certs) throws Exception {
        KeyAndCertCredential credential;
        PrivateKey privateKey;
        PKCS10CertificationRequest req;
        X509Certificate[] proxyCertChain;
        logger.info((Object)"Processing putProxy.");
        String delegationID = inDelegationID;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        if (proxy == null) {
            logger.error((Object)"Failed to putProxy as proxy was null.");
            throw new DelegationException("No proxy was given.");
        }
        CertInfoTriple info = new CertInfoTriple(certs, vomsValidator, requireVomsAttrs);
        logger.debug((Object)("Got put proxy request from client '" + info.dn + "'"));
        try {
            proxyCertChain = CertificateUtils.loadCertificateChain((InputStream)new BufferedInputStream(new ByteArrayInputStream(proxy.getBytes())), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        }
        catch (IOException e2) {
            logger.error((Object)("Failed to load proxy certificate chain: " + e2.getMessage()));
            throw new DelegationException("Failed to load proxy certificate chain: " + e2.getMessage());
        }
        if (proxyCertChain == null || proxyCertChain.length == 0) {
            logger.error((Object)"Failed to load proxy certificate chain - chain was null or size 0.");
            throw new DelegationException("Failed to load proxy certificate chain.");
        }
        logger.debug((Object)"Given proxy certificate loaded successfully.");
        for (int i = 0; i < proxyCertChain.length; ++i) {
            try {
                proxyCertChain[i].checkValidity();
                continue;
            }
            catch (CertificateExpiredException e) {
                throw new DelegationException("Failed proxy validation - it expired on: " + proxyCertChain[0].getNotAfter());
            }
            catch (CertificateNotYetValidException e) {
                throw new DelegationException("Failed proxy validation - it will be valid from: " + proxyCertChain[0].getNotBefore());
            }
        }
        String proxySubjectDN = X500NameUtils.getReadableForm((X500Principal)proxyCertChain[0].getSubjectX500Principal());
        String proxyIssuerDN = X500NameUtils.getReadableForm((X500Principal)proxyCertChain[0].getIssuerX500Principal());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Proxy Subject DN: " + proxySubjectDN));
            logger.debug((Object)("Proxy Issuer DN: " + proxyIssuerDN));
            logger.debug((Object)("Proxy Public key:" + proxyCertChain[0].getPublicKey()));
            logger.debug((Object)("chain length is: " + proxyCertChain.length));
            logger.debug((Object)("last cert is:" + proxyCertChain[proxyCertChain.length - 1]));
            for (int n = 0; n < proxyCertChain.length; ++n) {
                logger.debug((Object)("cert [" + n + "] is from " + X500NameUtils.getReadableForm((X500Principal)proxyCertChain[n].getSubjectX500Principal())));
            }
        }
        if (proxySubjectDN == null || proxyIssuerDN == null) {
            logger.error((Object)"Failed to get DN (subject or issuer) out of proxy. It came null");
            throw new DelegationException("Failed to get DN (subject or issuer) out of proxy.");
        }
        logger.debug((Object)("Client DN: " + info.dn));
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(info.dn, info.vomsAttributes);
        }
        logger.debug((Object)("Delegation ID is '" + delegationID + "'"));
        if (!proxyIssuerDN.endsWith(info.dn)) {
            String message = "Client '" + info.dn + "' is not issuer of proxy '" + proxyIssuerDN + "'.";
            logger.error((Object)message);
            throw new DelegationException(message);
        }
        String cacheID = delegationID;
        cacheID = delegationID + '+' + GrDPX509Util.generateSessionID(proxyCertChain[0].getPublicKey());
        logger.debug((Object)("public key is: " + proxyCertChain[0].getPublicKey()));
        logger.debug((Object)("Cache ID (delegation ID + session ID): " + cacheID));
        GrDPStorageCacheElement cacheElem = null;
        try {
            cacheElem = this.m_storage.findGrDPStorageCacheElement(cacheID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failed to get certificate request information from storage.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (cacheElem == null) {
            logger.info((Object)("Could not find cache ID '" + cacheID + "' for DN '" + info.dn + "' in cache."));
            throw new DelegationException("Could not find a proper delegation request");
        }
        logger.debug((Object)("Got from cache element for cache ID '" + cacheID + "' and DN '" + info.dn + "'"));
        PEMReader pemReader = new PEMReader((Reader)new StringReader(cacheElem.getCertificateRequest()));
        try {
            req = (PKCS10CertificationRequest)pemReader.readObject();
            pemReader.close();
        }
        catch (IOException e1) {
            logger.error((Object)"Could not load the original certificate request from cache.");
            throw new DelegationException("Could not load the original certificate request from cache: " + e1.getMessage());
        }
        if (req == null) {
            logger.error((Object)"Could not load the original certificate request from cache.");
            throw new DelegationException("Could not load the original certificate request from cache.");
        }
        try {
            if (!req.getPublicKey().equals(proxyCertChain[0].getPublicKey())) {
                logger.error((Object)"The proxy and the original request's public key do not match.");
                logger.error((Object)("Proxy public key: " + proxyCertChain[0].getPublicKey()));
                logger.error((Object)("Request public key: " + req.getPublicKey()));
                throw new DelegationException("The proxy and the original request's public key do not match.");
            }
        }
        catch (GeneralSecurityException ge) {
            logger.error((Object)("Error while decoding the certificate request: " + ge));
            throw new DelegationException("Error while decoding the certificate request.");
        }
        ByteArrayInputStream keyStream = new ByteArrayInputStream(cacheElem.getPrivateKey().getBytes());
        try {
            privateKey = CertificateUtils.loadPrivateKey((InputStream)keyStream, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, null);
        }
        catch (IOException e) {
            throw new DelegationException("Failed to read private key from storage, error: " + e.getClass() + ": " + e.getMessage());
        }
        try {
            credential = new KeyAndCertCredential(privateKey, proxyCertChain);
        }
        catch (KeyStoreException e) {
            throw new DelegationException("Failed to handle credentials, error: " + e.getClass() + ": " + e.getMessage());
        }
        ByteArrayOutputStream proxyStream = new ByteArrayOutputStream();
        try {
            CertificateUtils.savePEMKeystore((OutputStream)proxyStream, (KeyStore)credential.getKeyStore(), (String)credential.getKeyAlias(), null, (char[])credential.getKeyPassword(), null, (boolean)true);
        }
        catch (Exception e) {
            logger.error((Object)("Error while converting the proxy to string for storage: " + e.getClass() + ": " + e.getMessage()));
            e.printStackTrace();
            throw new DelegationException("Error while converting the proxy to string for storage: " + e.getClass() + ": " + e.getMessage());
        }
        String completeProxy = proxyStream.toString();
        if (completeProxy == null) {
            logger.error((Object)"Failed to add private key to the proxy certificate chain.");
            throw new DelegationException("Could not properly process given proxy.");
        }
        try {
            GrDPStorageElement elem = this.m_storage.findGrDPStorageElement(delegationID, info.dn);
            if (elem != null) {
                elem.setCertificate(completeProxy);
                elem.setTerminationTime(proxyCertChain[0].getNotAfter());
                this.m_storage.updateGrDPStorageElement(elem);
            } else {
                elem = new GrDPStorageElement();
                elem.setDelegationID(delegationID);
                elem.setDN(info.dn);
                elem.setVomsAttributes(info.vomsAttributes);
                elem.setCertificate(completeProxy);
                elem.setTerminationTime(proxyCertChain[0].getNotAfter());
                this.m_storage.insertGrDPStorageElement(elem);
            }
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failed to put certificate request in storage.", (Throwable)e);
            throw new DelegationException("Internal failure: " + e.getMessage());
        }
        logger.debug((Object)"Delegation finished successfully.");
        try {
            this.m_storage.deleteGrDPStorageCacheElement(cacheID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.warn((Object)"Failed to remove credential from storage cache.");
        }
    }

    public void destroy(String inDelegationID, X509Certificate[] certs) throws DelegationException {
        logger.debug((Object)"Processing destroy.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        CertInfoTriple info = new CertInfoTriple(certs, vomsValidator, requireVomsAttrs);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(info.dn, info.vomsAttributes);
        }
        logger.debug((Object)("Got destroy request for delegation id '" + delegationID + "' from client '" + info.dn + "'"));
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction. Exception: ", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem == null) {
            logger.debug((Object)("Failed to find delegation ID '" + delegationID + "' for client '" + info.dn + "' in storage."));
            throw new DelegationException("Failed to find delegation ID '" + delegationID + "' in storage.");
        }
        try {
            this.m_storage.deleteGrDPStorageElement(delegationID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)("Inconsistency needs manual intervention. Delegation ID '" + delegationID + " of client '" + info.dn + "' was found, " + "but could not be removed from storage."));
            throw new DelegationException("Failed to destroy delegated credential.");
        }
        logger.debug((Object)"Delegated credential destroyed.");
    }

    public Calendar getTerminationTime(String inDelegationID, X509Certificate[] certs) throws DelegationException {
        logger.debug((Object)"Processing getTerminationTime.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        CertInfoTriple info = new CertInfoTriple(certs, vomsValidator, requireVomsAttrs);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(info.dn, info.vomsAttributes);
        }
        logger.debug((Object)("Got getTerminationTime request for delegation id '" + delegationID + "' from client '" + info.dn + "'"));
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, info.dn);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction. Exception: ", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem == null) {
            logger.debug((Object)("Failed to find delegation ID '" + delegationID + "' for client '" + info.dn + "' in storage."));
            throw new DelegationException("Failed to find delegation ID '" + delegationID + "' in storage.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(elem.getTerminationTime());
        return cal;
    }

    private String createAndStoreCertificateRequest(X509Certificate[] certs, String dlgID, String clientDN, String[] vomsAttributes) throws DelegationException {
        String certRequest = null;
        PrivateKey privKey = null;
        ProxyCSR proxyCsr = null;
        String privateKeyString = null;
        try {
            ProxyCertificateOptions options = new ProxyCertificateOptions(certs);
            ProxyChainInfo info = new ProxyChainInfo(certs);
            ProxyType type = info.getProxyType().toProxyType();
            options.setType(type);
            options.setKeyLength(this.m_keySize);
            if (this.limited || info.isLimited()) {
                options.setLimited(this.limited);
            }
            proxyCsr = ProxyCSRGenerator.generate((ProxyCertificateOptions)options);
            PKCS10CertificationRequest req = proxyCsr.getCSR();
            privKey = proxyCsr.getPrivateKey();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                CertificateUtils.savePrivateKey((OutputStream)stream, (PrivateKey)privKey, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, null, null);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Failed to generate certificate request.", (Throwable)e);
                throw new DelegationException("Internal failure, failed to generate certificate request.", e);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to generate certificate request.", (Throwable)e);
                throw new DelegationException("Internal failure, failed to generate certificate request.", e);
            }
            privateKeyString = stream.toString();
            StringWriter stringWriter = new StringWriter();
            PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
            try {
                pemWriter.writeObject((Object)req);
                pemWriter.flush();
                pemWriter.close();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to put certificate request in storage.", (Throwable)e);
                throw new DelegationException("Internal failure.", e);
            }
            certRequest = stringWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Error while generating the certificate request." + e));
            throw new DelegationException("Failed to generate a certificate request. " + e.getMessage());
        }
        logger.debug((Object)"Certificate request generation was successfull.");
        String cacheID = null;
        try {
            cacheID = dlgID + '+' + GrDPX509Util.generateSessionID(proxyCsr.getCSR().getPublicKey());
            logger.debug((Object)("public key is: " + proxyCsr.getCSR().getPublicKey()));
            logger.debug((Object)("Cache ID (delegation ID + session ID): " + cacheID));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to generate certificate request.", (Throwable)e);
            throw new DelegationException("Internal failure, failed to generate certificate request.", e);
        }
        try {
            GrDPStorageCacheElement cacheElem = new GrDPStorageCacheElement();
            cacheElem.setDelegationID(cacheID);
            cacheElem.setDN(clientDN);
            cacheElem.setVomsAttributes(vomsAttributes);
            cacheElem.setCertificateRequest(certRequest);
            cacheElem.setPrivateKey(privateKeyString);
            this.m_storage.insertGrDPStorageCacheElement(cacheElem);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failed to put certificate request in storage.", (Throwable)e);
            throw new DelegationException("Internal failure.", e);
        }
        logger.debug((Object)"New certificate request successfully stored in cache.");
        return certRequest;
    }
}

