/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyCSRInfo;
import eu.emi.security.authn.x509.proxy.ProxyChainInfo;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyRequestOptions;
import eu.emi.security.authn.x509.proxy.ProxyType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.glite.security.delegation.DelegationException;
import org.glite.security.delegation.GrDProxyDlgorOptions;

public class DelegationHandler {
    private static final Logger LOGGER = Logger.getLogger(DelegationHandler.class);
    private X509Certificate[] m_certs = null;
    private String strX509CertChain = null;

    public DelegationHandler(String certReq, String delegationID, String propFile) throws Exception {
        GrDProxyDlgorOptions dlgorOpt = null;
        try {
            dlgorOpt = new GrDProxyDlgorOptions(propFile);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("failed to read delegation options from: " + propFile + " nor from default location. Error was: " + e2.getMessage()));
            return;
        }
        this.requestHandler(certReq, delegationID, dlgorOpt);
    }

    public DelegationHandler(String certReq, String delegationID, GrDProxyDlgorOptions opts) throws Exception {
        this.requestHandler(certReq, delegationID, opts);
    }

    private void requestHandler(String certReq, String delegationID, GrDProxyDlgorOptions dlgorOpt) throws Exception {
        try {
            PKCS10CertificationRequest req;
            LOGGER.debug((Object)("User Cert/Proxy File" + dlgorOpt.getDlgorCertFile()));
            LOGGER.debug((Object)("User Key/Proxy File" + dlgorOpt.getDlgorKeyFile()));
            LOGGER.debug((Object)("User Password" + dlgorOpt.getDlgorPass()));
            LOGGER.debug((Object)("Certificate Request" + certReq));
            char[] pass = null;
            if (dlgorOpt.getDlgorPass() != null) {
                pass = dlgorOpt.getDlgorPass().toCharArray();
            }
            PEMCredential pemCredential = null;
            pemCredential = dlgorOpt.getDlgorKeyFile() == null ? new PEMCredential(dlgorOpt.getDlgorCertFile(), pass) : new PEMCredential(dlgorOpt.getDlgorCertFile(), dlgorOpt.getDlgorKeyFile(), pass);
            X509Certificate[] certs = pemCredential.getCertificateChain();
            for (int n = 0; n < certs.length; ++n) {
                LOGGER.debug((Object)("cert [" + n + "] is from " + X500NameUtils.getReadableForm((X500Principal)certs[n].getSubjectX500Principal())));
            }
            PEMReader pemReader = new PEMReader((Reader)new StringReader(certReq));
            try {
                req = (PKCS10CertificationRequest)pemReader.readObject();
            }
            catch (IOException e1) {
                LOGGER.error((Object)"Could not load the original certificate request from cache.");
                throw new DelegationException("Could not load the original certificate request from cache: " + e1.getMessage());
            }
            finally {
                pemReader.close();
            }
            ProxyRequestOptions options = new ProxyRequestOptions(certs, req);
            ProxyCSRInfo reqInfo = new ProxyCSRInfo(req);
            options.setType(reqInfo.getProxyType());
            ProxyChainInfo info = new ProxyChainInfo(certs);
            boolean reqLimited = false;
            if (reqInfo.isLimited() != null) {
                reqLimited = reqInfo.isLimited();
            }
            if (dlgorOpt.isLimited() || reqLimited || info.isLimited()) {
                if (reqInfo.getProxyType() != ProxyType.LEGACY) {
                    options.setPolicy(new ProxyPolicy("1.3.6.1.4.1.3536.1.1.1.9"));
                }
                options.setLimited(true);
            }
            if (dlgorOpt.getTracingIssuer() != null) {
                options.setProxyTracingIssuer(dlgorOpt.getTracingIssuer());
            }
            if (dlgorOpt.getTracingSubject() != null) {
                options.setProxyTracingSubject(dlgorOpt.getTracingSubject());
            }
            this.m_certs = ProxyGenerator.generate((ProxyRequestOptions)options, (PrivateKey)pemCredential.getKey());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CertificateUtils.saveCertificateChain((OutputStream)stream, (X509Certificate[])this.m_certs, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            this.strX509CertChain = stream.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Proxy generation failed: " + e));
            throw e;
        }
    }

    public X509Certificate[] getProxyCertificate() throws Exception {
        return this.m_certs;
    }

    public String getPEMProxyCertificate() {
        return this.strX509CertChain;
    }
}

