/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPRevocationChecker;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPVerifier;
import eu.emi.security.authn.x509.helpers.pkipath.ExtPKIXParameters;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CRLRevocationChecker;
import eu.emi.security.authn.x509.helpers.revocation.RevocationChecker;
import eu.emi.security.authn.x509.helpers.revocation.RevocationStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.i18n.LocaleString;
import org.bouncycastle.i18n.filter.TrustedInput;
import org.bouncycastle.i18n.filter.UntrustedInput;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import org.bouncycastle.jce.provider.PKIXPolicyNode;
import org.bouncycastle.x509.CertPathReviewerException;
import org.bouncycastle.x509.PKIXCertPathReviewer;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class FixedBCPKIXCertPathReviewer
extends PKIXCertPathReviewer {
    private static final String QC_STATEMENT = X509Extensions.QCStatements.getId();
    public static final String RESOURCE_NAME = "org.bouncycastle.x509.CertPathReviewerMessages";
    protected ExtPKIXParameters pkixParams;
    private boolean initialized;

    public void init(CertPath certPath, ExtPKIXParameters params) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = params.clone();
        this.validDate = FixedBCPKIXCertPathReviewer.getValidDate((PKIXParameters)((Object)this.pkixParams));
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public FixedBCPKIXCertPathReviewer(CertPath certPath, ExtPKIXParameters params) throws CertPathReviewerException {
        this.init(certPath, params);
    }

    protected void addError(SimpleValidationErrorException msg, int index) {
        if (index < -1 || index >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[index + 1].add(msg);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i = 0; i < this.notifications.length; ++i) {
                this.notifications[i] = new ArrayList();
                this.errors[i] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        X509Certificate cert = null;
        PKIXNameConstraintValidator nameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            for (int index = this.certs.size() - 1; index >= 0; --index) {
                ASN1Sequence excluded;
                ASN1Sequence ncSeq;
                Enumeration e;
                cert = (X509Certificate)this.certs.get(index);
                if (!FixedBCPKIXCertPathReviewer.isSelfIssued((X509Certificate)cert) || index == 0) {
                    ASN1Sequence altName;
                    ErrorBundle msg;
                    ASN1Sequence dns;
                    X500Principal principal = FixedBCPKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)cert);
                    ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(principal.getEncoded()));
                    try {
                        dns = (ASN1Sequence)aIn.readObject();
                    }
                    catch (IOException e2) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput((Object)principal)});
                        throw new CertPathReviewerException(msg, (Throwable)e2, this.certPath, index);
                    }
                    try {
                        nameConstraintValidator.checkPermittedDN(dns);
                    }
                    catch (PKIXNameConstraintValidatorException cpve) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput((Object)principal.getName())});
                        throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                    }
                    try {
                        nameConstraintValidator.checkExcludedDN(dns);
                    }
                    catch (PKIXNameConstraintValidatorException cpve) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput((Object)principal.getName())});
                        throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                    }
                    Vector emails = new X509Name(dns).getValues(X509Name.EmailAddress);
                    e = emails.elements();
                    while (e.hasMoreElements()) {
                        String email = (String)e.nextElement();
                        GeneralName emailAsGeneralName = new GeneralName(1, email);
                        try {
                            nameConstraintValidator.checkPermitted(emailAsGeneralName);
                        }
                        catch (PKIXNameConstraintValidatorException cpve) {
                            ErrorBundle msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput((Object)principal.getName())});
                            throw new CertPathReviewerException(msg2, (Throwable)cpve, this.certPath, index);
                        }
                        try {
                            nameConstraintValidator.checkExcluded(emailAsGeneralName);
                        }
                        catch (PKIXNameConstraintValidatorException cpve) {
                            ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput((Object)principal.getName())});
                            throw new CertPathReviewerException(msg3, (Throwable)cpve, this.certPath, index);
                        }
                    }
                    try {
                        altName = (ASN1Sequence)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException ae) {
                        ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException(msg4, (Throwable)ae, this.certPath, index);
                    }
                    if (altName != null) {
                        for (int j = 0; j < altName.size(); ++j) {
                            GeneralName name = GeneralName.getInstance((Object)altName.getObjectAt(j));
                            try {
                                nameConstraintValidator.checkPermitted(name);
                                nameConstraintValidator.checkExcluded(name);
                                continue;
                            }
                            catch (PKIXNameConstraintValidatorException cpve) {
                                ErrorBundle msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput((Object)name)});
                                throw new CertPathReviewerException(msg5, (Throwable)cpve, this.certPath, index);
                            }
                        }
                    }
                }
                try {
                    ncSeq = (ASN1Sequence)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)NAME_CONSTRAINTS);
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException(msg, (Throwable)ae, this.certPath, index);
                }
                if (ncSeq == null) continue;
                NameConstraints nc = new NameConstraints(ncSeq);
                ASN1Sequence permitted = nc.getPermittedSubtrees();
                if (permitted != null) {
                    nameConstraintValidator.intersectPermittedSubtree(permitted);
                }
                if ((excluded = nc.getExcludedSubtrees()) == null) continue;
                e = excluded.getObjects();
                while (e.hasMoreElements()) {
                    GeneralSubtree subtree = GeneralSubtree.getInstance(e.nextElement());
                    nameConstraintValidator.addExcludedSubtree(subtree);
                }
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
        }
    }

    private void checkPathLength() {
        int maxPathLength = this.n;
        int totalPathLength = 0;
        X509Certificate cert = null;
        for (int index = this.certs.size() - 1; index > 0; --index) {
            int _plc;
            BigInteger _pathLengthConstraint;
            BasicConstraints bc;
            cert = (X509Certificate)this.certs.get(index);
            if (!FixedBCPKIXCertPathReviewer.isSelfIssued((X509Certificate)cert)) {
                if (maxPathLength <= 0) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pathLenghtExtended");
                    this.addError(msg);
                }
                --maxPathLength;
                ++totalPathLength;
            }
            try {
                bc = BasicConstraints.getInstance((Object)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException ae) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.processLengthConstError");
                this.addError(msg, index);
                bc = null;
            }
            if (bc == null || (_pathLengthConstraint = bc.getPathLenConstraint()) == null || (_plc = _pathLengthConstraint.intValue()) >= maxPathLength) continue;
            maxPathLength = _plc;
        }
        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.totalPathLength", new Object[]{new Integer(totalPathLength)});
        this.addNotification(msg);
    }

    private void checkSignatures() {
        ErrorBundle msg;
        ErrorBundle msg2;
        TrustAnchor trust = null;
        X500Principal trustPrincipal = null;
        ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput((Object)this.validDate), new TrustedInput((Object)new Date())});
        this.addNotification(msg3);
        try {
            X509Certificate cert = (X509Certificate)this.certs.get(this.certs.size() - 1);
            Collection trustColl = this.getTrustAnchors(cert, this.pkixParams.getTrustAnchors());
            if (trustColl.size() > 1) {
                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.conflictingTrustAnchors", new Object[]{new Integer(trustColl.size()), new UntrustedInput((Object)cert.getIssuerX500Principal())});
                this.addError(msg2);
            } else if (trustColl.isEmpty()) {
                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput((Object)cert.getIssuerX500Principal()), new Integer(this.pkixParams.getTrustAnchors().size())});
                this.addError(msg2);
            } else {
                trust = (TrustAnchor)trustColl.iterator().next();
                PublicKey trustPublicKey = trust.getTrustedCert() != null ? trust.getTrustedCert().getPublicKey() : trust.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)cert, (PublicKey)trustPublicKey, (String)this.pkixParams.getSigProvider());
                }
                catch (SignatureException e) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustButInvalidCert");
                    this.addError(msg);
                }
                catch (Exception e) {}
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage());
        }
        catch (Throwable t) {
            ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknown", new Object[]{new UntrustedInput((Object)t.getMessage()), new UntrustedInput((Object)t)});
            this.addError(msg4);
        }
        if (trust != null) {
            boolean[] ku;
            X509Certificate sign = trust.getTrustedCert();
            try {
                trustPrincipal = sign != null ? FixedBCPKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)sign) : new X500Principal(trust.getCAName());
            }
            catch (IllegalArgumentException ex) {
                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput((Object)trust.getCAName())});
                this.addError(msg2);
            }
            if (sign != null && (ku = sign.getKeyUsage()) != null && !ku[5]) {
                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustKeyUsage");
                this.addNotification(msg2);
            }
        }
        PublicKey workingPublicKey = null;
        X500Principal workingIssuerName = trustPrincipal;
        X509Certificate sign = null;
        if (trust != null) {
            sign = trust.getTrustedCert();
            workingPublicKey = sign != null ? sign.getPublicKey() : trust.getCAPublicKey();
            try {
                FixedBCPKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)workingPublicKey);
            }
            catch (CertPathValidatorException ex) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustPubKeyError");
                this.addError(msg);
            }
        }
        X509Certificate cert = null;
        for (int index = this.certs.size() - 1; index >= 0; --index) {
            ErrorBundle msg5;
            ErrorBundle msg6;
            int i = this.n - index;
            cert = (X509Certificate)this.certs.get(index);
            if (workingPublicKey != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)cert, (PublicKey)workingPublicKey, (String)this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException ex) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{ex.getMessage(), ex, ex.getClass().getName()});
                    this.addError(msg6, index);
                }
            } else if (FixedBCPKIXCertPathReviewer.isSelfIssued((X509Certificate)cert)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)cert, (PublicKey)cert.getPublicKey(), (String)this.pkixParams.getSigProvider());
                    msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError(msg5, index);
                }
                catch (GeneralSecurityException ex) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{ex.getMessage(), ex, ex.getClass().getName()});
                    this.addError(msg6, index);
                }
            } else {
                msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.NoIssuerPublicKey");
                byte[] akiBytes = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (akiBytes != null) {
                    try {
                        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])akiBytes));
                        GeneralNames issuerNames = aki.getAuthorityCertIssuer();
                        if (issuerNames != null) {
                            GeneralName name = issuerNames.getNames()[0];
                            BigInteger serial = aki.getAuthorityCertSerialNumber();
                            if (serial != null) {
                                Object[] extraArgs = new Object[]{new LocaleString(RESOURCE_NAME, "missingIssuer"), " \"", name, "\" ", new LocaleString(RESOURCE_NAME, "missingSerial"), " ", serial};
                                msg5.setExtraArguments(extraArgs);
                            }
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.addError(msg5, index);
            }
            try {
                cert.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException cnve) {
                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput((Object)cert.getNotBefore())});
                this.addError(msg6, index);
            }
            catch (CertificateExpiredException cee) {
                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateExpired", new Object[]{new TrustedInput((Object)cert.getNotAfter())});
                this.addError(msg6, index);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                try {
                    this.checkRevocation(this.pkixParams, cert, this.validDate, sign, workingPublicKey);
                }
                catch (SimpleValidationErrorException e) {
                    this.addError(e, index);
                }
            }
            if (workingIssuerName != null && !cert.getIssuerX500Principal().equals(workingIssuerName)) {
                msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certWrongIssuer", new Object[]{workingIssuerName.getName(), cert.getIssuerX500Principal().getName()});
                this.addError(msg5, index);
            }
            if (i != this.n) {
                ErrorBundle msg7;
                if (cert != null && cert.getVersion() == 1) {
                    msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                    this.addError(msg5, index);
                }
                try {
                    BasicConstraints bc = BasicConstraints.getInstance((Object)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)BASIC_CONSTRAINTS));
                    if (bc != null) {
                        if (!bc.isCA()) {
                            msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                            this.addError(msg6, index);
                        }
                    } else {
                        msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBasicConstraints");
                        this.addError(msg6, index);
                    }
                }
                catch (AnnotatedException ae) {
                    msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.errorProcesingBC");
                    this.addError(msg7, index);
                }
                boolean[] _usage = cert.getKeyUsage();
                if (_usage != null && !_usage[5]) {
                    msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCertSign");
                    this.addError(msg7, index);
                }
            }
            sign = cert;
            workingIssuerName = cert.getSubjectX500Principal();
            try {
                workingPublicKey = FixedBCPKIXCertPathReviewer.getNextWorkingKey((List)this.certs, (int)index);
                FixedBCPKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)workingPublicKey);
                continue;
            }
            catch (CertPathValidatorException ex) {
                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pubKeyError");
                this.addError(msg6, index);
            }
        }
        this.trustAnchor = trust;
        this.subjectPublicKey = workingPublicKey;
    }

    private void checkPolicy() {
        Set userInitialPolicySet = this.pkixParams.getInitialPolicies();
        List[] policyNodes = new ArrayList[this.n + 1];
        for (int j = 0; j < policyNodes.length; ++j) {
            policyNodes[j] = new ArrayList();
        }
        HashSet<String> policySet = new HashSet<String>();
        policySet.add("2.5.29.32.0");
        PKIXPolicyNode validPolicyTree = new PKIXPolicyNode(new ArrayList(), 0, policySet, null, new HashSet(), "2.5.29.32.0", false);
        policyNodes[0].add(validPolicyTree);
        int explicitPolicy = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int inhibitAnyPolicy = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int policyMapping = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        HashSet<String> acceptablePolicies = null;
        X509Certificate cert = null;
        try {
            HashSet _validPolicyNodeSet;
            PKIXPolicyNode intersection;
            ErrorBundle msg;
            int index;
            for (index = this.certs.size() - 1; index >= 0; --index) {
                ASN1Sequence mappings;
                DERObject pm;
                ErrorBundle msg2;
                ASN1Sequence certPolicies;
                int i = this.n - index;
                cert = (X509Certificate)this.certs.get(index);
                try {
                    certPolicies = (ASN1Sequence)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException(msg3, (Throwable)ae, this.certPath, index);
                }
                if (certPolicies != null && validPolicyTree != null) {
                    PolicyInformation pInfo;
                    Enumeration e = certPolicies.getObjects();
                    HashSet<String> pols = new HashSet<String>();
                    while (e.hasMoreElements()) {
                        Set pq;
                        pInfo = PolicyInformation.getInstance(e.nextElement());
                        DERObjectIdentifier pOid = pInfo.getPolicyIdentifier();
                        pols.add(pOid.getId());
                        if ("2.5.29.32.0".equals(pOid.getId())) continue;
                        try {
                            pq = FixedBCPKIXCertPathReviewer.getQualifierSet((ASN1Sequence)pInfo.getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException cpve) {
                            msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException(msg2, (Throwable)cpve, this.certPath, index);
                        }
                        boolean match = FixedBCPKIXCertPathReviewer.processCertD1i((int)i, (List[])policyNodes, (DERObjectIdentifier)pOid, (Set)pq);
                        if (match) continue;
                        FixedBCPKIXCertPathReviewer.processCertD1ii((int)i, (List[])policyNodes, (DERObjectIdentifier)pOid, (Set)pq);
                    }
                    if (acceptablePolicies == null || acceptablePolicies.contains("2.5.29.32.0")) {
                        acceptablePolicies = pols;
                    } else {
                        Iterator it = acceptablePolicies.iterator();
                        HashSet t1 = new HashSet();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!pols.contains(o)) continue;
                            t1.add(o);
                        }
                        acceptablePolicies = t1;
                    }
                    if (inhibitAnyPolicy > 0 || i < this.n && FixedBCPKIXCertPathReviewer.isSelfIssued((X509Certificate)cert)) {
                        e = certPolicies.getObjects();
                        while (e.hasMoreElements()) {
                            Set _apq;
                            pInfo = PolicyInformation.getInstance(e.nextElement());
                            if (!"2.5.29.32.0".equals(pInfo.getPolicyIdentifier().getId())) continue;
                            try {
                                _apq = FixedBCPKIXCertPathReviewer.getQualifierSet((ASN1Sequence)pInfo.getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException cpve) {
                                ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(msg4, (Throwable)cpve, this.certPath, index);
                            }
                            List _nodes = policyNodes[i - 1];
                            for (int k = 0; k < _nodes.size(); ++k) {
                                PKIXPolicyNode _node = (PKIXPolicyNode)_nodes.get(k);
                                for (Object _tmp : _node.getExpectedPolicies()) {
                                    String _policy;
                                    if (_tmp instanceof String) {
                                        _policy = (String)_tmp;
                                    } else {
                                        if (!(_tmp instanceof DERObjectIdentifier)) continue;
                                        _policy = ((DERObjectIdentifier)_tmp).getId();
                                    }
                                    boolean _found = false;
                                    Iterator _childrenIter = _node.getChildren();
                                    while (_childrenIter.hasNext()) {
                                        PKIXPolicyNode _child = (PKIXPolicyNode)_childrenIter.next();
                                        if (!_policy.equals(_child.getValidPolicy())) continue;
                                        _found = true;
                                    }
                                    if (_found) continue;
                                    HashSet<String> _newChildExpectedPolicies = new HashSet<String>();
                                    _newChildExpectedPolicies.add(_policy);
                                    PKIXPolicyNode _newChild = new PKIXPolicyNode(new ArrayList(), i, _newChildExpectedPolicies, (PolicyNode)_node, _apq, _policy, false);
                                    _node.addChild(_newChild);
                                    policyNodes[i].add(_newChild);
                                }
                            }
                        }
                    }
                    for (int j = i - 1; j >= 0; --j) {
                        PKIXPolicyNode node;
                        List nodes = policyNodes[j];
                        for (int k = 0; k < nodes.size() && ((node = (PKIXPolicyNode)nodes.get(k)).hasChildren() || (validPolicyTree = FixedBCPKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)validPolicyTree, (List[])policyNodes, (PKIXPolicyNode)node)) != null); ++k) {
                        }
                    }
                    Set<String> criticalExtensionOids = cert.getCriticalExtensionOIDs();
                    if (criticalExtensionOids != null) {
                        boolean critical = criticalExtensionOids.contains(CERTIFICATE_POLICIES);
                        List nodes = policyNodes[i];
                        for (int j = 0; j < nodes.size(); ++j) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(j);
                            node.setCritical(critical);
                        }
                    }
                }
                if (certPolicies == null) {
                    validPolicyTree = null;
                }
                if (explicitPolicy <= 0 && validPolicyTree == null) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException(msg);
                }
                if (i == this.n) continue;
                try {
                    pm = FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)POLICY_MAPPINGS);
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(msg5, (Throwable)ae, this.certPath, index);
                }
                if (pm != null) {
                    mappings = (ASN1Sequence)pm;
                    for (int j = 0; j < mappings.size(); ++j) {
                        ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j);
                        DERObjectIdentifier ip_id = (DERObjectIdentifier)mapping.getObjectAt(0);
                        DERObjectIdentifier sp_id = (DERObjectIdentifier)mapping.getObjectAt(1);
                        if ("2.5.29.32.0".equals(ip_id.getId())) {
                            msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException(msg2, this.certPath, index);
                        }
                        if (!"2.5.29.32.0".equals(sp_id.getId())) continue;
                        msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException(msg2, this.certPath, index);
                    }
                }
                if (pm != null) {
                    mappings = (ASN1Sequence)pm;
                    HashMap m_idp = new HashMap();
                    HashSet<String> s_idp = new HashSet<String>();
                    for (int j = 0; j < mappings.size(); ++j) {
                        Set<String> tmp;
                        ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j);
                        String id_p = ((DERObjectIdentifier)mapping.getObjectAt(0)).getId();
                        String sd_p = ((DERObjectIdentifier)mapping.getObjectAt(1)).getId();
                        if (!m_idp.containsKey(id_p)) {
                            tmp = new HashSet<String>();
                            tmp.add(sd_p);
                            m_idp.put(id_p, tmp);
                            s_idp.add(id_p);
                            continue;
                        }
                        tmp = (Set)m_idp.get(id_p);
                        tmp.add(sd_p);
                    }
                    for (String id_p : s_idp) {
                        if (policyMapping > 0) {
                            ErrorBundle msg6;
                            try {
                                FixedBCPKIXCertPathReviewer.prepareNextCertB1((int)i, (List[])policyNodes, (String)id_p, m_idp, (X509Certificate)cert);
                                continue;
                            }
                            catch (AnnotatedException ae) {
                                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException(msg6, (Throwable)ae, this.certPath, index);
                            }
                            catch (CertPathValidatorException cpve) {
                                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(msg6, (Throwable)cpve, this.certPath, index);
                            }
                        }
                        if (policyMapping > 0) continue;
                        validPolicyTree = FixedBCPKIXCertPathReviewer.prepareNextCertB2((int)i, (List[])policyNodes, (String)id_p, (PKIXPolicyNode)validPolicyTree);
                    }
                }
                if (!FixedBCPKIXCertPathReviewer.isSelfIssued((X509Certificate)cert)) {
                    if (explicitPolicy != 0) {
                        --explicitPolicy;
                    }
                    if (policyMapping != 0) {
                        --policyMapping;
                    }
                    if (inhibitAnyPolicy != 0) {
                        --inhibitAnyPolicy;
                    }
                }
                try {
                    ASN1Sequence pc = (ASN1Sequence)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)POLICY_CONSTRAINTS);
                    if (pc != null) {
                        Enumeration policyConstraints = pc.getObjects();
                        while (policyConstraints.hasMoreElements()) {
                            ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                            switch (constraint.getTagNo()) {
                                case 0: {
                                    int tmpInt = DERInteger.getInstance((ASN1TaggedObject)constraint, (boolean)false).getValue().intValue();
                                    if (tmpInt >= explicitPolicy) break;
                                    explicitPolicy = tmpInt;
                                    break;
                                }
                                case 1: {
                                    int tmpInt = DERInteger.getInstance((ASN1TaggedObject)constraint, (boolean)false).getValue().intValue();
                                    if (tmpInt >= policyMapping) break;
                                    policyMapping = tmpInt;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(msg7, this.certPath, index);
                }
                try {
                    int _inhibitAnyPolicy;
                    DERInteger iap = (DERInteger)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)INHIBIT_ANY_POLICY);
                    if (iap == null || (_inhibitAnyPolicy = iap.getValue().intValue()) >= inhibitAnyPolicy) continue;
                    inhibitAnyPolicy = _inhibitAnyPolicy;
                    continue;
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(msg8, this.certPath, index);
                }
            }
            if (!FixedBCPKIXCertPathReviewer.isSelfIssued(cert) && explicitPolicy > 0) {
                --explicitPolicy;
            }
            try {
                ASN1Sequence pc = (ASN1Sequence)FixedBCPKIXCertPathReviewer.getExtensionValue(cert, (String)POLICY_CONSTRAINTS);
                if (pc != null) {
                    Enumeration policyConstraints = pc.getObjects();
                    while (policyConstraints.hasMoreElements()) {
                        ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                        switch (constraint.getTagNo()) {
                            case 0: {
                                int tmpInt = DERInteger.getInstance((ASN1TaggedObject)constraint, (boolean)false).getValue().intValue();
                                if (tmpInt != 0) break;
                                explicitPolicy = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException e) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException(msg, this.certPath, index);
            }
            if (validPolicyTree == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException(msg, this.certPath, index);
                }
                intersection = null;
            } else if (FixedBCPKIXCertPathReviewer.isAnyPolicy((Set)userInitialPolicySet)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (acceptablePolicies.isEmpty()) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException(msg, this.certPath, index);
                    }
                    _validPolicyNodeSet = new HashSet();
                    for (int j = 0; j < policyNodes.length; ++j) {
                        ArrayList _nodeDepth = policyNodes[j];
                        for (int k = 0; k < _nodeDepth.size(); ++k) {
                            PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k);
                            if (!"2.5.29.32.0".equals(_node.getValidPolicy())) continue;
                            Iterator _iter = _node.getChildren();
                            while (_iter.hasNext()) {
                                _validPolicyNodeSet.add(_iter.next());
                            }
                        }
                    }
                    for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                        String _validPolicy = _node.getValidPolicy();
                        if (acceptablePolicies.contains(_validPolicy)) continue;
                    }
                    if (validPolicyTree != null) {
                        for (int j = this.n - 1; j >= 0; --j) {
                            List nodes = policyNodes[j];
                            for (int k = 0; k < nodes.size(); ++k) {
                                PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k);
                                if (node.hasChildren()) continue;
                                validPolicyTree = FixedBCPKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)validPolicyTree, (List[])policyNodes, (PKIXPolicyNode)node);
                            }
                        }
                    }
                }
                intersection = validPolicyTree;
            } else {
                _validPolicyNodeSet = new HashSet();
                for (int j = 0; j < policyNodes.length; ++j) {
                    ArrayList _nodeDepth = policyNodes[j];
                    for (int k = 0; k < _nodeDepth.size(); ++k) {
                        PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k);
                        if (!"2.5.29.32.0".equals(_node.getValidPolicy())) continue;
                        Iterator _iter = _node.getChildren();
                        while (_iter.hasNext()) {
                            PKIXPolicyNode _c_node = (PKIXPolicyNode)_iter.next();
                            if ("2.5.29.32.0".equals(_c_node.getValidPolicy())) continue;
                            _validPolicyNodeSet.add(_c_node);
                        }
                    }
                }
                for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                    String _validPolicy = _node.getValidPolicy();
                    if (userInitialPolicySet.contains(_validPolicy)) continue;
                    validPolicyTree = FixedBCPKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)validPolicyTree, (List[])policyNodes, (PKIXPolicyNode)_node);
                }
                if (validPolicyTree != null) {
                    for (int j = this.n - 1; j >= 0; --j) {
                        ArrayList nodes = policyNodes[j];
                        for (int k = 0; k < nodes.size(); ++k) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k);
                            if (node.hasChildren()) continue;
                            validPolicyTree = FixedBCPKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)validPolicyTree, (List[])policyNodes, (PKIXPolicyNode)node);
                        }
                    }
                }
                intersection = validPolicyTree;
            }
            if (explicitPolicy <= 0 && intersection == null) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException(msg);
            }
            validPolicyTree = intersection;
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
            validPolicyTree = null;
        }
    }

    private void checkCriticalExtensions() {
        List pathCheckers = this.pkixParams.getCertPathCheckers();
        Iterator certIter = pathCheckers.iterator();
        try {
            try {
                while (certIter.hasNext()) {
                    ((PKIXCertPathChecker)certIter.next()).init(false);
                }
            }
            catch (CertPathValidatorException cpve) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathCheckerError", new Object[]{cpve.getMessage(), cpve, cpve.getClass().getName()});
                throw new CertPathReviewerException(msg, (Throwable)cpve);
            }
            X509Certificate cert = null;
            for (int index = this.certs.size() - 1; index >= 0; --index) {
                cert = (X509Certificate)this.certs.get(index);
                Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
                if (criticalExtensions == null || criticalExtensions.isEmpty()) continue;
                criticalExtensions.remove(KEY_USAGE);
                criticalExtensions.remove(CERTIFICATE_POLICIES);
                criticalExtensions.remove(POLICY_MAPPINGS);
                criticalExtensions.remove(INHIBIT_ANY_POLICY);
                criticalExtensions.remove(ISSUING_DISTRIBUTION_POINT);
                criticalExtensions.remove(DELTA_CRL_INDICATOR);
                criticalExtensions.remove(POLICY_CONSTRAINTS);
                criticalExtensions.remove(BASIC_CONSTRAINTS);
                criticalExtensions.remove(SUBJECT_ALTERNATIVE_NAME);
                criticalExtensions.remove(NAME_CONSTRAINTS);
                if (criticalExtensions.contains(QC_STATEMENT) && this.processQcStatements(cert, index)) {
                    criticalExtensions.remove(QC_STATEMENT);
                }
                Iterator tmpIter = pathCheckers.iterator();
                while (tmpIter.hasNext()) {
                    try {
                        ((PKIXCertPathChecker)tmpIter.next()).check(cert, criticalExtensions);
                    }
                    catch (CertPathValidatorException e) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.criticalExtensionError", new Object[]{e.getMessage(), e, e.getClass().getName()});
                        throw new CertPathReviewerException(msg, e.getCause(), this.certPath, index);
                    }
                }
                if (criticalExtensions.isEmpty()) continue;
                Iterator<String> it = criticalExtensions.iterator();
                while (it.hasNext()) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExt", new Object[]{new DERObjectIdentifier(it.next())});
                    this.addError(msg, index);
                }
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
        }
    }

    private boolean processQcStatements(X509Certificate cert, int index) {
        try {
            boolean unknownStatement = false;
            ASN1Sequence qcSt = (ASN1Sequence)FixedBCPKIXCertPathReviewer.getExtensionValue((X509Extension)cert, (String)QC_STATEMENT);
            for (int j = 0; j < qcSt.size(); ++j) {
                ErrorBundle msg;
                QCStatement stmt = QCStatement.getInstance((Object)qcSt.getObjectAt(j));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals((Object)stmt.getStatementId())) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcEuCompliance");
                    this.addNotification(msg, index);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals((Object)stmt.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals((Object)stmt.getStatementId())) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcSSCD");
                    this.addNotification(msg, index);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals((Object)stmt.getStatementId())) {
                    MonetaryValue limit = MonetaryValue.getInstance((Object)stmt.getStatementInfo());
                    Iso4217CurrencyCode currency = limit.getCurrency();
                    double value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
                    ErrorBundle msg2 = limit.getCurrency().isAlphabetic() ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueAlpha", new Object[]{limit.getCurrency().getAlphabetic(), new TrustedInput((Object)new Double(value)), limit}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueNum", new Object[]{new Integer(limit.getCurrency().getNumeric()), new TrustedInput((Object)new Double(value)), limit});
                    this.addNotification(msg2, index);
                    continue;
                }
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcUnknownStatement", new Object[]{stmt.getStatementId(), new UntrustedInput((Object)stmt)});
                this.addNotification(msg, index);
                unknownStatement = true;
            }
            return !unknownStatement;
        }
        catch (AnnotatedException ae) {
            ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcStatementExtError");
            this.addError(msg, index);
            return false;
        }
    }

    protected void checkRevocation(ExtPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey) throws SimpleValidationErrorException {
        RevocationParameters params = paramsPKIX.getRevocationParams();
        CRLRevocationChecker crlChecker = new CRLRevocationChecker(paramsPKIX, validDate, workingPublicKey, this.certs, params.getCrlCheckingMode());
        OCSPVerifier ocspVerifier = new OCSPVerifier(params.getOcspParameters(), paramsPKIX.getObservers());
        OCSPRevocationChecker ocspChecker = new OCSPRevocationChecker(ocspVerifier, params.getOcspParameters().getCheckingMode());
        ArrayList<RevocationChecker> revCheckers = new ArrayList<RevocationChecker>(2);
        if (params.getOrder().equals((Object)RevocationParameters.RevocationCheckingOrder.CRL_OCSP)) {
            revCheckers.add(crlChecker);
            revCheckers.add(ocspChecker);
        } else {
            revCheckers.add(ocspChecker);
            revCheckers.add(crlChecker);
        }
        for (RevocationChecker checker : revCheckers) {
            RevocationStatus status = checker.checkRevocation(cert, sign);
            if (status != RevocationStatus.verified || params.isUseAllEnabled()) continue;
            return;
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint crlDistPoints) {
        Vector<String> urls = new Vector<String>();
        if (crlDistPoints != null) {
            DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
            if (distPoints == null) {
                return urls;
            }
            for (int i = 0; i < distPoints.length; ++i) {
                DistributionPointName dp_name = distPoints[i].getDistributionPoint();
                if (dp_name == null || dp_name.getType() != 0) continue;
                GeneralName[] generalNames = GeneralNames.getInstance((Object)dp_name.getName()).getNames();
                for (int j = 0; j < generalNames.length; ++j) {
                    if (generalNames[j].getTagNo() != 6) continue;
                    String url = ((DERIA5String)generalNames[j].getName()).getString();
                    urls.add(url);
                }
            }
        }
        return urls;
    }
}

