/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;

public class RevocationParameters
implements Cloneable {
    public static final RevocationParameters IGNORE = new RevocationParameters(CrlCheckingMode.IGNORE, new OCSPParametes(OCSPCheckingMode.IGNORE));
    protected CrlCheckingMode crlCheckingMode;
    protected OCSPParametes ocspParameters;
    protected boolean useAllEnabled;
    protected RevocationCheckingOrder order;

    public RevocationParameters() {
        this(CrlCheckingMode.IF_VALID, new OCSPParametes());
    }

    public RevocationParameters(CrlCheckingMode crlCheckingMode) {
        this(crlCheckingMode, new OCSPParametes(), false, RevocationCheckingOrder.OCSP_CRL);
    }

    public RevocationParameters(CrlCheckingMode crlCheckingMode, OCSPParametes ocspParameters) {
        this(crlCheckingMode, ocspParameters, false, RevocationCheckingOrder.OCSP_CRL);
    }

    public RevocationParameters(CrlCheckingMode crlCheckingMode, OCSPParametes ocspParametes, boolean useAllEnabled, RevocationCheckingOrder order) {
        this.crlCheckingMode = crlCheckingMode;
        this.ocspParameters = ocspParametes;
        this.useAllEnabled = useAllEnabled;
        this.order = order;
    }

    public CrlCheckingMode getCrlCheckingMode() {
        return this.crlCheckingMode;
    }

    public void setCrlCheckingMode(CrlCheckingMode crlCheckingMode) {
        this.crlCheckingMode = crlCheckingMode;
    }

    public OCSPParametes getOcspParameters() {
        return this.ocspParameters;
    }

    public void setOcspParameters(OCSPParametes ocspParametes) {
        this.ocspParameters = ocspParametes;
    }

    public boolean isUseAllEnabled() {
        return this.useAllEnabled;
    }

    public void setUseAllEnabled(boolean useAllEnabled) {
        this.useAllEnabled = useAllEnabled;
    }

    public RevocationCheckingOrder getOrder() {
        return this.order;
    }

    public void setOrder(RevocationCheckingOrder order) {
        this.order = order;
    }

    public RevocationParameters clone() {
        return new RevocationParameters(this.crlCheckingMode, this.ocspParameters);
    }

    public static enum RevocationCheckingOrder {
        CRL_OCSP,
        OCSP_CRL;

    }
}

