/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.HostnameToCertificateChecker;
import eu.emi.security.authn.x509.helpers.ssl.SSLTrustManager;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SocketFactoryCreator {
    public static X509TrustManager getSSLTrustManager(X509CertChainValidator v) {
        return new SSLTrustManager(v);
    }

    public static SSLContext getSSLContext(X509Credential c, X509CertChainValidator v, SecureRandom r) {
        SSLContext sslCtx;
        KeyManager[] keyManagerArray;
        if (c == null) {
            keyManagerArray = null;
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = c.getKeyManager();
        }
        KeyManager[] kms = keyManagerArray;
        SSLTrustManager tm = new SSLTrustManager(v);
        try {
            sslCtx = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The TLS protocol is unsupported by the JDK, a serious installation problem?", e);
        }
        try {
            sslCtx.init(kms, new TrustManager[]{tm}, r);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Shouldn't happen - SSLContext can't be initiated?", e);
        }
        return sslCtx;
    }

    public static SSLServerSocketFactory getServerSocketFactory(X509Credential c, X509CertChainValidator v, SecureRandom r) {
        return SocketFactoryCreator.getSSLContext(c, v, r).getServerSocketFactory();
    }

    public static SSLServerSocketFactory getServerSocketFactory(X509Credential c, X509CertChainValidator v) {
        return SocketFactoryCreator.getServerSocketFactory(c, v, new SecureRandom());
    }

    public static SSLSocketFactory getSocketFactory(X509Credential c, X509CertChainValidator v, SecureRandom r) {
        return SocketFactoryCreator.getSSLContext(c, v, r).getSocketFactory();
    }

    public static SSLSocketFactory getSocketFactory(X509Credential c, X509CertChainValidator v) {
        return SocketFactoryCreator.getSocketFactory(c, v, new SecureRandom());
    }

    public static void connectWithHostnameChecking(SSLSocket socket, HostnameMismatchCallback callback) throws SSLPeerUnverifiedException {
        HostnameToCertificateChecker checker = new HostnameToCertificateChecker();
        SSLSession session = socket.getSession();
        Certificate[] serverChain = session.getPeerCertificates();
        if (serverChain == null || serverChain.length == 0) {
            throw new IllegalStateException("JDK BUG? Got null or empty peer certificate array");
        }
        if (!(serverChain[0] instanceof X509Certificate)) {
            throw new ClassCastException("Peer certificate should be an X.509 certificate, but is " + serverChain[0].getClass().getName());
        }
        X509Certificate cert = (X509Certificate)serverChain[0];
        String hostname = socket.getInetAddress().getHostName();
        try {
            if (!checker.checkMatching(hostname, cert)) {
                callback.nameMismatch(socket, cert, hostname);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't check peer's address against its certificate", e);
        }
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

