/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.AbstractDelegatingX509Credential;
import eu.emi.security.authn.x509.helpers.AbstractX509Credential;
import eu.emi.security.authn.x509.helpers.ReaderInputStream;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.PasswordFinder;

public class PEMCredential
extends AbstractDelegatingX509Credential {
    public PEMCredential(String keystorePath, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        this((InputStream)new BufferedInputStream(new FileInputStream(keystorePath)), keyPasswd);
    }

    public PEMCredential(String keystorePath, PasswordFinder pf) throws IOException, KeyStoreException, CertificateException {
        this((InputStream)new BufferedInputStream(new FileInputStream(keystorePath)), pf);
    }

    public PEMCredential(InputStream keystoreStream, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        this(keystoreStream, CertificateUtils.getPF(keyPasswd));
    }

    public PEMCredential(InputStream keystoreStream, PasswordFinder pf) throws IOException, KeyStoreException, CertificateException {
        PrivateKey pk;
        KeyStore ks = CertificateUtils.loadPEMKeystore(keystoreStream, pf, AbstractX509Credential.KEY_PASSWD);
        X509Certificate[] certChain = CertificateUtils.convertToX509Chain(ks.getCertificateChain("default"));
        keystoreStream.close();
        try {
            pk = (PrivateKey)ks.getKey("default", AbstractX509Credential.KEY_PASSWD);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get key from the generated keystore, bug?", e);
        }
        this.delegate = new KeyAndCertCredential(pk, certChain);
    }

    public PEMCredential(InputStream privateKeyStream, InputStream certificateStream, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        this(privateKeyStream, certificateStream, CertificateUtils.getPF(keyPasswd));
    }

    public PEMCredential(InputStream privateKeyStream, InputStream certificateStream, PasswordFinder pf) throws IOException, KeyStoreException, CertificateException {
        this.init(privateKeyStream, certificateStream, pf);
    }

    public PEMCredential(Reader privateKeyReader, Reader certificateReader, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        this(privateKeyReader, certificateReader, CertificateUtils.getPF(keyPasswd));
    }

    public PEMCredential(Reader privateKeyReader, Reader certificateReader, PasswordFinder pf) throws IOException, KeyStoreException, CertificateException {
        ReaderInputStream pkIs = new ReaderInputStream(privateKeyReader, CertificateUtils.ASCII);
        ReaderInputStream ccIs = new ReaderInputStream(certificateReader, CertificateUtils.ASCII);
        this.init(pkIs, ccIs, pf);
    }

    public PEMCredential(String keyPath, String certificatePath, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        this((InputStream)new FileInputStream(keyPath), (InputStream)new FileInputStream(certificatePath), keyPasswd);
    }

    private void init(InputStream privateKeyStream, InputStream certificateStream, PasswordFinder pf) throws IOException, KeyStoreException, CertificateException {
        X509Certificate[] chain = CertificateUtils.loadCertificateChain(certificateStream, CertificateUtils.Encoding.PEM);
        PrivateKey pk = CertificateUtils.loadPEMPrivateKey(privateKeyStream, pf);
        privateKeyStream.close();
        certificateStream.close();
        this.delegate = new KeyAndCertCredential(pk, chain);
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

