#!/bin/sh
# $Id: a1_grid_env.sh,v 1.7 2010/03/11 21:46:23 aelwell Exp $

# Bail out if environment set already
if [ "X${GLITE_ENV_SET+X}" = "X" ]; then 

unset GLITE_LOCATION LCG_LOCATION EDG_LOCATION GLOBUS_LOCATION

platform="unknown"

detectPlatform() {

platformfile=$glite_sw_top/glite/platform.`arch`

if [ -f $platformfile ] ; then
 platform=`cat $platformfile`
 return 0
fi

if [ -f /usr/bin/lsb_release ] ; then
 lsb_osname=`/usr/bin/lsb_release -i | cut -f2`
 lsb_osrelease=`/usr/bin/lsb_release -r | cut -f2 | grep -o '^[0-9]*'`

 case "$lsb_osname" in
  CentOS)
   if [ "$lsb_osrelease" ] ; then
    platform=CentOS"$lsb_osrelease"_`arch`
    return 0
   fi
  ;;
  Debian)
   if [ "$lsb_osrelease" ] ; then
    platform=Debian"$lsb_osrelease"_`arch`
    return 0
   fi
  ;;
  Fedora*)
   if [ "$lsb_osrelease" ] ; then
    platform=Fedora"$lsb_osrelease"_`arch`
    return 0
   fi
  ;;
  Scientific* | RedHatEnterpriseAS)
   if [ "$lsb_osrelease" ] ; then
    platform=SL"$lsb_osrelease"_`arch`
    return 0
   fi
  ;;
  S[Uu]SE*)
   if [ "$lsb_osrelease" ] ; then
    platform=SUSE"$lsb_osrelease"_`arch`
    return 0
   fi
  ;;
  Ubuntu*)
   if [ "$lsb_osrelease" ] ; then
    platform=Ubuntu"$lsb_osrelease"_`arch`
    return 0
   fi
  ;;
  *)
  ;;
 esac
fi

centosInfoFile=/etc/redhat-release
redhatInfoFile=/etc/redhat-release
debianInfoFile=/etc/debian_version
suseInfoFile=/etc/SuSE-release

ostype=`uname -s`

if [ "$ostype" = "Linux" ] ; then
 if [ -f $redhatInfoFile ] ; then
  if  cat $redhatInfoFile | grep -Eq 'Scientific|Fedora|(E|e)nterprise' ; then
   os=SL
   osrelease=`sed -n 's/.*[Rr]elease *\([0-9]*\).*/\1/p' $redhatInfoFile`
   if [ "$osrelease" ] ; then
    platform=$os"$osrelease"_`arch`
    return 0
   fi
  fi
 fi
 if [ -f $debianInfoFile ] ; then
  os=Debian
  osrelease=`cat $debianInfoFile | grep -o '^ *[0-9]*'`
  if [ "$osrelease" ] ; then
   platform=$os"$osrelease"_`arch`
   return 0
  fi
 fi
 if [ -f $centosInfoFile ] ; then
  if cat $centosInfoFile | grep -Eq 'CentOS' ; then
   os=CentOS
   osrelease=`sed -n 's/.*[Rr]elease *\([0-9]*\).*/\1/p' $centosInfoFile`
    if [ "$osrelease" ] ; then
     platform=$os"$osrelease"_`arch`
     return 0
    fi
  fi
 fi
 if [ -f $suseInfoFile ] ; then
  os=SUSE
  osrelease=`sed -n 's/.*= *\([0-9]*\).*/\1/p' $suseInfoFile`
  if [ "$osrelease" ] ; then
   platform=$os"$osrelease"_`arch`
   return 0
  fi
 fi
fi

return 1
}

if [ "${GLITE_MW_VERSION:-$EDG_MW_VERSION}" ]; then
 eval `
  unset GLITE_MW_VERSION EDG_MW_VERSION
  bash --login -c '
   echo \
    glite_sw_top=${VO_OPS_SW_DIR:-VO_OPS_SW_DIR_undefined} \
    glite_loc=${GLITE_LOCATION:-GLITE_LOCATION_undefined}
  '
 `
 vers_cmd=$glite_loc/bin/glite-version
 version=
 if [ -x $vers_cmd ]; then
  version=`$vers_cmd -m`
 fi
 while [ "x$version" != "x${GLITE_MW_VERSION:-$EDG_MW_VERSION}" ]; do
  if detectPlatform ; then
   base=$glite_sw_top/glite/$platform/${GLITE_MW_VERSION:-$EDG_MW_VERSION}
   script=$base/external/etc/profile.d/grid-env.sh
   if [ -f "$script" ]; then
    . "$script"
    break
   fi
  fi
  export EDG_MW_VERSION=not_found:${GLITE_MW_VERSION:-$EDG_MW_VERSION}
  export GLITE_MW_VERSION=$EDG_MW_VERSION
  break
 done
fi
fi
