#ifndef SEMSGSECURITY_HH
#define SEMSGSECURITY_HH


/* SEMsgSecurity
 * A class that encapsulates the security stuff of SEMsg
 *
 *
 *
 * by Fabrizio Furano, CERN, Jan 2011
 */
#include <stdio.h>
#include <stdlib.h>
#include <openssl/evp.h>
#include <openssl/pem.h>
#include <openssl/rsa.h>

#include <cms/MapMessage.h>

#include <map>

class SEMsgSecurity {
private:
  RSA *rsa_pkey;
  EVP_PKEY *pkey, *pubkey;
  EVP_MD_CTX ctx;
  unsigned char *sig;
  unsigned int siglen;
  std::string strpubkey;
  std::string mycert;
  bool init_ok;

  // My DN
  std::string myDN;

  // Certificate verification
  X509_STORE* m_store;
  X509_LOOKUP* m_lookup;

  char *vfybuf;
  int vfybuflen;
  
  int check_cert1(X509 *cert);
  int check_cert2(X509 *cert, char *name);

  // Given a message, build up the buffer needed to univocally validate it
  // against the signature
  size_t BuildVfyBuf(const cms::MapMessage* m);

  // The whitelist, i.e. a map of authorized senders, together with
  // an array of allowed path prefixes
  std::map<std::string, std::vector<std::string> > senderWL;

public:
  SEMsgSecurity();
  virtual ~SEMsgSecurity();

  int Init(char *cfgprefix);

  // To know if the security was correctly initialized
  bool GetSecStatus() {
    return init_ok;
  }

  // Computes the signature for a message (avoiding the signature field)
  int CalcSignature(  const cms::MapMessage* m, std::string &sig);

  // Verifies the given signature already in the message
  int CheckSignature(  const cms::MapMessage* m );

  // Signs the message
  int SignMessage( cms::MapMessage* m );
  
  // Validates the signature of a message
  int CheckMessage( const cms::MapMessage* m );


};





#endif
