# Copyright (c) Members of the EMI Collaboration. 2011.
# See http://eu-emi.eu/partners/ for details on the copyright holders.
# For license conditions see http://www.apache.org/licenses/LICENSE-2.0
#
# This script sets up the environment for the Pseudonymity Service.
# 
# DO NOT CHANGE THE CONTENT OF THIS FILE UNLESS YOU REALLY KNOW WHAT YOU ARE DOING
#

set -e

# Location of the Pseudonymity jars
PSEUDO_LIBS=/var/lib/pseudonymity/server/lib

# Location of the PSEUDO endorsed jars
PSEUDO_ENDORSED_LIBS=$PSEUDO_LIBS/endorsed

# PSEUDO configuration file location
PSEUDO_CONF_FILE="$PSEUDO_SERVER_HOME/conf/pseudonymity-server.ini"

# Sets the heap size for the JVM  
if [ -z $PSEUDO_JAVA_OPTS ]; then
        PSEUDO_JAVA_OPTS="-Xmx256m "
fi

# The name of the class that implements the Pseudonymity standalone server
PSEUDO_CLASS="org.glite.pseudo.server.standalone.PseudonymityService"

# The name of the class the implements the Pseudonymity shutdown helper
PSEUDO_SHUTDOWN_CLASS="org.glite.pseudo.server.standalone.ShutdownClient"

# ':' separated list of  PSEUDO dependencies, used to build the classpath
PSEUDO_DEPS=`ls -x $PSEUDO_LIBS/*.jar | tr '\n' ':'`

# Location of the jar file
PSEUDO_JAR="/var/lib/pseudonymity/server/lib/pseudonymity-server-1.1.1.jar"

# Classpath for the service
PSEUDO_CP="$PSEUDO_DEPS:$PSEUDO_SERVER_HOME/conf/logging/standalone:/usr/share/java/canl.jar:/usr/share/java/bcprov-1.46.jar:/usr/share/java/log4j.jar:/usr/share/java/jspapi.jar:/usr/share/java/pseudonymity-common.jar:/usr/share/java/commons-io.jar:/etc/pseudonymity/server/.:"

# Environment for the PSEUDO service
PSEUDO_ENV="-DPSEUDO_SERVER_HOME=$PSEUDO_SERVER_HOME -Djava.endorsed.dirs=$PSEUDO_ENDORSED_LIBS"

# Command used to start the PSEUDO  service
PSEUDO_CMD="java $PSEUDO_JAVA_OPTS $PSEUDO_ENV -cp $PSEUDO_CP $PSEUDO_CLASS --conf-dir $PSEUDO_SERVER_HOME/conf"

# The hostname property as appears in the PSEUDO configuration file
PSEUDO_HOST=`grep 'hostname =' $PSEUDO_CONF_FILE | awk '{print $3}'`

# The port property as appears in the PSEUDO configuration file
PSEUDO_PORT=`grep 'port =' $PSEUDO_CONF_FILE | awk '{print $3}'`

# The shutdown port property as appears in the PSEUDO configuration file
PSEUDO_SHUTDOWN_PORT=`grep 'shutdown_port =' $PSEUDO_CONF_FILE | awk '{print $3}'`

# The certificate property as appears in the PSEUDO configuration file
PSEUDO_CERT=`grep 'certificate =' $PSEUDO_CONF_FILE  | awk '{print $3}'`

# The private key property as appears in the PSEUDO configuration file
PSEUDO_KEY=`grep 'private_key =' $PSEUDO_CONF_FILE | awk '{print $3}'`

# The command used to shutdown the PSEUDO service
PSEUDO_SHUTDOWN_CMD="java -DPSEUDO_SERVER_HOME=$PSEUDO_SERVER_HOME -cp $PSEUDO_CP $PSEUDO_SHUTDOWN_CLASS"