/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class SinglePubInfo
implements DEREncodable {
    DERInteger pubMethod;
    GeneralName pubLocation;

    public static SinglePubInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SinglePubInfo.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static SinglePubInfo getInstance(Object obj) {
        if (obj instanceof SinglePubInfo) {
            return (SinglePubInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SinglePubInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SinglePubInfo(ASN1Sequence seq) {
        this.pubMethod = DERInteger.getInstance((Object)seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.pubLocation = GeneralName.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(1)), (boolean)true);
        }
    }

    public SinglePubInfo(DERInteger pubMethod) {
        this.pubMethod = pubMethod;
    }

    public DERInteger getPubMethod() {
        return this.pubMethod;
    }

    public GeneralName getPubLocation() {
        return this.pubLocation;
    }

    public void setPubLocation(GeneralName pubLocation) {
        this.pubLocation = pubLocation;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.pubMethod);
        if (this.pubLocation != null) {
            v.add((DEREncodable)this.pubLocation);
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "SinglePubInfo: (pubMethod = " + this.getPubMethod() + ", ";
        if (this.getPubLocation() != null) {
            s = s + "pubLocation = " + this.getPubLocation();
        }
        s = s + ")";
        return s;
    }
}

