/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.PKMACValue;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class POPOSigningKeyInput
implements DEREncodable {
    GeneralName sender;
    PKMACValue publicKeyMAC;
    SubjectPublicKeyInfo publicKey;

    public static POPOSigningKeyInput getInstance(ASN1TaggedObject obj, boolean explicit) {
        return POPOSigningKeyInput.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static POPOSigningKeyInput getInstance(Object obj) {
        if (obj instanceof POPOSigningKeyInput) {
            return (POPOSigningKeyInput)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new POPOSigningKeyInput((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public POPOSigningKeyInput(ASN1Sequence seq) {
        DEREncodable obj = seq.getObjectAt(0);
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            if (tagObj.getTagNo() != 0) throw new IllegalArgumentException("unknown tag: " + tagObj.getTagNo());
            this.sender = GeneralName.getInstance((Object)tagObj.getObject());
        } else {
            this.publicKeyMAC = PKMACValue.getInstance(obj);
        }
        this.publicKey = SubjectPublicKeyInfo.getInstance((Object)seq.getObjectAt(1));
    }

    public POPOSigningKeyInput(GeneralName sender, SubjectPublicKeyInfo publicKey) {
        this.sender = sender;
        this.publicKey = publicKey;
    }

    public POPOSigningKeyInput(PKMACValue publicKeyMAC, SubjectPublicKeyInfo publicKey) {
        this.publicKeyMAC = publicKeyMAC;
        this.publicKey = publicKey;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public PKMACValue getPublicKeyMAC() {
        return this.publicKeyMAC;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.sender != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.sender));
        } else {
            v.add((DEREncodable)this.publicKeyMAC);
        }
        v.add((DEREncodable)this.publicKey);
        return new DERSequence(v);
    }

    public String toString() {
        String s = "POPOSigningKeyInput: (";
        s = this.getSender() != null ? s + "sender: " + this.getSender() + ", " : s + "publicKeyMAC: " + this.getPublicKeyMAC() + ", ";
        s = s + "publicKey: " + this.getPublicKey() + ")";
        return s;
    }
}

