/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.POPOSigningKeyInput;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class POPOSigningKey
implements DEREncodable {
    POPOSigningKeyInput poposkInput;
    AlgorithmIdentifier algorithmIdentifier;
    DERBitString signature;

    public static POPOSigningKey getInstance(ASN1TaggedObject obj, boolean explicit) {
        return POPOSigningKey.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static POPOSigningKey getInstance(Object obj) {
        if (obj instanceof POPOSigningKey) {
            return (POPOSigningKey)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new POPOSigningKey((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public POPOSigningKey(ASN1Sequence seq) {
        int idx = 0;
        DEREncodable obj = seq.getObjectAt(idx++);
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            if (tagObj.getTagNo() == 0) {
                this.poposkInput = POPOSigningKeyInput.getInstance(tagObj.getObject());
            } else {
                throw new IllegalArgumentException("unknown tag: " + tagObj.getTagNo());
            }
        }
        int n = --idx;
        this.algorithmIdentifier = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(n));
        this.signature = DERBitString.getInstance((Object)seq.getObjectAt(++idx));
    }

    public POPOSigningKey(AlgorithmIdentifier algorithmIdentifier, DERBitString signature) {
        this.algorithmIdentifier = algorithmIdentifier;
        this.signature = signature;
    }

    public POPOSigningKeyInput getPoposkInput() {
        return this.poposkInput;
    }

    public void setPoposkInput(POPOSigningKeyInput poposkInput) {
        this.poposkInput = poposkInput;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.poposkInput != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.poposkInput));
        }
        v.add((DEREncodable)this.algorithmIdentifier);
        v.add((DEREncodable)this.signature);
        return new DERSequence(v);
    }

    public String toString() {
        String s = "POPOSigningKey: (";
        if (this.getPoposkInput() != null) {
            s = s + "poposkInput: " + this.getPoposkInput() + ", ";
        }
        s = s + "algorithmIdentifier: " + this.getAlgorithmIdentifier() + ", ";
        s = s + "signature: " + this.getSignature() + ")";
        return s;
    }
}

