/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class POPOPrivKey
implements DEREncodable {
    DEREncodable obj;
    int tag;

    public POPOPrivKey(DERObject obj, int tag) {
        this.obj = obj;
        this.tag = tag;
    }

    public DERBitString getThisMessage() {
        if (this.tag != 0) {
            return null;
        }
        return (DERBitString)this.obj;
    }

    public DERInteger getSubsequentMessage() {
        if (this.tag != 1) {
            return null;
        }
        return (DERInteger)this.obj;
    }

    public DERBitString getDhMAC() {
        if (this.tag != 2) {
            return null;
        }
        return (DERBitString)this.obj;
    }

    public static POPOPrivKey getInstance(DERObject obj) {
        return POPOPrivKey.getInstance((ASN1TaggedObject)obj, true);
    }

    public static POPOPrivKey getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        int tag = tagObj.getTagNo();
        switch (tag) {
            case 0: {
                return new POPOPrivKey((DERObject)DERBitString.getInstance((Object)tagObj.getObject()), 0);
            }
            case 1: {
                return new POPOPrivKey((DERObject)DERInteger.getInstance((Object)tagObj.getObject()), 1);
            }
            case 2: {
                return new POPOPrivKey((DERObject)DERBitString.getInstance((Object)tagObj.getObject()), 2);
            }
        }
        throw new IllegalArgumentException("unknown tag: " + tag);
    }

    public DERObject getDERObject() {
        return new DERTaggedObject(true, this.tag, this.obj);
    }

    public String toString() {
        return "POPOPrivKey: (" + this.obj + ")";
    }
}

