/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PKMACValue
implements DEREncodable {
    AlgorithmIdentifier algId;
    DERBitString value;

    public static PKMACValue getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKMACValue.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static PKMACValue getInstance(Object obj) {
        if (obj instanceof PKMACValue) {
            return (PKMACValue)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKMACValue((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PKMACValue(ASN1Sequence seq) {
        this.algId = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(0));
        this.value = DERBitString.getInstance((Object)seq.getObjectAt(1));
    }

    public PKMACValue(AlgorithmIdentifier algId, DERBitString value) {
        this.algId = algId;
        this.value = value;
    }

    public AlgorithmIdentifier getAlgId() {
        return this.algId;
    }

    public DERBitString getValue() {
        return this.value;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.algId);
        v.add((DEREncodable)this.value);
        return new DERSequence(v);
    }

    public String toString() {
        return "PKMACValue: (algId = " + this.getAlgId() + ", value = " + this.getValue() + ")";
    }
}

