/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedValue
implements DEREncodable {
    AlgorithmIdentifier intendedAlg;
    AlgorithmIdentifier symmAlg;
    DERBitString encSymmKey;
    AlgorithmIdentifier keyAlg;
    DEROctetString valueHint;
    DERBitString encValue;

    public static EncryptedValue getInstance(ASN1TaggedObject obj, boolean explicit) {
        return EncryptedValue.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static EncryptedValue getInstance(Object obj) {
        if (obj instanceof EncryptedValue) {
            return (EncryptedValue)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new EncryptedValue((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public EncryptedValue(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof DERTaggedObject) {
                DERTaggedObject tagObj = (DERTaggedObject)obj;
                switch (tagObj.getTagNo()) {
                    case 0: {
                        this.intendedAlg = AlgorithmIdentifier.getInstance((Object)tagObj.getObject());
                        break;
                    }
                    case 1: {
                        this.symmAlg = AlgorithmIdentifier.getInstance((Object)tagObj.getObject());
                        break;
                    }
                    case 2: {
                        this.encSymmKey = DERBitString.getInstance((Object)tagObj.getObject());
                        break;
                    }
                    case 3: {
                        this.keyAlg = AlgorithmIdentifier.getInstance((Object)tagObj.getObject());
                        break;
                    }
                    case 4: {
                        this.valueHint = (DEROctetString)DEROctetString.getInstance((Object)tagObj.getObject());
                    }
                }
                continue;
            }
            this.encValue = DERBitString.getInstance(obj);
            break;
        }
    }

    public EncryptedValue(DERBitString encValue) {
        this.encValue = encValue;
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.intendedAlg;
    }

    public void setIntendedAlg(AlgorithmIdentifier intendedAlg) {
        this.intendedAlg = intendedAlg;
    }

    public AlgorithmIdentifier getSymmAlg() {
        return this.symmAlg;
    }

    public void setSymmAlg(AlgorithmIdentifier symmAlg) {
        this.symmAlg = symmAlg;
    }

    public DERBitString getEncSymmKey() {
        return this.encSymmKey;
    }

    public void setEncSymmKey(DERBitString encSymmKey) {
        this.encSymmKey = encSymmKey;
    }

    public AlgorithmIdentifier getKeyAlg() {
        return this.keyAlg;
    }

    public void setKeyAlg(AlgorithmIdentifier keyAlg) {
        this.keyAlg = keyAlg;
    }

    public DEROctetString getValueHint() {
        return this.valueHint;
    }

    public void setValueHint(DEROctetString valueHint) {
        this.valueHint = valueHint;
    }

    public DERBitString getEncValue() {
        return this.encValue;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.intendedAlg != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.intendedAlg));
        }
        if (this.symmAlg != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.symmAlg));
        }
        if (this.encSymmKey != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)this.encSymmKey));
        }
        if (this.keyAlg != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 3, (DEREncodable)this.keyAlg));
        }
        if (this.valueHint != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 4, (DEREncodable)this.valueHint));
        }
        v.add((DEREncodable)this.encValue);
        return new DERSequence(v);
    }

    public String toString() {
        String s = "EncryptedValue: (";
        if (this.getIntendedAlg() != null) {
            s = s + "intendedAlg: " + this.getIntendedAlg() + ", ";
        }
        if (this.getSymmAlg() != null) {
            s = s + "symmAlg: " + this.getSymmAlg() + ", ";
        }
        if (this.getEncSymmKey() != null) {
            s = s + "encSymmKey: " + this.getEncSymmKey() + ", ";
        }
        if (this.getKeyAlg() != null) {
            s = s + "keyAlg: " + this.getKeyAlg() + ", ";
        }
        if (this.getValueHint() != null) {
            s = s + "valueHint: " + this.getValueHint() + ", ";
        }
        s = s + "encValue: " + this.getEncValue() + ")";
        return s;
    }
}

