/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.crmf.CertId;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Extensions;

public class RevAnnContent
implements DEREncodable {
    DERInteger status;
    CertId certId;
    DERGeneralizedTime willBeRevokedAt;
    DERGeneralizedTime badSinceDate;
    X509Extensions crlDetails;

    public static RevAnnContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RevAnnContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static RevAnnContent getInstance(Object obj) {
        if (obj instanceof RevAnnContent) {
            return (RevAnnContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RevAnnContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public RevAnnContent(ASN1Sequence seq) {
        this.status = DERInteger.getInstance((Object)seq.getObjectAt(0));
        this.certId = CertId.getInstance(seq.getObjectAt(1));
        this.willBeRevokedAt = DERGeneralizedTime.getInstance((Object)seq.getObjectAt(2));
        this.badSinceDate = DERGeneralizedTime.getInstance((Object)seq.getObjectAt(3));
        if (seq.size() > 4) {
            this.crlDetails = X509Extensions.getInstance((Object)seq.getObjectAt(4));
        }
    }

    public RevAnnContent(DERInteger status, CertId certId, DERGeneralizedTime willBeRevokedAt, DERGeneralizedTime badSinceDate) {
        this.status = status;
        this.certId = certId;
        this.willBeRevokedAt = willBeRevokedAt;
        this.badSinceDate = badSinceDate;
    }

    public DERInteger getStatus() {
        return this.status;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public DERGeneralizedTime getWillBeRevokedAt() {
        return this.willBeRevokedAt;
    }

    public DERGeneralizedTime getBadSinceDate() {
        return this.badSinceDate;
    }

    public X509Extensions getCrlDetails() {
        return this.crlDetails;
    }

    public void setCrlDetails(X509Extensions crlDetails) {
        this.crlDetails = crlDetails;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.status);
        v.add((DEREncodable)this.certId);
        v.add((DEREncodable)this.willBeRevokedAt);
        v.add((DEREncodable)this.badSinceDate);
        if (this.crlDetails != null) {
            v.add((DEREncodable)this.crlDetails);
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "RevAnnContent: (status = " + this.getStatus() + ", " + "certId = " + this.getCertId() + ", " + "willBeRevokedAt = " + this.getWillBeRevokedAt() + ", " + "badSinceDate = " + this.getBadSinceDate();
        if (this.getCrlDetails() != null) {
            s = s + ", crlDetails = " + this.getCrlDetails();
        }
        s = s + ")";
        return s;
    }
}

