/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;

public class PKIFreeText
implements DEREncodable {
    Vector freeTextStrings = new Vector();

    public static PKIFreeText getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIFreeText.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static PKIFreeText getInstance(Object obj) {
        if (obj instanceof PKIFreeText) {
            return (PKIFreeText)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKIFreeText((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PKIFreeText(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            this.freeTextStrings.addElement(e.nextElement());
        }
    }

    public PKIFreeText(DERUTF8String p) {
        this.freeTextStrings.addElement(p);
    }

    public void addString(DERUTF8String p) {
        this.freeTextStrings.addElement(p);
    }

    public DERUTF8String getString(int nr) {
        if (this.freeTextStrings.size() > nr) {
            return (DERUTF8String)this.freeTextStrings.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < this.freeTextStrings.size(); ++i) {
            v.add((DEREncodable)((DERUTF8String)this.freeTextStrings.elementAt(i)));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "PKIFreeText: ";
        for (int i = 0; i < this.freeTextStrings.size(); ++i) {
            s = s + (DERUTF8String)this.freeTextStrings.elementAt(i);
        }
        return s;
    }
}

